<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>Teste de Conhecimento - Investigação Particular</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
      background: #f0f0f0;
      max-width: 800px;
      margin: auto;
    }
    h1, h2 {
      text-align: center;
      color: #003366;
    }
    .question {
      background: #fff;
      padding: 15px;
      margin-bottom: 15px;
      border-radius: 6px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
    }
    .question p {
      font-weight: bold;
      margin-bottom: 10px;
    }
    label {
      display: block;
      margin-bottom: 5px;
    }
    button {
      background-color: #003366;
      color: white;
      padding: 12px 20px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 1em;
      margin-top: 15px;
    }
    .print-button {
      background: #006600;
    }
    .hidden {
      display: none;
    }
    #certificado {
      background-color: white;
      padding: 40px;
      margin-top: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.2);
    }
    .assinatura input {
      width: 100%;
      padding: 8px;
      margin-top: 8px;
      margin-bottom: 16px;
      font-size: 1em;
    }
    #errosContainer {
      background: #fff3f3;
      border: 1px solid #cc0000;
      padding: 20px;
      margin-top: 30px;
      border-radius: 10px;
    }
    #errosContainer ul {
      list-style: none;
      padding-left: 0;
    }
    #errosContainer li {
      margin-bottom: 20px;
    }
    @media print {
      body * {
        visibility: hidden;
      }
      #certificado, #certificado * {
        visibility: visible;
      }
      #certificado {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        page-break-after: always;
      }
    }
  </style>
</head>
<body>

<h1>Teste de Conhecimento<br> Investigação Particular</h1>

<form id="quizForm">
  <div id="quizContainer"></div>
  <button type="submit">VISUALIZAR ACERTO</button>
</form>

<div id="certificado" class="hidden">
  <h2>Certificado de Participação</h2>
  <p>Certificamos que o(a) participante evidenciou sólidos conhecimentos técnicos na área de Investigação Particular, destacando-se pelo desempenho satisfatório.</p>
  <p><strong>Pontuação:</strong> <span id="pontuacaoTexto"></span> de 40 pontos.</p>
  <p><strong>Status:</strong> Aprovado(a)</p>

  <div class="assinatura"> 
    <label>Nome Completo:</label>
    <input type="text" placeholder="Digite Seu Nome Completo" required id="nomeCompleto" />

    <label>CPF:</label>
    <input type="text" placeholder="000.000.000-00" id="cpfInput" required maxlength="14" />
  </div>

  <p style="margin-top:20px; font-size: 14px;">
    ASSOCIAÇÃO DOS DETETIVES DO BRASIL<br>
    Fundada em 09 de fevereiro de 2011, em conformidade com a Lei que rege as associações — Lei Federal nº 10.406, de 10 de janeiro de 2002 (Novo Código Civil). Registrada junto à Receita Federal sob o CNPJ nº 13.329.080/0001-75.<br>
    📚 O Conhecimento é a Chave da Investigação<br><br>
    A profissão de detetive particular exige muito mais do que intuição e experiência. Exige preparo, ética, técnica e atualização constante.<br><br>
    Estudar as leis, os métodos investigativos, as ferramentas tecnológicas e o comportamento humano é essencial para quem deseja exercer a profissão com excelência e responsabilidade.<br><br>
    Aprender é investigar o futuro. Estude, aprimore-se e fortaleça sua missão!
  </p>

  <button class="print-button" onclick="imprimirCertificado()">Imprimir Certificado</button>
</div>

<div id="errosContainer" class="hidden">
  <h2>Questões que você errou:</h2>
  <ul id="listaErros"></ul>
</div>

<script>
const perguntas = [
  "Qual é o principal objetivo de uma investigação particular?",
  "Qual equipamento é essencial para um detetive particular?",
  "O detetive pode quebrar sigilo telefônico?",
  "Qual dessas condutas é proibida para o detetive particular?",
  "A Lei nº 13.432/2017 regulamenta:",
  "Quem pode contratar um detetive particular?",
  "Um relatório de investigação deve ser:",
  "Durante a investigação, o detetive deve agir com:",
  "O detetive pode portar arma de fogo?",
  "A atividade do detetive deve ser exercida com base na:",
  "Qual o tempo mínimo para arquivar documentos de uma investigação?",
  "A atuação do detetive está sujeita à fiscalização de qual órgão?",
  "O detetive pode divulgar imagens coletadas na investigação?",
  "Qual o papel do detetive em investigações empresariais?",
  "Em caso de crime, o detetive deve:",
  "A violação de correspondência é:",
  "O detetive pode usar disfarces durante a investigação?",
  "A ética profissional exige que o detetive seja:",
  "A profissão de detetive exige:",
  "Qual das opções é um exemplo de invasão de privacidade?"
];

const alternativas = [
  ["A) Coletar informações para um cliente.", "B) Prender suspeitos.", "C) Substituir a polícia.", "D) Realizar interrogatórios."],
  ["A) Câmera fotográfica.", "B) Algema.", "C) Arma de fogo.", "D) Sirene."],
  ["A) Sim, com ordem judicial.", "B) Sim, se for investigando cônjuge.", "C) Não.", "D) Sim, se for emergência."],
  ["A) Gravar sem consentimento.", "B) Invadir residência.", "C) Observar à distância.", "D) Acompanhar rotina."],
  ["A) Atuação da polícia federal.", "B) Atividade de segurança privada.", "C) Profissão de detetive particular.", "D) Penalidades a crimes digitais."],
  ["A) Somente advogados.", "B) Apenas empresas.", "C) Qualquer pessoa.", "D) Apenas juízes."],
  ["A) Oral e informal.", "B) Redigido e assinado.", "C) Enviado por WhatsApp.", "D) Não precisa relatar."],
  ["A) Rigor e imparcialidade.", "B) Vontade do cliente.", "C) Interesse próprio.", "D) Curiosidade."],
  ["A) Sim, sempre.", "B) Não, é proibido.", "C) Apenas com curso.", "D) Só fora do Brasil."],
  ["A) Lei da Liberdade de Informação.", "B) Constituição da ONU.", "C) Ética e legalidade.", "D) Nenhuma."],
  ["A) 1 mês.", "B) 6 meses.", "C) 2 anos.", "D) Depende do cliente."],
  ["A) Polícia Federal.", "B) Receita Federal.", "C) Conselho de Ética.", "D) Ministério da Justiça."],
  ["A) Sim, se cliente autorizar.", "B) Sim, sem limites.", "C) Não, é crime.", "D) Só em redes sociais."],
  ["A) Julgar os funcionários.", "B) Melhorar decisões com dados.", "C) Fazer denúncias públicas.", "D) Espionar por diversão."],
  ["A) Esconder os fatos.", "B) Informar à autoridade policial.", "C) Ignorar.", "D) Resolver sozinho."],
  ["A) Permitida com autorização.", "B) Permitida sem motivo.", "C) Crime previsto em lei.", "D) Obrigatória para investigar."],
  ["A) Sim, se necessário e legalmente.", "B) Nunca.", "C) Sempre.", "D) Apenas com permissão judicial."],
  ["A) Subjetivo e curioso.", "B) Profissional, ético e discreto.", "C) Aventureiro.", "D) Investigativo e impulsivo."],
  ["A) Apenas sorte.", "B) Registro em cartório.", "C) Formação técnica ou experiência.", "D) Nome limpo no SPC."],
  ["A) Usar escutas sem autorização.", "B) Observar em local público.", "C) Registrar entrada/saída.", "D) Seguir a pé na rua."]
];

const gabarito = ["A", "A", "A", "B", "C", "C", "B", "A", "B", "C", "C", "D", "C", "B", "B", "C", "A", "B", "C", "A"];

const quizContainer = document.getElementById('quizContainer');

perguntas.forEach((pergunta, i) => {
  const div = document.createElement('div');
  div.classList.add('question');
  div.innerHTML = `<p>${i + 1}. ${pergunta}</p>` +
    alternativas[i].map(alt => `
      <label>
        <input type="radio" name="q${i}" value="${alt.charAt(0)}"> ${alt}
      </label>`).join('');
  quizContainer.appendChild(div);
});

document.getElementById("quizForm").addEventListener("submit", function(e) {
  e.preventDefault();
  let pontos = 0;
  let erros = [];

  for (let i = 0; i < gabarito.length; i++) {
    const selected = document.querySelector(`input[name=q${i}]:checked`);
    if (selected && selected.value === gabarito[i]) {
      pontos += 2;
    } else {
      erros.push({
        numero: i + 1,
        pergunta: perguntas[i],
        respostaCorreta: gabarito[i],
        alternativas: alternativas[i],
        respostaUsuario: selected ? selected.value : null
      });
    }
  }

  document.getElementById("pontuacaoTexto").innerText = pontos;

  if (pontos >= 24) {
    // Se aprovado, esconde erros e formulário, mostra certificado
    document.getElementById("certificado").classList.remove("hidden");
    document.getElementById("quizForm").classList.add("hidden");
    document.getElementById("errosContainer").classList.add("hidden");
  } else {
    // Se reprovado, mostra alert, exibe erros detalhados e mantém formulário
    alert(`Você fez ${pontos} pontos. Mínimo para aprovação: 24.`);

    const listaErros = document.getElementById("listaErros");
    listaErros.innerHTML = "";

    erros.forEach(erro => {
      const item = document.createElement("li");

      const alternativaCerta = erro.alternativas.find(alt => alt.startsWith(erro.respostaCorreta));
      const alternativaMarcada = erro.respostaUsuario
        ? erro.alternativas.find(alt => alt.startsWith(erro.respostaUsuario))
        : "<i>(Você não respondeu)</i>";

      item.innerHTML = `
        <strong>${erro.numero}. ${erro.pergunta}</strong><br>
        <span style="color: red;">Sua resposta: ${alternativaMarcada || 'Nenhuma'}</span><br>
        <span style="color: green;">Resposta correta: ${alternativaCerta}</span>
      `;
      listaErros.appendChild(item);
    });

    document.getElementById("errosContainer").classList.remove("hidden");
    document.getElementById("quizForm").classList.remove("hidden");
    document.getElementById("certificado").classList.add("hidden");

    window.scrollTo(0, document.body.scrollHeight);
  }
});

function imprimirCertificado() {
  // Verifica se nome e CPF foram preenchidos antes de imprimir
  const nome = document.getElementById('nomeCompleto').value.trim();
  const cpf = document.getElementById('cpfInput').value.trim();
  if (!nome) {
    alert('Por favor, preencha o Nome Completo antes de imprimir o certificado.');
    return;
  }
  if (!cpf || cpf.length !== 14) {
    alert('Por favor, preencha o CPF corretamente antes de imprimir o certificado.');
    return;
  }
  window.print();
}

// Máscara CPF e capitalização nome
document.addEventListener("DOMContentLoaded", () => {
  const cpfInput = document.getElementById("cpfInput");
  cpfInput.addEventListener("input", function () {
    let v = cpfInput.value.replace(/\D/g, "");
    v = v.replace(/(\d{3})(\d)/, "$1.$2");
    v = v.replace(/(\d{3})(\d)/, "$1.$2");
    v = v.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
    cpfInput.value = v;
  });

  const nomeInput = document.getElementById('nomeCompleto');
  nomeInput.addEventListener('blur', () => {
    nomeInput.value = nomeInput.value.toLowerCase().split(' ').map(p => p.charAt(0).toUpperCase() + p.slice(1)).join(' ');
  });
});
</script>

</body>
</html>
