<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>Teste de Conhecimento</title>
  <meta name="description" content="Os detetives profissionais são profissionais que atuam na área privada e que prestam serviços específicos, de acordo com as necessidades de cada cliente na coleta de dados e informações, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse privado do contratante."/>
  <link href="logotipoadb.png" rel="shortcut icon" type="image/x-icon"/>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
      background: #f0f0f0;
      max-width: 800px;
      margin: auto;
    }
    h1, h2 { text-align: center; color: #003366; }
    .question {
      background: #fff;
      padding: 15px;
      margin-bottom: 15px;
      border-radius: 6px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
    }
    .question p { font-weight: bold; margin-bottom: 10px; }
    label { display: block; margin-bottom: 5px; cursor: pointer; }
    input[type="radio"] { margin-right: 8px; }
    button {
      background-color: #003366;
      color: white;
      padding: 12px 20px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 1em;
      margin-top: 15px;
      display: block;
      margin-left: auto;
      margin-right: auto;
    }
    .print-button { background: #006600; margin-top: 20px; }
    .gov-button { background: #004aad; margin-top: 10px; }
    .hidden { display: none; }
    #certificado {
      background-color: white;
      padding: 40px;
      margin-top: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.2);
    }
    .assinatura input {
      width: 100%;
      padding: 8px;
      margin-top: 8px;
      margin-bottom: 16px;
      font-size: 1em;
      box-sizing: border-box;
    }
    #errosContainer {
      background: #fff3f3;
      border: 1px solid #cc0000;
      padding: 20px;
      margin-top: 30px;
      border-radius: 10px;
    }
    #errosContainer ul {
      list-style: none;
      padding-left: 0;
    }
    #errosContainer li { margin-bottom: 20px; }
    @media print {
      body * { visibility: hidden; }
      #certificado, #certificado * {
        visibility: visible;
      }
      #certificado {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        max-height: 100vh;
        padding: 20px;
        box-sizing: border-box;
        background: white;
        page-break-before: avoid;
        page-break-after: avoid;
        overflow: hidden;
      }
    }
  </style>
</head>
<body>
  <h1>Teste de Capacidade</h1>

  <form id="quizForm">
    <div id="quizContainer"></div>
    <button type="submit">VISUALIZAR ACERTO</button>
  </form>

  <div id="errosContainer" class="hidden">
    <h2>Questões que você errou:</h2>
    <ul id="listaErros"></ul>
  </div>

  <div id="refazerContainer" class="hidden" style="text-align:center; margin-top: 20px;">
    <button type="button" onclick="refazerTeste()">Refazer Teste</button>
  </div>

  <div id="certificado" class="hidden">
    <table border="0" width="100%">
      <tr>
        <td width="25%">&nbsp;</td>
        <td width="50%" align="center"><img src="logotipoadb.png" width="50%" alt="Logo ADB"></td>
        <td width="25%">&nbsp;</td>
      </tr>
    </table>  

    <h2>Certificado de Participação<br><br>ASSOCIAÇÃO DOS DETETIVES DO BRASIL</h2><br>
    <p>Certificamos que o(a) participante evidenciou sólidos conhecimentos técnicos na área de Investigação Particular, destacando-se pelo desempenho satisfatório.<br><br> O profissional encontra-se, portanto, apto(a) a se cadastrar junto à Associação dos Detetives do Brasil, conforme as normas e critérios de habilitação estabelecidos.</p>

    <p><strong>Pontuação:</strong> <span id="pontuacaoTexto"></span> de 40 pontos.</p>
    <p><strong>Status:</strong> Aprovado(a)</p>

    <div class="assinatura">
      <label for="nomeCompleto">Nome Completo:</label>
      <input type="text" placeholder="Digite Seu Nome Completo" required id="nomeCompleto" />
      <label for="cpfInput">CPF:</label>
      <input type="text" placeholder="000.000.000-00" id="cpfInput" required maxlength="14" />
    </div>

    <br><br><br>
    <p style="margin: 0; font-weight: bold;">______________________________________________</p>
    <p style="margin: 5px 0 0 0;">Assinatura do(a) Profissional</p>
    <p style="margin: 3px 0 0 0; font-size: 0.9em; color: #333;">(Assine digitalmente via GOV.BR)</p>

    <button class="print-button" type="button" onclick="imprimirCertificado()">Imprimir Certificado e Assinar via GOV.BR</button>
    <button class="gov-button" type="button" onclick="abrirGovBr()">Abrir GOV.BR</button>
  </div>

  <script>
    // ===== Configurações =====
    const PASS_SCORE = 24;              // 24 pontos (12 acertos de 20)
    const POINTS_PER_QUESTION = 2;      // 2 pontos por acerto
    const SHUFFLE_QUESTIONS = true;     // embaralhar também as perguntas (altere para false se quiser fixas)

    // ===== Banco de perguntas/alternativas (todas corretas originalmente na alternativa 0 - "A)") =====
    const perguntas = [
      "Como a análise de padrões comportamentais pode ser aplicada em uma investigação de rotina para identificar suspeitos?",
      "Qual o papel da cadeia de custódia na integridade da prova documental obtida por um detetive particular?",
      "Em que circunstâncias o detetive particular pode utilizar tecnologia de geolocalização sem infringir direitos constitucionais?",
      "Como o princípio da razoabilidade deve orientar a atuação do detetive particular em ambientes públicos?",
      "Quais cuidados o detetive deve tomar ao elaborar um relatório que será apresentado em juízo?",
      "De que forma a atuação colaborativa entre detetive particular e advogado pode influenciar a eficácia de uma investigação?",
      "Como o detetive deve proceder ao encontrar indícios de um crime em andamento durante uma investigação civil?",
      "Quais são as implicações legais do uso de perfis falsos em redes sociais para fins investigativos?",
      "Como a Lei Geral de Proteção de Dados (LGPD) impacta a rotina de coleta de informações sensíveis pelo detetive?",
      "Explique a diferença entre vigilância e perseguição no contexto da atuação investigativa profissional.",
      "Quais técnicas de entrevista podem ser usadas para extrair informações de testemunhas sem violar a ética?",
      "Como a identificação de inconsistências em versões pode ser usada como técnica de verificação da veracidade dos fatos?",
      "Por que a imparcialidade é considerada um dos pilares da atuação do detetive particular?",
      "Quais são os riscos de contaminação de prova digital e como evitá-los?",
      "Como o detetive pode lidar com situações em que o cliente tenta interferir nos métodos da investigação?",
      "Qual a responsabilidade civil do detetive particular em caso de danos causados por informações inverídicas?",
      "Como a inteligência emocional auxilia na abordagem de pessoas durante uma investigação sensível?",
      "Explique como o uso de inteligência artificial pode contribuir (ou prejudicar) a atividade do detetive particular.",
      "Qual o impacto do viés cognitivo nas decisões do detetive e como mitigá-lo?",
      "Em que situações é justificável encerrar uma investigação antes do prazo acordado contratualmente?"
    ];

    const alternativas = [
      ["Observando hábitos, horários e reações repetidas para traçar perfis e padrões.", "Aplicando questionários formais durante a investigação.", "Solicitando laudos diretamente à polícia.", "Seguindo os suspeitos sem análise técnica."],
      ["Garante que a prova foi obtida legalmente e sem manipulação.", "Serve apenas como registro auxiliar.", "Não se aplica a provas documentais.", "Permite que o detetive altere dados antes da entrega."],
      ["Quando há consentimento claro e expresso da parte investigada.", "Quando o equipamento é homologado pela ANATEL.", "Sempre que o detetive quiser testar o recurso.", "Apenas quando o investigado estiver em ambiente público."],
      ["Deve respeitar limites de privacidade mesmo em locais abertos.", "Pode agir sem restrições legais.", "Apenas observar sem registrar nada.", "Usar qualquer meio disponível para obter provas."],
      ["Utilizar linguagem técnica, clara e objetiva, com fontes verificáveis.", "Adicionar opiniões pessoais para reforçar argumentos.", "Escrever de forma informal para facilitar a leitura.", "Omitir detalhes sensíveis para proteger o cliente."],
      ["Permite alinhar estratégias jurídicas com os dados obtidos.", "Diminui a autonomia do detetive.", "Não é recomendada por envolver sigilo profissional.", "Viola o Código de Ética da OAB."],
      ["Acionar imediatamente a autoridade competente e preservar a cena.", "Acompanhar de longe e não intervir.", "Registrar com fotos e divulgar em redes sociais.", "Confrontar os envolvidos diretamente."],
      ["Pode configurar crime se violar direitos fundamentais da pessoa.", "É totalmente legal em qualquer situação.", "Requer permissão judicial sempre.", "É permitido apenas para casos de traição conjugal."],
      ["O detetive precisa justificar a coleta e proteger os dados sensíveis do investigado.", "A LGPD não se aplica a detetives.", "Basta informar ao cliente que os dados são protegidos.", "Só vale para empresas de tecnologia."],
      ["Vigilância é uma ação profissional com limites legais; perseguição é ilegal e abusiva.", "Ambas significam o mesmo no contexto investigativo.", "A diferença está apenas na distância de observação.", "Perseguir é permitido se for a pé."],
      ["Rapport, escuta ativa e perguntas abertas são fundamentais.", "Ameaças veladas podem ser eficazes.", "Recompensas sempre garantem sinceridade.", "Pressão psicológica é permitida se o objetivo for nobre."],
      ["Confrontando as informações com outras fontes e datas-chave.", "Registrando tudo como o cliente disser.", "Anotando apenas o que for conveniente ao contratante.", "Ignorando detalhes contraditórios."],
      ["Evita distorções e assegura a credibilidade do relatório.", "Permite julgamento do investigado.", "Não influencia no resultado final.", "É desnecessária quando há prova concreta."],
      ["Usar ferramentas de verificação e manter logs originais.", "Imprimir as provas e arquivar em pastas físicas.", "Converter arquivos para formatos editáveis.", "Compartilhar via redes públicas."],
      ["Manter independência e seguir o contrato com ética.", "Atender aos desejos do cliente a todo custo.", "Consultar o cliente antes de cada ação.", "Aceitar sugestões de interferência como cooperação."],
      ["Pode responder judicialmente por danos causados pela informação.", "Não possui responsabilidade desde que esteja contratado.", "Pode culpar a fonte da informação.", "Só responde se o cliente reclamar."],
      ["Ajuda a manter calma, empatia e assertividade nas abordagens.", "Serve para manipular emocionalmente testemunhas.", "Reduz o tempo de investigação.", "Não tem relevância na prática profissional."],
      ["Pode agilizar cruzamento de dados, mas não substitui análise humana criteriosa.", "Deve substituir o trabalho de campo tradicional.", "Só é útil em crimes cibernéticos.", "Não deve ser usada por detetives."],
      ["Pode levar a julgamentos errados; é preciso checar evidências objetivas.", "Ajuda a acelerar decisões e conclusões.", "Deve ser reforçado para aumentar convicção.", "É irrelevante se houver intuição."],
      ["Quando há risco à segurança ou violação ética no prosseguimento.", "Sempre que o cliente estiver insatisfeito.", "Após 50% do pagamento realizado.", "Quando o detetive perde interesse no caso."]
    ];

    // Originalmente todas corretas na posição 0 ("A")
    const gabaritoOriginalIndex = Array(20).fill(0);

    // ===== Estado da variante / tentativa =====
    const attemptKey = 'quizAttemptVariant_v1';
    let attempt = parseInt(localStorage.getItem(attemptKey) || '0', 10);

    // Deterministic PRNG (mulberry32)
    function mulberry32(seed) {
      return function() {
        let t = seed += 0x6D2B79F5;
        t = Math.imul(t ^ (t >>> 15), t | 1);
        t ^= t + Math.imul(t ^ (t >>> 7), t | 61);
        return ((t ^ (t >>> 14)) >>> 0) / 4294967296;
      }
    }

    function seededShuffle(array, rng) {
      const a = array.slice();
      for (let i = a.length - 1; i > 0; i--) {
        const j = Math.floor(rng() * (i + 1));
        [a[i], a[j]] = [a[j], a[i]];
      }
      return a;
    }

    // Letras A-D
    const letters = ['A', 'B', 'C', 'D'];

    // Estruturas variáveis por tentativa
    let variant = null;       // [{qIndex, text, options: [{text, baseIndex}], correctIndex}]
    let currentAnswerKey = []; // indices (0..3) corretos após embaralhamento

    function buildVariant() {
      // RNG global por tentativa
      const rng = mulberry32(0xABCDEF ^ attempt);

      // Mapeia perguntas em objetos
      let qList = perguntas.map((text, idx) => ({ qIndex: idx, text }));

      // Embaralha perguntas (se habilitado)
      if (SHUFFLE_QUESTIONS) {
        qList = seededShuffle(qList, rng);
      }

      // Para cada pergunta, embaralhar alternativas de forma determinística por (attempt, qIndex)
      const built = [];
      const answerKey = [];

      qList.forEach((q, orderIdx) => {
        const baseOptions = alternativas[q.qIndex].map((optText, baseIndex) => ({ text: optText, baseIndex }));
        // RNG por pergunta (semente derivada)
        const rqp = mulberry32((attempt + 1) * 0x9E3779B1 ^ (q.qIndex + 1) * 0x85EBCA77);

        const shuffledOptions = seededShuffle(baseOptions, rqp);

        // índice correto após embaralhar = onde baseIndex == gabaritoOriginalIndex[qIndex]
        const correctBase = gabaritoOriginalIndex[q.qIndex];
        const newCorrectIndex = shuffledOptions.findIndex(o => o.baseIndex === correctBase);

        built.push({
          qIndex: q.qIndex,
          text: q.text,
          options: shuffledOptions,   // [{text, baseIndex}]
          correctIndex: newCorrectIndex
        });
        answerKey.push(newCorrectIndex);
      });

      variant = built;
      currentAnswerKey = answerKey;
    }

    // Renderiza o formulário a partir da variant atual
    const quizContainer = document.getElementById('quizContainer');

    function renderQuiz() {
      quizContainer.innerHTML = '';
      variant.forEach((q, i) => {
        const div = document.createElement('div');
        div.classList.add('question');

        const optsHtml = q.options.map((opt, j) => {
          const letter = letters[j];
          // value = índice daquela alternativa j; name = qi
          return `<label>
            <input type="radio" name="q${i}" value="${j}" required>
            <strong>${letter})</strong> ${opt.text}
          </label>`;
        }).join('');

        div.innerHTML = `<p>${i + 1}. ${q.text}</p>${optsHtml}`;
        quizContainer.appendChild(div);
      });
    }

    // Monta lista de erros (com letras atualizadas) e mostra containers
    function showErrors(result) {
      const listaErros = document.getElementById("listaErros");
      listaErros.innerHTML = "";

      result.errors.forEach(erro => {
        const correctLetter = letters[erro.correctIndex];
        const userLetter = (erro.userIndex !== null && erro.userIndex !== undefined) ? letters[erro.userIndex] : null;

        const alternativaCertaTexto = `${correctLetter}) ${erro.correctText}`;
        const alternativaMarcadaTexto = (userLetter === null)
          ? "<i>(Você não respondeu)</i>"
          : `${userLetter}) ${erro.userText}`;

        const li = document.createElement("li");
        li.innerHTML = `<strong>${erro.numero}. ${erro.pergunta}</strong><br>
                        <span style="color: green;"><em>✔ Resposta correta:</em> ${alternativaCertaTexto}</span><br>
                        <span style="color: red;"><em>✘ Sua resposta:</em> ${alternativaMarcadaTexto}</span>`;
        listaErros.appendChild(li);
      });

      document.getElementById("errosContainer").classList.remove("hidden");
      document.getElementById("refazerContainer").classList.remove("hidden");
      window.scrollTo({ top: document.getElementById("errosContainer").offsetTop, behavior: 'smooth' });
    }

    // Corrigir e decidir aprovação
    document.getElementById("quizForm").addEventListener("submit", function(e) {
      e.preventDefault();
      let pontos = 0;
      const errors = [];

      for (let i = 0; i < variant.length; i++) {
        const selected = document.querySelector(`input[name=q${i}]:checked`);
        const selIndex = selected ? parseInt(selected.value, 10) : null;
        const correctIndex = currentAnswerKey[i];

        if (selIndex === correctIndex) {
          pontos += POINTS_PER_QUESTION;
        } else {
          const vq = variant[i];
          errors.push({
            numero: i + 1,
            pergunta: vq.text,
            correctIndex: correctIndex,
            correctText: vq.options[correctIndex].text,
            userIndex: selIndex,
            userText: selIndex === null ? null : vq.options[selIndex].text
          });
        }
      }

      if (pontos >= PASS_SCORE) {
        document.getElementById("pontuacaoTexto").innerText = pontos;
        document.getElementById("certificado").classList.remove("hidden");
        document.getElementById("quizForm").classList.add("hidden");
        document.getElementById("errosContainer").classList.add("hidden");
        document.getElementById("refazerContainer").classList.add("hidden");
        window.scrollTo(0, 0);
      } else {
        alert(`Você fez ${pontos} pontos. Mínimo para aprovação: ${PASS_SCORE}.`);
        // Mostra erros
        document.getElementById("quizForm").classList.add("hidden");
        document.getElementById("quizContainer").classList.add("hidden");
        showErrors({ errors });

        // IMPORTANTE: incrementa tentativa para que a próxima variante seja diferente
        attempt += 1;
        localStorage.setItem(attemptKey, String(attempt));
      }
    });

    function refazerTeste() {
      // Gera nova variante com base no novo attempt e reexibe o quiz
      buildVariant();
      document.getElementById("errosContainer").classList.add("hidden");
      document.getElementById("refazerContainer").classList.add("hidden");
      document.getElementById("quizForm").classList.remove("hidden");
      document.getElementById("quizContainer").classList.remove("hidden");
      renderQuiz();
      window.scrollTo({ top: 0, behavior: 'smooth' });
    }

    // Certificado / utilitários
    function imprimirCertificado() {
      const nome = document.getElementById('nomeCompleto').value.trim();
      const cpf = document.getElementById('cpfInput').value.trim();
      if (!nome) { alert('Por favor, preencha seu nome completo.'); return; }
      if (!cpf || cpf.length !== 14) { alert('Por favor, preencha um CPF válido no formato 000.000.000-00.'); return; }
      const nomeFormatado = nome.toLowerCase().replace(/\b\w/g, l => l.toUpperCase());
      document.getElementById('nomeCompleto').value = nomeFormatado;
      window.print();
    }

    function abrirGovBr() {
      window.open("https://www.gov.br/pt-br/servicos/assinatura-eletronica", "_blank");
    }

    // Máscara CPF e formatação do nome
    const cpfInput = document.getElementById('cpfInput');
    cpfInput.addEventListener('input', function() {
      let v = this.value.replace(/\D/g, "");
      if (v.length > 11) v = v.slice(0,11);
      v = v.replace(/(\d{3})(\d)/, "$1.$2");
      v = v.replace(/(\d{3})(\d)/, "$1.$2");
      v = v.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
      this.value = v;
    });

    const nomeInput = document.getElementById('nomeCompleto');
    nomeInput.addEventListener('blur', function() {
      const nome = this.value.toLowerCase().replace(/\b\w/g, l => l.toUpperCase());
      this.value = nome;
    });

    // Inicialização
    buildVariant();
    renderQuiz();
  </script>
</body>
</html>
