<<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8" />
<title>Teste de Conhecimento - 30 Questões</title>
<style>
  /* ====== Estilo geral (tela) ====== */
  body {
    font-family: Arial, sans-serif;
    max-width: 900px;
    margin: auto;
    padding: 20px;
    background: #f9f9f9;
  }
  h1 { text-align: center; color: #333; }
  .pergunta { margin-bottom: 20px; }
  .resultado {
    display: none;
    margin-top: 20px;
    padding: 10px;
    background: #e0ffe0;
    border: 1px solid #00aa00;
  }
  .erro {
    background: #ffe0e0;
    border: 1px solid #cc0000;
    padding: 10px;
    margin-top: 10px;
  }
  input[type="text"] {
    width: 100%;
    padding: 8px;
    margin-bottom: 15px;
    font-size: 16px;
  }
  button { cursor: pointer; }

  /* ====== Certificado (na tela fica oculto até aprovação) ====== */
  #certificado {
    display: none;
    text-align: center;
    padding: 30px;
    border: 2px solid #333;
    margin: 30px auto;
    background: #fff;
    width: 100%;
    max-width: 800px;
    box-sizing: border-box;
  }
  #certificado img {
    width: 100px; /* ajuste o tamanho da logo aqui */
    margin-bottom: 20px;
  }
  #certificado h2 {
    font-size: 24px;
    text-align: center;
    margin-bottom: 10px;
  }
  /* Texto estilo ofício */
  #certificado p {
    font-size: 18px;
    line-height: 1.8;
    text-align: justify;
    text-indent: 50px;
    margin: 12px auto;
    max-width: 700px;
  }
  /* Subtítulo central (não justificado) */
  #certificado p.subtitulo {
    text-align: center;
    text-indent: 0;
    font-weight: bold;
    font-size: 20px;
    margin-top: 6px;
    margin-bottom: 18px;
  }
  /* Botão de imprimir do certificado (só aparece após aprovação) */
  #btnImprimirCert { display: none; margin-top: 16px; }

  /* ====== Impressão: 1 página A4 só com o certificado ====== */
  @media print {
    @page { size: A4; margin: 12mm; }

    body * { visibility: hidden; }
    #certificado, #certificado * { visibility: visible; }
    #btnImprimirCert { display: none !important; } /* esconde o botão na impressão */

    /* Ajustes para garantir que a data não suma no rodapé */
    #certificado {
      position: fixed;
      inset: 0;                 /* top/right/bottom/left = 0 */
      margin: auto;
      width: 180mm;             /* área segura dentro da A4 */
      max-height: 267mm;        /* 297mm - margens */
      overflow: visible;        /* permitir que a última linha apareça */
      border: none !important;
      box-shadow: none !important;
      background: #fff;
      padding: 0;
      text-align: center;

      /* Encolhe levemente no print para sobrar espaço no fim da página */
      transform: scale(0.96);
      transform-origin: top center;
    }

    /* Tipografia um pouco menor no print para não estourar a página */
    #certificado p {
      font-size: 16px !important;
      line-height: 1.6 !important;
      text-indent: 40px !important;
      margin: 10px auto !important;
      max-width: 170mm !important;
    }
  }
</style>
</head>
<body>

  <h1>Teste de Conhecimento em Investigação Criminal</h1>

  <div id="timer" style="text-align:center; font-size:20px; margin:20px 0; color:#d00;">
    <strong>Tempo restante:</strong> <span id="tempo">01:00:00</span>
  </div>

  <form id="quizForm">
    <label for="nome">Nome completo:</label>
    <input type="text" id="nome" placeholder="Ex: João da Silva" required />

    <label for="cpf">CPF:</label>
    <input type="text" id="cpf" placeholder="Ex: 000.000.000-00" required />
  </form>

  <button id="btnCorrigir" onclick="corrigir()">Ver Resultado</button>
  <div id="resultado" class="resultado"></div>
  <div id="erros"></div>
  <button id="btnRefazer" onclick="reiniciarTeste()" style="margin-top: 20px;">Refazer Teste</button>

  <!-- ====== Certificado ====== -->
  <div id="certificado">
    <img src="https://www.associacaodosdetetives.com.br/logotipoadb.png" alt="Logo ADB" />
    <h2>ASSOCIAÇÃO DOS DETETIVES DO BRASIL</h2>
    <p>
      Fundada em 09 de fevereiro de 2011, na forma da Lei que rege as associações —
      Lei Federal nº 10.406 de 10/01/2002 (Novo Código Civil) — com registro no órgão da Receita
      Federal sob o número CNPJ: 13.329.080/0001-75, com sede à Rua Isaac Bertoncine, nº 278,
      Centro – Lauro Müller, SC – CEP: 88880-000.
    </p><br>
    <p class="subtitulo">Certificado de Aprovação</p><br>
    <p id="certificadoTexto"></p>
    <button id="btnImprimirCert" onclick="imprimirCertificado()">Imprimir certificado</button>
  </div>

<script>
  /* ====== Gera certificado (oculta a prova, mostra botão de imprimir) ====== */
  function gerarCertificado(nome, cpf, acertos) {
    const certDiv = document.getElementById("certificado");
    const cidade = "Lauro Müller/SC"; // ajuste se quiser
    const data = new Date().toLocaleDateString('pt-BR', { day:'2-digit', month:'long', year:'numeric' });

    const texto = `Certificamos que <strong>${nome}</strong>, CPF: <strong>${cpf}</strong>, concluiu com real aproveitamento nesta entidade o teste de conhecimento em Investigação Criminal, obtendo <strong>${acertos}</strong> acertos de um total de ${perguntas.length} questões, para exercer a profissão de acordo com o C.B.O (código de ocupações) 3518-05 do Ministério do Trabalho e pelo Decreto Presidencial nº 5.154 de 23 de julho de 2004, pelas normas da Resolução CNE nº 04/99 – MEC (art. 7º, § 3º) de 7 de outubro de 1999, e a LEI Nº 13.432, DE 11 DE ABRIL DE 2017, que dispõe sobre o exercício da profissão de Detetive Particular. Pelo que expedimos este certificado em reconhecimento à sua capacidade.<br><br><br><strong>${cidade}, ${data}</strong>`;

    document.getElementById("certificadoTexto").innerHTML = texto;

    // Ocultar a prova, cronômetro, resultado, erros e botões
    document.getElementById("quizForm").style.display = "none";
    document.getElementById("timer").style.display = "none";
    document.getElementById("resultado").style.display = "none";
    document.getElementById("erros").style.display = "none";
    document.getElementById("btnCorrigir").style.display = "none";
    document.getElementById("btnRefazer").style.display = "none";

    // Exibir certificado e liberar botão de imprimir
    certDiv.style.display = "block";
    document.getElementById("btnImprimirCert").style.display = "inline-block";
    certDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
  }

  function imprimirCertificado() {
    window.print();
  }

  /* ====== Banco de perguntas ====== */
  const perguntas = [
    "Como a análise de padrões comportamentais pode ser aplicada em uma investigação de rotina para identificar suspeitos?",
    "Qual o papel da cadeia de custódia na integridade da prova documental obtida por um detetive particular?",
    "Em que circunstâncias o detetive particular pode utilizar tecnologia de geolocalização sem infringir direitos constitucionais?",
    "Como o princípio da razoabilidade deve orientar a atuação do detetive particular em ambientes públicos?",
    "Quais cuidados o detetive deve tomar ao elaborar um relatório que será apresentado em juízo?",
    "De que forma a atuação colaborativa entre detetive particular e advogado pode influenciar a eficácia de uma investigação?",
    "Como o detetive deve proceder ao encontrar indícios de um crime em andamento durante uma investigação civil?",
    "Quais são as implicações legais do uso de perfis falsos em redes sociais para fins investigativos?",
    "Como a Lei Geral de Proteção de Dados (LGPD) impacta a rotina de coleta de informações sensíveis pelo detetive?",
    "Explique a diferença entre vigilância e perseguição no contexto da atuação investigativa profissional.",
    "Quais técnicas de entrevista podem ser usadas para extrair informações de testemunhas sem violar a ética?",
    "Como a identificação de inconsistências em versões pode ser usada como técnica de verificação da veracidade dos fatos?",
    "Por que a imparcialidade é considerada um dos pilares da atuação do detetive particular?",
    "Quais são os riscos de contaminação de prova digital e como evitá-los?",
    "Como o detetive pode lidar com situações em que o cliente tenta interferir nos métodos da investigação?",
    "Qual a responsabilidade civil do detetive particular em caso de danos causados por informações inverídicas?",
    "Como a inteligência emocional auxilia na abordagem de pessoas durante uma investigação sensível?",
    "Explique como o uso de inteligência artificial pode contribuir (ou prejudicar) a atividade do detetive particular.",
    "Qual o impacto do viés cognitivo nas decisões do detetive e como mitigá-lo?",
    "Em que situações é justificável encerrar uma investigação antes do prazo acordado contratualmente?",
    "Como a análise de redes de relacionamento pode indicar conexões relevantes entre investigados?",
    "Quais são os principais cuidados ao realizar filmagens em locais públicos?",
    "Como o conhecimento em linguística pode apoiar a detecção de mentiras em depoimentos?",
    "Quais são as vantagens da vigilância fixa em relação à vigilância móvel?",
    "Como agir ao identificar uma testemunha-chave relutante em colaborar?",
    "De que forma o contexto cultural pode interferir na interpretação de comportamentos durante uma investigação?",
    "Qual o impacto de disfarces no sucesso de uma missão investigativa?",
    "O que caracteriza uma prova ilícita e quais as consequências de sua utilização?",
    "Como evitar interferências emocionais ao investigar casos que envolvam crianças ou idosos?",
    "Quais estratégias podem ser usadas para investigar um suspeito altamente cauteloso?",
    "Como documentar uma campana sem comprometer a discrição do profissional?"
  ];

  const alternativas = [
    ["A) Observando hábitos, horários e reações repetidas para traçar perfis e padrões.", "B) Aplicando questionários formais durante a investigação.", "C) Solicitando laudos diretamente à polícia.", "D) Seguindo os suspeitos sem análise técnica."],
    ["A) Garante que a prova foi obtida legalmente e sem manipulação.", "B) Serve apenas como registro auxiliar.", "C) Não se aplica a provas documentais.", "D) Permite que o detetive altere dados antes da entrega."],
    ["A) Quando há consentimento claro e expresso da parte investigada.", "B) Quando o equipamento é homologado pela ANATEL.", "C) Sempre que o detetive quiser testar o recurso.", "D) Apenas quando o investigado estiver em ambiente público."],
    ["A) Deve respeitar limites de privacidade mesmo em locais abertos.", "B) Pode agir sem restrições legais.", "C) Apenas observar sem registrar nada.", "D) Usar qualquer meio disponível para obter provas."],
    ["A) Utilizar linguagem técnica, clara e objetiva, com fontes verificáveis.", "B) Adicionar opiniões pessoais para reforçar argumentos.", "C) Escrever de forma informal para facilitar a leitura.", "D) Omitir detalhes sensíveis para proteger o cliente."],
    ["A) Permite alinhar estratégias jurídicas com os dados obtidos.", "B) Diminui a autonomia do detetive.", "C) Não é recomendada por envolver sigilo profissional.", "D) Viola o Código de Ética da OAB."],
    ["A) Acionar imediatamente a autoridade competente e preservar a cena.", "B) Acompanhar de longe e não intervir.", "C) Registrar com fotos e divulgar em redes sociais.", "D) Confrontar os envolvidos diretamente."],
    ["A) Pode configurar crime se violar direitos fundamentais da pessoa.", "B) É totalmente legal em qualquer situação.", "C) Requer permissão judicial sempre.", "D) É permitido apenas para casos de traição conjugal."],
    ["A) O detetive precisa justificar a coleta e proteger os dados sensíveis do investigado.", "B) A LGPD não se aplica a detetives.", "C) Basta informar ao cliente que os dados são protegidos.", "D) Só vale para empresas de tecnologia."],
    ["A) Vigilância é uma ação profissional com limites legais; perseguição é ilegal e abusiva.", "B) Ambas significam o mesmo no contexto investigativo.", "C) A diferença está apenas na distância de observação.", "D) Perseguir é permitido se for a pé."],
    ["A) Rapport, escuta ativa e perguntas abertas são fundamentais.", "B) Ameaças veladas podem ser eficazes.", "C) Recompensas sempre garantem sinceridade.", "D) Pressão psicológica é permitida se o objetivo for nobre."],
    ["A) Confrontando as informações com outras fontes e datas-chave.", "B) Registrando tudo como o cliente disser.", "C) Anotando apenas o que for conveniente ao contratante.", "D) Ignorando detalhes contraditórios."],
    ["A) Evita distorções e assegura a credibilidade do relatório.", "B) Permite julgamento do investigado.", "C) Não influencia no resultado final.", "D) É desnecessária quando há prova concreta."],
    ["A) Usar ferramentas de verificação e manter logs originais.", "B) Imprimir as provas e arquivar em pastas físicas.", "C) Converter arquivos para formatos editáveis.", "D) Compartilhar via redes públicas."],
    ["A) Manter independência e seguir o contrato com ética.", "B) Atender aos desejos do cliente a todo custo.", "C) Consultar o cliente antes de cada ação.", "D) Aceitar sugestões de interferência como cooperação."],
    ["A) Pode responder judicialmente por danos causados pela informação.", "B) Não possui responsabilidade desde que esteja contratado.", "C) Pode culpar a fonte da informação.", "D) Só responde se o cliente reclamar."],
    ["A) Ajuda a manter calma, empatia e assertividade nas abordagens.", "B) Serve para manipular emocionalmente testemunhas.", "C) Reduz o tempo de investigação.", "D) Não tem relevância na prática profissional."],
    ["A) Pode agilizar cruzamento de dados, mas não substitui análise humana criteriosa.", "B) Deve substituir o trabalho de campo tradicional.", "C) Só é útil em crimes cibernéticos.", "D) Não deve ser usada por detetives."],
    ["A) Pode levar a julgamentos errados; é preciso checar evidências objetivas.", "B) Ajuda a acelerar decisões e conclusões.", "C) Deve ser reforçado para aumentar convicção.", "D) É irrelevante se houver intuição."],
    ["A) Quando há risco à segurança ou violação ética no prosseguimento.", "B) Sempre que o cliente estiver insatisfeito.", "C) Após 50% do pagamento realizado.", "D) Quando o detetive perde interesse no caso."],
    ["A) Permite mapear ligações e influências relevantes para a investigação.", "B) É irrelevante sem prova concreta.", "C) Deve ser usada apenas por órgãos públicos.", "D) Não tem valor legal."],
    ["A) Verificar o direito à imagem e evitar gravações invasivas.", "B) Filmar livremente em qualquer local.", "C) Ocultar câmeras em banheiros públicos.", "D) Fazer transmissões ao vivo para o cliente."],
    ["A) Auxilia na identificação de contradições e padrões linguísticos.", "B) Não tem aplicação na investigação.", "C) É exclusiva de peritos judiciais.", "D) Só se aplica em interrogatórios policiais."],
    ["A) Proporciona observação contínua e maior controle.", "B) Tem mais riscos e menos eficácia.", "C) É recomendada apenas para casos simples.", "D) É inferior à vigilância móvel em todos os aspectos."],
    ["A) Construir confiança e garantir anonimato quando necessário.", "B) Ignorar a pessoa e seguir com outras fontes.", "C) Pressionar com ameaças veladas.", "D) Convocar diretamente a autoridade."],
    ["A) Pode gerar interpretações equivocadas se ignorado.", "B) Não afeta resultados.", "C) É irrelevante em perícias.", "D) Só interessa ao cliente."],
    ["A) Ajuda a preservar identidade e reduzir suspeitas.", "B) Dificulta a investigação.", "C) É proibido por lei.", "D) Compromete a seriedade da ação."],
    ["A) Aquela obtida com violação de direitos fundamentais.", "B) Qualquer prova não documentada.", "C) Informações de fonte anônima.", "D) Relatos de testemunhas não oficiais."],
    ["A) Manter postura profissional e procurar apoio psicológico se necessário.", "B) Recusar-se a atuar no caso.", "C) Tratar com indiferença para manter foco.", "D) Registrar em vídeo todo o processo."],
    ["A) Alternar horários e métodos, e evitar rotinas previsíveis.", "B) Seguir sempre à distância.", "C) Confrontar diretamente o suspeito.", "D) Utilizar apenas vigilância por câmeras."],
    ["A) Fazer anotações discretas e usar códigos visuais próprios.", "B) Registrar tudo em tempo real no celular.", "C) Compartilhar vídeos com colegas.", "D) Colar câmeras no corpo sem critério."]
  ];

  const gabarito = Array(30).fill("A");

  /* ====== Correção ====== */
  function corrigir() {
    const nome = document.getElementById("nome").value.trim();
    const cpf = document.getElementById("cpf").value.trim();
    const resultado = document.getElementById("resultado");
    const errosDiv = document.getElementById("erros");
    resultado.style.display = "none";
    errosDiv.innerHTML = "";

    if (!nome || !cpf) {
      alert("Por favor, preencha seu nome e CPF antes de enviar.");
      return;
    }

    let acertos = 0;
    let erros = [];

    for (let i = 0; i < perguntas.length; i++) {
      const resposta = document.querySelector('input[name="pergunta'+i+'"]:checked');
      if (resposta) {
        if (resposta.value === gabarito[i]) {
          acertos++;
        } else {
          erros.push({
            numero: i+1,
            pergunta: perguntas[i],
            correta: gabarito[i],
            marcada: resposta.value
          });
        }
      }
    }

    if (acertos >= 25) {
      resultado.innerHTML = "<strong>Parabéns!</strong> Você foi aprovado com " + acertos + " acertos.";
      gerarCertificado(nome, cpf, acertos);
    } else {
      resultado.innerHTML = "<strong>Você não atingiu a pontuação mínima.</strong> Acertos: " + acertos + " de " + perguntas.length;
      let listaErros = "<h3>Perguntas com erro:</h3>";
      erros.forEach(erro => {
        listaErros += "<div class='erro'><strong>Questão " + erro.numero + ":</strong> " + erro.pergunta + "<br>Resposta correta: " + erro.correta + "<br>Sua resposta: " + erro.marcada + "</div>";
      });
      errosDiv.innerHTML = listaErros;
      resultado.style.display = "block";
      window.scrollTo({ top: resultado.offsetTop - 20, behavior: 'smooth' });
    }
  }

  /* ====== Reiniciar ====== */
  function reiniciarTeste() {
    document.getElementById("quizForm").reset();
    document.getElementById("resultado").style.display = "none";
    document.getElementById("erros").innerHTML = "";
    document.getElementById("certificado").style.display = "none";
    document.getElementById("timer").style.display = "block";
    document.getElementById("btnCorrigir").style.display = "inline-block";
    document.getElementById("btnRefazer").style.display = "inline-block";
    window.location.reload(); // reconstruir tudo
  }

  /* ====== Monta questões ====== */
  window.onload = function() {
    const form = document.getElementById("quizForm");
    for (let i = 0; i < perguntas.length; i++) {
      const div = document.createElement("div");
      div.className = "pergunta";
      div.innerHTML = "<p><strong>" + (i+1) + ". " + perguntas[i] + "</strong></p>";
      alternativas[i].forEach((alt, j) => {
        const letra = String.fromCharCode(65 + j);
        div.innerHTML += "<label><input type='radio' name='pergunta" + i + "' value='" + letra + "'> " + alt + "</label><br>";
      });
      form.appendChild(div);
    }
    iniciarCronometro();
  };

  /* ====== Cronômetro (1h) ====== */
  function iniciarCronometro() {
    let tempoRestante = 60 * 60; // 1 hora em segundos
    const tempoSpan = document.getElementById("tempo");

    const intervalo = setInterval(() => {
      const horas = Math.floor(tempoRestante / 3600);
      const minutos = Math.floor((tempoRestante % 3600) / 60);
      const segundos = tempoRestante % 60;
      tempoSpan.textContent = `${String(horas).padStart(2, '0')}:${String(minutos).padStart(2, '0')}:${String(segundos).padStart(2, '0')}`;

      if (tempoRestante <= 0) {
        clearInterval(intervalo);
        corrigir();
        alert("Tempo esgotado. O teste foi finalizado automaticamente.");
      }
      tempoRestante--;
    }, 1000);
  }
</script>
</body>
</html>
