<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>Teste de Conhecimento - Investigação Particular</title>
  <meta name="description" content="Os detetives profissionais são profissionais que atuam na área privada e que prestam serviços específicos, de acordo com as necessidades de cada cliente na coleta de dados e informações, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse privado do contratante."/>
  <link href="https://www.associacaodosdetetives.com.br/logotipoadb.png" rel="shortcut icon" type="image/x-icon"/>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
      background: #f0f0f0;
      max-width: 800px;
      margin: auto;
    }
    h1, h2 { text-align: center; color: #003366; }
    .question {
      background: #fff;
      padding: 15px;
      margin-bottom: 15px;
      border-radius: 6px;
      box-shadow: 0 0 5px rgba(0,0,0,0.1);
    }
    .question p { font-weight: bold; margin-bottom: 10px; }
    label { display: block; margin-bottom: 5px; cursor: pointer; }
    input[type="radio"] { margin-right: 8px; }
    button {
      background-color: #003366;
      color: white;
      padding: 12px 20px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 1em;
      margin-top: 15px;
      display: block;
      margin-left: auto;
      margin-right: auto;
    }
    .print-button { background: #006600; margin-top: 20px; }
    .hidden { display: none; }
    #certificado {
      background-color: white;
      padding: 40px;
      margin-top: 30px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.2);
    }
    .assinatura input {
      width: 100%;
      padding: 8px;
      margin-top: 8px;
      margin-bottom: 16px;
      font-size: 1em;
      box-sizing: border-box;
    }
    #errosContainer {
      background: #fff3f3;
      border: 1px solid #cc0000;
      padding: 20px;
      margin-top: 30px;
      border-radius: 10px;
    }
    #errosContainer ul {
      list-style: none;
      padding-left: 0;
    }
    #errosContainer li { margin-bottom: 20px; }
    @media print {
      body * { visibility: hidden; }
      #certificado, #certificado * {
        visibility: visible;
      }
      #certificado {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        max-height: 100vh;
        padding: 20px;
        box-sizing: border-box;
        background: white;
        page-break-before: avoid;
        page-break-after: avoid;
        overflow: hidden;
      }
    }
  </style>
</head>
<body>
    <p style="color: #990000; font-weight: bold; margin-top: 30px; background: #ffeaea; padding: 15px; border-left: 5px solid #cc0000; border-radius: 5px;">
    🚫 <strong>AVISO LEGAL:</strong><br>
    É terminantemente proibido o uso deste conteúdo para fins comerciais, inclusive reprodução total ou parcial, distribuição ou adaptação sem autorização expressa da Associação dos Detetives do Brasil – ADB.<br><br>
    Esta proteção está garantida pela <strong>Lei Federal nº 9.610/98</strong> (Lei de Direitos Autorais). O descumprimento constitui violação legal, sujeita a sanções civis e penais.
  </p>
    <h1>Teste de Conhecimento<br>Investigação Particular</h1>
  <form id="quizForm"><div id="quizContainer"></div><button type="submit">VISUALIZAR ACERTO</button></form>
  <div id="errosContainer" class="hidden"><h2>Questões que você errou:</h2><ul id="listaErros"></ul></div>
  <div id="refazerContainer" class="hidden" style="text-align:center; margin-top: 20px;">
    <button onclick="window.location.reload()">Refazer Teste</button>
  </div>
    <div id="certificado" class="hidden">
         <table border="0" width="100%">
    <tr>
      <td width="30%">&nbsp;</td>
      <td width="40%" align="center"><img src="https://www.associacaodosdetetives.com.br/logotipoadb.png" width="50%" alt="Logo ADB"></td>
      <td width="30%">&nbsp;</td>
    </tr>
  </table>  
        
        <h2>Certificado de Participação<br><br>ASSOCIAÇÃO DOS DETETIVES DO BRASIL</h2><br>
 
      <p> Fundada em 09 de fevereiro de 2011, em conformidade com a Lei que rege as associações — Lei Federal nº 10.406, de 10 de janeiro de 2002 (Novo Código Civil). Registrada junto à Receita Federal sob o CNPJ nº 13.329.080/0001-75.</p>
    <p>Certificamos que o(a) participante evidenciou sólidos conhecimentos técnicos na área de Investigação Particular, destacando-se pelo desempenho satisfatório.</p>
    <p><strong>Pontuação:</strong> <span id="pontuacaoTexto"></span> de 40 pontos.</p>
    <p><strong>Status:</strong> Aprovado(a)</p>
    <div class="assinatura">
      <label for="nomeCompleto">Nome Completo:</label>
      <input type="text" placeholder="Digite Seu Nome Completo" required id="nomeCompleto" />
      <label for="cpfInput">CPF:</label>
      <input type="text" placeholder="000.000.000-00" id="cpfInput" required maxlength="14" />
    </div>
    <p style="margin-top:20px; font-size: 14px;">
      📚 O Conhecimento é a Chave da Investigação<br><br>
      A profissão de detetive particular exige muito mais do que intuição e experiência. Exige preparo, ética, técnica e atualização constante.<br><br>
      Estudar as leis, os métodos investigativos, as ferramentas tecnológicas e o comportamento humano é essencial para quem deseja exercer a profissão com excelência e responsabilidade.<br><br>
      Aprender é investigar o futuro. Estude, aprimore-se e fortaleça sua missão!
    </p>
    <button class="print-button" type="button" onclick="imprimirCertificado()">Imprimir Certificado</button>
  </div>
  <script>
     const perguntas = [
    "Como a análise de padrões comportamentais pode ser aplicada em uma investigação de rotina para identificar suspeitos?",
    "Qual o papel da cadeia de custódia na integridade da prova documental obtida por um detetive particular?",
    "Em que circunstâncias o detetive particular pode utilizar tecnologia de geolocalização sem infringir direitos constitucionais?",
    "Como o princípio da razoabilidade deve orientar a atuação do detetive particular em ambientes públicos?",
    "Quais cuidados o detetive deve tomar ao elaborar um relatório que será apresentado em juízo?",
    "De que forma a atuação colaborativa entre detetive particular e advogado pode influenciar a eficácia de uma investigação?",
    "Como o detetive deve proceder ao encontrar indícios de um crime em andamento durante uma investigação civil?",
    "Quais são as implicações legais do uso de perfis falsos em redes sociais para fins investigativos?",
    "Como a Lei Geral de Proteção de Dados (LGPD) impacta a rotina de coleta de informações sensíveis pelo detetive?",
    "Explique a diferença entre vigilância e perseguição no contexto da atuação investigativa profissional.",
    "Quais técnicas de entrevista podem ser usadas para extrair informações de testemunhas sem violar a ética?",
    "Como a identificação de inconsistências em versões pode ser usada como técnica de verificação da veracidade dos fatos?",
    "Por que a imparcialidade é considerada um dos pilares da atuação do detetive particular?",
    "Quais são os riscos de contaminação de prova digital e como evitá-los?",
    "Como o detetive pode lidar com situações em que o cliente tenta interferir nos métodos da investigação?",
    "Qual a responsabilidade civil do detetive particular em caso de danos causados por informações inverídicas?",
    "Como a inteligência emocional auxilia na abordagem de pessoas durante uma investigação sensível?",
    "Explique como o uso de inteligência artificial pode contribuir (ou prejudicar) a atividade do detetive particular.",
    "Qual o impacto do viés cognitivo nas decisões do detetive e como mitigá-lo?",
    "Em que situações é justificável encerrar uma investigação antes do prazo acordado contratualmente?"
  ];

  const alternativas = [
    ["A) Observando hábitos, horários e reações repetidas para traçar perfis e padrões.", "B) Aplicando questionários formais durante a investigação.", "C) Solicitando laudos diretamente à polícia.", "D) Seguindo os suspeitos sem análise técnica."],
    ["A) Garante que a prova foi obtida legalmente e sem manipulação.", "B) Serve apenas como registro auxiliar.", "C) Não se aplica a provas documentais.", "D) Permite que o detetive altere dados antes da entrega."],
    ["A) Quando há consentimento claro e expresso da parte investigada.", "B) Quando o equipamento é homologado pela ANATEL.", "C) Sempre que o detetive quiser testar o recurso.", "D) Apenas quando o investigado estiver em ambiente público."],
    ["A) Deve respeitar limites de privacidade mesmo em locais abertos.", "B) Pode agir sem restrições legais.", "C) Apenas observar sem registrar nada.", "D) Usar qualquer meio disponível para obter provas."],
    ["A) Utilizar linguagem técnica, clara e objetiva, com fontes verificáveis.", "B) Adicionar opiniões pessoais para reforçar argumentos.", "C) Escrever de forma informal para facilitar a leitura.", "D) Omitir detalhes sensíveis para proteger o cliente."],
    ["A) Permite alinhar estratégias jurídicas com os dados obtidos.", "B) Diminui a autonomia do detetive.", "C) Não é recomendada por envolver sigilo profissional.", "D) Viola o Código de Ética da OAB."],
    ["A) Acionar imediatamente a autoridade competente e preservar a cena.", "B) Acompanhar de longe e não intervir.", "C) Registrar com fotos e divulgar em redes sociais.", "D) Confrontar os envolvidos diretamente."],
    ["A) Pode configurar crime se violar direitos fundamentais da pessoa.", "B) É totalmente legal em qualquer situação.", "C) Requer permissão judicial sempre.", "D) É permitido apenas para casos de traição conjugal."],
    ["A) O detetive precisa justificar a coleta e proteger os dados sensíveis do investigado.", "B) A LGPD não se aplica a detetives.", "C) Basta informar ao cliente que os dados são protegidos.", "D) Só vale para empresas de tecnologia."],
    ["A) Vigilância é uma ação profissional com limites legais; perseguição é ilegal e abusiva.", "B) Ambas significam o mesmo no contexto investigativo.", "C) A diferença está apenas na distância de observação.", "D) Perseguir é permitido se for a pé."],
    ["A) Rapport, escuta ativa e perguntas abertas são fundamentais.", "B) Ameaças veladas podem ser eficazes.", "C) Recompensas sempre garantem sinceridade.", "D) Pressão psicológica é permitida se o objetivo for nobre."],
    ["A) Confrontando as informações com outras fontes e datas-chave.", "B) Registrando tudo como o cliente disser.", "C) Anotando apenas o que for conveniente ao contratante.", "D) Ignorando detalhes contraditórios."],
    ["A) Evita distorções e assegura a credibilidade do relatório.", "B) Permite julgamento do investigado.", "C) Não influencia no resultado final.", "D) É desnecessária quando há prova concreta."],
    ["A) Usar ferramentas de verificação e manter logs originais.", "B) Imprimir as provas e arquivar em pastas físicas.", "C) Converter arquivos para formatos editáveis.", "D) Compartilhar via redes públicas."],
    ["A) Manter independência e seguir o contrato com ética.", "B) Atender aos desejos do cliente a todo custo.", "C) Consultar o cliente antes de cada ação.", "D) Aceitar sugestões de interferência como cooperação."],
    ["A) Pode responder judicialmente por danos causados pela informação.", "B) Não possui responsabilidade desde que esteja contratado.", "C) Pode culpar a fonte da informação.", "D) Só responde se o cliente reclamar."],
    ["A) Ajuda a manter calma, empatia e assertividade nas abordagens.", "B) Serve para manipular emocionalmente testemunhas.", "C) Reduz o tempo de investigação.", "D) Não tem relevância na prática profissional."],
    ["A) Pode agilizar cruzamento de dados, mas não substitui análise humana criteriosa.", "B) Deve substituir o trabalho de campo tradicional.", "C) Só é útil em crimes cibernéticos.", "D) Não deve ser usada por detetives."],
    ["A) Pode levar a julgamentos errados; é preciso checar evidências objetivas.", "B) Ajuda a acelerar decisões e conclusões.", "C) Deve ser reforçado para aumentar convicção.", "D) É irrelevante se houver intuição."],
    ["A) Quando há risco à segurança ou violação ética no prosseguimento.", "B) Sempre que o cliente estiver insatisfeito.", "C) Após 50% do pagamento realizado.", "D) Quando o detetive perde interesse no caso."]
  ];

  const gabarito = [
    "A", "A", "A", "A", "A", "A", "A", "A", "A", "A",
    "A", "A", "A", "A", "A", "A", "A", "A", "A", "A"
  ];
    
    
    const quizContainer = document.getElementById('quizContainer');
    perguntas.forEach((pergunta, i) => {
      const div = document.createElement('div');
      div.classList.add('question');
      div.innerHTML = `<p>${i + 1}. ${pergunta}</p>` +
        alternativas[i].map(alt => `<label><input type="radio" name="q${i}" value="${alt.charAt(0)}" required> ${alt}</label>`).join('');
      quizContainer.appendChild(div);
    });
    document.getElementById("quizForm").addEventListener("submit", function(e) {
      e.preventDefault();
      let pontos = 0;
      let erros = [];
      for (let i = 0; i < gabarito.length; i++) {
        const selected = document.querySelector(`input[name=q${i}]:checked`);
        if (selected && selected.value === gabarito[i]) {
          pontos += 2;
        } else {
          erros.push({
            numero: i + 1,
            pergunta: perguntas[i],
            respostaCorreta: gabarito[i],
            alternativas: alternativas[i],
            respostaUsuario: selected ? selected.value : null
          });
        }
      }
      if (pontos >= 24) {
        document.getElementById("pontuacaoTexto").innerText = pontos;
        document.getElementById("certificado").classList.remove("hidden");
        document.getElementById("quizForm").classList.add("hidden");
        document.getElementById("errosContainer").classList.add("hidden");
        document.getElementById("refazerContainer").classList.add("hidden");
        window.scrollTo(0, 0);
      } else {
        alert(`Você fez ${pontos} pontos. Mínimo para aprovação: 24.`);
        document.getElementById("quizForm").classList.add("hidden");    // esconde o form
        document.getElementById("quizContainer").classList.add("hidden"); // esconde as perguntas
        const listaErros = document.getElementById("listaErros");
        listaErros.innerHTML = "";
        erros.forEach(erro => {
          const alternativaCerta = erro.alternativas.find(alt => alt.startsWith(erro.respostaCorreta));
          const alternativaMarcada = erro.respostaUsuario
            ? erro.alternativas.find(alt => alt.startsWith(erro.respostaUsuario))
            : "<i>(Você não respondeu)</i>";
          const li = document.createElement("li");
          li.innerHTML = `<strong>${erro.numero}. ${erro.pergunta}</strong><br>
                          <span style="color: green;"><em>✔ Resposta correta:</em> ${alternativaCerta}</span><br>
                          <span style="color: red;"><em>✘ Sua resposta:</em> ${alternativaMarcada}</span>`;
          listaErros.appendChild(li);
        });
        document.getElementById("errosContainer").classList.remove("hidden");
        document.getElementById("refazerContainer").classList.remove("hidden");
        window.scrollTo(document.getElementById("errosContainer").offsetTop, 0);
      }
    });
    function imprimirCertificado() {
      const nome = document.getElementById('nomeCompleto').value.trim();
      const cpf = document.getElementById('cpfInput').value.trim();
      if (!nome) { alert('Por favor, preencha seu nome completo.'); return; }
      if (!cpf || cpf.length !== 14) { alert('Por favor, preencha um CPF válido no formato 000.000.000-00.'); return; }
      const nomeFormatado = nome.toLowerCase().replace(/\b\w/g, l => l.toUpperCase());
      document.getElementById('nomeCompleto').value = nomeFormatado;
      window.print();
    }
    const cpfInput = document.getElementById('cpfInput');
    cpfInput.addEventListener('input', function(e) {
      let v = this.value.replace(/\D/g, "");
      if (v.length > 11) v = v.slice(0,11);
      v = v.replace(/(\d{3})(\d)/, "$1.$2");
      v = v.replace(/(\d{3})(\d)/, "$1.$2");
      v = v.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
      this.value = v;
    });
    const nomeInput = document.getElementById('nomeCompleto');
    nomeInput.addEventListener('blur', function() {
      const nome = this.value.toLowerCase().replace(/\b\w/g, l => l.toUpperCase());
      this.value = nome;
    });
  </script>
</body>
</html>