<?php 
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Termo de Responsabilidade - ADB</title>
<style>
:root{
  --bg:#111; --panel:#1c1c1c; --text:#eee; --muted:#bbb;
  --gold:#d4af37; --gold-2:#f0c94d; --line:#2c2c2c;
}
*{box-sizing:border-box}
body{font-family:"Segoe UI",Arial,sans-serif;background:var(--bg);color:var(--text);margin:0}
.container{max-width:920px;background:var(--panel);margin:32px auto;padding:28px;border-radius:14px;border:1px solid var(--gold);box-shadow:0 0 12px rgba(212,175,55,.25)}
h2{color:var(--gold);text-align:center;margin:0 0 18px}
.form-area{display:grid;gap:16px;margin-bottom:18px}
.grid{display:grid;grid-template-columns:1fr;gap:14px}
@media (min-width:720px){ .grid{grid-template-columns:1fr 1fr} }

.field{display:flex;flex-direction:column;gap:6px}
label{font-weight:600;font-size:.92rem;color:#fff}
.input, .input-adb{
  width:100%;padding:10px 12px;border-radius:10px;border:1px solid #555;background:#222;color:#fff;font-size:1rem;outline:none
}
.input:focus, .input-adb:focus{border-color:var(--gold)}
.input-wrap{position:relative}
.input-wrap .prefix{
  position:absolute;left:12px;top:50%;transform:translateY(-50%);
  color:var(--gold);font-weight:700;letter-spacing:.5px;pointer-events:none
}
.input-adb{padding-left:70px}
.hr{height:1px;background:var(--line);margin:8px 0 0}

.actions{display:flex;flex-wrap:wrap;gap:10px}
button{background:var(--gold);border:0;color:#000;padding:10px 16px;border-radius:10px;font-weight:700;cursor:pointer}
button:hover{background:var(--gold-2)}
a.btn{display:inline-block;text-decoration:none}
.note{color:var(--muted);font-size:.88rem}

.termo{
  display:none;background:#fff;color:#000;padding:24px;border-radius:12px;margin-top:18px;
  font-size:.95rem;line-height:1.36
}
.termo h3{margin:.2rem 0 .5rem;text-align:center}
.termo h2{color:#000;margin:.2rem 0 1rem;text-align:center}
.termo ul{margin:.4rem 0 .6rem 1rem}
.termo p{margin:.35rem 0}
.signline{margin-top:22px}

/* Impressão 1 folha A4 */
@page{size:A4;margin:1.5cm}
@media print{
  body{background:#fff;color:#000}
  .no-print{display:none !important}
  .container{background:#fff;border:0;box-shadow:none;padding:0;margin:0;max-width:100%}
  .termo{display:block !important;font-size:.95rem;line-height:1.32}
  .termo h2,.termo h3{margin:.3rem 0}
  .termo p, .termo li{margin:.25rem 0}
}
</style>

<script>
// máscara simples de CPF
function maskCPF(val){
  return val.replace(/\D/g,'')
            .replace(/(\d{3})(\d)/,'$1.$2')
            .replace(/(\d{3})(\d)/,'$1.$2')
            .replace(/(\d{3})(\d{1,2})$/,'$1-$2')
            .slice(0,14);
}
document.addEventListener('DOMContentLoaded', ()=>{
  const cpf = document.getElementById('cpf');
  cpf.addEventListener('input', e => e.target.value = maskCPF(e.target.value));

  const matricula = document.getElementById('matricula');
  matricula.addEventListener('input', e=>{
    e.target.value = e.target.value.replace(/^ADB-/i,'').replace(/\s+/g,'');
  });
});

function gerarTermo(){
  const nome = document.getElementById("nome").value.trim();
  const cpf = document.getElementById("cpf").value.trim();
  let matriculaNum = document.getElementById("matricula").value.trim();
  const cidade = document.getElementById("cidade").value.trim();
  const data = document.getElementById("data").value.trim();

  if(!nome || !cpf || !matriculaNum || !cidade || !data){
    alert("Por favor, preencha todos os campos.");
    return;
  }

  const matricula = "ADB-" + matriculaNum;

  const termoHTML = `
  <div class="termo" id="termo">
    <h3>ASSOCIAÇÃO DOS DETETIVES DO BRASIL</h3>
    <h2>TERMO DE RESPONSABILIDADE DE USO DA PLATAFORMA DE CONSULTAS</h2><br><br>

    <p>Pelo presente instrumento, <strong>${nome}</strong>, portador do CPF nº <strong>${cpf}</strong>, matrícula <strong>${matricula}</strong>, residente em <strong>${cidade}</strong>, declara estar ciente e de pleno acordo com as condições estabelecidas para o uso da Plataforma de Consultas da Associação dos Detetives do Brasil (ADB), conforme a Lei nº 13.432/2017.</p>

    <div style="border-left:4px solid #000;padding-left:10px;margin:12px 0;font-style:italic;">
      <strong>Art. 2º</strong> Para os fins desta Lei, considera-se detetive particular o profissional que, habitualmente, por conta própria ou na forma de sociedade civil ou empresarial, 
      planeje e execute coleta de dados e informações de natureza não criminal, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, 
      visando ao esclarecimento de assuntos de interesse privado do contratante.
    </div>

    <h3>1. FINALIDADE</h3>
    <p>O acesso é concedido exclusivamente para fins profissionais, limitando-se à coleta de dados e informações de natureza não criminal, nos termos do art. 2º da Lei nº 13.432/2017.</p><br>

    <h3>2. RESPONSABILIDADE DO USUÁRIO</h3>
    <ul>
      <li>Utilizar os recursos apenas para fins profissionais legítimos;</li>
      <li>Preservar o sigilo e a confidencialidade das informações obtidas;</li>
      <li>Responder civil e penalmente por uso indevido dos dados;</li>
      <li>Não empregar as consultas para fins ilícitos ou discriminatórios;</li>
      <li>Cumprir integralmente a LGPD (Lei nº 13.709/2018).</li>
    </ul>

    <h3>3. DECLARAÇÃO</h3>
    <p>Declaro, sob as penas da lei, que assumo total responsabilidade pelo uso da Plataforma de Consultas da ADB, comprometendo-me a agir de forma ética, sigilosa e conforme os limites da legislação vigente.</p><br>

    <h3>4. ATIVAÇÃO DE CONTA</h3>
    <div style="background:#f9f9f9;padding:10px;border-radius:8px;">
      <p>💰 Valor do Sistema: R$ 100,00 mensais</p>
      <p>💳 Forma de Pagamento: PIX<br>
      Chave PIX (CNPJ): 13.329.080/0001-75</p>
      <p>Para ativar sua conta, envie:<br>
      1️⃣ Seu e-mail de cadastro<br>
      2️⃣ O comprovante de pagamento</p>
      <p>📨 Após o envio, sua conta será liberada para acesso ao sistema.</p>
      <p style="margin-top:10px;">❗ <strong>Não há fidelidade:</strong> o usuário poderá cancelar o acesso a qualquer momento, sem multa ou obrigatoriedade de permanência.</p><br><br>
    </div>

    <p style="margin-top:20px;"><strong>Local e Data:</strong> ${cidade}, ${data}</p>
    <p><strong>Nome:</strong> ${nome}</p>
    <p><strong>CPF:</strong> ${cpf}</p>
    <p><strong>Matrícula ADB:</strong> ${matricula}</p><br><br>

    <p class="signline">_________________________________________<br>Assinatura do Profissional</p>

    <div class="no-print" style="margin-top:14px;text-align:center;">
      <a class="btn" href="manual_gov_br.php" target="_blank" rel="noopener">
        <button>Assinar com GOV.BR</button>
      </a>
      <button onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
    </div>
  </div>`;

  document.getElementById("resultado").innerHTML = termoHTML;
  document.getElementById("termo").style.display = "block";
}
</script>
</head>
<body>
  <div class="container">
    <h2 class="no-print">🕵️‍♂️ Termo de Responsabilidade de uso do sistema</h2>

    <div class="form-area no-print">
      <div class="grid">
        <div class="field">
          <label for="nome">Nome completo</label>
          <input class="input" type="text" id="nome" placeholder="Digite o nome completo">
        </div>

        <div class="field">
          <label for="cpf">CPF</label>
          <input class="input" type="text" id="cpf" placeholder="000.000.000-00" inputmode="numeric">
        </div>

        <div class="field">
          <label for="matricula">Matrícula ADB</label>
          <div class="input-wrap">
            <span class="prefix">ADB-</span>
            <input class="input-adb" type="text" id="matricula" placeholder="0001" inputmode="numeric">
          </div>
          <div class="note">Digite apenas o número. O prefixo ADB- será incluído automaticamente.</div>
        </div>

        <div class="field">
          <label for="cidade">Cidade / UF</label>
          <input class="input" type="text" id="cidade" placeholder="Cidade - Estado">
        </div>

        <div class="field">
          <label for="data">Data</label>
          <input class="input" type="text" id="data" placeholder="Ex: 31 de outubro de 2025">
        </div>
      </div>

      <div class="hr"></div>

      <div class="actions">
        <button onclick="gerarTermo()">Gerar Termo</button>
        <span class="note">Após gerar, você poderá imprimir em PDF ou assinar via GOV.BR.</span>
      </div>
    </div>

    <div id="resultado"></div>

    <div class="no-print" style="text-align:center;margin-top:14px;color:var(--muted);font-size:.86rem">
      © Associação dos Detetives do Brasil – ADB • Uso restrito a profissionais credenciados.
    </div>
  </div>
</body>
</html>
