<?php require_once('Connections/banco.php'); ?>
<?php
// Load the common classes
require_once('includes/common/KT_common.php');

// Load the tNG classes
require_once('includes/tng/tNG.inc.php');

// Make a transaction dispatcher instance
$tNGs = new tNG_dispatcher("");

// Make unified connection variable
$conn_banco = new KT_connection($banco, $database_banco);

// Start trigger
$formValidation = new tNG_FormValidation();
$formValidation->addField("kt_login_user", true, "text", "", "", "", "");
$formValidation->addField("kt_login_password", true, "text", "", "", "", "");
$tNGs->prepareValidation($formValidation);

// Make a login transaction instance
$loginTransaction = new tNG_login($conn_banco);
$tNGs->addTransaction($loginTransaction);
// Register triggers
$loginTransaction->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "POST", "kt_login1");
$loginTransaction->registerTrigger("BEFORE", "Trigger_Default_FormValidation", 10, $formValidation);
$loginTransaction->registerTrigger("END", "Trigger_Default_Redirect", 99, "{kt_login_redirect}");
// Add columns
$loginTransaction->addColumn("kt_login_user", "STRING_TYPE", "POST", "kt_login_user");
$loginTransaction->addColumn("kt_login_password", "STRING_TYPE", "POST", "kt_login_password");

// Execute all the registered transactions
$tNGs->executeTransactions();

// (Opcional) Obter recordset
$rscustom = $tNGs->getRecordset("custom");
$row_rscustom = mysql_fetch_assoc($rscustom);
$totalRows_rscustom = mysql_num_rows($rscustom);

// Header de saída
header('Content-Type: text/html; charset=UTF-8');

// Fallback para $BRASAO
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>
<style>
 :root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;        /* azul bem mais forte (navy profundo) */
  --azul-escuro:#000f24; /* ainda mais fechado p/ sombras/bordas */
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
}

  *{box-sizing:border-box}
  body{
    margin:0; font-family:Arial, Helvetica, sans-serif; color:var(--texto);
    background:#fff; line-height:1.6; -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale;
  }

  /* NAVBAR */
  .adb-nav{ position:sticky; top:0; z-index:999; background:var(--azul); color:#fff; border-bottom:3px solid var(--amarelo) }
  .adb-wrap{ max-width:1300px; margin:0 auto; padding:10px 16px; display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative }
  .adb-brand{ display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0 }
  .adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
  .adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap }
  .adb-toggle{ display:none; background:transparent; border:0; color:#fff; cursor:pointer; width:40px; height:40px; border-radius:8px }
  .adb-toggle:focus-visible{ outline:2px solid #fff; outline-offset:2px }
  .adb-menu{ list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px }
  .adb-menu a{ display:inline-block; text-decoration:none; color:#fff; font-weight:700; padding:10px 14px; border-radius:10px }
  .adb-menu a:hover{ background:rgba(255,255,255,.12) }

  @media (max-width:768px){
    .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
    .adb-menu{
      position:absolute; left:16px; right:16px; top:56px; background:var(--azul);
      flex-direction:column; align-items:stretch; gap:0; max-height:0; overflow:hidden; transition:max-height .25s ease;
      border-bottom:3px solid var(--amarelo); border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35);
    }
    .adb-menu.open{ max-height:420px }
    .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
    .adb-menu a{ padding:14px 18px }
  }

  /* HERO */
  header{ background:var(--azul); color:#fff; text-align:center; padding:28px 16px 46px; position:relative }
  header .topo{ max-width:1100px; margin:0 auto }
  header img.brasao{
    width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px;
    background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15)
  }
  header h1{ margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35) }
  header .faixa{ position:absolute; left:0; right:0; bottom:-18px; height:36px; background:var(--amarelo); border-top:2px solid rgba(255,255,255,.5); border-bottom:1px solid rgba(0,0,0,.08) }

  /* MAIN */
  main{ max-width:1000px; margin:48px auto 28px; padding:0 16px }
  .lead{ background:var(--cinza); border:1px solid var(--borda); border-left:4px solid var(--azul); padding:12px 14px; border-radius:10px; margin:0 0 16px 0 }
  .grid{ display:grid; grid-template-columns:1fr 1fr; gap:16px }
  .card{ background:#fff; border:1px solid var(--borda); border-radius:14px; padding:18px; box-shadow:0 6px 18px rgba(0,0,0,.04) }

  /* FORM */
  .form-row{ margin-bottom:14px }
  .label{ display:block; margin-bottom:6px; font-weight:700; font-size:14px }
  .input{
    width:100%; max-width:360px; height:44px; padding:10px 12px; border-radius:10px; border:1px solid var(--borda); font-size:16px;
    outline:none; transition:border-color .2s ease, box-shadow .2s ease; background:#fff;
  }
  .input:focus{ border-color:color-mix(in srgb, var(--azul), #000 14%); box-shadow:0 0 0 3px rgba(0,39,118,.15) }

  .field-hint, .field-error{ font-size:12px; margin-top:6px }
  .field-error{ color:#b91c1c }
  .actions{ margin-top:8px; display:flex; align-items:center; gap:12px; flex-wrap:wrap }

  .btn{
    display:inline-flex; align-items:center; justify-content:center; gap:.5rem;
    padding:12px 20px; border-radius:12px; border:1px solid color-mix(in srgb, var(--azul), #000 14%);
    background:linear-gradient(180deg, var(--azul) 0%, color-mix(in srgb, var(--azul), #000 12%) 100%);
    color:#fff; font-weight:800; letter-spacing:.2px; cursor:pointer;
    box-shadow:0 8px 18px rgba(0,39,118,.28), inset 0 1px 0 rgba(255,255,255,.18);
    transition:transform .15s ease, box-shadow .2s ease, background .2s ease, border-color .2s ease
  }
  .btn:hover{ transform:translateY(-1px); box-shadow:0 12px 28px rgba(0,39,118,.35), inset 0 1px 0 rgba(255,255,255,.22) }
  .btn:active{ transform:translateY(0); box-shadow:0 6px 14px rgba(0,39,118,.28) inset }
  .link{ color:#0b61ff; text-decoration:none; font-weight:700 }
  .link:hover{ text-decoration:underline }

  .pw-wrap{ position:relative; display:inline-block }
  .pw-toggle{
    position:absolute; right:10px; top:50%; transform:translateY(-50%);
    background:transparent; border:0; padding:4px; cursor:pointer
  }

  /* WHATSAPP FAB */
  .wa-fab{ position:fixed; right:18px; bottom:18px; z-index:1000; width:72px; height:72px; border-radius:50%; background:#25D366;
           display:flex; align-items:center; justify-content:center; box-shadow:0 10px 24px rgba(0,0,0,.25) }
  .wa-fab img{ width:38px; height:38px }

  /* RESPONSIVE */
  @media (max-width:768px){
    header{ padding:22px 12px 40px }
    header h1{ font-size:22px }
    header img.brasao{ width:90px; padding:6px; border-radius:8px }
    .grid{ grid-template-columns:1fr }
    .btn{ width:100% }
    .wa-fab{ width:64px; height:64px; right:14px; bottom:14px }
    .wa-fab img{ width:34px; height:34px }
  }

  /* PRINT */
  @media print{
    .adb-nav, header .faixa, .wa-fab{ display:none !important }
    header{ background:#fff; color:#000; padding:12px }
    header img.brasao{ background:transparent; box-shadow:none; padding:0 }
    .card{ box-shadow:none }
    body{ background:#fff }
  }
  .adb-menu a.active {
  background: var(--amarelo);
  color: var(--texto); /* deixa o texto escuro para contraste */
}

</style>


</head>
<body>

<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="index.php" rel="noopener">
      <img src="logotipoadb.png" alt="ADB">
      <span>Cadastro Nacional</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true"><path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/></svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
     <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
     <li><a href="atualizacao.php"class="active">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<header id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da República Federativa do Brasil" onerror="this.style.display='none'">
    <h1>Portal do associado</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<main>
  <p class="lead">
    <strong>Mural de avisos:</strong> mantenha seus dados sempre atualizados e proteja seu acesso. Em caso de dúvidas, fale com o suporte.
  </p>

  <section class="grid" style="margin-top:18px">
    <div class="card" style="text-align:center">
      <img src="login.png" alt="Login" style="max-width:280px; width:60%; height:auto">
      <div style="margin-top:8px; font-weight:700">Portal do associado</div>
    </div>

    <div class="card">
  <!-- Form de login (mantido) -->
  <p><?php echo $tNGs->getLoginMsg(); ?>
  <?php echo $tNGs->getErrorMsg(); ?></p>

  <form method="post" id="form1" class="KT_tngformerror" action="<?php echo KT_escapeAttribute(KT_getFullUri()); ?>" novalidate>
    <div class="form-row">
  <label for="kt_login_user" class="label">Matrícula</label>
  <input
    type="text"
    name="kt_login_user"
    id="kt_login_user"
    class="input"
    maxlength="9"
    autocomplete="ADB-123456"
    placeholder="Ex: ADB-123456"
    required
  >
  <?php echo $tNGs->displayFieldHint("kt_login_user"); ?>
  <div class="field-error"><?php echo $tNGs->displayFieldError("custom", "kt_login_user"); ?></div>
</div>


    <div class="form-row">
      <label for="kt_login_password" class="label">Senha</label>
      <div class="pw-wrap">
        <input
          type="password"
          name="kt_login_password"
          id="kt_login_password"
          class="input"
          autocomplete="current-password"
          placeholder="Digite sua senha"
          required
        >
        <button class="pw-toggle" type="button" aria-label="Mostrar/ocultar senha" title="Mostrar/ocultar senha" id="pwToggle">
          <!-- olho -->
          <svg width="22" height="22" viewBox="0 0 24 24" fill="none" aria-hidden="true">
            <path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7S2 12 2 12Z" stroke="#475569" stroke-width="1.8"/>
            <circle cx="12" cy="12" r="3.5" stroke="#475569" stroke-width="1.8"/>
          </svg>
        </button>
      </div>
      <?php echo $tNGs->displayFieldHint("kt_login_password"); ?>
      <div class="field-error"><?php echo $tNGs->displayFieldError("custom", "kt_login_password"); ?></div>
    </div>

    <div class="actions">
      <input type="submit" name="kt_login1" id="kt_login1" value="Entrar" class="btn">
      <a class="link" href="forgot_password.php" title="Recuperar senha">Recupere sua senha aqui!</a>
    </div>

    <?php
      // Exibe mensagem de erro geral, se houver
      if ($tNGs->getErrorMsg()) {
        echo '<div class="field-error" style="margin-top:10px">'.$tNGs->getErrorMsg().'</div>';
      }
    ?>
  </form>
</div>

  </section>
</main>

<!-- FAB WhatsApp -->
<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<footer style="max-width:1000px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center;">
  Associação dos Detetives do Brasil
</footer>

<script>
  // Navbar
  (function(){
    const btn = document.getElementById('adbToggle');
    const menu = document.getElementById('adbMenu');
    if(!btn || !menu || btn.dataset.bound) return;

    const closeMenu = () => { menu.classList.remove('open'); btn.setAttribute('aria-expanded','false'); document.body.style.overflow=''; };
    const openMenu  = () => { menu.classList.add('open');  btn.setAttribute('aria-expanded','true');  document.body.style.overflow='hidden'; };
    const toggle    = (e) => { e && e.stopPropagation(); menu.classList.contains('open') ? closeMenu() : openMenu(); };

    ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggle, {passive:true}));
    document.addEventListener('click', (e)=>{ if (!menu.classList.contains('open')) return; if (!e.target.closest('.adb-nav')) closeMenu(); }, true);
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape' && menu.classList.contains('open')) closeMenu(); });
    window.addEventListener('resize', ()=>{ if (window.innerWidth>768) closeMenu(); });
    btn.dataset.bound = '1';
  })();

  // Máscara para matrícula ADB-12345 (5 dígitos)
  (function(){
    const input = document.getElementById('kt_login_user');
    if(!input) return;

    input.addEventListener('focus', () => {
      if (!input.value.startsWith('ADB-')) input.value = 'ADB-';
      // posiciona o cursor ao fim
      setTimeout(()=>{ input.setSelectionRange(input.value.length, input.value.length); }, 0);
    });

    input.addEventListener('keydown', function(event) {
      const k = event.key;
      const allowed = ['ArrowRight','ArrowLeft','Tab','Delete','Backspace','Home','End'];
      if (input.selectionStart < 4 && !allowed.includes(k)) event.preventDefault();
    });

    input.addEventListener('input', function () {
      if (!input.value.startsWith('ADB-')) input.value = 'ADB-';
      let numbers = input.value.slice(4).replace(/\D/g, '').slice(0,5);
      input.value = 'ADB-' + numbers;
    });
  })();

  // Mostrar/ocultar senha
  (function(){
    const pw = document.getElementById('kt_login_password');
    const btn = document.getElementById('pwToggle');
    if(!pw || !btn) return;
    btn.addEventListener('click', ()=>{
      const isPwd = pw.type === 'password';
      pw.type = isPwd ? 'text' : 'password';
      btn.setAttribute('aria-label', isPwd ? 'Ocultar senha' : 'Mostrar senha');
    });
  })();
</script>
</body>
</html>
