<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>
  <style>
    body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; color: #333; }
    h1, h2 { color: #004d40; }
    .lgpd-banner {
      position: fixed;
      bottom: 0;
      width: 100%;
      background: #f0fdf4;
      border-top: 1px solid #ccc;
      padding: 16px;
      text-align: center;
      box-shadow: 0 -2px 6px rgba(0,0,0,0.1);
      font-size: 15px;
      z-index: 9999;
    }
    .lgpd-banner button {
      margin-top: 10px;
      padding: 8px 16px;
      background-color: #2e7d32;
      color: white;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }
    .hidden { display: none; }
  </style>
</head>
<body>

  <h1>Política de Privacidade</h1>
  <h2>1. Compromisso com a Privacidade</h2>
  <p>A Associação dos Detetives do Brasil (ADB) reafirma seu compromisso com a proteção da privacidade e dos dados pessoais de seus associados, visitantes e profissionais que interagem com a entidade. Todos os dados coletados são tratados com responsabilidade, segurança e em conformidade com a legislação vigente, garantindo transparência, confidencialidade e respeito aos direitos dos titulares.</p>

  <h2>2. Quais dados coletamos</h2>
 Para fins de identificação, registro e comunicação, são coletadas as seguintes informações:<br>
- Dados pessoais: nome completo, CPF, RG ou CNH;<br>

- Dados de contato: endereço residencial, e-mail e telefone;<br>

- Identificação visual e informações complementares: foto 3x4, tipo sanguíneo e documentos comprobatórios da atividade profissional.<br>

  <h2>3. Finalidade do uso</h2>
  <p>Os dados cadastrados são utilizados para a emissão de documentos profissionais, certificações, comunicação institucional com os associados e ações de padronização e fiscalização colaborativa. Além disso, visam fortalecer a profissão, proporcionando ao cidadão e às autoridades civis e militares uma fonte segura e confiável para a verificação da identidade, qualificação e regularidade dos profissionais devidamente registrados.
  
  </p>

  <h2>4. Compartilhamento</h2>
<p>
O compartilhamento das informações cadastrais do profissional poderá ocorrer apenas em situações específicas, sempre observando a legislação vigente e a proteção da privacidade:
</p>

<ol>
  <li>
    <strong>Clientes contratantes:</strong> quando houver solicitação por parte de clientes que tenham
    formalmente contratado o profissional, mediante apresentação do contrato de prestação de serviços
    assinado e reconhecido pela entidade.
  </li>
  <li>
    <strong>Autorização do profissional:</strong> mediante consentimento expresso do próprio profissional,
    por meio de seu código de acesso.
  </li>
  <li>
    <strong>Requisição legal:</strong> quando solicitado por autoridades competentes, nos termos da 
    <em>Lei nº 13.432/2017</em>, incluindo o Poder Judiciário, órgãos de segurança pública ou outras
    entidades legalmente autorizadas.
  </li>
</ol>


  <h2>5. Direitos do titular</h2>
  <p>O titular dos dados possui o direito de acessar, corrigir, atualizar ou solicitar a exclusão de suas informações pessoais a qualquer momento, mediante solicitação formal junto à Associação dos Detetives do Brasil (ADB).

Além disso, o direito de associação é livre e facultativo. O profissional pode ingressar ou se desligar da ADB a qualquer momento, conforme sua conveniência, sem sofrer qualquer cobrança, penalidade ou restrição ao exercício de sua atividade como profissional autônomo.</p>

  <h2>6. Segurança</h2>
  <p>Os dados pessoais são armazenados em ambiente seguro, com acesso restrito exclusivamente a pessoas autorizadas, devidamente comprometidas com a confidencialidade e a proteção das informações. A Associação dos Detetives do Brasil (ADB) adota medidas técnicas e administrativas para garantir a integridade, confidencialidade e disponibilidade dos dados, em conformidade com a Lei Geral de Proteção de Dados Pessoais (LGPD – Lei nº 13.709/2018).

</p>

  <h2>7. Cookies</h2>
  <p>Utilizamos cookies apenas para melhorar a navegação. Você pode desativá-los no seu navegador.</p>

  <div id="lgpd" class="lgpd-banner">
    🔒 Este site está em conformidade com a <strong>Lei Geral de Proteção de Dados (LGPD)</strong>. Ao continuar, você concorda com nossa política.
    <br>
    <button onclick="aceitarLGPD()">OK, Li e Aceito</button>
  </div>

  <script>
    function aceitarLGPD() {
      localStorage.setItem('lgpd_aceito', 'sim');
      document.getElementById('lgpd').classList.add('hidden');
    }
    window.onload = function () {
      if (localStorage.getItem('lgpd_aceito') === 'sim') {
        document.getElementById('lgpd').classList.add('hidden');
      }
    };
  </script>

</body>
</html>