<?php
// Arquivo: artigo_deveres.php
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            background-color: #f7f7f7;
            color: #333;
        }
        .container {
            background: #fff;
            padding: 30px;
            max-width: 900px;
            margin: auto;
            border-radius: 8px;
            box-shadow: 0 0 10px #ccc;
        }
        h1, h2 {
            color: #0a0a0a;
        }
        h1 {
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        ul {
            margin-top: 10px;
            padding-left: 20px;
        }
        .section {
            margin-top: 30px;
        }
        .footer {
            margin-top: 50px;
            font-style: italic;
            text-align: center;
            color: #666;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Obrigações e Deveres dos Profissionais Cadastrados na ADB</h1>

    <p>
        A <strong>Associação dos Detetives do Brasil – ADB</strong> estabelece regras e deveres fundamentais para todos os seus membros,
        com o objetivo de manter a ordem, a ética e a valorização da profissão de detetive particular.
    </p>

    <div class="section">
        <h2>1. Compromisso com a Verdade e a Ética Profissional</h2>
        <ul>
            <li>Zelar pela ética nas investigações;</li>
            <li>Preservar o sigilo das informações;</li>
            <li>Atuar com responsabilidade e discrição;</li>
            <li>Não comprometer a imagem da categoria com condutas inapropriadas.</li>
        </ul>
    </div>

    <div class="section">
        <h2>2. Atualização Cadastral e Participação</h2>
        <ul>
            <li>Manter os dados atualizados no sistema da ADB;</li>
            <li>Participar de assembleias, votações e convocações oficiais;</li>
            <li>Assinar documentos obrigatórios como editais e listas.</li>
        </ul>
    </div>
    <div class="section">
        <h2>Sanções pelo Descumprimento</h2>
        <p>O não cumprimento dos deveres pode gerar sanções como:</p>
        <ul>
            <li><strong>Advertência formal</strong> por falhas leves;</li>
            <li><strong>Suspensão temporária</strong> por descumprimentos reincidentes ou desrespeito aos processos administrativos;</li>
            <li><strong>Desligamento do quadro de associados</strong> nos casos graves ou de omissão prolongada.</li>
        </ul>
    </div>

    <div class="section">
        <h2>Compromisso com a Classe</h2>
        <p>
            A união e o comprometimento dos associados são fundamentais para a força da entidade.
            Respeitar suas obrigações é respeitar a si mesmo e à profissão.
        </p>
    </div>

    <div class="footer">
        Diretoria da ADB – Associação dos Detetives do Brasil
    </div>
</div>

</body>
</html>
