<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Manual de Ativação da Assinatura Digital GOV.BR</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f4f4f4;
      margin: 0;
      padding: 0;
      color: #333;
      line-height: 1.6;
    }

    .container {
      max-width: 900px;
      margin: auto;
      padding: 20px;
      background: #fff;
    }

    h1, h2 {
      color: #003366;
    }

    img {
      max-width: 100%;
      height: auto;
      display: block;
      margin: 20px auto;
    }

    ol, ul {
      margin-left: 20px;
    }

    a {
      color: #0066cc;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    .section {
      margin-bottom: 40px;
    }
  </style>
</head>
<body>

<div class="container">
  <h1>Manual Assinatura Digital GOV.BR</h1>

  <div class="section">
    <h2>Via Aplicativo GOV.BR (Celular)</h2>
    <img src="https://agenciagov.ebc.com.br/noticias/202505/assinatura-gov-br-ultrapassa-75-milhoes-de-usos-e-registra-alta-de-92-em-2025/@@download/image/Assinatura%20govbr.png" width="100%"alt="App GOV.BR no celular">

    <ol>
      <li>Baixe ou abra o aplicativo <strong>gov.br</strong> no seu celular Android ou iPhone.
<br>
<a href="https://play.google.com/store/apps/details?id=br.gov.meugovbr" target="_blank">
  <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" 
       alt="Disponível no Google Play" width="180">
</a></li>
      <li>Faça login com seu CPF e senha. Caso não tenha conta, crie uma no próprio app.</li>
      <li>Acesse <strong>Assinatura Eletrônica</strong> no menu “Assinar documentos” ou “Mais serviços”.</li>
      <li>Confirme que sua conta é <strong>nível Prata ou Ouro</strong>. Se necessário, eleve o nível com reconhecimento facial ou outro meio.</li>
      <li>Faça upload do documento PDF que deseja assinar.</li>
      <li>Toque em “Escolher arquivo” e selecione o documento salvo em seu celular.</li>
      <li>Clique no local onde será feita a assinatura e ajuste a posição.</li>
      <li>Clique em <strong>“Assinar”</strong> para aplicar a assinatura.</li>
      <li>Confirme clicando novamente em <strong>“Assinar”</strong>.</li>
      <li>Digite o código recebido por SMS e clique em <strong>“Autorizar”</strong>.</li>
      <li>Após finalizado, clique em <strong>“Baixar arquivo assinado”</strong>.</li>
      <li>Envie o documento assinado para o suporte da ADB.</li>
    </ol>
  </div>

  <div class="section">
    <h2>Via Computador (Site GOV.BR)</h2>
    <img src="https://p2.trrsf.com/image/fget/cf/500/0/images.terra.com/2025/04/11/1407239549-xpy6tcxjmfbujnjj3ggaqdzf7e.jpeg"width="100%" alt="Site GOV.BR Assinatura Digital">

    <p>
      <a href="https://www.gov.br/governodigital/pt-br/identidade/assinatura-eletronica" target="_blank">
        Acesse o site oficial de assinatura digital GOV.BR
      </a>
    </p>

    <ol>
      <li>Acesse o site: <br><strong>https://www.gov.br/pt-br/servicos/assinar-digitalmente-documentos</strong></li>
      <li>Faça login com CPF e senha. Se não tiver conta, crie uma nova.</li>
      <li>Entre em <strong>“Assinatura Eletrônica”</strong> pelo menu ou “Mais serviços”.</li>
      <li>Confirme nível Prata ou Ouro (use reconhecimento facial se necessário).</li>
      <li>Faça upload do documento PDF a ser assinado.</li>
      <li>Escolha o arquivo salvo no seu computador.</li>
      <li>Posicione a assinatura no local correto.</li>
      <li>Clique em <strong>“Assinar”</strong> e depois em <strong>“Confirmar Assinatura”</strong>.</li>
      <li>Insira o código enviado por SMS e clique em <strong>“Autorizar”</strong>.</li>
      <li>Baixe o arquivo assinado.</li>
      <li>Envie o documento assinado para o suporte da ADB.</li>
    </ol>
  </div>
</div>

</body>
</html>
