<?php require_once('Connections/banco.php'); ?> 
<?php
// Load the common classes
require_once('includes/common/KT_common.php');
// Load the tNG classes
require_once('includes/tng/tNG.inc.php');

// Make a transaction dispatcher instance
$tNGs = new tNG_dispatcher("");

// Make unified connection variable
$conn_banco = new KT_connection($banco, $database_banco);
/* ====================== CONSULTAS ====================== */
if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    if (PHP_VERSION < 6) {
      $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
    }
    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

    switch ($theType) {
      case "text":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "long":
      case "int":    $theValue = ($theValue != "") ? intval($theValue) : "NULL"; break;
      case "double": $theValue = ($theValue != "") ? doubleval($theValue) : "NULL"; break;
      case "date":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "defined":$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
    }
    return $theValue;
  }
}

$currentPage = $_SERVER["PHP_SELF"];

$maxRows_ConsulaDeterive = 200;
$pageNum_ConsulaDeterive = isset($_GET['pageNum_ConsulaDeterive']) ? (int)$_GET['pageNum_ConsulaDeterive'] : 0;
$startRow_ConsulaDeterive = $pageNum_ConsulaDeterive * $maxRows_ConsulaDeterive;

$colname_ConsulaDeterive = "-1";
if (isset($_GET['uf'])) {
  $colname_ConsulaDeterive = $_GET['uf'];
}

mysql_select_db($database_banco, $banco);
$query_ConsulaDeterive = sprintf("
  SELECT c.*, e.nm_estado
    FROM cadastro_detetive c
    JOIN estado e ON c.cd_estado = e.cd_estado
   WHERE c.cd_estado = %s
ORDER BY c.nome_detetive ASC",
  GetSQLValueString($colname_ConsulaDeterive, "int")
);
$query_limit_ConsulaDeterive = sprintf("%s LIMIT %d, %d", $query_ConsulaDeterive, $startRow_ConsulaDeterive, $maxRows_ConsulaDeterive);
$ConsulaDeterive = mysql_query($query_limit_ConsulaDeterive, $banco) or die(mysql_error());
$row_ConsulaDeterive = mysql_fetch_assoc($ConsulaDeterive);

if (isset($_GET['totalRows_ConsulaDeterive'])) {
  $totalRows_ConsulaDeterive = $_GET['totalRows_ConsulaDeterive'];
} else {
  $all_ConsulaDeterive = mysql_query($query_ConsulaDeterive);
  $totalRows_ConsulaDeterive = mysql_num_rows($all_ConsulaDeterive);
}
$totalPages_ConsulaDeterive = ceil($totalRows_ConsulaDeterive/$maxRows_ConsulaDeterive)-1;

mysql_select_db($database_banco, $banco);
$query_ConsultaEstado = "SELECT * FROM estado ORDER BY nm_estado ASC";
$ConsultaEstado = mysql_query($query_ConsultaEstado, $banco) or die(mysql_error());
$row_ConsultaEstado = mysql_fetch_assoc($ConsultaEstado);
$totalRows_ConsultaEstado = mysql_num_rows($ConsultaEstado);

/* Query string de paginação */
$queryString_ConsulaDeterive = "";
if (!empty($_SERVER['QUERY_STRING'])) {
  $params = explode("&", $_SERVER['QUERY_STRING']);
  $newParams = array();
  foreach ($params as $param) {
    if (stristr($param, "pageNum_ConsulaDeterive") == false && stristr($param, "totalRows_ConsulaDeterive") == false) {
      array_push($newParams, $param);
    }
  }
  if (count($newParams) != 0) {
    $queryString_ConsulaDeterive = "&" . htmlentities(implode("&", $newParams));
  }
}
$queryString_ConsulaDeterive = sprintf("&totalRows_ConsulaDeterive=%d%s", $totalRows_ConsulaDeterive, $queryString_ConsulaDeterive);

/* Fallback do brasão */
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>

<style>
 :root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;        /* azul bem mais forte (navy profundo) */
  --azul-escuro:#000f24; /* ainda mais fechado p/ sombras/bordas */
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
  --borda:#e5e7eb;       /* adicionada para evitar referência indefinida */
}

  *{box-sizing:border-box}
  body{
    margin:0; font-family:Arial, Helvetica, sans-serif; color:#1f2937;
    background:#fff; line-height:1.6; font-size:16px;
    -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale;
  }

  /* NAVBAR */
  .adb-nav{position:sticky; top:0; z-index:999; background:var(--azul); color:#fff; border-bottom:3px solid var(--amarelo)}
  .adb-wrap{max-width:1300px; margin:0 auto; padding:10px 16px; display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative}
  .adb-brand{display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0}
  .adb-brand img{width:40px; height:40px; border-radius:6px; background:#fff; padding:4px}
  .adb-brand span{font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap}
  .adb-toggle{display:none; background:transparent; border:0; color:#fff; cursor:pointer; width:40px; height:40px; border-radius:8px}
  .adb-toggle:focus-visible{outline:2px solid #fff; outline-offset:2px}
  .adb-menu{list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px}
  .adb-menu a{display:inline-block; text-decoration:none; color:#fff; font-weight:700; padding:10px 14px; border-radius:10px}
  .adb-menu a:hover{background:rgba(255,255,255,.12)}
  @media (max-width:768px){
    .adb-toggle{display:inline-flex; align-items:center; justify-content:center}
    .adb-menu{
      position:absolute; left:16px; right:16px; top:56px; background:var(--azul);
      flex-direction:column; align-items:stretch; gap:0;
      max-height:0; overflow:hidden; transition:max-height .25s ease;
      border-bottom:3px solid var(--amarelo); border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35)
    }
    .adb-menu.open{max-height:420px}
    .adb-menu li{border-top:1px solid rgba(255,255,255,.12)}
    .adb-menu a{padding:14px 18px}
  }

  /* HEADER */
  header.adb-hero{background:var(--azul); color:#fff; text-align:center; padding:28px 16px 46px; position:relative}
  header.adb-hero .topo{max-width:1100px; margin:0 auto}
  header.adb-hero img.brasao{
    width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px;
    background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15)
  }
  header.adb-hero h1{margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35)}
  header.adb-hero .faixa{position:absolute; left:0; right:0; bottom:-18px; height:36px; background:var(--amarelo); border-top:2px solid rgba(255,255,255,.5); border-bottom:1px solid rgba(0,0,0,.08)}

  /* MAIN */
  main{max-width:1300px; margin:48px auto 28px; padding:0 16px}
  .grid{display:grid; grid-template-columns:1fr 1fr 1fr; gap:16px} /* 3 colunas no desktop */
  .card{background:#fff; border:1px solid var(--borda); border-radius:14px; padding:18px; box-shadow:0 6px 18px rgba(0,0,0,.04)}
  .card h2,.card h3{margin-top:0}

  /* Botões */
  .btn{display:inline-block; padding:14px 22px; border-radius:10px; font-weight:700; font-size:18px; text-decoration:none; text-align:center; color:#fff; box-shadow:0 6px 16px rgba(0,0,0,.12); transition:.2s transform ease,.2s opacity ease; margin:6px 8px 0 0}
  .btn:hover{transform:translateY(-1px); opacity:.92}
  .btn:active{transform:translateY(0)}
  .btn-azul{background:var(--azul)}
  .btn-verde{background:var(--verde)}

  /* Botões primários dos formulários */
  :is(#rg,#cpf_cnpj) .btn-primario{
    --btn: var(--azul);
    --btn-2: color-mix(in srgb, var(--azul), black 12%);
    --ring: color-mix(in srgb, var(--azul), transparent 65%);
    position:relative; display:inline-flex; align-items:center; justify-content:center; gap:.5rem;
    padding:14px 24px; border-radius:12px;
    border:1px solid color-mix(in srgb, var(--azul), #000 14%);
    background: linear-gradient(180deg, var(--btn) 0%, var(--btn-2) 100%);
    color:#fff; font-weight:800; letter-spacing:.2px;
    box-shadow:0 8px 18px rgba(0,0,0,.18), inset 0 1px 0 rgba(255,255,255,.18);
    transition:transform .15s ease, box-shadow .2s ease, background .2s ease, border-color .2s ease, opacity .2s ease;
  }
  :is(#rg,#cpf_cnpj) .btn-primario:hover{transform:translateY(-1px)}
  :is(#rg,#cpf_cnpj) .btn-primario:active{transform:translateY(0)}
  :is(#rg,#cpf_cnpj) .btn-primario:focus-visible{outline:3px solid #fff; outline-offset:2px; box-shadow:0 0 0 4px var(--ring), 0 10px 22px rgba(0,0,0,.25)}

  /* Inputs com mesma altura */
  #rg #search-input, #cpf_cnpj #cpf{height:44px !important; padding:10px 14px !important; font-size:16px; border:1px solid #ccc; border-radius:8px}

  footer{max-width:1000px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center}

  /* FAB WhatsApp */
  .wa-fab{position:fixed; right:18px; bottom:18px; z-index:1000; display:inline-block; width:72px; height:72px; border-radius:50%; background:#25D366; box-shadow:0 10px 24px rgba(0,0,0,.25); display:flex; align-items:center; justify-content:center}
  .wa-fab img{width:38px; height:38px}

  /* Responsividade */
  @media (max-width:768px){
    header.adb-hero{padding:22px 12px 40px}
    header.adb-hero h1{font-size:22px}
    header.adb-hero img.brasao{width:90px; padding:6px; border-radius:8px}
    .grid{grid-template-columns:1fr} /* no celular, 1 coluna */
    .btn{display:block; width:100%; margin:10px 0 0}
    .wa-fab{width:64px; height:64px; right:14px; bottom:14px}
    .wa-fab img{width:34px; height:34px}
  }

  /* Print */
  @media print{
    .adb-nav, header.adb-hero .faixa, .wa-fab{display:none !important}
    header.adb-hero{background:#fff; color:#000; padding:12px}
    header.adb-hero img.brasao{background:transparent; box-shadow:none; padding:0}
    .card{box-shadow:none}
    body{background:#fff}
  }
  .adb-menu a.active {
    background: var(--amarelo);
    color: var(--texto); /* deixa o texto escuro para contraste */
  }
  .btn-secundario {
  display:inline-block;
  padding:10px 18px;
  border-radius:8px;
  font-weight:600;
  font-size:15px;
  text-decoration:none;
  background:#f3f4f6;       /* cinza bem claro */
  color:var(--azul);        /* mantém o azul da identidade */
  border:1px solid #d1d5db; /* borda leve */
  transition:.2s background ease, .2s color ease;
}
.btn-secundario:hover {
  background:#e5e7eb;
  color:var(--azul-escuro);
}
/* Ajuste global dos botões */
.btn,
.btn-primario,
.btn-secundario {
  display: inline-flex;              /* melhor alinhamento */
  align-items: center;
  justify-content: center;
  min-width: 180px;                  /* largura mínima */
  min-height: 48px;                  /* altura mínima */
  padding: 12px 24px;                /* espaçamento interno */
  font-size: 16px;                   /* padroniza o texto */
  font-weight: 700;
  border-radius: 10px;
  text-decoration: none;
  box-sizing: border-box;
}

/* Botão azul principal */
.btn-azul,
.btn-primario {
  background: var(--azul);
  color: #fff;
  border: none;
  cursor: pointer;
  transition: background 0.25s ease;
}
.btn-azul:hover,
.btn-primario:hover {
  background: var(--azul-escuro);
}

/* Botão secundário */
.btn-secundario {
  background: #f3f4f6;
  color: var(--azul);
  border: 1px solid #d1d5db;
  transition: background 0.25s ease, color 0.25s ease;
}
.btn-secundario:hover {
  background: #e5e7eb;
  color: var(--azul-escuro);
}

/* Em telas menores: botões ocupam largura total */
@media (max-width: 768px) {
  .btn,
  .btn-primario,
  .btn-secundario {
    width: 100%;
    min-width: unset;  /* remove limite fixo */
  }
}

</style>
<style>
/* Fundo escuro cobrindo toda a tela */
#avisoOverlay {
  position: fixed;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.8);
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 9999;
}

/* Caixa central */
#avisoModal {
  background: #fff;
  padding: 20px;
  max-width: 600px;
  width: 90%;
  border-radius: 12px;
  text-align: center;
  font-family: Arial, sans-serif;
  box-shadow: 0px 0px 20px #000;
}

#avisoModal h2 {
  color: #222;
  margin-bottom: 15px;
}

#avisoModal p {
  font-size: 16px;
  line-height: 1.5;
  margin-bottom: 20px;
}

#fecharAviso {
  background: #006400;
  color: #fff;
  padding: 12px 24px;
  border: none;
  border-radius: 8px;
  cursor: pointer;
  font-size: 16px;
}
#fecharAviso:hover {
  background: #228B22;
}
</style>



<script>
document.getElementById("fecharAviso").onclick = function() {
  document.getElementById("avisoOverlay").style.display = "none";
};
</script>

</head>
<body>

<!-- COMUNICADO AOS ASSOCIADOS – ABERTURA AUTOMÁTICA -->
<div id="comunicadoModal" style="display:none;position:fixed;z-index:9999;left:0;top:0;width:100%;height:100%;overflow:auto;background-color:rgba(0,0,0,0.7);transition:opacity 0.3s ease;">
  <div style="background:#212121;color:#f5f5f5;margin:5% auto;padding:30px;border-radius:10px;max-width:750px;
              font-family:'Segoe UI',Arial,sans-serif;box-shadow:0 0 25px rgba(0,0,0,0.6);position:relative;">
    
    <!-- BOTÃO DE FECHAR NO CANTO SUPERIOR DIREITO -->
    <button onclick="fecharComunicado()" 
            style="position:absolute;top:10px;right:10px;background:#d4af37;color:#000;
                   border:none;border-radius:50%;width:30px;height:30px;font-size:18px;
                   font-weight:bold;cursor:pointer;">×</button>
    
    <h2 style="text-align:center;color:#ffd700;">Comunicado aos Associados – Comprometimento Institucional</h2>
    <p>Prezados(as) Associados(as),</p>

    <p>Por exigência do cartório, estaremos <strong>refazendo todo o processo administrativo</strong> para adequá-lo às orientações solicitadas. Nosso objetivo é apresentar um <strong>modelo devidamente ajustado para o cadastro junto à Polícia Federal</strong>, garantindo que toda a parte jurídica esteja em plena conformidade.</p>

    <p>Dessa forma, estamos encaminhando o <strong>novo Edital</strong>, que precisou ser refeito. A partir do dia <strong>30 de dezembro</strong>, será encaminhada também a <strong>Ata correspondente para assinatura</strong>.</p>

    <p>📄 <strong>Pedimos, por gentileza</strong>, que realize a assinatura do Edital <strong>via GOV.BR</strong> e nos devolva o documento para que possamos encaminhá-lo ao cartório.</p><br>

    <p><a href="https://www.detetivesprofissionais.com.br/imprimir_edital.php" target="_blank" 
          style="background:#d4af37;color:#000;padding:10px 15px;border-radius:5px;text-decoration:none;font-weight:bold;">🔗 Acessar Edital</a></p>

    <hr style="border:0;border-top:1px solid #d4af37;margin:25px 0;">

    <h3 style="color:#ffd700;">Comprometimento Associativo</h3>

    <p>A Associação dos Detetives do Brasil informa que <strong>todos os membros associados</strong> devem manter compromisso com os atos administrativos que exigem <strong>assinatura e participação formal</strong>.</p>

    <p>Os associados que <strong>deixarem de cumprir</strong> as solicitações oficiais ou <strong>não realizarem as assinaturas necessárias</strong> poderão ter seu <strong>cadastro suspenso temporariamente</strong>, conforme previsto nas normas internas.</p>

    <blockquote style="background:#333;padding:10px 15px;border-left:5px solid #d4af37;color:#fff;">
      <strong>Art. 3º – Dos deveres dos profissionais cadastrados na ADB:</strong><br>
      V – Assinar documentos obrigatórios exigidos pela administração, como editais, termos e declarações.<br>
      🔗 <a href="https://detetivesprofissionais.com.br/regimento_interno.php" target="_blank" style="color:#ffd700;">Consultar Regimento Interno</a>
    </blockquote>

    <p>Nosso objetivo é <strong>fortalecer o sistema associativo</strong> e garantir que apenas profissionais <strong>verdadeiramente comprometidos</strong> com as obrigações e responsabilidades <strong>permaneçam ativos</strong>.</p>

    <p>Contamos com a colaboração, responsabilidade e seriedade de todos para o fortalecimento da nossa instituição.</p>

    <p style="margin-top:25px;text-align:center;font-weight:bold;color:#ffd700;">Associação dos Detetives do Brasil – ADB<br>
    <em style="color:#fff;">Compromisso, ética e fortalecimento profissional.</em></p>

    <p style="text-align:center;margin-top:25px;">
      <button onclick="fecharComunicado()" 
              style="background:#d4af37;color:#000;border:none;padding:10px 25px;
                     border-radius:5px;font-weight:bold;cursor:pointer;">Fechar</button>
    </p>
  </div>
</div>

<script>
  // Exibe automaticamente após o carregamento da página
  window.onload = function() {
    document.getElementById('comunicadoModal').style.display = 'block';
  }
  function fecharComunicado() {
    document.getElementById('comunicadoModal').style.display = 'none';
  }
</script>

<!-- SCRIPT DO MODAL -->
<script>
function abrirComunicado() {
  document.getElementById('comunicadoModal').style.display = 'block';
}
function fecharComunicado() {
  document.getElementById('comunicadoModal').style.display = 'none';
}

// ABRE AUTOMATICAMENTE APÓS 1 SEGUNDO
window.addEventListener('load', function() {
  setTimeout(function() {
    abrirComunicado();
  }, 1000);
});
</script>

<!-- NAVBAR -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="https://www.detetivesprofissionais.com.br/" rel="noopener">
      <img src="logotipoadb.png" alt="ADB">
      <span>Cadastro Nacional</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
      <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
      <li><a href="atualizacao.php"class="active">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<!-- HEADER -->
<header class="adb-hero" id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da Associação dos Detetives do Brasil" loading="lazy" onerror="this.style.display='none'">
    <h1>🔍 Opções de consultas</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<!-- MAIN -->
<main>
  <section class="grid" style="margin-top:18px">

   <!-- Consulta por MATRÍCULA -->
<div class="card">
  <form action="web_buscacompleta.php" method="post" enctype="multipart/form-data"
        name="restrito" id="rg" onsubmit="return validarCodigo();" style="text-align:center; padding:10px">
    <label for="search-input" style="display:block; margin-bottom:8px; font-weight:700">
      Consultar Nº de Matrícula
    </label>
    <input type="text" id="search-input" name="restrito" placeholder="ADB-12345"
           maxlength="12" required>
    <br><br>
    <button type="submit" class="btn btn-azul">🔍 Consultar</button>
  </form>

  <style>
    .btn {
      font-family: Arial, sans-serif;
      font-size: 14px;
      font-weight: 600;
      padding: 10px 20px;
      border-radius: 6px;
      display: inline-block;
      text-decoration: none;
      text-align: center;
      cursor: pointer;
    }

    .btn-azul {
      background-color: #001a33;
      color: #fff;
      border: none;
      transition: background 0.3s ease;
    }

    .btn-azul:hover {
      background-color: #003366;
    }
  </style>
</div>

<script>
(function(){
  const input = document.getElementById('search-input');
  if(!input) return;

  // Sempre força o prefixo ADB-
  input.addEventListener('focus', () => {
    if (!input.value.startsWith('ADB-')) input.value = 'ADB-';
  });

  // Bloqueia digitação antes do prefixo
  input.addEventListener('keydown', function(event) {
    if (input.selectionStart < 4 && !['ArrowRight','ArrowLeft','Tab','Delete','Backspace'].includes(event.key)) {
      event.preventDefault();
    }
  });

  // Garante apenas números após o ADB-
  input.addEventListener('input', function () {
    if (!input.value.startsWith('ADB-')) input.value = 'ADB-';
    let numeros = input.value.slice(4).replace(/\D/g, ''); // só números
    input.value = 'ADB-' + numeros;
  });

  // Validação final antes de enviar
  window.validarCodigo = function(){
    const valor = input.value.trim();
    const regex = /^ADB-\d+$/;
    if (!regex.test(valor)) {
      alert('Por favor, digite a matrícula no formato ADB-12345.');
      return false;
    }
    return true;
  };
})();
</script>


    <!-- Consulta por CPF -->
<div class="card">
  <form action="web_buscar.php" method="post" enctype="multipart/form-data"
        name="cpf_cnpj" id="cpf_cnpj" style="text-align:center; padding:10px">
    <label for="cpf" style="display:block; margin-bottom:8px; font-weight:700">
      Consultar CPF do profissional
    </label>
    <input type="text" id="cpf" name="cpf_cnpj" placeholder="CPF: 000.000.000-00" maxlength="14" required>
    <br><br>
    <button type="submit" class="btn btn-azul">🔍 Consultar</button>
  </form>

  <style>
    /* Estilo geral do botão */
    .btn {
      font-family: Arial, sans-serif;
      font-size: 14px;
      font-weight: 600;
      padding: 10px 20px;
      border-radius: 6px;
      display: inline-block;
      text-decoration: none;
      text-align: center;
      cursor: pointer;
    }

    /* Cor específica do botão azul */
    .btn-azul {
      background-color: #001a33; /* azul forte */
      color: #fff;
      transition: background 0.3s ease;
      border: none;
    }

    .btn-azul:hover {
      background-color: #003366; /* azul mais escuro no hover */
    }
  </style>
</div>

<script>
  // Máscara para CPF
  const cpfInput = document.getElementById('cpf');
  cpfInput.addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, ""); // Remove tudo que não for número
    if (value.length > 11) value = value.slice(0, 11); // Limita a 11 dígitos

    // Aplica a máscara conforme digita
    if (value.length > 9) {
      value = value.replace(/(\d{3})(\d{3})(\d{3})(\d{1,2})/, "$1.$2.$3-$4");
    } else if (value.length > 6) {
      value = value.replace(/(\d{3})(\d{3})(\d{1,3})/, "$1.$2.$3");
    } else if (value.length > 3) {
      value = value.replace(/(\d{3})(\d{1,3})/, "$1.$2");
    }
    e.target.value = value;
  });
</script>
    <!-- Terceira coluna: Profissionais Associados -->
    <div class="card" style="text-align:center; padding:20px">
      <h4 style="margin-bottom:12px">Profissionais Associados</h4>
      <p style="margin:0 0 10px">Lista oficial dos profissionais vinculados.</p>
     <a href="profissionais_associado.php"
   class="btn btn-azul" target="_blank" rel="noopener">
   👥 Acessar Lista
</a><br><br>   
     <h4>🪪  Carteira de identificação</h4>
     <p>A Identificação da Associação dos Detetives do Brasil é válida em todo o território nacional.</p>
      <a class="btn btn-verde" href="modelooficial.jpg" target="_blank" rel="noopener">⬇️ Modelo oficial - 2025</a>
    </div>

  </section><br><br>

  <p style="text-align:center; margin-top:18px">
  <a class="btn-secundario" href="politica_de_privacidade.php" target="_blank" rel="noopener">
    Política de Privacidade
  </a>
</p>

</main>

<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<style>
.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-transform: scale(1.5);
    transform: scale(1.5);
}

.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-filter: drop-shadow(0px 0px 5px rgba(255,20,147));
    filter: drop-shadow(0px 0px 20px rgba(255,20,147));
}

</style>
</a>
<footer>
  Associação dos Detetives do Brasil
</footer>

<!-- JS do menu -->
<script>
(function(){
  const btn  = document.getElementById('adbToggle');
  const menu = document.getElementById('adbMenu');
  if (!btn || !menu || btn.dataset.bound) return;

  const closeMenu = () => { menu.classList.remove('open'); btn.setAttribute('aria-expanded','false'); document.body.style.overflow=''; };
  const openMenu  = () => { menu.classList.add('open');  btn.setAttribute('aria-expanded','true');  document.body.style.overflow='hidden'; };
  const toggle    = (e) => { e && e.stopPropagation(); menu.classList.contains('open') ? closeMenu() : openMenu(); };

  ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggle, {passive:true}));
  document.addEventListener('click', (e)=>{ if (!menu.classList.contains('open')) return; if (!e.target.closest('.adb-nav')) closeMenu(); }, true);
  document.addEventListener('keydown', (e)=>{ if(e.key==='Escape' && menu.classList.contains('open')) closeMenu(); });
  window.addEventListener('resize', ()=>{ if (window.innerWidth>768) closeMenu(); });
  window.addEventListener('pageshow', ()=>{ closeMenu(); });

  btn.dataset.bound = '1';
})();
</script>
<!-- === ADB • BOTÃO FLUTUANTE DE TRADUÇÃO (BANDEIRAS + BUSCA) • VERSÃO ESTÁVEL === -->
<div id="adb-translate">
  <button id="adb-translate-toggle" type="button" aria-label="Traduzir página">
    🌐 <span>Tradução</span>
  </button>

  <div id="adb-translate-panel" role="dialog" aria-label="Selecione um idioma">
    <div class="adb-translate-header">
      <input id="adb-translate-search" type="text" placeholder="Buscar idioma..." aria-label="Buscar idioma" />
      <button id="adb-translate-close" type="button" aria-label="Fechar">✖</button>
    </div>
    <div id="adb-translate-grid" aria-live="polite"></div>
    <div class="adb-translate-foot">
      <small>ASSOCIAÇÃO DOS DETETIVES DO BRASIL • ADB</small>
    </div>
  </div>
</div>

<!-- Elemento oculto necessário ao Google Translate -->
<div id="google_translate_element" style="display:none;"></div>

<style>
  :root{ --adb-black:#000; --adb-gold:#c9a34b; --adb-gray:#111; }
  #adb-translate{
    position:fixed; bottom:20px; left:20px; z-index:2147483000; /* bem alto */
    font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
  }
  #adb-translate-toggle{
    display:flex; align-items:center; gap:8px;
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:12px;
    padding:8px 12px; cursor:pointer; box-shadow:0 6px 14px rgba(0,0,0,.45);
    font-weight:600;
  }
  #adb-translate-toggle:hover{ filter:brightness(1.1); }

  #adb-translate-panel{
    display:none; margin-top:10px; width:min(92vw, 720px); max-height:min(70vh, 560px);
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:14px;
    box-shadow:0 14px 40px rgba(0,0,0,.6); overflow:hidden;
  }
  #adb-translate.open #adb-translate-panel{ display:block; }

  .adb-translate-header{
    display:flex; align-items:center; gap:8px;
    padding:10px; background:var(--adb-gray); border-bottom:1px solid #2a2a2a;
  }
  #adb-translate-search{
    flex:1; padding:10px 12px; border-radius:10px; border:1px solid #333;
    background:#000; color:#eee; outline:none;
  }
  #adb-translate-search::placeholder{ color:#999; }
  #adb-translate-close{
    background:#000; color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:10px; padding:8px 10px; cursor:pointer;
  }
  #adb-translate-close:hover{ background:#111; }

  #adb-translate-grid{
    padding:10px; display:grid; grid-template-columns: repeat(6, 1fr);
    gap:8px; overflow:auto; max-height: calc(min(70vh, 560px) - 98px);
  }
  @media (max-width:640px){ #adb-translate-grid{ grid-template-columns: repeat(3, 1fr); } }
  .adb-lang{
    display:flex; align-items:center; gap:8px;
    background:#0a0a0a; color:#ddd; border:1px solid #222; border-radius:10px;
    padding:8px; cursor:pointer; min-height:44px;
  }
  .adb-lang:hover{ border-color:var(--adb-gold); transform:translateY(-1px); }
  .adb-flag{ width:1.6em; display:inline-flex; align-items:center; justify-content:center; }
  .adb-flag .fi{ width:1.5em; height:1em; border-radius:2px; box-shadow:0 0 0 1px rgba(0,0,0,.25); }
  .adb-name{ font-size:13px; line-height:1.2; }
  .adb-code{ font-size:11px; opacity:.7; }

  .adb-translate-foot{ padding:8px 10px; border-top:1px solid #2a2a2a; text-align:center; background:#0b0b0b; }
  .adb-translate-foot small{ color:#9a865b; }

  /* Anti-banner do Google Translate (desktop + mobile) */
  #goog-gt-tt, .goog-te-balloon-frame, .goog-te-menu-frame, .goog-te-banner-frame { display:none !important; visibility:hidden !important; opacity:0 !important; height:0 !important; }
  iframe.goog-te-banner-frame { display:none !important; }
  html, body { top:0 !important; margin-top:0 !important; transform:none !important; }
  html.translated-ltr body, html.translated-rtl body { top:0 !important; position:static !important; }
  body > .skiptranslate { display:none !important; }
</style>

<script>
(function(){
  'use strict';

  /* ===== Lista de códigos (~130) ===== */
  const BASE_CODES = 'pt,af,sq,am,ar,hy,as,ay,az,bm,eu,be,bn,bho,bs,bg,ca,ceb,zh-CN,zh-TW,co,hr,cs,da,dv,doi,nl,en,eo,et,ee,fil,fi,fr,fy,gl,ka,de,el,gn,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,ilo,id,ga,it,ja,jv,kn,kk,km,rw,gom,ko,kri,ku,ky,lo,la,lv,ln,lt,lg,lb,mk,mai,mg,ms,ml,mt,mi,mr,lus,mn,my,ne,no,nso,ny,or,om,ps,fa,pl,pt-PT,pa,qu,ro,ru,sm,sa,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,tg,ta,tt,te,th,ti,ts,tr,tk,tw,uk,ur,ug,uz,vi,xh,yi,yo,zu'.split(',');

  /* Nomes e bandeiras por emoji — sempre funciona (mobile/desktop que suporte emoji) */
  const MAP = {
    'pt':['Português (Original)','🇧🇷'], 'en':['Inglês','🇺🇸'], 'es':['Espanhol','🇪🇸'], 'fr':['Francês','🇫🇷'], 'de':['Alemão','🇩🇪'],
    'it':['Italiano','🇮🇹'], 'ru':['Russo','🇷🇺'], 'ja':['Japonês','🇯🇵'], 'ko':['Coreano','🇰🇷'],
    'zh-CN':['Chinês (Simplificado)','🇨🇳'], 'zh-TW':['Chinês (Tradicional)','🇹🇼'], 'ar':['Árabe','🇸🇦'],
    'hi':['Hindi','🇮🇳'], 'bn':['Bengali','🇧🇩'], 'id':['Indonésio','🇮🇩'], 'tr':['Turco','🇹🇷'],
    'uk':['Ucraniano','🇺🇦'], 'pl':['Polonês','🇵🇱'], 'pt-PT':['Português (Portugal)','🇵🇹'],
    'fa':['Persa (Farsi)','🇮🇷'], 'he':['Hebraico','🇮🇱'], 'el':['Grego','🇬🇷'], 'sv':['Sueco','🇸🇪'],
    'no':['Norueguês','🇳🇴'], 'da':['Dinamarquês','🇩🇰'], 'fi':['Finlandês','🇫🇮'], 'cs':['Tcheco','🇨🇿'],
    'sk':['Eslovaco','🇸🇰'], 'sl':['Esloveno','🇸🇮'], 'ro':['Romeno','🇷🇴'], 'hu':['Húngaro','🇭🇺'],
    'bg':['Búlgaro','🇧🇬'], 'sr':['Sérvio','🇷🇸'], 'hr':['Croata','🇭🇷'], 'nl':['Holandês','🇳🇱'],
    'et':['Estoniano','🇪🇪'], 'lv':['Letão','🇱🇻'], 'lt':['Lituano','🇱🇹'], 'ga':['Irlandês','🇮🇪'],
    'gd':['Gaélico Escocês','🏴'], 'gl':['Galego','🇪🇸'], 'ca':['Catalão','🇪🇸'], 'eu':['Basco','🇪🇸'],
    'mi':['Maori','🇳🇿'], 'ms':['Malaio','🇲🇾'], 'sw':['Suaíli','🇰🇪'], 'vi':['Vietnamita','🇻🇳'],
    'th':['Tailandês','🇹🇭'], 'ur':['Urdu','🇵🇰'], 'ta':['Tâmil','🇮🇳'], 'te':['Telugo','🇮🇳'],
    'ml':['Malaiala','🇮🇳'], 'mr':['Marati','🇮🇳'], 'kn':['Kannada','🇮🇳'], 'gu':['Gujarati','🇮🇳'],
    'ne':['Nepalês','🇳🇵'], 'si':['Cingalês (Sinhala)','🇱🇰'], 'my':['Birmanês','🇲🇲'], 'km':['Khmer','🇰🇭'],
    'lo':['Lao','🇱🇦'], 'mn':['Mongol','🇲🇳'], 'kk':['Cazaque','🇰🇿'], 'uz':['Uzbeque','🇺🇿'],
    'az':['Azeri','🇦🇿'], 'ka':['Georgiano','🇬🇪'], 'hy':['Armênio','🇦🇲'], 'ps':['Pastó (Pashto)','🇦🇫'],
    'tk':['Turcomano','🇹🇲'], 'tg':['Tajique','🇹🇯'], 'ky':['Quirguiz','🇰🇬'], 'ku':['Curdo','🇮🇶'],
    'pa':['Panjabi (Punjabi)','🇮🇳'], 'af':['Africâner','🇿🇦'], 'sq':['Albanês','🇦🇱'], 'bs':['Bósnio','🇧🇦'],
    'mk':['Macedônio','🇲🇰'], 'is':['Islandês','🇮🇸'], 'xh':['Xhosa','🇿🇦'], 'zu':['Zulu','🇿🇦'],
    'st':['Sesoto (Sotho do Sul)','🇿🇦'], 'nso':['Sepedi (Sotho do Norte)','🇿🇦'], 'yo':['Iorubá','🇳🇬'],
    'ig':['Igbo','🇳🇬'], 'ha':['Hauçá','🇳🇬'], 'rw':['Quiniaruanda','🇷🇼'], 'so':['Somali','🇸🇴'],
    'am':['Amárico','🇪🇹'], 'ti':['Tigrínia','🇪🇷'], 'om':['Oromo','🇪🇹'], 'ee':['Ewe','🇬🇭'],
    'tw':['Twi (Akan)','🇬🇭'], 'kri':['Krio','🇸🇱'], 'sm':['Samoano','🇼🇸'], 'ht':['Haitiano Crioulo','🇭🇹'],
    'fil':['Filipino','🇵🇭'], 'tl':['Tagalo','🇵🇭'], 'jv':['Javanês','🇮🇩'], 'su':['Sundanês','🇮🇩'],
    'bho':['Bojpuri','🇮🇳'], 'mai':['Maithili','🇮🇳'], 'or':['Odia (Oriá)','🇮🇳'], 'as':['Assamês','🇮🇳'],
    'gom':['Concani (Konkani)','🇮🇳'], 'la':['Latim','🌐'], 'sa':['Sânscrito','🌐'], 'tt':['Tártaro','🌐'],
    'yi':['Iídiche','🌐'], 'hmn':['Hmong','🌐'], 'co':['Córsico','🇫🇷'], 'haw':['Havaiano','🇺🇸']
  };

  const ADB_LANGUAGES = BASE_CODES.map(code => {
    const [name, flag] = MAP[code] || [code,'🌐'];
    return { code, name, flag };
  });

  const ADB_CODE_ALIASES = { 'pt-BR':'pt', 'zh':'zh-CN' };

  /* Google Translate init */
  window.googleTranslateElementInit = function(){
    try{
      new google.translate.TranslateElement({
        pageLanguage:'pt',
        includedLanguages: ADB_LANGUAGES.map(l => l.code).join(','),
        autoDisplay:false
      }, 'google_translate_element');
    }catch(e){}
  };

  function normalizeCode(code){ return ADB_CODE_ALIASES[code] || code; }
  function setTranslateCookie(langTo){
    try{
      const pair = '/pt/' + normalizeCode(langTo);
      const domain = location.hostname.replace(/^www\./,'');
      const base = 'googtrans=' + pair + '; path=/;';
      document.cookie = base;
      document.cookie = base + ' domain=.' + domain + ';';
    }catch(e){}
  }
  function applyTranslation(lang){
    try{
      if(!lang) return;
      setTranslateCookie(lang);
      const sel = document.querySelector('select.goog-te-combo');
      if (sel){
        sel.value = normalizeCode(lang);
        sel.dispatchEvent(new Event('change', {bubbles:true}));
        antiBanner.trigger();
      } else {
        location.reload();
      }
    }catch(e){}
  }

  /* Render e interação */
  (function(){
    const root=document.getElementById('adb-translate');
    const toggle=document.getElementById('adb-translate-toggle');
    const panel=document.getElementById('adb-translate-panel');
    const closeBtn=document.getElementById('adb-translate-close');
    const grid=document.getElementById('adb-translate-grid');
    const search=document.getElementById('adb-translate-search');

    function itemHTML(lang){
      return '<button class="adb-lang" type="button" data-code="'+lang.code+'" title="'+lang.name+'">'
           +   '<span class="adb-flag">'+lang.flag+'</span>'
           +   '<div class="adb-meta">'
           +     '<div class="adb-name">'+lang.name+'</div>'
           +     '<div class="adb-code">'+lang.code+'</div>'
           +   '</div>'
           + '</button>';
    }
    function renderList(filter){
      try{
        const f=(filter||'').trim().toLowerCase();
        const list = ADB_LANGUAGES.filter(l => !f || l.name.toLowerCase().includes(f) || l.code.toLowerCase().includes(f));
        grid.innerHTML = list.map(itemHTML).join('');
        // após render, tenta aplicar SVGs (se folha carregar)
        applySVGFlagsSafe();
      }catch(e){}
    }
    renderList('');

    toggle.addEventListener('click', ()=>{ root.classList.toggle('open'); if(root.classList.contains('open')) search.focus(); });
    closeBtn.addEventListener('click', ()=> root.classList.remove('open'));
    document.addEventListener('click', (e)=>{
      const btn = e.target.closest('.adb-lang');
      if(btn){ applyTranslation(btn.getAttribute('data-code')); }
    });
    search.addEventListener('input', ()=>renderList(search.value));
  })();

  /* Anti-banner (agressivo e seguro) */
  const antiBanner = (function(){
    function kill(){
      try{
        document.querySelectorAll('iframe.goog-te-banner-frame, .goog-te-menu-frame, #goog-gt-tt, .goog-te-balloon-frame').forEach(el => el.remove());
        document.documentElement.style.top='0px';
        document.body.style.top='0px';
        document.body.style.position='static';
        document.body.style.marginTop='0px';
        document.body.style.transform='none';
      }catch(e){}
    }
    function burst(){
      kill(); setTimeout(kill,200); setTimeout(kill,600); setTimeout(kill,1200); setTimeout(kill,2500); setTimeout(kill,4000);
    }
    try{
      const obs=new MutationObserver(burst);
      obs.observe(document.documentElement,{childList:true,subtree:true});
    }catch(e){}
    window.addEventListener('load', burst);
    window.addEventListener('resize', burst);
    window.addEventListener('orientationchange', burst);
    document.addEventListener('DOMContentLoaded', burst);
    return { trigger: burst };
  })();

  /* ===== Bandeiras SVG no desktop (opcional, sem travar nada) ===== */
  // Carrega CSS de bandeiras; se não carregar, continua com emoji.
  let flagCSSLoaded = false;
  try{
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css';
    link.onload = function(){ flagCSSLoaded = true; applySVGFlagsSafe(); };
    document.head.appendChild(link);
  }catch(e){}

  // Mapeamento mínimo idioma->país para SVG; não listado => mantém emoji.
  const FLAG_MAP = {
    'pt':'br','pt-PT':'pt','en':'us','es':'es','fr':'fr','de':'de','it':'it','ru':'ru',
    'ja':'jp','ko':'kr','zh-CN':'cn','zh-TW':'tw','ar':'sa','he':'il','fa':'ir',
    'hi':'in','bn':'bd','id':'id','tr':'tr','uk':'ua','pl':'pl','nl':'nl','sv':'se',
    'no':'no','da':'dk','fi':'fi','cs':'cz','sk':'sk','sl':'si','ro':'ro','hu':'hu',
    'bg':'bg','sr':'rs','hr':'hr','et':'ee','lv':'lv','lt':'lt','ga':'ie','gd':'gb', /* gb (uk) genérico */
    'gl':'es','ca':'es','eu':'es','mi':'nz','ms':'my','sw':'ke','vi':'vn','th':'th',
    'ur':'pk','ta':'in','te':'in','ml':'in','mr':'in','kn':'in','gu':'in','ne':'np',
    'si':'lk','my':'mm','km':'kh','lo':'la','mn':'mn','kk':'kz','uz':'uz','az':'az',
    'ka':'ge','hy':'am','ps':'af','tk':'tm','tg':'tj','ky':'kg','ku':'iq','pa':'in',
    'af':'za','sq':'al','bs':'ba','mk':'mk','is':'is','xh':'za','zu':'za','st':'za',
    'nso':'za','yo':'ng','ig':'ng','ha':'ng','rw':'rw','so':'so','am':'et','ti':'er',
    'om':'et','ee':'gh','tw':'gh','kri':'sl','sm':'ws','ht':'ht','fil':'ph','tl':'ph',
    'jv':'id','su':'id','bho':'in','mai':'in','or':'in','as':'in','gom':'in','co':'fr','haw':'us'
  };

  function applySVGFlagsSafe(){
    try{
      if(!flagCSSLoaded) return; // só tenta se o CSS carregou
      const grid = document.getElementById('adb-translate-grid');
      if(!grid) return;
      grid.querySelectorAll('.adb-lang').forEach(btn=>{
        const code = btn.getAttribute('data-code');
        const cc = FLAG_MAP[code];
        const holder = btn.querySelector('.adb-flag');
        if(holder && cc){
          holder.innerHTML = '<span class="fi fi-'+cc+'"></span>';
        }
      });
    }catch(e){}
  }

})();
</script>

<!-- Script oficial do Google Translate -->
<script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<!-- === / ADB • BOTÃO FLUTUANTE DE TRADUÇÃO • VERSÃO ESTÁVEL === -->

</body>
</html>
