<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – Procuração</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    *{box-sizing:border-box}
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111;line-height:1.6}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB */
    .header{background:#000;color:#d4af37;padding:20px 12px;display:flex;flex-direction:column;align-items:center;text-align:center}
    .header img{height:80px;display:block;margin:0 auto}
    .header h1{margin:6px 0;color:#fff;font-size:22px}
    .header .idline{margin:4px 0;color:#f0e6b2;font-size:13px;display:block}

    .lead{background:#fff7cc;border:1px solid #ffe08a;color:#5a4d00;padding:12px 14px;border-radius:10px;margin:0 0 16px 0}
    p{text-align:justify}
    .no-print{display:block}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#004aad;color:#fff;font-weight:700;cursor:pointer}
    .btn:hover{opacity:.92}
    .muted{color:#4b5563}

    .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    label{font-weight:700;display:block;margin-bottom:4px}
    input[type="text"], input[type="number"]{width:100%;padding:10px;border:1px solid #ccc;border-radius:8px}

    /* Assinaturas */
    .assinaturas-duplas{margin-top:28px;display:flex;gap:18px;align-items:flex-start;justify-content:space-between;flex-wrap:wrap}
    .assin-card{flex:1 1 410px;border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff;min-width:380px}
    .assin-titulo{font-weight:700;text-align:center;margin-bottom:12px}
    .assin-area{border:1px dashed #888;border-radius:8px;height:120px;background:#fafafa;margin:10px 0 12px}
    .assin-linha{margin-top:18px;border-top:1px solid #000;padding-top:6px;text-align:center}

    .local-data{text-align:center;margin-top:10px}
    .links-util{display:flex;gap:8px;justify-content:flex-end;margin-top:8px}
    .links-util a{font-size:12px;color:#004aad;text-decoration:none}

    @media (max-width:768px){.form-grid{grid-template-columns:1fr}.assin-card{min-width:auto}}

    /* Impressão */
    @media print{
      .no-print{display:none!important}
      input{border:0!important;background:transparent!important;box-shadow:none!important;outline:0!important;padding:0!important;margin:0!important;appearance:none;-webkit-appearance:none}
      input[type="text"], input[type="number"]{display:inline!important;width:auto!important}
      input::placeholder{color:transparent!important}
      @page{size:A4;margin:14mm}
      .container{box-shadow:none}
      body{background:#fff}
      .header{text-align:center;align-items:center}
    }
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- ========== FORMULÁRIO (sem banco) ========== -->
    <div id="formArea" class="no-print">
      <h2>Procuração</h2>
      <div class="lead">Preencha os campos e clique em <strong>Gerar documento</strong>. Depois você pode revisar e <strong>imprimir em PDF</strong>.</div>

      <h3>Outorgante</h3>
      <div class="form-grid">
        <div>
          <label>Nome do outorgante</label>
          <input type="text" id="o_nome" placeholder="Nome do Cliente" required>
        </div>
        <div>
          <label>CPF do outorgante</label>
          <input type="text" id="o_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço do outorgante</label>
          <input type="text" id="o_end" placeholder="Rua, nº, Bairro – Cidade/UF" required>
        </div>
      </div>

      <h3>Procurador (Detetive Profissional)</h3>
      <div class="form-grid">
        <div>
          <label>Nome do procurador</label>
          <input type="text" id="p_nome" placeholder="Nome completo" required>
        </div>
        <div>
          <label>Estado civil</label>
          <input type="text" id="p_civil" placeholder="solteiro" value="solteiro">
        </div>
        <div>
          <label>CPF do procurador</label>
          <input type="text" id="p_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div>
          <label>Identidade (RG)</label>
          <input type="text" id="p_rg" placeholder="Número da identidade" required>
        </div>
        <div>
          <label>Matrícula ADB </label>
          <input type="text" id="p_matricula" placeholder="ADB-12345">
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço do escritório</label>
          <input type="text" id="p_end" placeholder="Av./Rua, nº, Bairro – Cidade/UF" required>
        </div>
      </div>

      <h3>Local e Data</h3>
      <div class="form-grid">
        <div>
          <label>Cidade</label>
          <input type="text" id="cidade" placeholder="Cidade" required>
        </div>
        <div>
          <label>Data (dd/mm/aaaa)</label>
          <input type="text" id="data_doc" placeholder="00/00/2025" maxlength="10" inputmode="numeric" required>
        </div>
      </div>

      <div style="text-align:right;margin-top:18px">
        <button class="btn" id="btnGerar">Gerar documento</button>
      </div>
    </div>

    <!-- ========== DOCUMENTO GERADO ========== -->
    <div id="printArea" style="display:none">
      <h2>PROCURAÇÃO</h2>

      <div class="links-util no-print">
        <a href="#" id="editAgain">← Voltar e editar</a>
        <a href="#" onclick="window.print()">🖨️ Imprimir / Salvar PDF</a>
      </div>

      <p>
        Por este instrumento particular de procuração, o <strong>OUTORGANTE</strong> abaixo qualificado, nomeia e constitui seu bastante <strong>procurador</strong> <strong><span id="out_p_nome"></span></strong>, brasileiro, <span id="out_p_civil"></span>, Detetive Profissional, Identidade nº <strong><span id="out_p_rg"></span></strong>, CPF nº <strong><span id="out_p_cpf"></span></strong><span id="out_p_matricula_wrap"></span>, com escritório na <strong><span id="out_p_end"></span></strong>, Detetive profissional de acordo com o Código Brasileiro de Ocupações nº <strong>3518-05</strong> e pela Lei Federal nº <strong>13.432</strong>, outorgando-lhe todos os poderes contidos na cláusula “<em>ad judicia</em>” e extrajudicial, para que proceda a todos os atos necessários à defesa dos seus direitos e interesses, em qualquer foro ou instância ou onde se fizer necessário, com poderes para o acompanhamento de inquérito policial, postulando as diligências que achar necessárias, podendo requerer e providenciar documentos junto à repartição pública, narrar fatos e, enfim, tudo mais praticar para o fiel e cabal desempenho deste mandato que lhe é conferido.
      </p>

      <p>
        <strong>Outorgante:</strong> <span id="out_o_nome"></span> — CPF: <span id="out_o_cpf"></span> — Endereço: <span id="out_o_end"></span>
      </p>

      <p class="local-data">
        <strong><span id="out_local_data_extenso"></span></strong>
      </p>

      <div class="assinaturas-duplas">
        <div class="assin-card">
          <div class="assin-titulo">OUTORGANTE</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_o_nome_ass"></span></strong><br>
            CPF: <span id="out_o_cpf_ass"></span>
          </div>
        </div>
        <div class="assin-card">
          <div class="assin-titulo">PROCURADOR (DETETIVE)</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_p_nome_ass"></span></strong><br>
            CPF: <span id="out_p_cpf_ass"></span><span id="out_p_matricula_ass_wrap"></span>
          </div>
        </div>
      </div>

      <div class="no-print" style="text-align:right;margin-top:16px">
        <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
      </div>

      <br>
      <p class="muted">Documento elaborado em conformidade com a Lei Federal nº 13.432/2017 (atividade do detetive particular).</p>
    </div>
  </div>
</div>

<script>
  const el = (id)=>document.getElementById(id);
  const onlyDigits = (v)=> (v||'').replace(/\D/g,'');

  // Máscaras CPF
  ['o_cpf','p_cpf'].forEach(id=>{
    el(id).addEventListener('input', ()=>{
      let v = onlyDigits(el(id).value).slice(0,11);
      if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
      else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
      else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
      el(id).value = v;
    });
  });

  // Matrícula ADB opcional
  el('p_matricula').addEventListener('blur', ()=>{
    let v = el('p_matricula').value.trim().toUpperCase();
    if(!v) return;
    if(!v.startsWith('ADB-')) v = 'ADB-' + v.replace(/[^0-9]/g,'');
    else v = 'ADB-' + v.slice(4).replace(/[^0-9]/g,'');
    el('p_matricula').value = v;
  });

  // Data dd/mm/aaaa
  el('data_doc').addEventListener('input', ()=>{
    let v = onlyDigits(el('data_doc').value).slice(0,8);
    if(v.length >= 5) v = v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/, '$1/$2/$3');
    else if(v.length >= 3) v = v.replace(/^(\d{2})(\d{0,2}).*$/, '$1/$2');
    el('data_doc').value = v;
  });

  function dataPorExtenso(ddmmaa){
    const meses = ['janeiro','fevereiro','março','abril','maio','junho','julho','agosto','setembro','outubro','novembro','dezembro'];
    const m = /^([0-3]\\d)\/([0-1]\\d)\/(\\d{4})$/.exec(ddmmaa);
    if(!m) return ddmmaa;
    const d = parseInt(m[1],10); const mi = Math.max(1, Math.min(12, parseInt(m[2],10))) - 1; const a = m[3];
    return `${d} de ${meses[mi]} de ${a}`;
  }

  // Geração do documento
  el('btnGerar').addEventListener('click', ()=>{
    // Coleta
    const o_nome = el('o_nome').value.trim();
    const o_cpf  = el('o_cpf').value.trim();
    const o_end  = el('o_end').value.trim();

    const p_nome = el('p_nome').value.trim();
    const p_civil= el('p_civil').value.trim() || 'solteiro';
    const p_cpf  = el('p_cpf').value.trim();
    const p_rg   = el('p_rg').value.trim();
    const p_mat  = el('p_matricula').value.trim();
    const p_end  = el('p_end').value.trim();

    const cidade = el('cidade').value.trim();
    const dataDoc= el('data_doc').value.trim();

    // Valida
    if(!o_nome){ alert('Informe o nome do outorgante.'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(o_cpf)){ alert('CPF do outorgante inválido. Use 000.000.000-00.'); return; }
    if(!o_end){ alert('Informe o endereço do outorgante.'); return; }

    if(!p_nome){ alert('Informe o nome do procurador (detetive).'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(p_cpf)){ alert('CPF do procurador inválido.'); return; }
    if(!p_rg){ alert('Informe o RG do procurador.'); return; }
    if(!p_end){ alert('Informe o endereço do escritório.'); return; }

    if(!cidade){ alert('Informe a cidade.'); return; }
    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(dataDoc)){ alert('Informe a data no formato dd/mm/aaaa.'); return; }

    // Preenche saída
    el('out_o_nome').innerText = o_nome;
    el('out_o_cpf').innerText  = o_cpf;
    el('out_o_end').innerText  = o_end;

    el('out_p_nome').innerText = p_nome;
    el('out_p_civil').innerText= p_civil;
    el('out_p_cpf').innerText  = p_cpf;
    el('out_p_rg').innerText   = p_rg;
    el('out_p_end').innerText  = p_end;

    if(p_mat){
      el('out_p_matricula_wrap').innerHTML = `, Matrícula ADB nº <strong>${p_mat}</strong>`;
      el('out_p_matricula_ass_wrap').innerHTML = ` • Matrícula ADB: <span>${p_mat}</span>`;
    } else {
      el('out_p_matricula_wrap').innerHTML = '';
      el('out_p_matricula_ass_wrap').innerHTML = '';
    }

    el('out_local_data_extenso').innerText = `${cidade}, ${dataPorExtenso(dataDoc)}`;

    // Assinaturas
    el('out_o_nome_ass').innerText = o_nome;
    el('out_o_cpf_ass').innerText  = o_cpf;
    el('out_p_nome_ass').innerText = p_nome;
    el('out_p_cpf_ass').innerText  = p_cpf;

    // Alterna telas
    document.getElementById('formArea').style.display = 'none';
    document.getElementById('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });

  // Voltar e editar
  document.getElementById('editAgain').addEventListener('click', (e)=>{
    e.preventDefault();
    document.getElementById('printArea').style.display = 'none';
    document.getElementById('formArea').style.display = 'block';
    window.scrollTo(0,0);
  });
</script>
</body>
</html>
