<?php
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edital de Convocação - ADB</title>
<style>
:root{
  --bg:#111; --panel:#1c1c1c; --text:#eee;
  --gold:#d4af37;
}
body{
  font-family:"Segoe UI",Arial,sans-serif;
  background:var(--bg);color:var(--text);margin:0;
}
.container{
  max-width:900px;background:var(--panel);margin:30px auto;
  padding:30px;border-radius:12px;border:1px solid var(--gold);
  box-shadow:0 0 10px rgba(212,175,55,.3);
}
h2{color:var(--gold);text-align:center;margin-bottom:15px}
button{
  background:var(--gold);border:0;color:#000;padding:10px 16px;
  border-radius:8px;font-weight:bold;cursor:pointer;transition:.2s;
}
button:hover{filter:brightness(1.05)}
input{
  width:100%;padding:10px;border-radius:8px;border:1px solid #555;
  background:#222;color:#fff;margin-top:6px;font-size:0.95em;
}
.no-print{margin-bottom:15px}
.assinaturas{
  display:grid;grid-template-columns:1fr 1fr;gap:15px;margin-top:20px;
}
.ass-box{
  border:1px solid #000;border-radius:8px;padding:10px;min-height:80px;
  text-align:center;font-size:0.9em;background:#fafafa;
}
.ass-nome{font-weight:bold;margin-bottom:6px;text-align:center;color:#000}
.ass-legenda{color:#333;font-size:0.85em}
.edital{
  background:#fff;color:#000;padding:25px;border-radius:12px;
  font-size:1rem;line-height:1.5;display:none;
}
p{text-align:justify;margin:8px 0}

/* Impressão */
@page{size:A4;margin:1.5cm}
@media print{
  body{background:#fff;color:#000}
  .no-print{display:none!important}
  .container{background:#fff;border:0;box-shadow:none;padding:0;margin:0}
  .edital{display:block!important}
  .assinaturas{gap:8px}
}
</style>
</head>
<body>
  <div class="container">
    <h2 class="no-print">🕵️‍♂️ Edital de Convocação – ADB</h2>

    <!-- FORMULÁRIO DE GERAÇÃO -->
    <div class="no-print" id="formulario">
      <label for="nome">Nome do Associado Convocado:</label>
      <input type="text" id="nome" placeholder="Digite o nome completo do associado">
      <div style="margin-top:10px;">
        <button id="btnGerar" onclick="gerarEdital()">Gerar Edital</button>
      </div>
    </div>

    <!-- CONTEÚDO DO EDITAL -->
    <div id="resultado" class="edital">
      <h3 style="text-align:center;margin:0;">EDITAL DE CONVOCAÇÃO</h3>
      <h4 style="text-align:center;margin-top:5px;">
        ASSEMBLEIA GERAL EXTRAORDINÁRIA DE CONVALIDAÇÃO E REGULARIZAÇÃO DA ASSOCIAÇÃO DOS DETETIVES DO BRASIL
      </h4>

      <p>Ficam convocados todos os associados da Associação dos Detetives do Brasil, pessoa jurídica de direito privado, inscrita no CNPJ sob o n° 13.329.080.0001-75, para a Assembleia Geral Extraordinária de Convalidação e Regularização da Associação dos Detetives do Brasil, a ser realizada no dia 30 de Dezembro, às 08h00 em primeira convocação, com a presença de 2/3 (dois terços) dos associados, e às 08h30 (trinta minutos depois) em segunda convocação, com qualquer quórum, em sala de conferência online, no sítio eletrônico http://www.associacaodosdetetives.com.br.</p>

      <p>A presente convocação é realizada por iniciativa de mais de 1/3 (um terço) mais um dos associados em pleno gozo de seus direitos sociais, nos termos do art. 13 do Estatuto Social vigente e em conformidade com o art. 596, §2º, do Código de Normas da Corregedoria-Geral da Justiça de Santa Catarina – Foro Extrajudicial, para deliberar sobre a seguinte ORDEM DO DIA:</p>

      <p>1️⃣ Esclarecimentos sobre o processo de convalidação e regularização da entidade perante o Ofício de Registro Civil de Pessoas Jurídicas;</p>
      <p>2️⃣ Apresentação, discussão e deliberação sobre os motivos da postergação das eleições da diretoria no período de vacância;</p>
      <p>3️⃣ Indicação do membro responsável pela guarda dos livros e documentos da associação durante o período de vacância;</p>
      <p>4️⃣ Prestação de contas do período de vacância;</p>
      <p>5️⃣ Aprovação do novo Estatuto Social consolidado da associação;</p>
      <p>6️⃣ Eleição e posse dos membros da Diretoria Executiva e do Conselho Fiscal para o mandato 2025–2027;</p>
      <p>7️⃣ Assuntos gerais.</p>

      <p>Lauro Müller/SC, 05 de Novembro de 2025.</p>

      <h3 style="text-align:center;margin-top:25px;">ASSOCIADO CONVOCADO – ASSINATURA GOV.BR</h3>
      <div class="assinaturas" id="assinaturas"></div>

      <!-- BOTÃO DE IMPRESSÃO (só aparece após gerar o edital) -->
      <div class="no-print" style="text-align:center;margin-top:25px;">
        <button id="btnImprimir" onclick="window.print()" style="display:none;">🖨️ Imprimir edital para assinar</button>
      </div>
    </div>
  </div>

<script>
function gerarEdital(){
  const nome = document.getElementById("nome").value.trim();
  if(!nome){
    alert("Digite o nome do associado convocado.");
    return;
  }

  // Mostra o nome dentro da área de assinatura
  const area = document.getElementById("assinaturas");
  area.innerHTML = `
    <div>
      <div class="ass-nome">${nome}</div>
      <div class="ass-box">
        <div class="ass-legenda">Assinado eletronicamente via GOV.BR aqui</div>
      </div>
    </div>
  `;

  // Mostra o edital
  document.getElementById("resultado").style.display = "block";

  // Exibe o botão imprimir e oculta o formulário
  document.getElementById("btnImprimir").style.display = "inline-block";
  document.getElementById("formulario").style.display = "none";

  // Rola suavemente até o edital
  document.getElementById("resultado").scrollIntoView({behavior:'smooth', block:'start'});
}
</script>
</body>
</html>
