<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Declaração de Tipo Sanguíneo | ADB</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  /* Base e layout */
  body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111}
  .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}

  /* Cabeçalho ADB */
  .header{background:#000;color:#d4af37;text-align:center;padding:20px 12px}
  .header img{height:80px;margin:0 auto;display:block}
  .header h1{margin:6px 0;color:#fff;font-size:22px}
  .header .idline{margin:4px 0;color:#f0e6b2;font-size:13px}

  /* Conteúdo */
  .main{padding:24px}
  h2{text-align:center;margin:6px 0 16px}
  p{line-height:1.6;text-align:justify}
  .conteudo{line-height:1.7}
  .meta{font-size:13px;color:#333;text-align:center;margin-bottom:18px}
  .subtitulo{font-weight:700;margin-top:12px}

  /* Formulário */
  .form-row{display:flex;gap:12px;flex-wrap:wrap;justify-content:center;margin-bottom:10px}
  .input, .select{width:100%;max-width:320px;padding:10px;border:1px solid #ccc;border-radius:8px}
  button{padding:10px 16px;border:0;border-radius:8px;background:#000;color:#fff;font-weight:700;cursor:pointer}
  button.secondary{background:#444}

  /* Assinatura */
  .assinaturas-adb{margin-top:26px;text-align:center}
  .assin-gov-caixa{border:1px dashed #888;border-radius:8px;padding:18px;min-height:96px;display:flex;align-items:center;justify-content:center;text-align:center;color:#333;font-style:italic}
  .assin-linha{margin-top:22px;border-top:1px solid #000;padding-top:8px}

  /* Rodapé/ações */
  .btns{display:flex;gap:10px;justify-content:flex-end;margin-top:24px}

  /* Impressão */
  @media print{
    @page{size:A4;margin:14mm}
    #formArea,.btns{display:none!important}
    .container{box-shadow:none}
    body{background:#fff}
  }
</style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <p class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</p>
    <p class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</p>
  </div>

  <div class="main">
    <!-- FORMULÁRIO -->
    <div id="formArea">
      <h2>Gerar Declaração de Tipo Sanguíneo</h2>
      <div class="form-row">
        <input type="text" id="nome" class="input" placeholder="Nome completo do(a) profissional" autocomplete="name" required>
        <input type="text" id="rg" class="input" placeholder="Carteira de identidade (RG)" autocomplete="off" required>
        <input type="text" id="cpf" class="input" placeholder="CPF no formato 000.000.000-00" inputmode="numeric" maxlength="14" required>
      </div>
      <div class="form-row">
        <select id="tipo" class="select" required>
          <option value="">Selecione o tipo sanguíneo</option>
          <option>A</option>
          <option>B</option>
          <option>AB</option>
          <option>O</option>
        </select>
        <select id="rh" class="select" required>
          <option value="">Selecione o Fator Rh</option>
          <option>Positivo (+)</option>
          <option>Negativo (-)</option>
        </select>
      </div>
      <div style="text-align:center;margin-top:10px">
        <button id="gerar">Gerar Declaração</button>
      </div>
    </div>

    <!-- DECLARAÇÃO -->
    <div id="printArea" style="display:none">
      <h2>DECLARAÇÃO DE TIPO SANGUÍNEO</h2>
      <div class="meta">
        <strong>Associação dos Detetives do Brasil – ADB</strong><br>
        CNPJ: 13.329.080/0001-75 • Sede: Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000
      </div>

      <div class="conteudo">
        <p>
          Eu, <strong><span id="outNome">NOME DO PROFISSIONAL</span></strong>, portador(a) da carteira de identidade nº
          <strong><span id="outRG">RG</span></strong>, inscrito(a) no CPF/MF sob o nº
          <strong><span id="outCPF">000.000.000-00</span></strong>, venho por meio desta declarar à
          <strong>Associação dos Detetives do Brasil</strong> que, de forma consciente e verdadeira,
          meu tipo sanguíneo é: <strong><span id="outTipo">—</span></strong>.<br>
          <br>
          <strong>Fator Rh:</strong> <strong><span id="outRh">—</span></strong>.
        </p>

        <p style="margin-top:14px">
          Por ser verdade, firmo a presente declaração.
        </p>

        <div class="assinaturas-adb">
          <div class="assin-gov-caixa" style="margin-top:26px">
            Assinado eletronicamente<br>via GOV.BR
          </div>
          <div class="assin-linha">
            <strong>Assinatura do(a) profissional VIA GOV.BR</strong><br>
            <span id="outNome2">NOME DO PROFISSIONAL</span><br>
            <strong>RG:</strong> <span id="outRG2">RG</span> •
            <strong>CPF:</strong> <span id="outCPF2">000.000.000-00</span>
          </div>
        </div>
      </div>

      <div class="btns">
        <button onclick="window.print()">🖨️ Imprimir / Salvar como PDF</button>
        <button class="secondary" onclick="location.reload()">↩️ Voltar</button>
      </div>
    </div>
  </div>
</div>

<script>
  // Máscara de CPF (000.000.000-00)
  const cpfInput = document.getElementById('cpf');
  cpfInput.addEventListener('input', () => {
    let v = cpfInput.value.replace(/\D/g,'').slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    cpfInput.value = v;
  });

  // Geração do documento
  document.getElementById("gerar").addEventListener("click", function(){
    const nome = document.getElementById("nome").value.trim();
    const rg   = document.getElementById("rg").value.trim();
    const cpf  = document.getElementById("cpf").value.trim();
    const tipo = document.getElementById("tipo").value.trim();
    const rh   = document.getElementById("rh").value.trim();

    if(!nome){ alert("Informe o nome completo."); return; }
    if(!rg){ alert("Informe o número da carteira de identidade (RG)."); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpf)){ alert("Informe o CPF no formato 000.000.000-00."); return; }
    if(!tipo){ alert("Selecione o tipo sanguíneo."); return; }
    if(!rh){ alert("Selecione o Fator Rh."); return; }

    // Preenche a saída
    document.getElementById('outNome').textContent = nome;
    document.getElementById('outRG').textContent   = rg;
    document.getElementById('outCPF').textContent  = cpf;
    document.getElementById('outTipo').textContent = tipo;
    document.getElementById('outRh').textContent   = rh;

    document.getElementById('outNome2').textContent = nome;
    document.getElementById('outRG2').textContent   = rg;
    document.getElementById('outCPF2').textContent  = cpf;

    // Exibe a declaração pronta
    document.getElementById("formArea").style.display = "none";
    document.getElementById("printArea").style.display = "block";
    window.scrollTo(0,0);
  });
</script>
</body>
</html>
