<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Declaração de Residência – Associação dos Detetives do Brasil (ADB)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  :root{--preto:#000;--dourado:#d4af37;--fundo:#f5f5f5;--texto:#111}
  *{box-sizing:border-box}
  body{font-family:Arial,Helvetica,sans-serif;margin:0;background:var(--fundo);color:var(--texto);line-height:1.6}
  .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
  .header{background:var(--preto);color:var(--dourado);text-align:center;padding:20px 12px}
  .header img{height:80px;margin:0 auto;display:block}
  .header h1{margin:6px 0;color:#fff;font-size:22px}
  .header .idline{margin:4px 0;color:#f0e6b2;font-size:13px}
  .main{padding:24px}
  h2{text-align:center;margin:6px 0 16px}
  h3{margin:16px 0 8px}
  .section{border:1px solid #ccc;padding:15px;margin-top:20px;border-radius:8px;background:#fff}
  label{font-weight:700;display:block;margin-bottom:6px}
  input, select{width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;font-size:15px}
  .grid-2{display:grid;grid-template-columns:1fr 1fr;gap:12px}
  .grid-3{display:grid;grid-template-columns:2fr 1fr 1fr;gap:12px}
  .btns, .toolbar{display:flex;gap:10px;flex-wrap:wrap;justify-content:center;margin-top:16px}
  button{padding:10px 16px;border:0;border-radius:8px;background:var(--preto);color:#fff;font-weight:700;cursor:pointer}
  button.secondary{background:#444}
  .meta{text-align:center;font-size:13px;color:#333;margin:8px 0 0}
  .assin-area{margin-top:22px}
  .assin-bloco{padding-top:8px;text-align:center;border-top:1px solid #000}
  .assin-gov-caixa{border:1px dashed #888;border-radius:8px;padding:18px;min-height:96px;display:flex;align-items:center;justify-content:center;text-align:center;color:#333;font-style:italic}
  #formArea{display:block} #previewArea{display:none}
  @media print{
    @page{size:A4;margin:14mm}
    .header, .toolbar, .btns, #formArea{display:none!important}
    .container{box-shadow:none}
    body{background:#fff}
    #previewArea{display:block!important}
  }
</style>
</head>
<body>
<div class="container">
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <p class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</p>
    <p class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</p>
  </div>

  <div class="main">
    <!-- FORM -->
    <div id="formArea">
      <h2>Declaração de Residência</h2>
      <p class="meta"><strong>Fluxo:</strong> preencha os dados ➜ clique em <em>Gerar Declaração</em> ➜ visualize/imprima.</p>

      <!-- Declarante -->
      <div class="section">
        <h3>1) DADOS DO DECLARANTE (Proprietario do imovel)</h3>
        <div class="grid-2">
          <div>
            <label for="dec_nome">Nome completo</label>
            <input type="text" id="dec_nome" placeholder="Ex.: Maria da Silva" required>
          </div>
          <div>
            <label for="dec_cpf">CPF</label>
            <input type="text" id="dec_cpf" maxlength="14" placeholder="000.000.000-00" inputmode="numeric" required>
          </div>
        </div>
      </div>

      <!-- Declarado -->
      <div class="section">
        <h3>2) DADOS DO DECLARADO (Morador do imovel)</h3>
        <div class="grid-2">
          <div>
            <label for="res_nome">Nome completo</label>
            <input type="text" id="res_nome" placeholder="Ex.: João Pereira" required>
          </div>
          <div>
            <label for="res_cpf">CPF</label>
            <input type="text" id="res_cpf" maxlength="14" placeholder="000.000.000-00" inputmode="numeric" required>
          </div>
        </div>
        <div class="grid-2">
          <div>
            <label for="res_rg">RG (opcional)</label>
            <input type="text" id="res_rg" placeholder="Ex.: 1.234.567">
          </div>
          <div>
            <label for="vinculo">Qualificação do declarante</label>
            <select id="vinculo">
              <option value="proprietário(a)">Proprietário(a) do imóvel</option>
              <option value="responsável">Responsável pelo imóvel</option>
              <option value="morador(a)">Morador(a) do imóvel</option>
              <option value="outro">Outro</option>
            </select>
          </div>
        </div>
      </div>

      <!-- Endereço do Declarado -->
      <div class="section">
        <h3>3) ENDEREÇO DO DECLARADO</h3>
        <div class="grid-2">
          <div>
            <label for="end_rua">Logradouro (rua/av/rodovia)</label>
            <input type="text" id="end_rua" placeholder="Ex.: Rua Isaac Bertoncine" required>
          </div>
          <div>
            <label for="end_num">Número</label>
            <input type="text" id="end_num" placeholder="Ex.: 278" required>
          </div>
        </div>
        <div class="grid-3">
          <div>
            <label for="end_bairro">Bairro</label>
            <input type="text" id="end_bairro" placeholder="Ex.: Centro" required>
          </div>
          <div>
            <label for="end_cep">CEP</label>
            <input type="text" id="end_cep" maxlength="9" placeholder="00000-000" inputmode="numeric" required>
          </div>
          <div>
            <label for="end_uf">UF</label>
            <input type="text" id="end_uf" maxlength="2" placeholder="SC" required>
          </div>
        </div>
        <div class="grid-2">
          <div>
            <label for="end_cidade">Cidade</label>
            <input type="text" id="end_cidade" placeholder="Ex.: Lauro Müller" required>
          </div>
          <div>
            <label for="end_comp">Complemento (opcional)</label>
            <input type="text" id="end_comp" placeholder="Ex.: Bloco A, ap. 302">
          </div>
        </div>
      </div>

      <!-- Local e Data -->
      <div class="section grid-2">
        <div>
          <label for="local">Local</label>
          <input type="text" id="local" placeholder="Cidade/UF" required>
        </div>
        <div>
          <label for="data_emissao">Data</label>
          <input type="date" id="data_emissao" required>
        </div>
      </div>

      <!-- Ações -->
      <div class="btns">
        <button type="button" id="btnGerar">Gerar Declaração</button>
        <button type="button" class="secondary" id="btnLimpar">Limpar</button>
      </div>
    </div>

    <!-- PREVIEW -->
    <div id="previewArea">
      <h2>Declaração de Residência</h2>
      <div class="meta">
        <strong>Associação dos Detetives do Brasil – ADB</strong><br>
        <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span><br>
        <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
      </div>

      <div class="section" id="textoDeclaracao"></div>

      <div class="section assin-area">
        <h3>ASSINATURA DO DECLARANTE - PROPRIETÁRIO</h3>
        <div class="assin-bloco">
          <div><strong>Nome:</strong> <span id="pvNome">________________________</span></div>
          <div><strong>CPF:</strong> <span id="pvCPF">___.___.___-__</span></div><br>
          <div class="assin-gov-caixa">Assinado eletronicamente<br>via GOV.BR</div>
          <div class="meta">Esta via é destinada à conferência e arquivo.</div>
        </div>
      </div>

      <div class="btns">
        <button type="button" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
        <button type="button" class="secondary" id="btnEditar">✏️ Editar dados</button>
      </div>
    </div>

    <p class="meta"><em>Observação:</em> Recomenda-se anexar comprovante de endereço recente (até 90 dias), quando solicitado.</p>
  </div>
</div>

<script>
  // Utilidades
  function toTitleCase(s){return (s||"").toLowerCase().split(/\s+/).map((p,i)=> i&&["da","de","do","das","dos","e","a","o","as","os"].includes(p)?p:p.charAt(0).toUpperCase()+p.slice(1)).join(" ")}
  function maskCPF(v){v=(v||"").replace(/\D/g,'').slice(0,11);
    if(v.length>9) return v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/,'$1.$2.$3-$4');
    if(v.length>6) return v.replace(/(\d{3})(\d{3})(\d{0,3})/,'$1.$2.$3');
    if(v.length>3) return v.replace(/(\d{3})(\d{0,3})/,'$1.$2'); return v;}
  function validCPF(cpf){cpf=(cpf||"").replace(/[^\d]+/g,''); if(cpf.length!==11||/^(\d)\1{10}$/.test(cpf)) return false;
    let s=0,r; for(let i=1;i<=9;i++) s+=parseInt(cpf.substring(i-1,i))*(11-i);
    r=(s*10)%11; if(r===10||r===11) r=0; if(r!==parseInt(cpf.substring(9,10))) return false;
    s=0; for(let i=1;i<=10;i++) s+=parseInt(cpf.substring(i-1,i))*(12-i);
    r=(s*10)%11; if(r===10||r===11) r=0; return r===parseInt(cpf.substring(10,11));}
  function maskCEP(v){v=(v||"").replace(/\D/g,'').slice(0,8); if(v.length>5) return v.replace(/(\d{5})(\d{0,3})/,'$1-$2'); return v;}
  function toUF(v){return (v||"").replace(/[^a-zA-Z]/g,'').toUpperCase().slice(0,2)}

  // Campos
  const dec_nome = document.getElementById('dec_nome');
  const dec_cpf  = document.getElementById('dec_cpf');
  const res_nome = document.getElementById('res_nome');
  const res_cpf  = document.getElementById('res_cpf');
  const res_rg   = document.getElementById('res_rg');
  const vinculo  = document.getElementById('vinculo');

  const end_rua  = document.getElementById('end_rua');
  const end_num  = document.getElementById('end_num');
  const end_bairro=document.getElementById('end_bairro');
  const end_cep  = document.getElementById('end_cep');
  const end_uf   = document.getElementById('end_uf');
  const end_cidade=document.getElementById('end_cidade');
  const end_comp = document.getElementById('end_comp');

  const local    = document.getElementById('local');
  const data     = document.getElementById('data_emissao');

  // Máscaras / formatações
  dec_nome.addEventListener('input',()=>{const p=dec_nome.selectionStart; dec_nome.value=toTitleCase(dec_nome.value); dec_nome.setSelectionRange(p,p);});
  res_nome.addEventListener('input',()=>{const p=res_nome.selectionStart; res_nome.value=toTitleCase(res_nome.value); res_nome.setSelectionRange(p,p);});
  dec_cpf.addEventListener('input',()=>{dec_cpf.value=maskCPF(dec_cpf.value);});
  res_cpf.addEventListener('input',()=>{res_cpf.value=maskCPF(res_cpf.value);});
  end_cep.addEventListener('input',()=>{end_cep.value=maskCEP(end_cep.value);});
  end_uf.addEventListener('input',()=>{end_uf.value=toUF(end_uf.value);});
  end_cidade.addEventListener('input',()=>{const p=end_cidade.selectionStart; end_cidade.value=toTitleCase(end_cidade.value); end_cidade.setSelectionRange(p,p);});
  end_bairro.addEventListener('input',()=>{const p=end_bairro.selectionStart; end_bairro.value=toTitleCase(end_bairro.value); end_bairro.setSelectionRange(p,p);});
  end_rua.addEventListener('input',()=>{const p=end_rua.selectionStart; end_rua.value=toTitleCase(end_rua.value); end_rua.setSelectionRange(p,p);});

  // Data padrão = hoje
  (function hoje(){
    const d=new Date(); const y=d.getFullYear(); const m=String(d.getMonth()+1).padStart(2,'0'); const dd=String(d.getDate()).padStart(2,'0');
    data.value = `${y}-${m}-${dd}`;
  })();

  // Validar campos obrigatórios
  function exige(campo, msg){ if(!campo.value || !campo.value.trim()){ alert(msg); campo.focus(); return false } return true }
  function exigeCPF(campo, msg){
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(campo.value)){ alert(msg+' (formato 000.000.000-00)'); campo.focus(); return false }
    if(!validCPF(campo.value)){ alert('CPF inválido: '+campo.value); campo.focus(); return false }
    return true;
  }

  // Gerar declaração
  document.getElementById('btnGerar').addEventListener('click', ()=>{
    if(!exige(dec_nome,'Informe o nome do DECLARANTE')) return;
    if(!exigeCPF(dec_cpf,'Informe o CPF do DECLARANTE')) return;
    if(!exige(res_nome,'Informe o nome do DECLARADO')) return;
    if(!exigeCPF(res_cpf,'Informe o CPF do DECLARADO')) return;
    if(!exige(end_rua,'Informe o logradouro')) return;
    if(!exige(end_num,'Informe o número')) return;
    if(!exige(end_bairro,'Informe o bairro')) return;
    if(!exige(end_cidade,'Informe a cidade')) return;
    if(!exige(end_uf,'Informe a UF')) return;
    if(!/^\d{5}-\d{3}$/.test(end_cep.value)){ alert('Informe o CEP no formato 00000-000'); end_cep.focus(); return; }
    if(!exige(local,'Informe o local (Cidade/UF)')) return;
    if(!exige(data,'Informe a data')) return;

    // Monta endereço
    const partes = [
      end_rua.value,
      'nº '+end_num.value,
      end_comp.value ? end_comp.value : null,
      'Bairro '+end_bairro.value,
      end_cidade.value,
      end_uf.value,
      'CEP '+end_cep.value
    ].filter(Boolean);

    const [y,m,d]=data.value.split('-'); const dataBR=`${d}/${m}/${y}`;
    const rgTxt = res_rg.value && res_rg.value.trim() ? ` e RG <strong>${res_rg.value.trim()}</strong>` : '';

    const corpo = `
      <p style="text-align:justify">
        Eu, <strong>${toTitleCase(dec_nome.value)}</strong>, inscrito(a) no CPF sob o nº <strong>${dec_cpf.value}</strong>,
        na qualidade de <strong>${vinculo.value}</strong>, declaro, para os devidos fins, que
        <strong>${toTitleCase(res_nome.value)}</strong>, CPF <strong>${res_cpf.value}</strong>${rgTxt},
        <strong>reside</strong> no endereço <strong>${partes.join(', ')}</strong>.
      </p>
      <p style="text-align:justify">
        Declaro, ainda, estar ciente de que esta declaração poderá ser utilizada perante a Associação dos Detetives do Brasil – ADB,
        órgãos públicos e instituições privadas que a solicitarem, respondendo civil e criminalmente pela veracidade das informações.
      </p>
      <p class="meta"><strong>Local e data:</strong> ${local.value} — ${dataBR}</p>
    `;

    document.getElementById('textoDeclaracao').innerHTML = corpo;
    document.getElementById('pvNome').textContent = toTitleCase(dec_nome.value);
    document.getElementById('pvCPF').textContent = dec_cpf.value;

    // Mostra preview
    document.getElementById('formArea').style.display='none';
    document.getElementById('previewArea').style.display='block';
    window.scrollTo(0,0);
  });

  // Editar / Limpar
  document.getElementById('btnEditar').addEventListener('click', ()=>{
    document.getElementById('previewArea').style.display='none';
    document.getElementById('formArea').style.display='block';
    window.scrollTo(0,0);
  });
  document.getElementById('btnLimpar').addEventListener('click', ()=>{
    document.querySelectorAll('input').forEach(i=> i.value='');
    vinculo.value='proprietário(a)';
    (function hoje(){
      const d=new Date(); const y=d.getFullYear(); const m=String(d.getMonth()+1).padStart(2,'0'); const dd=String(d.getDate()).padStart(2,'0');
      data.value = `${y}-${m}-${dd}`;
    })();
  });
</script>
</body>
</html>
