<?php require_once('Connections/banco.php'); ?> 
<?php
// Load the common classes
require_once('includes/common/KT_common.php');
// Load the tNG classes
require_once('includes/tng/tNG.inc.php');

// Make a transaction dispatcher instance
$tNGs = new tNG_dispatcher("");

// Make unified connection variable
$conn_banco = new KT_connection($banco, $database_banco);
/* ====================== CONSULTAS ====================== */
if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    if (PHP_VERSION < 6) {
      $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
    }
    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

    switch ($theType) {
      case "text":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "long":
      case "int":    $theValue = ($theValue != "") ? intval($theValue) : "NULL"; break;
      case "double": $theValue = ($theValue != "") ? doubleval($theValue) : "NULL"; break;
      case "date":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "defined":$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
    }
    return $theValue;
  }
}

$currentPage = $_SERVER["PHP_SELF"];

$maxRows_ConsulaDeterive = 200;
$pageNum_ConsulaDeterive = isset($_GET['pageNum_ConsulaDeterive']) ? (int)$_GET['pageNum_ConsulaDeterive'] : 0;
$startRow_ConsulaDeterive = $pageNum_ConsulaDeterive * $maxRows_ConsulaDeterive;

$colname_ConsulaDeterive = "-1";
if (isset($_GET['uf'])) {
  $colname_ConsulaDeterive = $_GET['uf'];
}

mysql_select_db($database_banco, $banco);
$query_ConsulaDeterive = sprintf("
  SELECT c.*, e.nm_estado
    FROM cadastro_detetive c
    JOIN estado e ON c.cd_estado = e.cd_estado
   WHERE c.cd_estado = %s
ORDER BY c.nome_detetive ASC",
  GetSQLValueString($colname_ConsulaDeterive, "int")
);
$query_limit_ConsulaDeterive = sprintf("%s LIMIT %d, %d", $query_ConsulaDeterive, $startRow_ConsulaDeterive, $maxRows_ConsulaDeterive);
$ConsulaDeterive = mysql_query($query_limit_ConsulaDeterive, $banco) or die(mysql_error());
$row_ConsulaDeterive = mysql_fetch_assoc($ConsulaDeterive);

if (isset($_GET['totalRows_ConsulaDeterive'])) {
  $totalRows_ConsulaDeterive = $_GET['totalRows_ConsulaDeterive'];
} else {
  $all_ConsulaDeterive = mysql_query($query_ConsulaDeterive);
  $totalRows_ConsulaDeterive = mysql_num_rows($all_ConsulaDeterive);
}
$totalPages_ConsulaDeterive = ceil($totalRows_ConsulaDeterive/$maxRows_ConsulaDeterive)-1;

mysql_select_db($database_banco, $banco);
$query_ConsultaEstado = "SELECT * FROM estado ORDER BY nm_estado ASC";
$ConsultaEstado = mysql_query($query_ConsultaEstado, $banco) or die(mysql_error());
$row_ConsultaEstado = mysql_fetch_assoc($ConsultaEstado);
$totalRows_ConsultaEstado = mysql_num_rows($ConsultaEstado);

/* Query string de paginação */
$queryString_ConsulaDeterive = "";
if (!empty($_SERVER['QUERY_STRING'])) {
  $params = explode("&", $_SERVER['QUERY_STRING']);
  $newParams = array();
  foreach ($params as $param) {
    if (stristr($param, "pageNum_ConsulaDeterive") == false && stristr($param, "totalRows_ConsulaDeterive") == false) {
      array_push($newParams, $param);
    }
  }
  if (count($newParams) != 0) {
    $queryString_ConsulaDeterive = "&" . htmlentities(implode("&", $newParams));
  }
}
$queryString_ConsulaDeterive = sprintf("&totalRows_ConsulaDeterive=%d%s", $totalRows_ConsulaDeterive, $queryString_ConsulaDeterive);

/* Fallback do brasão */
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>


<style>
 :root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;        /* azul bem mais forte (navy profundo) */
  --azul-escuro:#000f24; /* ainda mais fechado p/ sombras/bordas */
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
}


  *{box-sizing:border-box}

  body{
    margin:0;
    font-family: Arial, Helvetica, sans-serif;
    color:var(--texto);
    background:#fff;
    line-height:1.6;
    -webkit-font-smoothing:antialiased;
    -moz-osx-font-smoothing:grayscale;
  }

  /* ========== MENU RESPONSIVO (NOVO) ========== */
  .adb-nav{
    position:sticky; top:0; z-index:999;
    background: var(--azul);
    color:#fff;
    border-bottom: 3px solid var(--amarelo);
  }
  .adb-nav .adb-wrap{
    max-width:1300px; margin:0 auto; padding:10px 16px;
    display:flex; align-items:center; justify-content:space-between; gap:12px;
  }
  .adb-brand{
    display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff;
    min-width:0;
  }
  .adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
  .adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap; }

  .adb-toggle{
    display:none;
    background:transparent; border:0; color:#fff; cursor:pointer;
    width:40px; height:40px; border-radius:8px;
  }
  .adb-toggle:focus-visible{ outline:2px solid #fff; outline-offset:2px }

  .adb-menu{
    list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px;
  }
  .adb-menu a{
    display:inline-block; text-decoration:none; color:#fff; font-weight:700;
    padding:10px 14px; border-radius:10px;
  }
  .adb-menu a:hover{ background:rgba(255,255,255,.12) }
  .adb-menu .cta{
    background:var(--amarelo); color:#111827;
    box-shadow:0 6px 16px rgba(0,0,0,.12);
  }
  .adb-menu .cta:hover{ opacity:.92 }

  /* Mobile */
  @media (max-width: 768px){
    .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
    .adb-menu{
      position:fixed; left:0; right:0; top:56px;
      background:var(--azul);
      flex-direction:column; align-items:stretch; gap:0;
      max-height:0; overflow:hidden;
      transition:max-height .25s ease;
      border-bottom:3px solid var(--amarelo);
    }
    .adb-menu.open{ max-height:420px }
    .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
    .adb-menu a{ padding:14px 18px }
  }
  /* ========== FIM MENU ========== */

  /* Cabeçalho AZUL com FAIXA AMARELA */
  header{
    background: var(--azul);
    color:#fff;
    text-align:center;
    padding:28px 16px 46px;
    position:relative;
  }
  header .topo{
    max-width:1100px;
    margin:0 auto;
  }
  header img.brasao{
    width:110px;
    max-width:28vw;
    height:auto;
    display:block;
    margin:0 auto 12px;
    background:#fff;
    border-radius:10px;
    padding:8px;
    box-shadow:0 6px 20px rgba(0,0,0,.15);
  }
  header h1{
    margin:0;
    font-size:26px;
    font-weight:800;
    text-shadow: 0 1px 3px rgba(0,0,0,.35);
    text-align:center;
  }
  header .faixa{
    position:absolute; left:0; right:0; bottom:-18px; height:36px;
    background: var(--amarelo);
    border-top: 2px solid rgba(255,255,255,.5);
    border-bottom: 1px solid rgba(0,0,0,.08);
  }

  main{
    max-width:1000px;
    margin:48px auto 28px;
    padding:0 16px;
  }

  .lead{
    background:var(--cinza);
    border-left:4px solid var(--azul);
    padding:12px 14px;
    border-radius:10px;
    margin:0 0 16px 0;
  }

  h2{font-size:22px; margin:28px 0 10px}
  h3{font-size:18px; margin:22px 0 8px}
  ul{margin:8px 0 18px 20px}

  /* Grade simples para blocos */
  .grid{
    display:grid;
    grid-template-columns: 1fr 1fr;
    gap:16px;
  }
  .card{
    background:#fff;
    border:1px solid #e5e7eb;
    border-radius:14px;
    padding:18px;
    box-shadow:0 6px 18px rgba(0,0,0,.04);
  }
  .muted{color:#4b5563; font-size:14px}

  /* Botões padrão (funcionam para <a> ou <button>) */
  .btn{
    display:inline-block;
    padding:14px 22px;
    border-radius:10px;
    font-weight:700;
    font-size:18px;
    line-height:1.2;
    text-decoration:none;
    text-align:center;
    color:#fff;
    box-shadow:0 6px 16px rgba(0,0,0,.12);
    transition:.2s transform ease, .2s opacity ease;
    margin:6px 8px 0 0;
  }
  .btn:hover{ transform: translateY(-1px); opacity:.92 }
  .btn:active{ transform: translateY(0) }

  .btn-verde{ background:var(--verde); }
  .btn-azul{ background:var(--azul); }
  .btn-amarelo{ background:var(--amarelo); color:#1f2937; }

  .cta{ margin:14px 0 0 }

  footer{
    max-width:1000px;
    margin:8px auto 36px;
    padding:0 16px;
    color:#6b7280;
    font-size:13px;
    text-align:center;
  }

  /* Responsividade para celular */
  @media (max-width: 768px){
    body{ font-size:14px; }
    header{ padding:22px 12px 40px }
    header h1{ font-size:20px; text-align:center; }
    header img.brasao{ width:90px; padding:6px; border-radius:8px }
    .grid{ grid-template-columns: 1fr; }
    .btn{
      display:block; width:100%; margin:10px 0 0;
      font-size:17px;
      padding:12px 18px;
    }
  }

  /* Impressão limpa */
  @media print{
    header{ background:#fff; color:#000; padding:12px; }
    header img.brasao{ background:transparent; box-shadow:none; padding:0; }
    header .faixa, .btn, .adb-nav{ display:none !important; }
    .card{ box-shadow:none; }
    body{ background:#fff; }
  }
</style>
</head>
<body>

<!-- ========== NAVBAR RESPONSIVA (NOVO) ========== -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="index.php" rel="noopener">
      <img src="logotipoadb.png" alt="ADB">
     <span>Cadastro Nacional-ADB</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
       <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
      <li><a href="atualizacao.php"class="active">Atualização</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>
<!-- ========== FIM NAVBAR ========== -->

<header id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da República Federativa do Brasil" onerror="this.style.display='none'">
    <h1>Declaração de Recomendação Profissional</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<main>
  <section class="grid" style="margin-top:18px">
    <div class="card">
      
     <div style="background-color: #fff3cd; color: #856404; padding: 10px; border: 1px solid #ffeeba; border-radius: 5px; font-family: Arial, sans-serif; margin-bottom: 15px;">
    <strong>Atenção:</strong> Para uma melhor visualização e preenchimento correto, recomenda-se que este documento seja preenchido em um <strong>computador ou notebook</strong>.
</div>
    </div>

    <div class="card">
      <p> <p align="center"><form action="declaracao_de_recomendacao.php" method="post" enctype="multipart/form-data" name="restrito" id="rg" onsubmit="return validarCodigo();" style="text-align: center; padding: 20px;">
  <input 
    type="text" 
    id="search-input" 
    name="restrito" 
    placeholder="ADB-12345"
    style="width: 90%; max-width: 300px; padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 4px;" 
    required
  ><br><br>
  
  <button
    type="submit"
    style="padding: 12px 24px; background-color: #001a33; color: white; border: none; border-radius: 6px; font-size: 16px; cursor: pointer;"
  >
    Imprimir Declaração de Recomendação Profissional
  </button>
</form>

<script>
  const input = document.getElementById('search-input');

  // Adiciona automaticamente o prefixo "ADB-"
  input.addEventListener('focus', () => {
    if (!input.value.startsWith('ADB-')) {
      input.value = 'ADB-';
    }
  });

  // Impede remoção do prefixo "ADB-"
  input.addEventListener('keydown', function(event) {
    if (input.selectionStart < 4 && 
       !['ArrowRight', 'ArrowLeft', 'Tab', 'Delete', 'Backspace'].includes(event.key)) {
      event.preventDefault();
    }
  });

  // Força o padrão "ADB-" + somente números
  input.addEventListener('input', function () {
    if (!input.value.startsWith('ADB-')) {
      input.value = 'ADB-';
    }
    let numbers = input.value.slice(4).replace(/\D/g, '');
    input.value = 'ADB-' + numbers;
  });

  // Validação: pelo menos um número após "ADB-"
  function validarCodigo() {
    const valor = input.value.trim();
    const regex = /^ADB-\d+$/;

    if (!regex.test(valor)) {
      alert('Digite o código no formato: ADB-12345 (com números após o prefixo).');
      return false;
    }
    return true;
  }
</script></p>   
   
 </table> <BR><BR><BR> 
<BR>
<BR><BR> 
	</p></p>
    </div>
  </section>
</main>

<!-- Botão flutuante do WhatsApp (aparece em desktop e mobile) -->
<table border="0" width="100%">
  <tr>
    <td>
      <a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed; width:40px; height:5px; bottom:100px; z-index:100;">
        <img class="imagem3" src="WhatsAppPNG.png" alt="" width="90">
      </a>
    </td>
  </tr>
</table>

<footer>
  Associação dos Detetives do Brasil
</footer>

<!-- ========== JS do menu (NOVO) ========== -->
<script>
  (function(){
    const btn = document.getElementById('adbToggle');
    const menu = document.getElementById('adbMenu');
    if(!btn || !menu) return;

    function closeOnResize(){
      if(window.innerWidth > 768){
        menu.classList.remove('open');
        btn.setAttribute('aria-expanded','false');
      }
    }
    btn.addEventListener('click', function(){
      const isOpen = menu.classList.toggle('open');
      btn.setAttribute('aria-expanded', String(isOpen));
    });
    window.addEventListener('resize', closeOnResize);
  })();
</script>
</body>
</html>
