<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Declaração de Aceitação – Sistema de Consulta Profissional | ADB</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  /* Base e layout */
  body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111}
  .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}

  /* Cabeçalho ADB */
  .header{background:#000;color:#d4af37;text-align:center;padding:20px 12px}
  .header img{height:80px;margin:0 auto;display:block}
  .header h1{margin:6px 0 6px;color:#fff;font-size:22px;text-align:center}
  .header .idline{margin:4px 0;color:#f0e6b2;text-align:center;font-size:13px}

  /* Conteúdo */
  .main{padding:24px}
  h2{text-align:center;margin:6px 0 16px}
  p{line-height:1.6;text-align:justify}
  .conteudo{line-height:1.7}
  .subtitulo{font-weight:700;margin-top:12px}
  .lista p{margin:6px 0}
  .meta{font-size:13px;color:#333;text-align:center;margin-bottom:18px}

  /* Formulário */
  .form-row{display:flex;gap:12px;flex-wrap:wrap;justify-content:center;margin-bottom:10px}
  .input{width:100%;max-width:320px;padding:10px;border:1px solid #ccc;border-radius:8px}
  button{padding:10px 16px;border:0;border-radius:8px;background:#000;color:#fff;font-weight:700;cursor:pointer}
  button.secondary{background:#444}

  /* Assinatura */
  .assinaturas-adb{margin-top:26px;text-align:center}
  .assin-gov-caixa{border:1px dashed #888;border-radius:8px;padding:18px;min-height:96px;display:flex;align-items:center;justify-content:center;text-align:center;color:#333;font-style:italic}
  .assin-linha{margin-top:22px;border-top:1px solid #000;padding-top:8px}

  /* Impressão */
  @media print{
    @page{size:A4;margin:14mm}
    #formArea,.btns{display:none!important}
    .container{box-shadow:none}
    body{background:#fff}
  }
</style>
</head>
<body><!-- opcional: adicione data-codigo="ADB-12345" aqui para exibir o código -->
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <p class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</p>
    <p class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</p>
  </div>

  <div class="main">
    <!-- FORMULÁRIO (sem campo de código) -->
    <div id="formArea">
      <h2>Gerar Declaração de Aceitação</h2>
      <div class="form-row">
        <input type="text" id="nome" class="input" placeholder="Nome completo do profissional" autocomplete="name" required>
        <input type="text" id="cpf" class="input" placeholder="Informe o CPF no formato 000.000.000-00" inputmode="numeric" maxlength="14" required>
      </div>
      <div style="text-align:center;margin-top:10px">
        <button id="gerar">Gerar Declaração</button>
      </div>
    </div>

    <!-- DECLARAÇÃO -->
    <div id="printArea" style="display:none">
      <h2>DECLARAÇÃO DE ACEITAÇÃO<br>DE LIBERAÇÃO DAS INFORMAÇÕES PELO SISTEMA DE CONSULTA PROFISSIONAL - ADB</h2>
      <div class="meta">
        <strong>Associação dos Detetives do Brasil – ADB</strong><br>
        CNPJ: 13.329.080/0001-75 • Sede: Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000
      </div>

      <div class="conteudo">
        Declaro, para os devidos fins, que tenho ciência dos objetivos da
        <strong>Associação dos Detetives do Brasil</strong> e, na condição de profissional associado,
        <strong>autorizo a disponibilidade de minhas informações como profissional</strong> pelo sistema
        eletrônico/cadastro da ADB, com as chaves de consulta
        (<em>nº de registro, código de acesso, CPF e busca por estado</em>)
        que possam ser de interesse de clientes ou autoridades civis (autoridade policial, Procon – Código de Defesa
        do Consumidor) e militares, Ministério Público, Poder Judiciário, dentre outras.

        <div class="lista">
          <p><strong>As informações do profissional só serão fornecidas:</strong></p>
          <p>01 – Para clientes que contrataram formalmente o profissional cadastrado e que apresentem o
          contrato de prestação de serviço assinado pelo profissional à entidade;</p>
          <p>02 – Com a autorização do profissional através de seu código de acesso;</p>
          <p>03 – Por solicitação de autoridades legais, conforme determina a <strong>Lei nº 3.099, Art. 5º</strong>:
          Poder Judiciário, entidades policiais ou outras com respaldo legal.</p>
        </div>

        <div class="subtitulo">Resultado da consulta no sistema eletrônico da ADB:</div><br>

        <p><strong>Nº de matrícula (ex: ADB-0000) – Informações completas:</strong><br>
        Foto de perfil, condições do cadastro, nº de registro, data e hora do cadastro, data de validade do cadastro,
        funcional atual, nome completo, CPF, identidade, data de nascimento, naturalidade, nome do pai, nome da mãe,
        tipo sanguíneo, tempo de profissão, endereço residencial, e-mail, página eletrônica, escola de formação, data
        de conclusão do curso, curso de formação, especialidade, experiência e certificado de formação profissional.</p><br>

        <p><strong>CPF (ex: 000.000.000-00) – Informações completas:</strong><br>
        Mesmo conteúdo das consultas por nº de matrícula.</p>

        <p><strong>Busca por estado – Consulta livre de autorização:</strong><br>
        Nome completo, cidade, telefone, WhatsApp. Esta consulta permite o
        primeiro contato com o profissional.</p>

        <br>
        Por aceitar as disposições previstas no sistema eletrônico da ADB referentes ao acesso às informações do
        profissional qualificado acima, <strong>DECLARO QUE ACEITO E CONCORDO</strong> com as condições estabelecidas
        de funcionamento.

        <div class="assinaturas-adb">
          <div class="assin-gov-caixa" style="margin-top:26px">
            Assinado eletronicamente<br>via GOV.BR
          </div>
          <div class="assin-linha">
            <strong>Assinatura do profissional VIA GOV.BR</strong><br>
            <span id="outNome">NOME DO PROFISSIONAL</span><br>
            <strong>Inscrito(a) no CPF/MF sob o nº</strong> <span id="outCPF">000.000.000-00</span><br>
            <p id="linhaCodigo" style="display:none;margin:6px 0 0">
              <strong>Código ADB:</strong> <span id="outCodigo">ADB-0000</span>
            </p>
          </div>
        </div>
      </div>

      <div style="text-align:right;margin-top:24px" class="btns">
        <button onclick="window.print()">🖨️ Imprimir / Salvar como PDF</button>
        <button class="secondary" onclick="location.reload()">↩️ Voltar</button>
      </div>
    </div>
  </div>
</div>

<script>
  // Utilitário: obter parâmetro da URL
  function getParam(name){
    const params = new URLSearchParams(window.location.search);
    return params.get(name) || '';
  }

  // Se existir ?codigo=ADB-12345 na URL ou data-codigo no <body>, exibir automaticamente
  function obterCodigoExterno(){
    const bodyCodigo = (document.body.getAttribute('data-codigo') || '').trim().toUpperCase();
    const urlCodigo  = (getParam('codigo') || '').trim().toUpperCase();
    const candidato  = bodyCodigo || urlCodigo;
    return (/^ADB-\d+$/).test(candidato) ? candidato : '';
  }

  // Máscara de CPF (000.000.000-00)
  const cpfInput = document.getElementById('cpf');
  cpfInput.addEventListener('input', () => {
    let v = cpfInput.value.replace(/\D/g,'').slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    cpfInput.value = v;
  });

  // Geração do documento (sem digitação de código)
  document.getElementById("gerar").addEventListener("click", function(){
    const nome = document.getElementById("nome").value.trim();
    const cpf  = document.getElementById("cpf").value.trim();

    if(!nome){
      alert("Informe o nome completo do profissional.");
      return;
    }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpf)){
      alert("Informe o CPF no formato 000.000.000-00.");
      return;
    }

    // Preenche nome e CPF
    document.getElementById('outNome').textContent   = nome;
    document.getElementById('outCPF').textContent    = cpf;

    // Preenche (opcional) o Código ADB vindo de fora
    const codigoExterno = obterCodigoExterno();
    if(codigoExterno){
      document.getElementById('outCodigo').textContent = codigoExterno;
      document.getElementById('linhaCodigo').style.display = 'block';
    } else {
      document.getElementById('linhaCodigo').style.display = 'none';
    }

    // Exibe a declaração pronta
    document.getElementById("formArea").style.display = "none";
    document.getElementById("printArea").style.display = "block";
    window.scrollTo(0,0);
  });
</script>
</body>
</html>
