<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – Relatório de Investigação</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    *{box-sizing:border-box}
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111;line-height:1.6}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB */
    .header{background:#000;color:#d4af37;padding:20px 12px;display:flex;flex-direction:column;align-items:center;text-align:center}
    .header img{height:80px;display:block;margin:0 auto}
    .header h1{margin:6px 0;color:#fff;font-size:22px}
    .header .idline{margin:4px 0;color:#f0e6b2;font-size:13px;display:block}

    .lead{background:#fff7cc;border:1px solid #ffe08a;color:#5a4d00;padding:12px 14px;border-radius:10px;margin:0 0 16px 0}
    p{text-align:justify}
    .no-print{display:block}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#004aad;color:#fff;font-weight:700;cursor:pointer}
    .btn:hover{opacity:.92}
    .btn-danger{background:#b91c1c}
    .btn-ghost{background:#e5e7eb;color:#111}
    .muted{color:#4b5563}

    .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    label{font-weight:700;display:block;margin-bottom:4px}
    input[type="text"], input[type="number"], textarea{width:100%;padding:10px;border:1px solid #ccc;border-radius:8px}
    textarea{min-height:110px;resize:vertical}

    /* Blocos do relatório */
    .blocks{margin-top:14px}
    .block{border:1px solid #e5e7eb;border-radius:12px;padding:12px;margin-bottom:12px;background:#fafafa}
    .block-head{display:flex;gap:10px;align-items:center;justify-content:space-between;flex-wrap:wrap}
    .block-title{font-weight:700}
    .small{font-size:12px;color:#6b7280}

    .img-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(180px,1fr));gap:12px;margin-top:10px}
    .img-card{border:1px solid #e5e7eb;border-radius:10px;overflow:hidden;background:#fff}
    .img-card img{display:block;width:100%;height:160px;object-fit:cover}
    .img-card .cap{padding:8px;font-size:13px;color:#374151;border-top:1px solid #f3f4f6}
    .img-card .meta{padding:0 8px 8px;font-size:12px;color:#6b7280}
    .img-actions{display:flex;justify-content:flex-end;gap:8px;padding:8px}

    /* Assinaturas */
    .assinaturas-duplas{margin-top:28px;display:flex;gap:18px;align-items:flex-start;justify-content:space-between;flex-wrap:wrap}
    .assin-card{flex:1 1 410px;border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff;min-width:380px}
    .assin-titulo{font-weight:700;text-align:center;margin-bottom:12px}
    .assin-area{border:1px dashed #888;border-radius:8px;height:120px;background:#fafafa;margin:10px 0 12px}
    .assin-linha{margin-top:18px;border-top:1px solid #000;padding-top:6px;text-align:center}

    .local-data{text-align:center;margin-top:10px}
    .links-util{display:flex;gap:8px;justify-content:flex-end;margin-top:8px}
    .links-util a{font-size:12px;color:#004aad;text-decoration:none}

    @media (max-width:768px){.form-grid{grid-template-columns:1fr}.assin-card{min-width:auto}}

    /* Impressão */
    @media print{
      .no-print{display:none!important}
      input, textarea{border:0!important;background:transparent!important;box-shadow:none!important;outline:0!important;padding:0!important;margin:0!important;appearance:none;-webkit-appearance:none}
      input[type="text"], textarea{display:inline!important;width:auto!important}
      input::placeholder, textarea::placeholder{color:transparent!important}
      @page{size:A4;margin:14mm}
      .container{box-shadow:none}
      body{background:#fff}
      .header{text-align:center;align-items:center}
      .img-card img{height:auto}
    }
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- ========== FORMULÁRIO (sem banco) ========== -->
    <div id="formArea" class="no-print">
      <h2>Relatório de Investigação – Preenchimento</h2>
      <div class="lead">Preencha os dados abaixo. Você pode <strong>adicionar blocos de texto</strong> com data/hora e <strong>inserir imagens</strong> (com legenda). Depois clique em <strong>Gerar relatório</strong> e imprima/baixe em PDF.</div>

      <h3>Profissional</h3>
      <div class="form-grid">
        <div>
          <label>Nome do profissional</label>
          <input type="text" id="f_nome" placeholder="Seu nome" required>
        </div>
        <div>
          <label>Identidade (RG)</label>
          <input type="text" id="f_rg" placeholder="Número da identidade" required>
        </div>
        <div>
          <label>CPF</label>
          <input type="text" id="f_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div>
          <label>Matrícula ADB</label>
          <input type="text" id="f_matricula" placeholder="ADB-12345" required>
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço profissional</label>
          <input type="text" id="f_end" placeholder="Rua/Av., nº – Cidade/UF" required>
        </div>
      </div>

      <h3>Contratante</h3>
      <div class="form-grid">
        <div>
          <label>Nome do contratante</label>
          <input type="text" id="t_nome" placeholder="Nome do contratante" required>
        </div>
        <div>
          <label>CPF do contratante</label>
          <input type="text" id="t_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço do contratante</label>
          <input type="text" id="t_end" placeholder="Endereço completo" required>
        </div>
      </div>

      <h3>Blocos de Relatório</h3>
      <div class="blocks" id="blocks"></div>
      <div class="form-grid">
        <div>
          <button type="button" class="btn" id="btnAddText">➕ Adicionar bloco de texto</button>
        </div>
        <div>
          <button type="button" class="btn btn-ghost" id="btnAddImage">➕ Adicionar imagem</button>
          <input type="file" id="fileInput" accept="image/*" style="display:none">
        </div>
      </div>

      <h3>Data do relatório</h3>
      <div class="form-grid">
        <div>
          <label>Data (dd/mm/aaaa)</label>
          <input type="text" id="f_data" placeholder="00/00/0000" maxlength="10" inputmode="numeric" required>
        </div>
        <div>
          <label>Hora (HH:MM)</label>
          <input type="text" id="f_hora" placeholder="--:--" maxlength="5" inputmode="numeric" required>
        </div>
      </div>

      <div style="text-align:right;margin-top:18px">
        <button class="btn" id="btnGerar">Gerar relatório</button>
      </div>
    </div>

    <!-- ========== DOCUMENTO GERADO ========== -->
    <div id="printArea" style="display:none">
      <h2>RELATÓRIO DE INVESTIGAÇÃO</h2>

      <div class="links-util no-print">
        <a href="#" id="editAgain">← Voltar e editar</a>
        <a href="#" onclick="window.print()">🖨️ Imprimir / Salvar PDF</a>
      </div>

      <p>
        Eu, <strong><span id="out_nome"></span></strong>, portador(a) da cédula de identidade nº <strong><span id="out_rg"></span></strong>, inscrito(a) no CPF nº <strong><span id="out_cpf"></span></strong>, matrícula <strong><span id="out_matricula"></span></strong> na Associação dos Detetives do Brasil, residente e domiciliado à <strong><span id="out_end"></span></strong>, venho apresentar o presente relatório de investigação particular, elaborado em estrita observância aos preceitos legais que regem a profissão, em especial a <strong>Lei Federal nº 13.432/2017</strong>, que regulamenta a atividade de detetive particular, incluindo o dever de sigilo profissional.
      </p>

      <p><strong>CONTRATANTE:</strong><br>
        Nome: <span id="out_t_nome"></span><br>
        CPF: <span id="out_t_cpf"></span><br>
        Endereço: <span id="out_t_end"></span>
      </p>

      <p>
        O presente relatório tem por objetivo expor detalhadamente as metodologias empregadas, as informações obtidas e as conclusões decorrentes da investigação particular realizada para atender à solicitação do cliente acima identificado.
      </p>

      <p>
        Todas as informações aqui contidas são tratadas com o mais rigoroso sigilo, conforme estabelecido pela legislação vigente, garantindo o resguardo dos direitos e da privacidade das partes envolvidas, bem como a ética e a confidencialidade que norteiam a atividade.
      </p>

      <div id="out_blocks"></div>

      <p class="local-data"><strong>Data/Hora do relatório:</strong> <span id="out_data"></span> • <span id="out_hora"></span></p>

      <!-- Assinaturas -->
      <div class="assinaturas-duplas">
        <div class="assin-card">
          <div class="assin-titulo">Assinatura do Profissional</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_nome_ass"></span></strong><br>
            CPF: <span id="out_cpf_ass"></span> • Matrícula ADB: <span id="out_matricula_ass"></span>
          </div>
          <div class="assin-meta">Assinatura eletrônica via GOV.BR (quando aplicável)</div>
        </div>
        <div class="assin-card">
          <div class="assin-titulo">Recebimento do Contratante</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_t_nome_ass"></span></strong><br>
            CPF: <span id="out_t_cpf_ass"></span>
          </div>
        </div>
      </div>

      <div class="no-print" style="text-align:right; margin-top:16px">
        <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
      </div><br>

      <p class="muted">Relatório elaborado conforme a Lei Federal nº 13.432/2017. Reservado e confidencial.</p>
    </div>
  </div>
</div>

<script>
  // Utilidades
  const el = (id)=>document.getElementById(id);
  const onlyDigits = (v)=> (v||'').replace(/\D/g,'');

  // Máscara CPF
  function maskCPF(input){
    let v = onlyDigits(input.value).slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    input.value = v;
  }
  ['f_cpf','t_cpf'].forEach(id=> el(id).addEventListener('input', ()=> maskCPF(el(id))));

  // Matrícula ADB
  el('f_matricula').addEventListener('blur', ()=>{
    let v = el('f_matricula').value.trim().toUpperCase();
    if(!v) return;
    if(!v.startsWith('ADB-')){
      v = 'ADB-' + v.replace(/[^0-9]/g,'');
    } else {
      v = 'ADB-' + v.slice(4).replace(/[^0-9]/g,'');
    }
    el('f_matricula').value = v;
  });

  // Datas e hora
  el('f_data').addEventListener('input', ()=>{
    let v = onlyDigits(el('f_data').value).slice(0,8);
    if(v.length >= 5) v = v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/, '$1/$2/$3');
    else if(v.length >= 3) v = v.replace(/^(\d{2})(\d{0,2}).*$/, '$1/$2');
    el('f_data').value = v;
  });
  el('f_hora').addEventListener('input', ()=>{
    let v = onlyDigits(el('f_hora').value).slice(0,4);
    if(v.length > 2) v = v.slice(0,2) + ':' + v.slice(2);
    el('f_hora').value = v;
  });

  // Blocos do relatório (texto)
  const blocksEl = el('blocks');
  function addTextBlock(initText=''){
    const id = 'b'+Math.random().toString(36).slice(2,9);
    const wrap = document.createElement('div');
    wrap.className = 'block';
    wrap.innerHTML = `
      <div class="block-head">
        <div class="block-title">Relatório</div>
        <div class="small">Data: <input type="text" class="blk-data" placeholder="dd/mm/aaaa" maxlength="10" style="width:110px"> &nbsp; Hora: <input type="text" class="blk-hora" placeholder="--:--" maxlength="5" style="width:80px"> &nbsp; <button type="button" class="btn btn-danger btn-del">✖ Excluir bloco</button></div>
      </div>
      <textarea class="blk-text" placeholder="Descreva observações, metodologias, deslocamentos, fatos relevantes...">${initText}</textarea>
    `;
    // máscara para data/hora do bloco
    const di = wrap.querySelector('.blk-data');
    const hi = wrap.querySelector('.blk-hora');
    const now = new Date();
    const dd = String(now.getDate()).padStart(2,'0');
    const mm = String(now.getMonth()+1).padStart(2,'0');
    const yyyy = now.getFullYear();
    di.value = `${dd}/${mm}/${yyyy}`;
    hi.value = `${String(now.getHours()).padStart(2,'0')}:${String(now.getMinutes()).padStart(2,'0')}`;
    di.addEventListener('input', ()=>{ let v=onlyDigits(di.value).slice(0,8); if(v.length>=5)v=v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/,'$1/$2/$3'); else if(v.length>=3)v=v.replace(/^(\d{2})(\d{0,2}).*$/,'$1/$2'); di.value=v;});
    hi.addEventListener('input', ()=>{ let v=onlyDigits(hi.value).slice(0,4); if(v.length>2)v=v.slice(0,2)+':'+v.slice(2); hi.value=v;});

    wrap.querySelector('.btn-del').addEventListener('click', ()=> wrap.remove());
    blocksEl.appendChild(wrap);
  }
  el('btnAddText').addEventListener('click', ()=> addTextBlock());
  // cria primeiro bloco por padrão
  addTextBlock();

  // Imagens
  const fileInput = el('fileInput');
  const btnAddImage = el('btnAddImage');
  btnAddImage.addEventListener('click', ()=> fileInput.click());
  fileInput.addEventListener('change', (e)=>{
    const files = [...e.target.files];
    if(!files.length) return;
    const wrap = document.createElement('div');
    wrap.className = 'block';
    wrap.innerHTML = `
      <div class="block-head">
        <div class="block-title">Imagens</div>
        <div class="small">Adicionadas em ${new Date().toLocaleString('pt-BR')}</div>
      </div>
      <div class="img-grid"></div>
    `;
    const grid = wrap.querySelector('.img-grid');

    files.forEach(file=>{
      const reader = new FileReader();
      reader.onload = function(){
        const card = document.createElement('div');
        card.className = 'img-card';
        card.innerHTML = `
          <img src="${reader.result}" alt="Imagem do relatório">
          <div class="cap"><input type="text" placeholder="Legenda (opcional)" style="width:100%;border:0;outline:none"></div>
          <div class="meta">Arquivo: ${file.name}</div>
          <div class="img-actions no-print"><button type="button" class="btn btn-danger btn-rem">Excluir</button></div>
        `;
        card.querySelector('.btn-rem').addEventListener('click', ()=> card.remove());
        grid.appendChild(card);
      };
      reader.readAsDataURL(file);
    });

    blocksEl.appendChild(wrap);
    // limpa input para permitir novo upload igual
    fileInput.value = '';
  });

  // Gerar relatório
  el('btnGerar').addEventListener('click', ()=>{
    // Coleta e valida
    const nome = el('f_nome').value.trim();
    const rg = el('f_rg').value.trim();
    const cpf = el('f_cpf').value.trim();
    const mat = el('f_matricula').value.trim().toUpperCase();
    const end = el('f_end').value.trim();
    const tnome = el('t_nome').value.trim();
    const tcpf  = el('t_cpf').value.trim();
    const tend  = el('t_end').value.trim();
    const data  = el('f_data').value.trim();
    const hora  = el('f_hora').value.trim();

    if(!nome){ alert('Informe o nome do profissional.'); return; }
    if(!rg){ alert('Informe o RG.'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpf)){ alert('Informe o CPF no formato 000.000.000-00.'); return; }
    if(!/^ADB-\d+$/.test(mat)){ alert('Informe a Matrícula ADB no formato ADB-12345.'); return; }
    if(!end){ alert('Informe o endereço profissional.'); return; }

    if(!tnome){ alert('Informe o nome do contratante.'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(tcpf)){ alert('Informe o CPF do contratante no formato 000.000.000-00.'); return; }
    if(!tend){ alert('Informe o endereço do contratante.'); return; }

    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(data)){ alert('Informe a data no formato dd/mm/aaaa.'); return; }
    if(!/^\d{2}:\d{2}$/.test(hora)){ alert('Informe a hora no formato HH:MM.'); return; }

    // Preenche cabeçalho do relatório
    el('out_nome').innerText = nome;
    el('out_rg').innerText = rg;
    el('out_cpf').innerText = cpf;
    el('out_matricula').innerText = mat;
    el('out_end').innerText = end;

    el('out_t_nome').innerText = tnome;
    el('out_t_cpf').innerText  = tcpf;
    el('out_t_end').innerText  = tend;

    el('out_data').innerText = data;
    el('out_hora').innerText = hora;

    // Assinaturas
    el('out_nome_ass').innerText = nome;
    el('out_cpf_ass').innerText  = cpf;
    el('out_matricula_ass').innerText = mat;
    el('out_t_nome_ass').innerText = tnome;
    el('out_t_cpf_ass').innerText  = tcpf;

    // Monta blocos no documento
    const outBlocks = el('out_blocks');
    outBlocks.innerHTML = '';
    const allBlocks = [...document.querySelectorAll('#blocks .block')];
    if(!allBlocks.length){
      const p = document.createElement('p');
      p.className = 'muted';
      p.textContent = 'Nenhum bloco de relatório foi adicionado.';
      outBlocks.appendChild(p);
    } else {
      allBlocks.forEach((blk, idx)=>{
        const text = blk.querySelector('.blk-text');
        const di = blk.querySelector('.blk-data');
        const hi = blk.querySelector('.blk-hora');
        const imgs = blk.querySelectorAll('.img-card');

        const section = document.createElement('section');
        section.style.margin = '14px 0';

        // Cabeçalho do bloco
        const head = document.createElement('div');
        head.innerHTML = `<strong>Bloco ${idx+1}</strong>` + (di && hi ? ` — <span class="small">${di.value || ''} • ${hi.value || ''}</span>` : '');
        section.appendChild(head);

        // Texto
        if(text && text.value.trim()){
          const pt = document.createElement('p');
          pt.textContent = text.value.trim();
          section.appendChild(pt);
        }

        // Imagens
        if(imgs.length){
          const grid = document.createElement('div');
          grid.className = 'img-grid';
          imgs.forEach(imgCard=>{
            const clone = imgCard.cloneNode(true);
            // remove botões de ação no print
            const actions = clone.querySelector('.img-actions');
            if(actions) actions.remove();
            grid.appendChild(clone);
          });
          section.appendChild(grid);
        }

        outBlocks.appendChild(section);
      });
    }

    // Alterna telas
    document.getElementById('formArea').style.display = 'none';
    document.getElementById('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });

  // Voltar e editar
  document.getElementById('editAgain').addEventListener('click', (e)=>{
    e.preventDefault();
    document.getElementById('printArea').style.display = 'none';
    document.getElementById('formArea').style.display = 'block';
    window.scrollTo(0,0);
  });
</script>
</body>
</html>