<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – Prestação de Serviço (Investigação Particular)</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    *{box-sizing:border-box}
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111;line-height:1.6}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB */
    .header{
      background:#000; color:#d4af37; padding:20px 12px;
      display:flex; flex-direction:column; align-items:center; text-align:center;
    }
    .header img{height:80px; display:block; margin:0 auto}
    .header h1{margin:6px 0; color:#fff; font-size:22px}
    .header .idline{margin:4px 0; color:#f0e6b2; font-size:13px; display:block}

    .lead{background:#fff7cc;border:1px solid #ffe08a;color:#5a4d00;padding:12px 14px;border-radius:10px;margin:0 0 16px 0}
    p{text-align:justify}
    .no-print{display:block}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#004aad;color:#fff;font-weight:700;cursor:pointer}
    .btn:hover{opacity:.92}
    .btn-danger{background:#b91c1c}
    .muted{color:#4b5563}

    .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    label{font-weight:700;display:block;margin-bottom:4px}
    input[type="text"], input[type="number"]{
      width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;
    }

    /* Assinaturas */
    .assinaturas-duplas{
      margin-top:28px;
      display:flex; gap:18px; align-items:flex-start; justify-content:space-between; flex-wrap:wrap;
    }
    .assin-card{
      flex:1 1 410px;
      border:1px solid #e5e7eb; border-radius:12px;
      padding:16px; background:#fff;
      min-width:380px;
    }
    .assin-titulo{ font-weight:700; text-align:center; margin-bottom:12px; }
    .assin-area{
      border:1px dashed #888; border-radius:8px; height:120px;
      background:#fafafa; margin:10px 0 12px;
    }
    .assin-linha{ margin-top:18px; border-top:1px solid #000; padding-top:6px; text-align:center; }
    .assin-meta{ font-size:13px; color:#4b5563; text-align:center; margin-top:4px; }

    .local-data{ text-align:center; margin-top:10px; }
    .links-util{display:flex;gap:8px;justify-content:flex-end;margin-top:8px}
    .links-util a{font-size:12px;color:#004aad;text-decoration:none}

    @media (max-width: 768px){ .form-grid{grid-template-columns:1fr} .assin-card{ min-width:auto; } }

    /* Impressão */
    @media print{
      .no-print{ display:none !important; }
      input{ border:0 !important; background:transparent !important; box-shadow:none !important; outline:0 !important; padding:0 !important; margin:0 !important; appearance:none; -webkit-appearance:none; }
      input[type="text"], input[type="number"]{ display:inline !important; width:auto !important; }
      input::placeholder{ color:transparent !important; }
      @page{ size:A4; margin:14mm; }
      .container{ box-shadow:none }
      body{ background:#fff }
      .header{ text-align:center; align-items:center }
    }

    ul.lista{margin:8px 0 0 18px}
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- ========== FORMULÁRIO (sem banco) ========== -->
    <div id="formArea" class="no-print">
      <h2>Prestação de Serviço – Investigação Particular</h2>
      <div class="lead">Preencha os campos e clique em <strong>Gerar documento</strong>. Você poderá revisar e <strong>imprimir em PDF</strong>.</div>

      <h3>Dados do CONTRATADO (Detetive Particular)</h3>
      <div class="form-grid">
        <div>
          <label>Nome do contratado</label>
          <input type="text" id="c_nome" placeholder="Nome completo" required>
        </div>
        <div>
          <label>CPF do contratado</label>
          <input type="text" id="c_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div>
          <label>Endereço (Rua, nº, bairro, cidade/UF)</label>
          <input type="text" id="c_end" placeholder="Rua, nº, Bairro, Cidade/UF" required>
        </div>
        <div>
          <label>CBO / Lei Federal</label>
          <input type="text" id="c_cbo" value="CBO 3518-05 • Lei Federal 13.432/2017" readonly>
        </div>
        <div>
          <label>Matrícula ADB</label>
          <input type="text" id="c_matricula" placeholder="ADB-00000" required>
        </div>
      </div>

      <h3 style="margin-top:18px">Dados do CONTRATANTE</h3>
      <div class="form-grid">
        <div>
          <label>Nome do contratante</label>
          <input type="text" id="t_nome" placeholder="DIGITE O NOME DO CONTRATANTE" required>
        </div>
        <div>
          <label>CPF do contratante</label>
          <input type="text" id="t_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço do contratante</label>
          <input type="text" id="t_end" placeholder="DIGITE O ENDEREÇO DO CONTRATANTE" required>
        </div>
      </div>

      <h3 style="margin-top:18px">Valores e Condições</h3>
      <div class="form-grid">
        <div>
          <label>Valor da diária única (R$)</label>
          <input type="text" id="v_diaria" placeholder="0.000,00" inputmode="numeric">
        </div>
        <div>
          <label>Pacote – nº de dias</label>
          <input type="number" id="p_dias" placeholder="00" min="0" step="1" value="0">
        </div>
        <div>
          <label>Pacote – valor da diária (R$)</label>
          <input type="text" id="p_diaria" placeholder="000,00" inputmode="numeric">
        </div>
        <div>
          <label>Pacote – total (R$)</label>
          <input type="text" id="p_total" placeholder="0.000,00" inputmode="numeric" readonly>
        </div>
      </div>

      <div class="form-grid">
        <div>
          <label>Pagamento inicial ( % )</label>
          <input type="number" id="pct_inicial" placeholder="00" min="0" max="100" value="50">
        </div>
        <div>
          <label>Pagamento final ( % )</label>
          <input type="number" id="pct_final" placeholder="00" min="0" max="100" value="50">
        </div>
        <div>
          <label>Valor inicial (R$)</label>
          <input type="text" id="v_inicial" placeholder="0.000,00" readonly>
        </div>
        <div>
          <label>Valor final (R$)</label>
          <input type="text" id="v_final" placeholder="0.000,00" readonly>
        </div>
      </div>

      <h3 style="margin-top:18px">Diária em Campo e Datas</h3>
      <div class="form-grid">
        <div>
          <label>Duração da diária (00h00min)</label>
          <input type="text" id="d_duracao" placeholder="00h00min">
        </div>
        <div>
          <label>Início (HH:MM)</label>
          <input type="text" id="d_inicio" placeholder="00:00" maxlength="5">
        </div>
        <div>
          <label>Término (HH:MM)</label>
          <input type="text" id="d_fim" placeholder="00:00" maxlength="5">
        </div>
        <div>
          <label>Data do orçamento</label>
          <input type="text" id="data_orc" placeholder="00/00/0000" maxlength="10" inputmode="numeric" required>
        </div>
        <div>
          <label>Validade do orçamento (dias)</label>
          <input type="number" id="validade_dias" placeholder="15" min="1" value="15">
        </div>
      </div>

      <div class="form-grid">
        <div style="grid-column:1/-1">
          <label>Despesas extras (descrição opcional)</label>
          <input type="text" id="v_despesas" placeholder="Ex.: combustível, pedágio, estacionamento (reembolso mediante comprovantes)">
        </div>
        <div>
          <label>Forma de pagamento</label>
          <input type="text" id="forma_pgto" placeholder="Transferência via PIX ou transferência bancária">
        </div>
      </div>

      <div style="text-align:right;margin-top:18px">
        <button class="btn" id="btnGerar">Gerar documento</button>
      </div>
    </div>

    <!-- ========== ORÇAMENTO GERADO ========== -->
    <div id="printArea" style="display:none">
      <h2>PRESTAÇÃO DE SERVIÇO</h2>

      <div class="links-util no-print">
        <a href="#" id="editAgain">← Voltar e editar</a>
        <a href="#" onclick="window.print()">🖨️ Imprimir / Salvar PDF</a>
      </div>

      <h3>DO OBJETO</h3>
      <p>
        O presente orçamento tem como objetivo a prestação de serviço de Investigação particular para coleta de dados e informações visando ao esclarecimento de assuntos de interesse privado do CONTRATANTE, com plena liberdade, apreço pela verdade, zelo e discrição, orientando-se pelos informes preliminares a si fornecidos, obrigando-se, contudo, a observar os preceitos constitucionais atinentes à vida privada, à inviolabilidade do lar e das comunicações, à honra e à boa fama das pessoas, apresentando no final do prazo estabelecido na Cláusula 3ª um RELATÓRIO (impresso ou via e-mail) detalhando a pesquisa, os dados obtidos e seu parecer sobre o caso.
      </p>

      <p>
        De um lado <strong><span id="out_c_nome"></span></strong>, portador do CPF <strong><span id="out_c_cpf"></span></strong>, residente e domiciliado à <strong><span id="out_c_end"></span></strong>, Detetive Particular de acordo com o Código Brasileiro de Ocupações nº <strong>3518-05</strong> e pela Lei Federal <strong>13.432</strong>, Matrícula <strong><span id="out_c_matricula"></span></strong> na Associação dos Detetives do Brasil, representado neste ato como simplesmente <strong>CONTRATADO</strong>, e de outro lado:
      </p>

      <p><strong>CONTRATANTE:</strong><br>
        Nome: <span id="out_t_nome"></span><br>
        CPF: <span id="out_t_cpf"></span><br>
        Endereço: <span id="out_t_end"></span>
      </p>

      <h3>Prazo de validade deste orçamento</h3>
      <p>
        Conforme o Código de Defesa do Consumidor, o prazo de validade é de <strong><span id="out_validade_cdc"></span> dias</strong> a contar da data deste orçamento (<strong><span id="out_data_orc"></span></strong>).
      </p>

      <h3>Objetivo da prestação do serviço</h3>
      <p>
        Prestação de serviço de investigação particular para coleta de dados e informações visando ao esclarecimento de assuntos de interesse privado do CONTRATANTE.
      </p>

      <h3>Prazo para execução do serviço</h3>
      <p>
        O serviço será executado dentro de <strong>48 horas</strong> após a assinatura do contrato, para a devida organização e início dos trabalhos.
      </p>

      <h3>Valores e condições de pagamento</h3>
      <p>
        <strong>Valor da diária única:</strong> R$ <span id="out_v_diaria"></span>
      </p>
      <p>
        <strong>Valor do pacote para</strong> <span id="out_p_dias"></span> <strong>dia(s)</strong> – valor da diária: R$ <span id="out_p_diaria"></span> — <strong>total:</strong> R$ <span id="out_p_total"></span>
      </p>
      <p>
        <strong>Condições de pagamento no pacote:</strong><br>
        Pagamento inicial de R$ <strong><span id="out_v_inicial"></span></strong> (<span id="out_pct_inicial"></span>%) no ato da assinatura.<br>
        Pagamento final de R$ <strong><span id="out_v_final"></span></strong> (<span id="out_pct_final"></span>%) com entrega do relatório (positivo ou negativo).
      </p>

      <h3>Duração da diária em campo</h3>
      <p>
        Diária em campo de <strong><span id="out_d_duracao"></span></strong>, com início às <strong><span id="out_d_inicio"></span></strong> e término às <strong><span id="out_d_fim"></span></strong>. Podendo se estender, caso necessário, com acréscimo de <strong>10%</strong> no valor da diária em curso por horas excedentes, mediante autorização do CONTRATANTE. Havendo continuidade, o valor será ajustado ao final do trabalho.
      </p>

      <h3>Despesas extras</h3>
      <p>
        Correrão por conta do(a) CONTRATANTE todas as despesas imprescindíveis ao bom e regular andamento da investigação, desde que previamente autorizadas e reembolsadas mediante apresentação dos respectivos comprovantes.<br>
        <em>Observação:</em> <span id="out_v_despesas"></span>
      </p>

      <h3>Forma de pagamento</h3>
      <p><span id="out_forma_pgto"></span></p>

      <h3>Validade do orçamento</h3>
      <p>
        O valor orçado terá validade pelo prazo de <strong><span id="out_validade_custom"></span> dias</strong>, contado do recebimento pelo contratante. § 2º Uma vez aprovado, o orçamento obriga as partes e só poderá ser alterado mediante livre negociação entre elas.
      </p>

      <p class="local-data"><strong>Data do orçamento:</strong> <span id="out_data_orc2"></span></p>

      <h3>O que é fornecido no relatório final?</h3>
      <ul class="lista">
        <li>Fotos de todo o acompanhamento;</li>
        <li>Vídeos (quando possível, sem comprometer o sigilo);</li>
        <li>Descrições de endereços frequentados e outras anotações relevantes;</li>
        <li>Contato via WhatsApp durante a execução (com localização via Google Maps).</li>
      </ul>

      <!-- Assinaturas -->
      <div class="assinaturas-duplas">
        <div class="assin-card">
          <div class="assin-titulo">CONTRATADO</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_c_nome_ass"></span></strong><br>
            CPF: <span id="out_c_cpf_ass"></span> • Matrícula ADB: <span id="out_c_matricula_ass"></span>
          </div>
          <div class="assin-meta">Assinatura eletrônica via GOV.BR (quando aplicável)</div>
        </div>

        <div class="assin-card">
          <div class="assin-titulo">CONTRATANTE</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_t_nome_ass"></span></strong><br>
            CPF: <span id="out_t_cpf_ass"></span>
          </div>
          <div class="assin-meta">(Assinatura do contratante)</div>
        </div>
      </div>

      <div class="no-print" style="text-align:right; margin-top:16px">
        <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
      </div><br>

      <p class="muted">Este orçamento observa a Lei Federal nº 13.432/2017 (atividade do detetive particular) e o CDC no tocante à validade de proposta.</p>
    </div>
  </div>
</div>

<script>
  // Utilidades
  const el = (id)=>document.getElementById(id);
  const onlyDigits = (v)=> (v||'').replace(/\D/g,'');

  // Máscara CPF
  function maskCPF(input){
    let v = onlyDigits(input.value).slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    input.value = v;
  }
  ['c_cpf','t_cpf'].forEach(id=> el(id).addEventListener('input', ()=> maskCPF(el(id))));

  // Matrícula ADB
  el('c_matricula').addEventListener('blur', ()=>{
    let v = el('c_matricula').value.trim().toUpperCase();
    if(!v) return;
    if(!v.startsWith('ADB-')){
      v = 'ADB-' + v.replace(/[^0-9]/g,'');
    } else {
      v = 'ADB-' + v.slice(4).replace(/[^0-9]/g,'');
    }
    el('c_matricula').value = v;
  });

  // Máscara de dinheiro BR (0.000,00)
  function maskMoney(input){
    let v = onlyDigits(input.value);
    if(!v){ input.value = ''; return; }
    while(v.length < 3) v = '0' + v;
    const cents = v.slice(-2);
    let int = v.slice(0, -2).replace(/^0+/, '') || '0';
    int = int.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    input.value = int + ',' + cents;
  }
  ['v_diaria','p_diaria'].forEach(id=>{
    el(id).addEventListener('input', ()=> maskMoney(el(id)));
    el(id).addEventListener('blur',  ()=> maskMoney(el(id)));
  });

  function parseMoney(str){
    if(!str) return 0;
    const n = str.replace(/\./g,'').replace(',', '.');
    const f = parseFloat(n);
    return isNaN(f) ? 0 : f;
  }
  function formatMoneyBR(v){
    return v.toLocaleString('pt-BR', {minimumFractionDigits:2, maximumFractionDigits:2});
  }

  // Cálculo pacote total e percentuais
  function recalcTotals(){
    const dias = parseInt(el('p_dias').value || '0', 10);
    const vDia = parseMoney(el('p_diaria').value);
    const total = dias > 0 ? (dias * vDia) : parseMoney(el('v_diaria').value);
    el('p_total').value = formatMoneyBR(total);

    const pi = Math.max(0, Math.min(100, parseFloat(el('pct_inicial').value || '0')));
    const pf = Math.max(0, Math.min(100, parseFloat(el('pct_final').value || '0')));

    const vin = total * (pi/100);
    const vfi = total * (pf/100);
    el('v_inicial').value = formatMoneyBR(vin);
    el('v_final').value   = formatMoneyBR(vfi);
  }
  ;['p_dias','p_diaria','v_diaria','pct_inicial','pct_final'].forEach(id=>{
    el(id).addEventListener('input', recalcTotals);
    el(id).addEventListener('blur', recalcTotals);
  });

  // Máscara datas dd/mm/aaaa
  function maskDateInput(input){
    let v = onlyDigits(input.value).slice(0,8);
    if(v.length >= 5) v = v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/, '$1/$2/$3');
    else if(v.length >= 3) v = v.replace(/^(\d{2})(\d{0,2}).*$/, '$1/$2');
    input.value = v;
  }
  el('data_orc').addEventListener('input', ()=> maskDateInput(el('data_orc')));

  // Máscara horários HH:MM e duração 00h00min
  function maskTime(input){
    let v = input.value.replace(/[^\d]/g,'').slice(0,4);
    if(v.length > 2) v = v.slice(0,2) + ':' + v.slice(2);
    input.value = v;
  }
  ['d_inicio','d_fim'].forEach(id=> el(id).addEventListener('input', ()=> maskTime(el(id))));
  el('d_duracao').addEventListener('input', ()=>{
    let v = el('d_duracao').value.toUpperCase().replace(/[^\dHMIN]/g,'').replace(/MIN/g,'min');
    v = v.replace(/[^\d]/g,''); // deixa só números e remonta
    v = v.slice(0,4);
    if(v.length <= 2) el('d_duracao').value = (v || '00') + 'h';
    else el('d_duracao').value = v.slice(0,2) + 'h' + v.slice(2).padEnd(2,'0') + 'min';
  });

  // Geração do documento
  el('btnGerar').addEventListener('click', ()=>{
    // Recalcula totais
    recalcTotals();

    // Coleta
    const c_nome = el('c_nome').value.trim();
    const c_cpf  = el('c_cpf').value.trim();
    const c_end  = el('c_end').value.trim();
    const c_mat  = el('c_matricula').value.trim().toUpperCase();

    const t_nome = el('t_nome').value.trim();
    const t_cpf  = el('t_cpf').value.trim();
    const t_end  = el('t_end').value.trim();

    const v_diaria = el('v_diaria').value.trim() || '0,00';
    const p_dias   = parseInt(el('p_dias').value || '0', 10);
    const p_diaria = el('p_diaria').value.trim() || '0,00';
    const p_total  = el('p_total').value.trim() || '0,00';

    const pct_inicial = el('pct_inicial').value || '0';
    const pct_final   = el('pct_final').value || '0';
    const v_inicial   = el('v_inicial').value || '0,00';
    const v_final     = el('v_final').value || '0,00';

    const d_duracao = el('d_duracao').value.trim() || '00h00min';
    const d_inicio  = el('d_inicio').value.trim()  || '00:00';
    const d_fim     = el('d_fim').value.trim()     || '00:00';

    const data_orc = el('data_orc').value.trim();
    const validade = parseInt(el('validade_dias').value || '15', 10);

    const v_despesas = el('v_despesas').value.trim() || '—';
    const forma_pgto = el('forma_pgto').value.trim() || 'Transferência via PIX ou transferência bancária';

    // Valida mínimos
    if(!c_nome){ alert('Informe o nome do CONTRATADO.'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(c_cpf)){ alert('CPF do CONTRATADO inválido. Use 000.000.000-00.'); return; }
    if(!c_end){ alert('Informe o endereço do CONTRATADO.'); return; }
    if(!/^ADB-\d+$/.test(c_mat)){ alert('Matrícula ADB inválida. Use ADB-12345.'); return; }

    if(!t_nome){ alert('Informe o nome do CONTRATANTE.'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(t_cpf)){ alert('CPF do CONTRATANTE inválido. Use 000.000.000-00.'); return; }
    if(!t_end){ alert('Informe o endereço do CONTRATANTE.'); return; }

    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(data_orc)){ alert('Informe a data do orçamento no formato dd/mm/aaaa.'); return; }

    // Preenche saída
    el('out_c_nome').innerText = c_nome;
    el('out_c_cpf').innerText  = c_cpf;
    el('out_c_end').innerText  = c_end;
    el('out_c_matricula').innerText = c_mat;

    el('out_t_nome').innerText = t_nome;
    el('out_t_cpf').innerText  = t_cpf;
    el('out_t_end').innerText  = t_end;

    el('out_v_diaria').innerText = v_diaria;
    el('out_p_dias').innerText   = isNaN(p_dias)? '0' : p_dias;
    el('out_p_diaria').innerText = p_diaria;
    el('out_p_total').innerText  = p_total;

    el('out_pct_inicial').innerText = pct_inicial;
    el('out_pct_final').innerText   = pct_final;
    el('out_v_inicial').innerText   = v_inicial;
    el('out_v_final').innerText     = v_final;

    el('out_d_duracao').innerText = d_duracao;
    el('out_d_inicio').innerText  = d_inicio;
    el('out_d_fim').innerText     = d_fim;

    el('out_data_orc').innerText  = data_orc;
    el('out_data_orc2').innerText = data_orc;
    el('out_validade_cdc').innerText = validade;
    el('out_validade_custom').innerText = validade;

    el('out_v_despesas').innerText = v_despesas;
    el('out_forma_pgto').innerText = forma_pgto;

    // Assinaturas
    el('out_c_nome_ass').innerText = c_nome;
    el('out_c_cpf_ass').innerText  = c_cpf;
    el('out_c_matricula_ass').innerText = c_mat;
    el('out_t_nome_ass').innerText = t_nome;
    el('out_t_cpf_ass').innerText  = t_cpf;

    // Alterna telas
    document.getElementById('formArea').style.display = 'none';
    document.getElementById('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });

  // Voltar e editar
  document.getElementById('editAgain').addEventListener('click', (e)=>{
    e.preventDefault();
    document.getElementById('printArea').style.display = 'none';
    document.getElementById('formArea').style.display = 'block';
    window.scrollTo(0,0);
  });
</script>
</body>
</html>
