<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – Petição de Aceite de Colaboração (Lei 13.432/2017)</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    *{box-sizing:border-box}
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111;line-height:1.6}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB */
    .header{background:#000;color:#d4af37;padding:20px 12px;display:flex;flex-direction:column;align-items:center;text-align:center}
    .header img{height:80px;display:block;margin:0 auto}
    .header h1{margin:6px 0;color:#fff;font-size:22px}
    .header .idline{margin:4px 0;color:#f0e6b2;font-size:13px;display:block}

    .lead{background:#fff7cc;border:1px solid #ffe08a;color:#5a4d00;padding:12px 14px;border-radius:10px;margin:0 0 16px 0}
    p{text-align:justify}
    .no-print{display:block}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#004aad;color:#fff;font-weight:700;cursor:pointer}
    .btn:hover{opacity:.92}
    .btn-danger{background:#b91c1c}
    .muted{color:#4b5563}

    .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    label{font-weight:700;display:block;margin-bottom:4px}
    input[type="text"], input[type="number"]{width:100%;padding:10px;border:1px solid #ccc;border-radius:8px}

    /* Assinaturas */
    .assinaturas-duplas{margin-top:28px;display:flex;gap:18px;align-items:flex-start;justify-content:space-between;flex-wrap:wrap}
    .assin-card{flex:1 1 410px;border:1px solid #e5e7eb;border-radius:12px;padding:16px;background:#fff;min-width:380px}
    .assin-titulo{font-weight:700;text-align:center;margin-bottom:12px}
    .assin-area{border:1px dashed #888;border-radius:8px;height:120px;background:#fafafa;margin:10px 0 12px}
    .assin-linha{margin-top:18px;border-top:1px solid #000;padding-top:6px;text-align:center}
    .assin-meta{font-size:13px;color:#4b5563;text-align:center;margin-top:4px}

    .local-data{text-align:center;margin-top:10px}
    .links-util{display:flex;gap:8px;justify-content:flex-end;margin-top:8px}
    .links-util a{font-size:12px;color:#004aad;text-decoration:none}

    @media (max-width:768px){.form-grid{grid-template-columns:1fr}.assin-card{min-width:auto}}

    /* Impressão */
    @media print{
      .no-print{display:none!important}
      input{border:0!important;background:transparent!important;box-shadow:none!important;outline:0!important;padding:0!important;margin:0!important;appearance:none;-webkit-appearance:none}
      input[type="text"], input[type="number"]{display:inline!important;width:auto!important}
      input::placeholder{color:transparent!important}
      @page{size:A4;margin:14mm}
      .container{box-shadow:none}
      body{background:#fff}
      .header{text-align:center;align-items:center}
    }
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- ========== FORMULÁRIO (sem banco) ========== -->
    <div id="formArea" class="no-print">
      <h2>Petição – Aceite de Colaboração do Detetive Profissional</h2>
      <div class="lead">Preencha os campos e clique em <strong>Gerar documento</strong>. Depois você pode revisar e <strong>imprimir em PDF</strong>.</div>

      <h3>Destinatário</h3>
      <div class="form-grid">
        <div>
          <label>Nº da Delegacia Policial</label>
          <input type="text" id="f_delegacia_num" placeholder="Ex.: 1ª, 5ª, 12ª" required>
        </div>
        <div>
          <label>Cidade/UF da Delegacia</label>
          <input type="text" id="f_delegacia_cidade" placeholder="Ex.: Lauro Müller/SC" required>
        </div>
        <div style="grid-column:1/-1">
          <label>Boletim de ocorrência nº</label>
          <input type="text" id="f_bo" placeholder="Número do boletim de ocorrência" required>
        </div>
      </div>

      <h3>Profissional (Detetive)</h3>
      <div class="form-grid">
        <div>
          <label>Nome do detetive</label>
          <input type="text" id="f_nome" placeholder="Nome completo" required>
        </div>
        <div>
          <label>Identidade (RG)</label>
          <input type="text" id="f_rg" placeholder="Número da identidade" required>
        </div>
        <div>
          <label>CPF</label>
          <input type="text" id="f_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div>
          <label>Matrícula ADB</label>
          <input type="text" id="f_matricula" placeholder="ADB-12345">
        </div>
        <div style="grid-column:1/-1">
          <label>Endereço do escritório</label>
          <input type="text" id="f_end" placeholder="Av./Rua, nº, Bairro – Cidade/UF" required>
        </div>
      </div>

      <h3>Contratante e Processo</h3>
      <div class="form-grid">
        <div>
          <label>Nome do contratante</label>
          <input type="text" id="f_contratante" placeholder="Nome do contratante" required>
        </div>
        <div>
          <label>Nº da investigação policial (se houver)</label>
          <input type="text" id="f_investigacao" placeholder="Número da investigação">
        </div>
      </div>

      <h3>Local e Data</h3>
      <div class="form-grid">
        <div>
          <label>Cidade</label>
          <input type="text" id="f_cidade" placeholder="Cidade" required>
        </div>
        <div>
          <label>Data do documento (dd/mm/aaaa)</label>
          <input type="text" id="f_data" placeholder="00/00/0000" maxlength="10" inputmode="numeric" required>
        </div>
      </div>

      <div style="text-align:right;margin-top:18px">
        <button class="btn" id="btnGerar">Gerar documento</button>
      </div>
    </div>

    <!-- ========== DOCUMENTO GERADO ========== -->
    <div id="printArea" style="display:none">
      <h2>PETIÇÃO – ACEITE DE COLABORAÇÃO</h2>

      <div class="links-util no-print">
        <a href="#" id="editAgain">← Voltar e editar</a>
        <a href="#" onclick="window.print()">🖨️ Imprimir / Salvar PDF</a>
      </div>

      <p>
        <strong>AO EXMO. DR. DELEGADO TITULAR DA <span id="out_delegacia_num"></span> DELEGACIA POLICIAL – <span id="out_delegacia_cidade"></span></strong>
      </p>

      <p>
        <strong>Ref. Boletim de Ocorrência nº:</strong> <span id="out_bo"></span>
      </p>

      <p>
        Eu, <strong><span id="out_nome"></span></strong>, Detetive Profissional, Identidade nº <strong><span id="out_rg"></span></strong>, CPF nº <strong><span id="out_cpf"></span></strong><span id="out_matricula_wrap"></span>, com escritório situado à <strong><span id="out_end"></span></strong>, venho requerer a V. Exª, a saber:
      </p>

      <p>
        <strong>DR. DELEGADO</strong> – Este profissional foi contratado pelo Sr.(a) <strong><span id="out_contratante"></span></strong>, o(a) qual procedeu o Registro de Ocorrência acima descrito perante esta Respeitável Delegacia Policial.
      </p>

      <p>
        O <strong>Art. 5º da Lei 13.432/2017</strong>, que dispõe sobre o exercício da profissão de detetive particular, assim prevê: “<em>O detetive particular pode colaborar com investigação policial em curso, desde que expressamente autorizado pelo contratante</em>”. <br>
        <em>Parágrafo único</em>. O aceite da colaboração ficará a critério do Delegado de Polícia, que poderá admiti-la ou rejeitá-la a qualquer tempo.
      </p>

      <p>
        Conforme determina a legislação específica, este detetive junta a <strong>Autorização Expressa</strong> do contratante à presente petição.
      </p>

      <p>
        Este profissional tem a intenção de atuar apenas como <strong>COLABORADOR</strong>, nos limites da Lei Federal nº 13.432/2017, pois é ente privado contratado pelo cliente; inclusive a referida lei <strong>veda</strong> ao detetive particular, com base no <strong>Art. 10, inciso IV</strong>, participar diretamente de diligências policiais.
      </p>

      <p>
        Isto posto, requeiro a V. Exª que profira despacho de <strong>ACEITE DA COLABORAÇÃO</strong> deste detetive profissional na investigação policial em curso nº <strong><span id="out_investigacao"></span></strong>.
      </p>

      <p class="local-data">
        <strong><span id="out_local_data_extenso"></span></strong>
      </p>

      <div class="assinaturas-duplas">
        <div class="assin-card">
          <div class="assin-titulo">Assinatura do Profissional</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_nome_ass"></span></strong><br>
            CPF: <span id="out_cpf_ass"></span><span id="out_matricula_ass_wrap"></span>
          </div>
          <div class="assin-meta">Assinatura eletrônica via GOV.BR (quando aplicável)</div>
        </div>

        <div class="assin-card">
          <div class="assin-titulo">Despacho da Autoridade</div>
          <div class="assin-area" aria-label="Área para despacho/assinatura"></div>
          <div class="assin-linha">
            <strong>Delegado(a) de Polícia</strong><br>
            <span><span id="out_delegacia_num_ass"></span> Delegacia – <span id="out_delegacia_cidade_ass"></span></span>
          </div>
        </div>
      </div>

      <div class="no-print" style="text-align:right;margin-top:16px">
        <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
      </div>

      <br>
      <p class="muted">Documento conforme Lei Federal nº 13.432/2017 (detetive particular).</p>
    </div>
  </div>
</div>

<script>
  const el = (id)=>document.getElementById(id);
  const onlyDigits = (v)=> (v||'').replace(/\D/g,'');

  // Máscara CPF
  el('f_cpf').addEventListener('input', ()=>{
    let v = onlyDigits(el('f_cpf').value).slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    el('f_cpf').value = v;
  });

  // Matrícula ADB
  el('f_matricula').addEventListener('blur', ()=>{
    let v = el('f_matricula').value.trim().toUpperCase();
    if(!v) return;
    if(!v.startsWith('ADB-')) v = 'ADB-' + v.replace(/[^0-9]/g,'');
    else v = 'ADB-' + v.slice(4).replace(/[^0-9]/g,'');
    el('f_matricula').value = v;
  });

  // Data dd/mm/aaaa
  el('f_data').addEventListener('input', ()=>{
    let v = onlyDigits(el('f_data').value).slice(0,8);
    if(v.length >= 5) v = v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/, '$1/$2/$3');
    else if(v.length >= 3) v = v.replace(/^(\d{2})(\d{0,2}).*$/, '$1/$2');
    el('f_data').value = v;
  });

  function dataPorExtenso(ddmmaa){
    // dd/mm/aaaa -> "Dia de Mês de Ano"
    const meses = ['janeiro','fevereiro','março','abril','maio','junho','julho','agosto','setembro','outubro','novembro','dezembro'];
    const m = /^([0-3]\\d)\/([0-1]\\d)\/(\\d{4})$/.exec(ddmmaa);
    if(!m) return ddmmaa;
    const d = parseInt(m[1],10); const mi = Math.max(1, Math.min(12, parseInt(m[2],10))) - 1; const a = m[3];
    return `${d} de ${meses[mi]} de ${a}`;
  }

  // Gerar documento
  el('btnGerar').addEventListener('click', ()=>{
    // Coleta
    const delegNum = el('f_delegacia_num').value.trim();
    const delegCid = el('f_delegacia_cidade').value.trim();
    const bo = el('f_bo').value.trim();
    const nome = el('f_nome').value.trim();
    const rg = el('f_rg').value.trim();
    const cpf = el('f_cpf').value.trim();
    const mat = el('f_matricula').value.trim();
    const end = el('f_end').value.trim();
    const contratante = el('f_contratante').value.trim();
    const investig = el('f_investigacao').value.trim();
    const cidade = el('f_cidade').value.trim();
    const dataDoc = el('f_data').value.trim();

    // Valida mínimos
    if(!delegNum){ alert('Informe o Nº da Delegacia.'); return; }
    if(!delegCid){ alert('Informe a cidade/UF da Delegacia.'); return; }
    if(!bo){ alert('Informe o número do boletim de ocorrência.'); return; }
    if(!nome){ alert('Informe o nome do detetive.'); return; }
    if(!rg){ alert('Informe a identidade (RG).'); return; }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpf)){ alert('Informe o CPF no formato 000.000.000-00.'); return; }
    if(!end){ alert('Informe o endereço do escritório.'); return; }
    if(!contratante){ alert('Informe o nome do contratante.'); return; }
    if(!cidade){ alert('Informe a cidade.'); return; }
    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(dataDoc)){ alert('Informe a data no formato dd/mm/aaaa.'); return; }

    // Preenche saída
    el('out_delegacia_num').innerText = delegNum;
    el('out_delegacia_cidade').innerText = delegCid;
    el('out_bo').innerText = bo;

    el('out_nome').innerText = nome;
    el('out_rg').innerText = rg;
    el('out_cpf').innerText = cpf;
    el('out_end').innerText = end;

    // Matrícula ADB (opcional)
    if(mat){
      el('out_matricula_wrap').innerHTML = `, Matrícula ADB nº <strong>${mat}</strong>`;
      el('out_matricula_ass_wrap').innerHTML = ` • Matrícula ADB: <span>${mat}</span>`;
    } else {
      el('out_matricula_wrap').innerHTML = '';
      el('out_matricula_ass_wrap').innerHTML = '';
    }

    el('out_contratante').innerText = contratante;
    el('out_investigacao').innerText = investig || '—';

    // Local e data por extenso
    el('out_local_data_extenso').innerText = `${cidade}, ${dataPorExtenso(dataDoc)}`;

    // Assinaturas
    el('out_nome_ass').innerText = nome;
    el('out_cpf_ass').innerText = cpf;
    el('out_delegacia_num_ass').innerText = delegNum;
    el('out_delegacia_cidade_ass').innerText = delegCid;

    // Alterna telas
    document.getElementById('formArea').style.display = 'none';
    document.getElementById('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });

  // Voltar e editar
  document.getElementById('editAgain').addEventListener('click', (e)=>{
    e.preventDefault();
    document.getElementById('printArea').style.display = 'none';
    document.getElementById('formArea').style.display = 'block';
    window.scrollTo(0,0);
  });
</script>
</body>
</html>