<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>AUTORIZAÇÃO – Colaboração com Investigação Policial | ADB</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  /* Base e layout */
  body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111}
  .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}

  /* Cabeçalho ADB (centralizado) */
  .header{
    background:#000; color:#d4af37; padding:20px 12px;
    display:flex; flex-direction:column; align-items:center;
    text-align:center;
  }
  .header img{height:80px; display:block; margin:0 auto}
  .header h1{margin:6px 0; color:#fff; font-size:22px; text-align:center}
  .header .idline{
    margin:4px 0; color:#f0e6b2; font-size:13px;
    display:block; text-align:center;
  }

  /* Conteúdo */
  .main{padding:24px}
  h2{text-align:center;margin:6px 0 16px}
  p{line-height:1.6;text-align:justify}
  .conteudo{line-height:1.8}
  .meta{font-size:13px;color:#333;text-align:center;margin-bottom:18px}
  .subtitulo{font-weight:700;margin-top:12px}

  /* Formulário */
  .form-row{display:flex;gap:12px;flex-wrap:wrap;justify-content:center;margin-bottom:10px}
  .input,.select{width:100%;max-width:320px;padding:10px;border:1px solid #ccc;border-radius:8px}
  .wide{max-width:660px}
  button{padding:10px 16px;border:0;border-radius:8px;background:#000;color:#fff;font-weight:700;cursor:pointer}
  button.secondary{background:#444}

  /* Assinatura */
  .assinaturas-adb{margin-top:26px;text-align:center}
  .assin-gov-caixa{border:1px dashed #888;border-radius:8px;padding:18px;min-height:96px;display:flex;align-items:center;justify-content:center;text-align:center;color:#333;font-style:italic}
  .assin-linha{margin-top:22px;border-top:1px solid #000;padding-top:8px}

  /* Ações */
  .btns{display:flex;gap:10px;justify-content:flex-end;margin-top:24px}

  /* Impressão */
  @media print{
    @page{size:A4;margin:14mm}
    #formArea,.btns{display:none!important}
    .container{box-shadow:none}
    body{background:#fff}
    .header{ text-align:center; align-items:center }
  }
</style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="https://www.associacaodosdetetives.com.br/logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- FORMULÁRIO -->
    <div id="formArea">
      <h2>AUTORIZAÇÃO</h2>
      <div class="subtitulo">Dados do(a) Contratante</div>
      <div class="form-row">
        <input type="text" id="nome" class="input" placeholder="Nome completo" required>
        <input type="text" id="nacionalidade" class="input" placeholder="Nacionalidade" required>
        <select id="estadocivil" class="select" required>
          <option value="">Estado civil</option>
          <option>Solteiro(a)</option><option>Casado(a)</option><option>Divorciado(a)</option>
          <option>Viúvo(a)</option><option>União estável</option>
        </select>
        <input type="text" id="profissao" class="input" placeholder="Profissão" required>
      </div>
      <div class="form-row">
        <input type="text" id="rg" class="input" placeholder="Identidade (RG) nº" required>
        <input type="text" id="cpf" class="input" placeholder="CPF no formato 000.000.000-00" inputmode="numeric" maxlength="14" required>
        <input type="text" id="endereco" class="input wide" placeholder="Endereço completo (rua, nº, bairro, cidade/UF)" required>
      </div>

      <div class="subtitulo">Profissional Autorizado (Detetive Particular – CBO 3518-05 / Lei 13.432)</div>
      <div class="form-row">
        <input type="text" id="detetive" class="input" placeholder="Nome do profissional" required>
        <input type="text" id="detetiveCpf" class="input" placeholder="CPF do profissional 000.000.000-00" inputmode="numeric" maxlength="14" required>
        <input type="text" id="detetiveEndereco" class="input wide" placeholder="Endereço do profissional" required>
        <input type="text" id="detetiveEstado" class="input" placeholder="Estado (UF)" maxlength="2" required>
      </div>

      <div class="subtitulo">Procedimento Policial</div>
      <div class="form-row">
        <input type="text" id="nProcedimento" class="input" placeholder="Nº do procedimento" required>
        <select id="qualificacao" class="select" required>
          <option value="">Qualificação no procedimento</option>
          <option>Vítima</option>
          <option>Autor do Fato</option>
          <option>Indiciado</option>
        </select>
      </div>

      <div class="subtitulo">Local e Data</div>
      <div class="form-row">
        <input type="text" id="cidade" class="input" placeholder="Sua cidade" required>
        <input type="date" id="data" class="input" required>
      </div>

      <div style="text-align:center;margin-top:12px">
        <button id="gerar" type="button">Gerar Autorização</button>
      </div>
    </div>

    <!-- DOCUMENTO GERADO -->
    <div id="printArea" style="display:none">
      <h2>AUTORIZAÇÃO</h2>
      <div class="meta">
        <strong>Associação dos Detetives do Brasil – ADB</strong><br>
        CNPJ: 13.329.080/0001-75 • Sede: Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000
      </div>

      <div class="conteudo">
        <p>
          <strong>Nome completo, Nacionalidade, estado civil, Profissão, RG, CPF e Endereço do(a) Contratante:</strong><br>
          <strong><span id="outNome">NOME</span></strong>, <span id="outNacionalidade">NACIONALIDADE</span>,
          <span id="outEstadoCivil">ESTADO CIVIL</span>, <span id="outProfissao">PROFISSÃO</span>,
          Identidade nº <span id="outRG">RG</span>, inscrito(a) no CPF/MF sob o nº
          <span id="outCPF">000.000.000-00</span>, residente à <span id="outEndereco">ENDEREÇO</span>,
          após ter celebrado <strong>CONTRATO DE PRESTAÇÃO DE SERVIÇO</strong>, 
          <strong>AUTORIZO EXPRESSAMENTE</strong>, com fulcro no <strong>Art. 5º e Parágrafo Único da Lei Federal nº 13.432/17</strong>,
          o profissional <strong><span id="outDetetive">DETETIVE</span></strong>, portador do CPF
          <strong><span id="outDetetiveCpf">000.000.000-00</span></strong>, residente e domiciliado na Rua
          <strong><span id="outDetetiveEndereco">ENDEREÇO DETETIVE</span></strong>, Estado:
          <strong><span id="outDetetiveEstado">UF</span></strong>, <strong>Detetive Particular</strong> de acordo com o
          Código Brasileiro de Ocupações n° 3518-05 e pela Lei Federal 13.432,
          a <strong>COLABORAR COM A INVESTIGAÇÃO POLICIAL EM CURSO</strong>.
        </p>

        <p>
          <strong>Nº do procedimento:</strong> <span id="outNProc">—</span>, por ser
          <strong><span id="outQualificacao">—</span></strong> no referido procedimento; através do
          <strong>ACEITE do Exmo. Dr. Delegado de Polícia</strong>.
        </p>

        <p style="margin:10px 0">
          <span id="outCidade">Cidade</span>, <span id="outData">data</span>
        </p>

        <div class="assinaturas-adb">
          <div class="assin-gov-caixa" style="margin-top:20px">
            Assinado eletronicamente<br>via GOV.BR
          </div>
          <div class="assin-linha">
            <strong>Nome do(a) Contratante:</strong><br>
            <span id="outAssinante">NOME DO CONTRATANTE</span><br>
            <small>(CONTRATANTE)</small>
          </div>
        </div>
      </div>

      <div class="btns">
        <button type="button" onclick="window.print()">🖨️ Imprimir / Salvar como PDF</button>
        <button type="button" class="secondary" onclick="location.reload()">↩️ Voltar</button>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  // Máscara de CPF
  function maskCPF(el){
    let v = el.value.replace(/\D/g,'').slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/,'$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/,'$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/,'$1.$2');
    el.value = v;
  }
  const cpf = document.getElementById('cpf');
  const detetiveCpf = document.getElementById('detetiveCpf');
  cpf.addEventListener('input', ()=>maskCPF(cpf));
  detetiveCpf.addEventListener('input', ()=>maskCPF(detetiveCpf));

  // Data padrão: hoje
  const dataInput = document.getElementById('data');
  if(!dataInput.value){
    const hoje = new Date();
    const iso = new Date(hoje.getTime() - (hoje.getTimezoneOffset()*60000)).toISOString().slice(0,10);
    dataInput.value = iso;
  }

  // Geração
  document.getElementById('gerar').addEventListener('click', (ev) => {
    ev.preventDefault();

    const nome = document.getElementById('nome').value.trim();
    const nacionalidade = document.getElementById('nacionalidade').value.trim();
    const estadocivil = document.getElementById('estadocivil').value.trim();
    const profissao = document.getElementById('profissao').value.trim();
    const rg = document.getElementById('rg').value.trim();
    const cpfv = document.getElementById('cpf').value.trim();
    const endereco = document.getElementById('endereco').value.trim();

    const detetive = document.getElementById('detetive').value.trim();
    const detetiveCpfV = document.getElementById('detetiveCpf').value.trim();
    const detetiveEnd = document.getElementById('detetiveEndereco').value.trim();
    const detetiveUF = document.getElementById('detetiveEstado').value.trim().toUpperCase();

    const nproc = document.getElementById('nProcedimento').value.trim();
    const qualif = document.getElementById('qualificacao').value.trim();

    const cidade = document.getElementById('cidade').value.trim();
    const data = document.getElementById('data').value;

    // Validações
    if(!nome||!nacionalidade||!estadocivil||!profissao||!rg||!cpfv||!endereco){
      alert('Preencha todos os dados do(a) contratante.'); return;
    }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpfv)){
      alert('CPF do(a) contratante deve estar no formato 000.000.000-00.'); return;
    }
    if(!detetive||!detetiveCpfV||!detetiveEnd||!detetiveUF){
      alert('Preencha todos os dados do profissional detetive.'); return;
    }
    if(!/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(detetiveCpfV)){
      alert('CPF do profissional deve estar no formato 000.000.000-00.'); return;
    }
    if(!nproc||!qualif){ alert('Informe o nº do procedimento e a qualificação.'); return; }
    if(!cidade||!data){ alert('Informe cidade e data.'); return; }

    // Saídas
    document.getElementById('outNome').textContent = nome;
    document.getElementById('outNacionalidade').textContent = nacionalidade;
    document.getElementById('outEstadoCivil').textContent = estadocivil;
    document.getElementById('outProfissao').textContent = profissao;
    document.getElementById('outRG').textContent = rg;
    document.getElementById('outCPF').textContent = cpfv;
    document.getElementById('outEndereco').textContent = endereco;

    document.getElementById('outDetetive').textContent = detetive;
    document.getElementById('outDetetiveCpf').textContent = detetiveCpfV;
    document.getElementById('outDetetiveEndereco').textContent = detetiveEnd;
    document.getElementById('outDetetiveEstado').textContent = detetiveUF;

    document.getElementById('outNProc').textContent = nproc;
    document.getElementById('outQualificacao').textContent = qualif;

    const d = new Date(data+'T00:00:00');
    const meses = ['janeiro','fevereiro','março','abril','maio','junho','julho','agosto','setembro','outubro','novembro','dezembro'];
    const fmt = `${String(d.getDate()).padStart(2,'0')} de ${meses[d.getMonth()]} de ${d.getFullYear()}`;
    document.getElementById('outCidade').textContent = cidade;
    document.getElementById('outData').textContent = fmt;

    document.getElementById('outAssinante').textContent = nome;

    // Mostra documento
    document.getElementById('formArea').style.display = 'none';
    document.getElementById('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });
});
</script>
</body>
</html>
