<?php
// Arquivo: documentacao.php (layout modernizado - mantém funcionalidade)
header('Content-Type: text/html; charset=UTF-8');

// Fallback para o brasão, caso $BRASAO não esteja definido
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>

  <!-- Meta Description -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">

  <!-- Palavras-chave -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">

  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">

  <!-- Open Graph -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">

  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>

  <!-- JSON-LD Organização (SEO) -->
  <script type="application/ld+json">
  {
    "@context":"https://schema.org",
    "@type":"Organization",
    "name":"Associação dos Detetives do Brasil (ADB)",
    "url":"https://www.detetivesprofissionais.com.br/",
    "logo":"https://www.detetivesprofissionais.com.br/logotipoadb.png",
    "foundingDate":"2011-02-09",
    "address":{
      "@type":"PostalAddress",
      "streetAddress":"Rua Isaac Bertoncine, 278, Centro",
      "addressLocality":"Lauro Müller",
      "addressRegion":"SC",
      "postalCode":"88880-000",
      "addressCountry":"BR"
    },
    "identifier":"CNPJ 13.329.080/0001-75",
    "sameAs":[
      "https://www.associacaodosdetetives.com.br/"
    ]
  }
  </script>
</head>

<style>
 :root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;
  --azul-escuro:#000f24;
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
}

*{box-sizing:border-box}

body{
  margin:0;
  font-family: Arial, Helvetica, sans-serif;
  color:var(--texto);
  background:#fff;
  line-height:1.6;
  font-size:16px;
  -webkit-font-smoothing:antialiased;
  -moz-osx-font-smoothing:grayscale;
}

/* ===== NAVBAR ===== */
.adb-nav{
  position:sticky; top:0; z-index:999;
  background: var(--azul);
  color:#fff;
  border-bottom: 3px solid var(--amarelo);
}
.adb-nav .adb-wrap{
  max-width:1300px; margin:0 auto; padding:10px 16px;
  display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative;
}
.adb-brand{
  display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0;
}
.adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
.adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap; }

.adb-toggle{
  display:none;
  background:transparent; border:0; color:#fff; cursor:pointer;
  width:40px; height:40px; border-radius:8px;
}
.adb-toggle:focus-visible{ outline:2px solid #fff; outline-offset:2px }

.adb-menu{
  list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px;
}
.adb-menu a{
  display:inline-block; text-decoration:none; color:#fff; font-weight:700;
  padding:10px 14px; border-radius:10px;
}
.adb-menu a:hover{ background:rgba(255,255,255,.12) }
.adb-menu a.active{ background: var(--amarelo); color: var(--texto); }

@media (max-width: 768px){
  .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
  .adb-menu{
    position:absolute; left:16px; right:16px; top:56px;
    background:var(--azul);
    flex-direction:column; align-items:stretch; gap:0;
    max-height:0; overflow:hidden;
    transition:max-height .25s ease;
    border-bottom:3px solid var(--amarelo);
    border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35);
  }
  .adb-menu.open{ max-height:420px }
  .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
  .adb-menu a{ padding:14px 18px }
}

/* ===== HERO ===== */
header.adb-hero{
  background: var(--azul);
  color:#fff;
  text-align:center;
  padding:28px 16px 46px;
  position:relative;
}
header.adb-hero .topo{ max-width:100%; margin:0 auto; }
header.adb-hero img.brasao{
  width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px;
  background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15);
}
header.adb-hero h1{
  margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35);
}
header.adb-hero .faixa{
  position:absolute; left:0; right:0; bottom:-18px; height:36px;
  background: var(--amarelo);
  border-top: 2px solid rgba(255,255,255,.5);
  border-bottom: 1px solid rgba(0,0,0,.08);
}

/* ===== MAIN / CARDS ===== */
main{ max-width:1300px; margin:48px auto 28px; padding:0 16px; }

.grid{
  display:grid;
  grid-template-columns: 1fr 1fr;
  gap:16px;
}
.card{
  background:#fff;
  border:1px solid #e5e7eb;
  border-radius:14px;
  padding:18px;
  box-shadow:0 6px 18px rgba(0,0,0,.04);
}
.card h2, .card h3{ margin-top:0 }
.card .muted{color:#4b5563; font-size:14px}

.btn{
  display:inline-block; padding:14px 22px; border-radius:10px; font-weight:700; font-size:18px;
  text-decoration:none; text-align:center; color:#fff; box-shadow:0 6px 16px rgba(0,0,0,.12);
  transition:.2s transform ease, .2s opacity ease; margin:6px 8px 0 0;
}
.btn:hover{ transform: translateY(-1px); opacity:.92 }
.btn:active{ transform: translateY(0) }
.btn-verde{ background:var(--verde) }
.btn-azul{ background:var(--azul) }
.btn-amarelo{ background:var(--amarelo); color:#1f2937 }

/* Mídia */
.card img{ border-radius:10px }
video{ border-radius:12px; outline:none; }

/* Responsividade */
@media (max-width: 768px){
  header.adb-hero{ padding:22px 12px 40px }
  header.adb-hero h1{ font-size:22px; }
  header.adb-hero img.brasao{ width:90px; padding:6px; border-radius:8px }
  .grid{ grid-template-columns: 1fr; }
  .btn{ display:block; width:100%; margin:10px 0 0; }
}

/* FAB WhatsApp */
.wa-fab{
  position:fixed; right:18px; bottom:18px; z-index:1000;
  width:64px; height:64px; border-radius:50%; background:#25D366;
  box-shadow: 0 10px 24px rgba(0,0,0,.25);
  display:flex; align-items:center; justify-content:center;
}
.wa-fab img{ width:34px; height:34px }

/* Impressão */
@media print{
  .adb-nav, header.adb-hero .faixa, .wa-fab{ display:none !important }
  header.adb-hero{ background:#fff; color:#000; padding:12px }
  header.adb-hero img.brasao{ background:transparent; box-shadow:none; padding:0; }
  .card{ box-shadow:none }
  body{ background:#fff }
}
</style>
</head>
<body>

<!-- NAVBAR -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="index.php" rel="noopener noreferrer">
      <img src="logotipoadb.png" alt="ADB" loading="lazy">
      <span>Cadastro Nacional</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
        <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
      <li><a href="atualizacao.php"class="active">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<!-- HERO -->
<header class="adb-hero" id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da Associação dos Detetives do Brasil" loading="lazy" onerror="this.style.display='none'">
    <h1>Finalidade Institucional</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<!-- CONTEÚDO -->
<main>
  <section class="grid" style="margin-top:18px">

    <!-- Marca / Call-to-action lateral -->
    <div class="card" aria-labelledby="logo-cta">
      <p style="text-align:center;">
        <a href="index.php" rel="noopener">
          <img src="logotipoadb.png" alt="Logotipo ADB" width="90%" loading="lazy">
        </a>
      </p>
     
      <p style="text-align:center">
        <a class="btn btn-verde" href="index.php">🔎 Verificar Profissional</a>
        <a class="btn btn-amarelo" href="restrito.php">🔐 Área do Associado</a>
      </p>
    </div>

    <!-- Bloco Objetivo/Valores/Registro -->
    <div class="card">
        <h3>🤝 Por que Existimos</h3>
      <ul>
        <li>Promover <strong>ética</strong> e <strong>colaboração</strong> na fiscalização da atividade.</li>
        <li>Reduzir a <strong>informalidade</strong> por meio de verificação pública e capacitação.</li>
        <li>Contribuir com <strong>políticas</strong> e <strong>normativas</strong> do setor.</li>
      </ul>

      <p class="muted">Observação: A insuficiência de mecanismos estatais eficazes permite a atuação de não habilitados. A ADB atua como <strong>instrumento de autorregulação</strong> para proteger a sociedade e valorizar a profissão.</p><br>
      <h3>🌐 Objetivos</h3>
      <ul>
        <li>Garantir conformidade com a <strong>Lei Federal nº 13.432/2017</strong>.</li>
        <li><strong>Combater a clandestinidade</strong> e a atuação irregular.</li>
        <li>Atuar como <strong>ponte com o poder público</strong> e incentivar a capacitação técnica.</li>
        <li>Reforçar a <strong>segurança jurídica</strong> e a credibilidade da categoria.</li>
      </ul><br>

      <h3>🧭 Valores</h3>
      <p>Ética, Legalidade, Transparência, Responsabilidade, Capacitação Contínua e Valorização Profissional.</p><br>

      <h3>📋 Registro</h3>
      <p>
        <strong>Fundada em 09/02/2011</strong>, conforme o Código Civil (Lei 10.406/2002).<br>
        <strong>CNPJ:</strong> 13.329.080/0001-75<br>
        <strong>Sede:</strong> Rua Isaac Bertoncine, 278 – Centro, Lauro Müller/SC – CEP 88880-000.
      </p>
    </div>

    <!-- Como Atuamos / Princípio / Missão -->
    <div class="card">
      <h3>🛠️ Como Atuamos</h3>
      <p>Mantemos o <strong>Cadastro Nacional de Detetives Particulares</strong>, com <strong>verificação pública de credenciais</strong> e suporte à <strong>segurança jurídica</strong> de contratantes. Cooperamos com órgãos públicos e promovemos <strong>ética</strong>, <strong>legalidade</strong> e <strong>atualização profissional contínua</strong>.</p><br>

      <h3>⚖️ Princípio</h3>
      <p>A associação é <strong>livre e facultativa</strong>, preservando a autonomia do profissional para ingressar ou sair a qualquer tempo.</p><br>

      <h3>🎯 Missão</h3>
      <p>Entregar <strong>confiança e qualidade</strong> a quem contrata, enquanto ampliamos <strong>desenvolvimento</strong> e <strong>reconhecimento</strong> dos associados.</p><br>

      <h3>📑 Finalidade Central</h3>
      <p>Consolidar, organizar e manter o <strong>Cadastro Nacional de Detetives Particulares</strong>, garantindo conformidade com a Lei 13.432/2017 e oferecendo ao cidadão e às autoridades um <strong>canal confiável de verificação</strong> de identidade, qualificação e regularidade.</p><br>
    </div>

    <!-- Vídeos / Materiais -->
    <div class="card">
      <h3>🎬 Materiais em Vídeo</h3>
      <video width="100%" controls preload="metadata" aria-label="Vídeo institucional ADB">
        <source src="video.mp4" type="video/mp4">
        Seu navegador não suporta o elemento de vídeo.
      </video>
    </div>

  </section>
</main>

<!-- BOTÃO WHATSAPP (flutuante) -->
<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<style>
.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-transform: scale(1.5);
    transform: scale(1.5);
}

.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-filter: drop-shadow(0px 0px 5px rgba(255,20,147));
    filter: drop-shadow(0px 0px 20px rgba(255,20,147));
}

</style>
</a>

<footer style="max-width:1100px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center;">
  Associação dos Detetives do Brasil
</footer>

<!-- JS do menu (robusto e idempotente) -->
<script>
(function(){
  const btn  = document.getElementById('adbToggle');
  const menu = document.getElementById('adbMenu');
  if (!btn || !menu || btn.dataset.bound) return;

  const closeMenu = () => {
    menu.classList.remove('open');
    btn.setAttribute('aria-expanded','false');
    document.body.style.overflow = '';
  };
  const openMenu = () => {
    menu.classList.add('open');
    btn.setAttribute('aria-expanded','true');
    document.body.style.overflow = 'hidden';
  };
  const toggle = (e) => {
    if (e) e.stopPropagation();
    menu.classList.contains('open') ? closeMenu() : openMenu();
  };

  ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggle, {passive:true}));

  document.addEventListener('click', (e)=>{
    if (!menu.classList.contains('open')) return;
    const inside = e.target.closest('.adb-nav') !== null;
    if (!inside) closeMenu();
  }, true);

  document.addEventListener('keydown', (e)=>{ if (e.key === 'Escape' && menu.classList.contains('open')) closeMenu(); });
  window.addEventListener('resize', ()=>{ if (window.innerWidth > 768) closeMenu(); });
  window.addEventListener('pageshow', ()=>{ closeMenu(); });

  btn.dataset.bound = '1';
})();
</script>

<!-- === ADB • BOTÃO FLUTUANTE DE TRADUÇÃO (BANDEIRAS + BUSCA) • VERSÃO ESTÁVEL === -->
<div id="adb-translate">
  <button id="adb-translate-toggle" type="button" aria-label="Traduzir página">
    🌐 <span>Tradução</span>
  </button>

  <div id="adb-translate-panel" role="dialog" aria-label="Selecione um idioma">
    <div class="adb-translate-header">
      <input id="adb-translate-search" type="text" placeholder="Buscar idioma..." aria-label="Buscar idioma" />
      <button id="adb-translate-close" type="button" aria-label="Fechar">✖</button>
    </div>
    <div id="adb-translate-grid" aria-live="polite"></div>
    <div class="adb-translate-foot">
      <small>ASSOCIAÇÃO DOS DETETIVES DO BRASIL • ADB</small>
    </div>
  </div>
</div>

<!-- Elemento oculto necessário ao Google Translate -->
<div id="google_translate_element" style="display:none;"></div>

<style>
  :root{ --adb-black:#000; --adb-gold:#c9a34b; --adb-gray:#111; }
  #adb-translate{
    position:fixed; bottom:20px; left:20px; z-index:2147483000;
    font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
  }
  #adb-translate-toggle{
    display:flex; align-items:center; gap:8px;
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:12px;
    padding:8px 12px; cursor:pointer; box-shadow:0 6px 14px rgba(0,0,0,.45);
    font-weight:600;
  }
  #adb-translate-toggle:hover{ filter:brightness(1.1); }

  #adb-translate-panel{
    display:none; margin-top:10px; width:min(92vw, 720px); max-height:min(70vh, 560px);
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:14px;
    box-shadow:0 14px 40px rgba(0,0,0,.6); overflow:hidden;
  }
  #adb-translate.open #adb-translate-panel{ display:block; }

  .adb-translate-header{
    display:flex; align-items:center; gap:8px;
    padding:10px; background:var(--adb-gray); border-bottom:1px solid #2a2a2a;
  }
  #adb-translate-search{
    flex:1; padding:10px 12px; border-radius:10px; border:1px solid #333;
    background:#000; color:#eee; outline:none;
  }
  #adb-translate-search::placeholder{ color:#999; }
  #adb-translate-close{
    background:#000; color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:10px; padding:8px 10px; cursor:pointer;
  }
  #adb-translate-close:hover{ background:#111; }

  #adb-translate-grid{
    padding:10px; display:grid; grid-template-columns: repeat(6, 1fr);
    gap:8px; overflow:auto; max-height: calc(min(70vh, 560px) - 98px);
  }
  @media (max-width:640px){ #adb-translate-grid{ grid-template-columns: repeat(3, 1fr); } }
  .adb-lang{
    display:flex; align-items:center; gap:8px;
    background:#0a0a0a; color:#ddd; border:1px solid #222; border-radius:10px;
    padding:8px; cursor:pointer; min-height:44px;
  }
  .adb-lang:hover{ border-color:var(--adb-gold); transform:translateY(-1px); }
  .adb-flag{ width:1.6em; display:inline-flex; align-items:center; justify-content:center; }
  .adb-name{ font-size:13px; line-height:1.2; }
  .adb-code{ font-size:11px; opacity:.7; }

  .adb-translate-foot{ padding:8px 10px; border-top:1px solid #2a2a2a; text-align:center; background:#0b0b0b; }
  .adb-translate-foot small{ color:#9a865b; }

  /* Anti-banner do Google Translate */
  #goog-gt-tt, .goog-te-balloon-frame, .goog-te-menu-frame, .goog-te-banner-frame { display:none !important; visibility:hidden !important; opacity:0 !important; height:0 !important; }
  iframe.goog-te-banner-frame { display:none !important; }
  html, body { top:0 !important; margin-top:0 !important; transform:none !important; }
  html.translated-ltr body, html.translated-rtl body { top:0 !important; position:static !important; }
  body > .skiptranslate { display:none !important; }
</style>

<script>
(function(){
  'use strict';

  const BASE_CODES = 'pt,af,sq,am,ar,hy,as,ay,az,bm,eu,be,bn,bho,bs,bg,ca,ceb,zh-CN,zh-TW,co,hr,cs,da,dv,doi,nl,en,eo,et,ee,fil,fi,fr,fy,gl,ka,de,el,gn,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,ilo,id,ga,it,ja,jv,kn,kk,km,rw,gom,ko,kri,ku,ky,lo,la,lv,ln,lt,lg,lb,mk,mai,mg,ms,ml,mt,mi,mr,lus,mn,my,ne,no,nso,ny,or,om,ps,fa,pl,pt-PT,pa,qu,ro,ru,sm,sa,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,tg,ta,tt,te,th,ti,ts,tr,tk,tw,uk,ur,ug,uz,vi,xh,yi,yo,zu'.split(',');
  const MAP = {
    'pt':['Português (Original)','🇧🇷'], 'en':['Inglês','🇺🇸'], 'es':['Espanhol','🇪🇸'], 'fr':['Francês','🇫🇷'], 'de':['Alemão','🇩🇪'],
    'it':['Italiano','🇮🇹'], 'ru':['Russo','🇷🇺'], 'ja':['Japonês','🇯🇵'], 'ko':['Coreano','🇰🇷'],
    'zh-CN':['Chinês (Simplificado)','🇨🇳'], 'zh-TW':['Chinês (Tradicional)','🇹🇼'], 'ar':['Árabe','🇸🇦'],
    'hi':['Hindi','🇮🇳'], 'bn':['Bengali','🇧🇩'], 'id':['Indonésio','🇮🇩'], 'tr':['Turco','🇹🇷'],
    'uk':['Ucraniano','🇺🇦'], 'pl':['Polonês','🇵🇱'], 'pt-PT':['Português (Portugal)','🇵🇹'],
    'fa':['Persa (Farsi)','🇮🇷'], 'he':['Hebraico','🇮🇱'], 'el':['Grego','🇬🇷'], 'sv':['Sueco','🇸🇪'],
    'no':['Norueguês','🇳🇴'], 'da':['Dinamarquês','🇩🇰'], 'fi':['Finlandês','🇫🇮'], 'cs':['Tcheco','🇨🇿'],
    'sk':['Eslovaco','🇸🇰'], 'sl':['Esloveno','🇸🇮'], 'ro':['Romeno','🇷🇴'], 'hu':['Húngaro','🇭🇺'],
    'bg':['Búlgaro','🇧🇬'], 'sr':['Sérvio','🇷🇸'], 'hr':['Croata','🇭🇷'], 'nl':['Holandês','🇳🇱'],
    'et':['Estoniano','🇪🇪'], 'lv':['Letão','🇱🇻'], 'lt':['Lituano','🇱🇹'], 'ga':['Irlandês','🇮🇪'],
    'gd':['Gaélico Escocês','🏴'], 'gl':['Galego','🇪🇸'], 'ca':['Catalão','🇪🇸'], 'eu':['Basco','🇪🇸'],
    'mi':['Maori','🇳🇿'], 'ms':['Malaio','🇲🇾'], 'sw':['Suaíli','🇰🇪'], 'vi':['Vietnamita','🇻🇳'],
    'th':['Tailandês','🇹🇭'], 'ur':['Urdu','🇵🇰'], 'ta':['Tâmil','🇮🇳'], 'te':['Telugo','🇮🇳'],
    'ml':['Malaiala','🇮🇳'], 'mr':['Marati','🇮🇳'], 'kn':['Kannada','🇮🇳'], 'gu':['Gujarati','🇮🇳'],
    'ne':['Nepalês','🇳🇵'], 'si':['Cingalês (Sinhala)','🇱🇰'], 'my':['Birmanês','🇲🇲'], 'km':['Khmer','🇰🇭'],
    'lo':['Lao','🇱🇦'], 'mn':['Mongol','🇲🇳'], 'kk':['Cazaque','🇰🇿'], 'uz':['Uzbeque','🇺🇿'],
    'az':['Azeri','🇦🇿'], 'ka':['Georgiano','🇬🇪'], 'hy':['Armênio','🇦🇲'], 'ps':['Pastó (Pashto)','🇦🇫'],
    'tk':['Turcomano','🇹🇲'], 'tg':['Tajique','🇹🇯'], 'ky':['Quirguiz','🇰🇬'], 'ku':['Curdo','🇮🇶'],
    'pa':['Panjabi (Punjabi)','🇮🇳'], 'af':['Africâner','🇿🇦'], 'sq':['Albanês','🇦🇱'], 'bs':['Bósnio','🇧🇦'],
    'mk':['Macedônio','🇲🇰'], 'is':['Islandês','🇮🇸'], 'xh':['Xhosa','🇿🇦'], 'zu':['Zulu','🇿🇦'],
    'st':['Sesoto (Sotho do Sul)','🇿🇦'], 'nso':['Sepedi (Sotho do Norte)','🇿🇦'], 'yo':['Iorubá','🇳🇬'],
    'ig':['Igbo','🇳🇬'], 'ha':['Hauçá','🇳🇬'], 'rw':['Quiniaruanda','🇷🇼'], 'so':['Somali','🇸🇴'],
    'am':['Amárico','🇪🇹'], 'ti':['Tigrínia','🇪🇷'], 'om':['Oromo','🇪🇹'], 'ee':['Ewe','🇬🇭'],
    'tw':['Twi (Akan)','🇬🇭'], 'kri':['Krio','🇸🇱'], 'sm':['Samoano','🇼🇸'], 'ht':['Haitiano Crioulo','🇭🇹'],
    'fil':['Filipino','🇵🇭'], 'tl':['Tagalo','🇵🇭'], 'jv':['Javanês','🇮🇩'], 'su':['Sundanês','🇮🇩'],
    'bho':['Bojpuri','🇮🇳'], 'mai':['Maithili','🇮🇳'], 'or':['Odia (Oriá)','🇮🇳'], 'as':['Assamês','🇮🇳'],
    'gom':['Concani (Konkani)','🇮🇳'], 'la':['Latim','🌐'], 'sa':['Sânscrito','🌐'], 'tt':['Tártaro','🌐'],
    'yi':['Iídiche','🌐'], 'hmn':['Hmong','🌐'], 'co':['Córsico','🇫🇷'], 'haw':['Havaiano','🇺🇸']
  };

  const ADB_LANGUAGES = BASE_CODES.map(code => {
    const [name, flag] = MAP[code] || [code,'🌐'];
    return { code, name, flag };
  });

  const ADB_CODE_ALIASES = { 'pt-BR':'pt', 'zh':'zh-CN' };

  window.googleTranslateElementInit = function(){
    try{
      new google.translate.TranslateElement({
        pageLanguage:'pt',
        includedLanguages: ADB_LANGUAGES.map(l => l.code).join(','),
        autoDisplay:false
      }, 'google_translate_element');
    }catch(e){}
  };

  function normalizeCode(code){ return ADB_CODE_ALIASES[code] || code; }
  function setTranslateCookie(langTo){
    try{
      const pair = '/pt/' + normalizeCode(langTo);
      const domain = location.hostname.replace(/^www\./,'');
      const base = 'googtrans=' + pair + '; path=/;';
      document.cookie = base;
      document.cookie = base + ' domain=.' + domain + ';';
    }catch(e){}
  }
  function applyTranslation(lang){
    try{
      if(!lang) return;
      setTranslateCookie(lang);
      const sel = document.querySelector('select.goog-te-combo');
      if (sel){
        sel.value = normalizeCode(lang);
        sel.dispatchEvent(new Event('change', {bubbles:true}));
        antiBanner.trigger();
      } else {
        location.reload();
      }
    }catch(e){}
  }

  (function(){
    const root=document.getElementById('adb-translate');
    const toggle=document.getElementById('adb-translate-toggle');
    const panel=document.getElementById('adb-translate-panel');
    const closeBtn=document.getElementById('adb-translate-close');
    const grid=document.getElementById('adb-translate-grid');
    const search=document.getElementById('adb-translate-search');

    function itemHTML(lang){
      return '<button class="adb-lang" type="button" data-code="'+lang.code+'" title="'+lang.name+'">'
           +   '<span class="adb-flag">'+lang.flag+'</span>'
           +   '<div class="adb-meta">'
           +     '<div class="adb-name">'+lang.name+'</div>'
           +     '<div class="adb-code">'+lang.code+'</div>'
           +   '</div>'
           + '</button>';
    }
    function renderList(filter){
      try{
        const f=(filter||'').trim().toLowerCase();
        const list = ADB_LANGUAGES.filter(l => !f || l.name.toLowerCase().includes(f) || l.code.toLowerCase().includes(f));
        grid.innerHTML = list.map(itemHTML).join('');
        applySVGFlagsSafe();
      }catch(e){}
    }
    renderList('');

    toggle.addEventListener('click', ()=>{ root.classList.toggle('open'); if(root.classList.contains('open')) search.focus(); });
    closeBtn.addEventListener('click', ()=> root.classList.remove('open'));
    document.addEventListener('click', (e)=>{
      const btn = e.target.closest('.adb-lang');
      if(btn){ applyTranslation(btn.getAttribute('data-code')); }
    });
    search.addEventListener('input', ()=>renderList(search.value));
  })();

  const antiBanner = (function(){
    function kill(){
      try{
        document.querySelectorAll('iframe.goog-te-banner-frame, .goog-te-menu-frame, #goog-gt-tt, .goog-te-balloon-frame').forEach(el => el.remove());
        document.documentElement.style.top='0px';
        document.body.style.top='0px';
        document.body.style.position='static';
        document.body.style.marginTop='0px';
        document.body.style.transform='none';
      }catch(e){}
    }
    function burst(){
      kill(); setTimeout(kill,200); setTimeout(kill,600); setTimeout(kill,1200); setTimeout(kill,2500); setTimeout(kill,4000);
    }
    try{
      const obs=new MutationObserver(burst);
      obs.observe(document.documentElement,{childList:true,subtree:true});
    }catch(e){}
    window.addEventListener('load', burst);
    window.addEventListener('resize', burst);
    window.addEventListener('orientationchange', burst);
    document.addEventListener('DOMContentLoaded', burst);
    return { trigger: burst };
  })();

  let flagCSSLoaded = false;
  try{
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css';
    link.onload = function(){ flagCSSLoaded = true; applySVGFlagsSafe(); };
    document.head.appendChild(link);
  }catch(e){}

  const FLAG_MAP = {
    'pt':'br','pt-PT':'pt','en':'us','es':'es','fr':'fr','de':'de','it':'it','ru':'ru',
    'ja':'jp','ko':'kr','zh-CN':'cn','zh-TW':'tw','ar':'sa','he':'il','fa':'ir',
    'hi':'in','bn':'bd','id':'id','tr':'tr','uk':'ua','pl':'pl','nl':'nl','sv':'se',
    'no':'no','da':'dk','fi':'fi','cs':'cz','sk':'sk','sl':'si','ro':'ro','hu':'hu',
    'bg':'bg','sr':'rs','hr':'hr','et':'ee','lv':'lv','lt':'lt','ga':'ie','gd':'gb',
    'gl':'es','ca':'es','eu':'es','mi':'nz','ms':'my','sw':'ke','vi':'vn','th':'th',
    'ur':'pk','ta':'in','te':'in','ml':'in','mr':'in','kn':'in','gu':'in','ne':'np',
    'si':'lk','my':'mm','km':'kh','lo':'la','mn':'mn','kk':'kz','uz':'uz','az':'az',
    'ka':'ge','hy':'am','ps':'af','tk':'tm','tg':'tj','ky':'kg','ku':'iq','pa':'in',
    'af':'za','sq':'al','bs':'ba','mk':'mk','is':'is','xh':'za','zu':'za','st':'za',
    'nso':'za','yo':'ng','ig':'ng','ha':'ng','rw':'rw','so':'so','am':'et','ti':'er',
    'om':'et','ee':'gh','tw':'gh','kri':'sl','sm':'ws','ht':'ht','fil':'ph','tl':'ph',
    'jv':'id','su':'id','bho':'in','mai':'in','or':'in','as':'in','gom':'in','co':'fr','haw':'us'
  };

  function applySVGFlagsSafe(){
    try{
      if(!flagCSSLoaded) return;
      const grid = document.getElementById('adb-translate-grid');
      if(!grid) return;
      grid.querySelectorAll('.adb-lang').forEach(btn=>{
        const code = btn.getAttribute('data-code');
        const cc = FLAG_MAP[code];
        const holder = btn.querySelector('.adb-flag');
        if(holder && cc){
          holder.innerHTML = '<span class="fi fi-'+cc+'"></span>';
        }
      });
    }catch(e){}
  }

})();
</script>

<!-- Script oficial do Google Translate -->
<script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<!-- === / ADB • BOTÃO FLUTUANTE DE TRADUÇÃO • VERSÃO ESTÁVEL === -->

</body>
</html>
