<?php
// ==============================//
//  ADB — Portal do Associado   //
//  Página organizada / revisão //
// ==============================//

require_once('Connections/banco.php');
require_once('includes/common/KT_common.php');
require_once('includes/tng/tNG.inc.php');

// --- Dispatcher & conexão (Kollection/InterAKT) ---
$tNGs = new tNG_dispatcher("");
$conn_banco = new KT_connection($banco, $database_banco);

// --- Restrição de acesso ---
$restrict = new tNG_RestrictAccess($conn_banco, "");
$restrict->addLevel("1");
$restrict->addLevel("0");
$restrict->Execute();

// --- Função utilitária (mantida p/ compatibilidade mysql_*) ---
if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    if (PHP_VERSION < 6) {
      $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
    }
    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);
    switch ($theType) {
      case "text":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "long":
      case "int":    $theValue = ($theValue != "") ? intval($theValue)    : "NULL"; break;
      case "double": $theValue = ($theValue != ""
      ) ? doubleval($theValue) : "NULL"; break;
      case "date":   $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL"; break;
      case "defined":$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
    }
    return $theValue;
  }
}

// --- Consulta do associado logado ---
$colname_Consulta = "-1";
if (isset($_SESSION['kt_login_user'])) {
  $colname_Consulta = $_SESSION['kt_login_user'];
}
mysql_select_db($database_banco, $banco);
$query_Consulta = sprintf("SELECT * FROM cadastro_detetive WHERE credencial = %s", GetSQLValueString($colname_Consulta, "text"));
$Consulta = mysql_query($query_Consulta, $banco) or die(mysql_error());
$row_Consulta = mysql_fetch_assoc($Consulta);
$totalRows_Consulta = mysql_num_rows($Consulta);

// ---------------- Logout -----------------
$logoutTransaction = new tNG_logoutTransaction($conn_banco);
$tNGs->addTransaction($logoutTransaction);
$logoutTransaction->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "GET", "KT_logout_now");
$logoutTransaction->registerTrigger("END", "Trigger_Default_Redirect", 99, "index.php");

// -------- Atualização de cadastro (senha/email etc.) --------
function Trigger_CheckPasswords(&$tNG) {
  $myThrowError = new tNG_ThrowError($tNG);
  $myThrowError->setErrorMsg("Digite a senha antiga e depois escolha uma nova senha.");
  $myThrowError->setField("senha");
  $myThrowError->setFieldErrorMsg("Senhas não conferem.");
  return $myThrowError->Execute();
}
function Trigger_CheckOldPassword(&$tNG) { return Trigger_UpdatePassword_CheckOldPassword($tNG); }

$formValidation = new tNG_FormValidation();
$formValidation->addField("email", true, "text", "email", "", "", "Campo obrigatório!");
$formValidation->addField("senha", true, "text", "", "", "", "");
$tNGs->prepareValidation($formValidation);

$upd_cadastro_detetive = new tNG_update($conn_banco);
$tNGs->addTransaction($upd_cadastro_detetive);
$upd_cadastro_detetive->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "POST", "KT_Update1");
$upd_cadastro_detetive->registerTrigger("BEFORE", "Trigger_Default_FormValidation", 10, $formValidation);
$upd_cadastro_detetive->registerConditionalTrigger("{POST.senha} != {POST.re_senha}", "BEFORE", "Trigger_CheckPasswords", 50);
$upd_cadastro_detetive->registerTrigger("BEFORE", "Trigger_CheckOldPassword", 60);
$upd_cadastro_detetive->registerTrigger("END", "Trigger_Default_Redirect", 99, "modifica_cadastro.php");
$upd_cadastro_detetive->setTable("cadastro_detetive");
$upd_cadastro_detetive->addColumn("nome_detetive",   "STRING_TYPE", "POST", "nome_detetive");
$upd_cadastro_detetive->addColumn("email",           "STRING_TYPE", "POST", "email");
$upd_cadastro_detetive->addColumn("logotipo",        "STRING_TYPE", "POST", "logotipo");
$upd_cadastro_detetive->addColumn("observacao",      "DATE_TYPE",   "POST", "observacao");
$upd_cadastro_detetive->addColumn("logotipo_estado", "STRING_TYPE", "POST", "logotipo_estado");
$upd_cadastro_detetive->addColumn("funcional",       "DATE_TYPE",   "POST", "funcional");
$upd_cadastro_detetive->addColumn("data_cadastro",   "DATE_TYPE",   "POST", "data_cadastro");
$upd_cadastro_detetive->addColumn("senha",           "STRING_TYPE", "POST", "senha");
$upd_cadastro_detetive->setPrimaryKey("cd_cadastro_detetive", "NUMERIC_TYPE", "SESSION", "kt_login_id");

// Executa transações e recordsets
$tNGs->executeTransactions();
$rscadastro_detetive = $tNGs->getRecordset("cadastro_detetive");
$row_rscadastro_detetive = mysql_fetch_assoc($rscadastro_detetive);
$totalRows_rscadastro_detetive = mysql_num_rows($rscadastro_detetive);

// (Opcional) lista de slides
$slides = glob('slides/*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
$slides = array_slice((array)$slides, 0, 50);
sort($slides);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL - SISTEMA DE REFERÊNCIA PROFISSIONAL</title>
  <meta name="description" content="Os detetives profissionais atuam na área privada com coleta de dados e informações, utilizando meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse do contratante." />
  <meta name="keywords" content="Detetive Particular, investigação, cadastro nacional, ADB, investigação particular, Santa Catarina, Florianópolis, Tubarão" />
  <link href="logotipoadb.png" rel="icon" type="image/png"/>
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
  <style>
    :root{ --adb-blue:#003366; --adb-dark:#002776; --adb-gold:#d4af37; --bg:#0f172a; --card:#0b1224; --muted:#cbd5e1; --text:#e5e7eb; --text-dim:#a1a1aa; --ring:rgba(212,175,55,.35); --shadow:0 10px 30px rgba(0,0,0,.35); --radius:18px; }
    *{box-sizing:border-box} html,body{height:100%}
    body{ margin:0; font-family: Inter, Arial, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", sans-serif; background: radial-gradient(1200px 800px at 10% -10%, rgba(212,175,55,.08), transparent 40%), radial-gradient(1000px 700px at 110% 10%, rgba(0,39,118,.10), transparent 45%), var(--bg); color:var(--text); line-height:1.55; }
    .adb-header{position:sticky; top:0; z-index:1000; background:linear-gradient(180deg, rgba(0,0,0,.65), rgba(0,0,0,.35)); backdrop-filter:blur(8px); border-bottom:1px solid rgba(255,255,255,.06);}
    .adb-nav{max-width:1200px; margin:0 auto; padding:14px 20px; display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative;}
    .adb-brand{display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; font-weight:700}
    .adb-brand img{width:28px; height:28px; border-radius:50%}
    .adb-brand span{font-size:18px; letter-spacing:.3px}
    .adb-nav-list{list-style:none; display:flex; gap:6px; margin:0; padding:0; align-items:center}
    .adb-nav-list a{display:inline-flex; align-items:center; gap:8px; text-decoration:none; color:var(--text); padding:10px 12px; border-radius:12px; border:1px solid rgba(255,255,255,.06); background:linear-gradient(180deg, rgba(255,255,255,.02), rgba(255,255,255,0));}
    .adb-nav-list a:hover{border-color:rgba(212,175,55,.45); box-shadow:0 0 0 3px var(--ring); color:#fff}
    .adb-btn-logout{font-weight:600; color:#fff !important; background:linear-gradient(180deg,#c08f1a,#a87a12); border:1px solid rgba(212,175,55,.45); border-radius:12px; padding:10px 14px;}
    .adb-hamburger{display:none; position:relative; width:40px; height:36px; border:1px solid rgba(255,255,255,.15); border-radius:12px; background:linear-gradient(180deg, rgba(255,255,255,.05), rgba(255,255,255,.02)); cursor:pointer; align-items:center; justify-content:center; gap:5px;}
    .adb-hamburger span{display:block; width:22px; height:2px; background:#e5e7eb; transition:transform .25s, opacity .25s}
    .adb-hamburger.adb-active span:nth-child(1){ transform: translateY(6px) rotate(45deg) }
    .adb-hamburger.adb-active span:nth-child(2){ opacity:0 }
    .adb-hamburger.adb-active span:nth-child(3){ transform: translateY(-6px) rotate(-45deg) }
    @media (max-width:768px){ .adb-hamburger{display:inline-flex} .adb-nav-list{ position:absolute; top:60px; right:16px; left:16px; display:none; flex-direction:column; gap:8px; padding:12px; margin:0; background:linear-gradient(180deg, rgba(11,18,36,.98), rgba(11,18,36,.96)); border:1px solid rgba(255,255,255,.08); border-radius:16px; box-shadow:0 20px 40px rgba(0,0,0,.45);} .adb-nav-list.adb-open{display:flex} .adb-nav-list a{width:100%}}

    .container{ max-width:1200px; margin:24px auto; padding:0 16px; display:grid; gap:20px; grid-template-columns: repeat(12, 1fr); }
    .col{ grid-column: span 4; } .col-6{ grid-column: span 6; } .col-12{ grid-column: span 12; }
    @media (max-width:1024px){ .col{ grid-column: span 6; } .col-6{ grid-column: span 12; } }
    @media (max-width:640px){ .container{ grid-template-columns: repeat(12, 1fr); } .col, .col-6, .col-12{ grid-column: span 12; } }

    .card{ background: linear-gradient(180deg, rgba(255,255,255,.02), rgba(255,255,255,.00)), var(--card); border:1px solid rgba(255,255,255,.06); border-radius: var(--radius); box-shadow: var(--shadow); padding:20px; }
    .card h3{ margin:0 0 12px 0; font-size:18px; color:#fff }
    .muted{ color:var(--text-dim) }
    .badge{ display:inline-flex; align-items:center; gap:8px; padding:6px 10px; border-radius:999px; border:1px solid rgba(255,255,255,.08); background:linear-gradient(180deg, rgba(255,255,255,.05), rgba(255,255,255,.00)); font-size:12px; color:var(--muted); }
    .btn{ appearance:none; border:1px solid rgba(255,255,255,.12); background:linear-gradient(180deg, rgba(0,39,118,.8), rgba(0,39,118,.55)); color:#fff; padding:12px 16px; border-radius:12px; cursor:pointer; text-decoration:none; display:inline-flex; align-items:center; gap:10px; font-weight:600; box-shadow: var(--shadow); }
    .btn:hover{ box-shadow:0 0 0 3px var(--ring); filter:brightness(1.06) }

    .callout{ background:linear-gradient(180deg, rgba(255,243,205,.08), rgba(255,243,205,.03)); border:1px solid rgba(255,238,186,.35); color:#f9e7a8; padding:16px; border-radius:16px; }
    .callout h4{ margin:0 0 8px 0; color:#fff }
    .rodape{ margin-top:40px; padding:28px 16px; text-align:left; color:var(--muted); border-top:1px solid rgba(255,255,255,.06); background: linear-gradient(180deg, rgba(0,0,0,.35), rgba(0,0,0,.55)); }
    .avatar{ width:120px; height:120px; border-radius:16px; object-fit:cover; border:1px solid rgba(255,255,255,.1) }
    .wa-fab{ position:fixed; right:18px; bottom:18px; z-index:100; border:none; background:transparent; padding:0; }
    .wa-fab img{ width:66px; height:66px; transition:transform .25s ease, filter .35s ease; filter: drop-shadow(0 10px 20px rgba(0,0,0,.45)); }
    .wa-fab img:hover{ transform: scale(1.08); filter: drop-shadow(0 0 20px rgba(212,175,55,.45)); }

    /* Cards de informação */
    .info-grid{ display:grid; grid-template-columns: repeat(auto-fit, minmax(220px,1fr)); gap:16px; margin-top:20px; }
    .info-card{ background:#111; border:1px solid var(--adb-gold); border-radius:12px; padding:16px; text-align:left; transition: all .2s ease; color:#f1f1f1; }
    .info-card:hover{ background:#1a1a1a; box-shadow:0 0 12px rgba(212,175,55,.5); transform: translateY(-3px); }
    .info-card h4{ margin:0 0 8px; font-size:1.1rem; color: var(--adb-gold); }
  </style>
</head>
<body>
<header class="adb-header" role="banner">
  <nav class="adb-nav" aria-label="Navegação principal">
    <a class="adb-brand" href="informacao.php">
      <img src="logotipoadb.png" alt="ADB">
      <span>Portal do associado</span>
    </a>

    <button id="adb-hamburger" class="adb-hamburger" aria-label="Abrir menu" aria-expanded="false" aria-controls="adb-menu">
      <span></span><span></span><span></span>
    </button>

    <ul id="adb-menu" class="adb-nav-list">
      <li><a href="informacao.php">Inicial</a></li>
      <li><a href="documentos_importantes.php">Documentos</a></li>
      <li><a href="materialdeestudo.php">Material</a></li>
      <li><a href="ferramentas.php">Ferramentas</a></li>
      <li><a href="manual_de_instalacao.php">Espião</a></li>
       <li><a href="aviso_grupo_oficial.php">Reunião oficial</a></li>
      <li><a href="modifica_cadastro.php">Alterar</a></li>
      <li>
        <?php echo $tNGs->getErrorMsg(); ?>
        <a class="adb-btn-logout" href="<?php echo $logoutTransaction->getLogoutLink(); ?>" rel="noopener">Sair</a>
      </li>
    </ul>
  </nav>
</header>

<main class="container" role="main">
  <!-- Coluna Perfil -->
  <section class="card col" aria-labelledby="perfil">
    <h3 id="perfil">Perfil do Associado</h3>
    <div style="display:flex; gap:16px; align-items:center; margin-bottom:12px;">
      <?php if ($row_rscadastro_detetive['logotipo']=="") { ?>
        <img class="avatar" src="logotipo/perfil.jpg" alt="Foto do perfil">
      <?php } else { ?>
        <img class="avatar" src="logotipo/<?php echo $row_rscadastro_detetive['logotipo']; ?>" alt="Logo do associado">
      <?php } ?>
      <div>
        <div class="badge">Detetive</div>
        <div style="margin-top:8px">
          <div><span style="color:#fff;font-weight:600">Nome:&nbsp;</span><span class="muted"><?php echo $row_rscadastro_detetive['nome_detetive']; ?></span></div>
          <div><span style="color:#fff;font-weight:600">Cadastro:&nbsp;</span><span class="muted"><?php echo $row_rscadastro_detetive['data_cadastro']; ?></span></div>
          <div><span style="color:#fff;font-weight:600">Renovação:&nbsp;</span><span style="color:#fca5a5"><?php echo $row_rscadastro_detetive['observacao']; ?></span></div>
        </div>
      </div>
    </div>

    <div class="callout" style="margin-top:12px;">
      <h4>⚠️ O que é uma Consulta Pública?</h4>
      <p class="muted">
        As consultas públicas desta página facilitam o acesso a informações e documentos oficiais (certidões, registros e dados de interesse geral). É uma ferramenta de transparência e cidadania, permitindo verificações seguras, éticas e legais.
      </p>
      <p class="muted">
        A <strong>Associação dos Detetives do Brasil</strong> reúne links de acesso às principais plataformas governamentais, promovendo responsabilidade e qualidade no exercício profissional.
      </p>
    </div>

    <p style="margin-top:16px;">
      <a class="btn" href="consultas_publicas.php">⬇️ Consultas Públicas</a><br><br>
      <strong>Base Legal — Art. 2º da Lei nº 13.432/2017:</strong>
      considera-se detetive particular o profissional que planeja e executa a coleta de dados e informações de natureza não criminal, utilizando conhecimento técnico e meios tecnológicos permitidos, com a finalidade de esclarecer assuntos de interesse privado do contratante.
    </p>
  </section>

  <!-- Coluna Sistema de Informações -->
  <section class="card col" aria-labelledby="sistema">
    <h3 id="sistema">Sistema de Informações</h3>
    <div class="info-grid">
      <div class="info-card">
        <h4>🔎 Chaves de busca</h4>
        <p>Nome completo<br>CPF<br>CNPJ<br>Placa de veículo<br>Número de telefone</p>
      </div>
      <div class="info-card">
        <h4>💳 Valor do acesso</h4>
        <p>
          <strong>Oferta Especial – Ativação de Conta</strong><br><br>
          💰 Valor do Sistema: <strong>R$ 130,00</strong> mensais<br>
          📅 <em>Atenção:</em> Esta oferta estará disponível por tempo limitado!<br><br>
          💳 Forma de pagamento: <strong>PIX</strong><br>
          Chave PIX (CNPJ): <strong>13.329.080/0001-75</strong><br><br>
          Para ativar sua conta, envie:<br>
          1️⃣ Seu e-mail de cadastro<br>
          2️⃣ O comprovante de pagamento<br><br>
          📨 Após o envio, sua conta será liberada para acesso ao sistema.
        </p>
      </div>
      <div class="info-card">
        <h4>🔐 Acesso restrito</h4>
        <p>Exclusivo para detetives <b>cadastrados e com cadastro atualizado</b> na ADB.</p>
        <p style="margin-top:16px;">
          <a class="btn" href="https://sigmabuscas.com/auth/login" target="_blank" rel="noopener">Login Sigma Buscas</a>
        </p>
      </div>
    </div>
  </section>

  <!-- Coluna Vídeo / Ferramenta -->
  <section class="card col" aria-labelledby="ferramenta">
    <h3 id="ferramenta">Apresentação</h3>
    <video width="100%" controls preload="metadata" aria-label="Vídeo institucional ADB">
      <source src="consulta.mp4" type="video/mp4">
      Seu navegador não suporta o elemento de vídeo.
    </video><br>
    <a href="termo_responsabilidade.php" class="btn-amarelo">📝 Gerar Termo de Responsabilidade</a>

<style>
.btn-amarelo {
  display: inline-block;
  background-color: #d4af37;
  color: #000;
  font-weight: bold;
  text-decoration: none;
  padding: 12px 22px;
  border-radius: 8px;
  font-family: "Segoe UI", Arial, sans-serif;
  font-size: 1rem;
  box-shadow: 0 0 8px rgba(212,175,55,0.5);
  transition: all 0.3s ease;
}
.btn-amarelo:hover {
  background-color: #f0c94d;
  box-shadow: 0 0 12px rgba(212,175,55,0.7);
  transform: translateY(-2px);
}
</style>

  </section>
</main>

<!-- Botão flutuante WhatsApp -->
<a class="wa-fab" href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" rel="noopener" aria-label="Fale no WhatsApp">
  <img src="WhatsAppPNG.png" alt="WhatsApp">
</a>

<footer class="rodape" role="contentinfo">
  <p>&copy; <?php echo date('Y'); ?> — Associação dos Detetives do Brasil — Todos os direitos reservados.</p>
</footer>

<script>
(function(){
  const btn  = document.getElementById('adb-hamburger');
  const menu = document.getElementById('adb-menu');
  if(!btn || !menu) return;

  const openMenu = () => { menu.classList.add('adb-open'); btn.classList.add('adb-active'); btn.setAttribute('aria-expanded','true'); document.body.style.overflow = 'hidden'; };
  const closeMenu = () => { menu.classList.remove('adb-open'); btn.classList.remove('adb-active'); btn.setAttribute('aria-expanded','false'); document.body.style.overflow = ''; };
  const toggleMenu = (ev) => { ev && ev.stopPropagation(); menu.classList.contains('adb-open') ? closeMenu() : openMenu(); };

  if (!btn.dataset.bound) {
    ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggleMenu, {passive:true}));
    document.addEventListener('click', (e) => { if (!menu.classList.contains('adb-open')) return; const inside = e.target.closest('.adb-nav'); if (!inside) closeMenu(); }, true);
    document.addEventListener('keydown', (e) => { if (e.key === 'Escape' && menu.classList.contains('adb-open')) closeMenu(); });
    menu.querySelectorAll('a').forEach(a => a.addEventListener('click', closeMenu));
    window.addEventListener('pageshow', () => { closeMenu(); });
    btn.dataset.bound = '1';
  }
})();
</script>

</body>
</html>
<?php mysql_free_result($Consulta); ?>