<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cuidados ao Contratar um Detetive Particular - ADB</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
      padding: 0;
      color: #222;
       font-size: 14px;
    }
    .container {
      max-width: 960px;
      margin: 0 auto;
      background: #fff;
      padding: 30px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h1, h2 {
      color: #111;
    }
    h1 {
      text-align: center;
      margin-bottom: 20px;
       font-size: 16px;
    }
    h2 {
      margin-top: 30px;
      color: #444;
    }
    ul {
      margin-top: 10px;
      padding-left: 20px;
    }
    li {
      margin-bottom: 12px;
    }
    .alerta {
      background-color: #ffe8e8;
      padding: 15px;
      border-left: 5px solid #cc0000;
      margin-top: 30px;
      font-weight: bold;
      color: #990000;
    }
    .rodape {
      text-align: center;
      font-size: 14px;
      color: #666;
      margin-top: 40px;
    }
    a {
      color: #004aad;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
  <style>
    /* Impede seleção de texto */
    body {
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
      user-select: none;
    }
  </style>
  <script>
    // Bloqueia botão direito
    document.addEventListener('contextmenu', function(e) {
      e.preventDefault();
    });

    // Bloqueia teclas específicas
    document.addEventListener('keydown', function(e) {
      if (
        (e.ctrlKey && (e.key === 'u' || e.key === 'c' || e.key === 's')) || // Ctrl+U, Ctrl+C, Ctrl+S
        e.key === 'F12' || e.key === 'PrintScreen'
      ) {
        e.preventDefault();
        alert("Ação bloqueada.");
      }
    });

    // Tentativa de apagar a área de transferência de PrintScreen
    document.addEventListener("keyup", function(e) {
      if (e.key === "PrintScreen") {
        navigator.clipboard.writeText("");
        alert("Captura de tela bloqueada.");
      }
    });
  </script>
</head>
</head>
<body>
  <div class="container">
    <h1><font color="#FF0000"><b>ATENÇÃO</b></font></h1>

    <p>A <strong>Associação dos Detetives do Brasil (ADB)</strong> alerta a população sobre o crescimento de golpes praticados por falsos detetives. Para garantir segurança e evitar prejuízos, siga estas orientações essenciais:</p>

    <h2>1. Confirme se o detetive está devidamente cadastrado</h2>
<p>Antes de qualquer contratação, solicite o número de matrícula profissional e verifique sua autenticidade por meio do <a href="https://www.associacaodosdetetives.com.br" target="_blank">nosso portal oficial</a>. Apenas profissionais regularmente cadastrados e com registro válido estão aptos a exercer legalmente a atividade de investigação privada.</p>


   <h2>2. Exija identificação profissional válida</h2>
<p>
Todo detetive particular devidamente cadastrado possui uma <strong>carteira de identificação profissional oficial</strong>, contendo foto recente, CPF, número de registro e a instituição à qual está vinculado. Solicite esse documento no momento do contato.
</p>
<p>
Não confie apenas em cartões de visita, perfis de redes sociais ou supostas recomendações informais. Caso o indivíduo afirme ser profissional regularizado, mas <strong>não apresente a identificação oficial</strong>, isso já é um forte indício de irregularidade. Nesses casos, interrompa a negociação e denuncie.
</p>


    <h2>3. Desconfie de promessas fáceis e preços muito baixos</h2>
<p>
Golpistas costumam atrair vítimas oferecendo valores extremamente baixos e prometendo resultados rápidos e garantidos — uma prática comum entre os que agem de má-fé.
</p>
<p>
Lembre-se: <strong>nenhum detetive sério e profissional garante 100% de êxito</strong> em uma investigação, pois os resultados dependem de fatores reais, legais e imprevisíveis. A ética profissional não permite prometer o que não se pode comprovar.
</p>


    <h2>4. Exija contrato formal por escrito</h2>
<p>
Nunca contrate serviços de investigação sem um <strong>contrato por escrito</strong>. Esse documento deve conter todas as informações essenciais: valores, formas de pagamento, prazos, descrição clara do serviço contratado, cláusulas de confidencialidade e os direitos e deveres de ambas as partes.
</p>
<p>
O contrato é a única forma legal de garantir segurança para o cliente e responsabilidade para o profissional. <strong>Evite acordos verbais ou informais</strong>, pois em caso de golpe ou descumprimento, você poderá ficar sem amparo jurídico.
</p>


    <h2>5. Pesquise o histórico e a reputação do detetive</h2>
<p>
Antes de contratar, verifique se o profissional possui <strong>endereço fixo</strong>, <strong>referências reais</strong> de clientes anteriores e uma <strong>presença digital consistente e transparente</strong> (site, e-mail corporativo, avaliações, redes sociais com histórico legítimo).
</p>
<p>
Se o detetive afirmar ser cadastrado, <strong>confirme essa informação diretamente com a ADB</strong> por meio do nosso sistema de consulta pública. Essa verificação é essencial para garantir que se trata de um profissional regularmente habilitado e em situação ativa.
</p>


   <h2>6. Cuidado com perfis falsos em redes sociais</h2>
<p>
Golpistas frequentemente criam perfis falsos para se passarem por detetives. Desconfie de contas recentes, com poucas fotos, nomes genéricos, ausência de conteúdo profissional e sem histórico verificável.
</p>
<p>
<strong>Perfis legítimos geralmente possuem publicações regulares, identidade visual profissional e informações verificáveis</strong>. Sempre que possível, solicite uma <strong>chamada de vídeo</strong> para confirmar a identidade da pessoa antes de qualquer negociação.
</p>


   <h2>7. Evite pagamentos integrais antecipados</h2>
<p>
Não realize transferências ou pagamentos integrais, especialmente via Pix para contas de pessoa física, antes do início efetivo dos serviços. Solicite sempre pagamentos parcelados e preferencialmente em nome da empresa ou com CNPJ válido, para garantir maior segurança e rastreabilidade financeira.
</p>
<p>
Desconfie de profissionais que exigem o valor total antecipadamente ou que utilizam apenas meios informais de pagamento sem comprovação fiscal.
</p>


    <h2>8. Consulte sempre a Associação dos Detetives do Brasil (ADB)</h2>
<p>
Caso o profissional se identifique como associado ou cadastrado na ADB, <strong>exija a comprovação dessa condição por meio do número de matrícula profissional</strong> e confirme essa informação na consulta pública do <a href="https://www.associacaodosdetetives.com.br" target="_blank">portal oficial da ADB</a>. A confiança deve ser sempre baseada em informações oficiais e verificáveis.
</p>
<p>
Essa prática evita fraudes e assegura que você contrate um detetive com respaldo legal, ética profissional e compromisso com a qualidade dos serviços.
</p>

<p>
A consulta ao cadastro oficial é a forma mais segura de garantir que você está contratando um detetive com respaldo legal e conduta ética comprovada.
</p>


    <div class="alerta">
      ATENÇÃO: Se você foi vítima de um falso detetive, denuncie à Polícia Civil e registre um boletim de ocorrência. Também pode relatar à ADB para contribuir com a identificação desses golpistas.
    </div>

    <div class="rodape">
      Associação dos Detetives do Brasil – ADB<br>
      Por uma investigação ética, segura e profissional.
    </div>
  </div>
</body>
</html>
