<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Estatuto + Assinatura | ADB (Alto Contraste p/ Impressão)</title>
<style>
:root{
  --bg:#ffffff; --panel:#ffffff; --paper:#ffffff; --text:#111111; --muted:#333333; --border:#000000;
  --btn:#111111; --btn-text:#ffffff;
}
*{box-sizing:border-box}
html,body{height:100%}
body{margin:0;background:var(--bg);color:var(--text);font:16px/1.7 "Segoe UI", Arial, Helvetica, sans-serif}
.header{background:var(--panel);border-bottom:2px solid var(--border);text-align:center;padding:24px 16px}
.header img{height:72px;display:block;margin:0 auto 8px}
.header h1{margin:6px 0 0;font-size:22px;letter-spacing:.2px;color:#000;text-transform:uppercase}
.wrap{max-width:980px;margin:24px auto;padding:0 16px 40px}
.card,.panel{background:var(--paper);border:1px solid var(--border);border-radius:8px;box-shadow:none;padding:20px}
label{display:block;margin:10px 0 6px;color:#000;font-weight:700}
input[type="text"]{width:100%;padding:12px 14px;border-radius:8px;border:1px solid var(--border);background:#fff;color:#000}
.controls{display:flex;gap:10px;flex-wrap:wrap;margin-top:14px}
.btn{appearance:none;border:1px solid var(--border);border-radius:8px;padding:10px 14px;background:var(--btn);color:var(--btn-text);font-weight:800;cursor:pointer}
.btn.secondary{background:#f6f6f6;color:#000}
.notice{font-size:14px;color:#000;margin-top:8px}
hr.sep{border:none;border-top:1px solid var(--border);margin:20px 0}

h2.section{margin:0 0 10px 0;color:#000;text-transform:uppercase;font-size:18px;text-align:center}
.texto{white-space:pre-wrap;font-family:"Segoe UI",Arial,sans-serif;font-size:16px;color:#000}

/* Campo matrícula com prefixo ADB- fixo */
.matricula-wrap{display:flex;align-items:stretch;gap:0}
.matricula-prefix{
  padding:12px 10px;border:1px solid var(--border);border-right:none;border-radius:8px 0 0 8px;background:#f5f5f5;color:#000;font-weight:800;min-width:68px;text-align:center
}
.matricula-input{border-radius:0 8px 8px 0}

.signature-box{margin-top:18px;padding:16px;border:1px solid var(--border);border-radius:8px;background:#fff}
.signature-title{font-weight:900;text-transform:uppercase;letter-spacing:.4px;margin-bottom:6px;color:#000}
.sig-grid{display:grid;grid-template-columns:1fr;gap:8px}
.sig-row{display:flex;gap:8px;flex-wrap:wrap}
.sig-label{min-width:160px;color:#000;font-weight:700}
.sig-value{font-weight:700}
.sig-line{height:1px;background:var(--border);margin:10px 0}
.sig-assinatura{text-align:center;margin-top:18px}
.sig-assinatura .linha{margin:26px auto 6px;height:1px;background:var(--border);max-width:380px}

/* Impressão */
@media print{
  :root{--bg:#fff;--panel:#fff;--paper:#fff;--text:#000;--border:#000}
  body{background:#fff;color:#000;font:12.5pt/1.5 "Times New Roman", Georgia, serif}
  .header,.card,.panel{border:0;box-shadow:none}
  .header h1{color:#000}
  .controls,#formulario,.tools,.header img{display:none !important}
  .texto{font-size:12.5pt;color:#000}
  .signature-box{border:1pt solid #000}
  @page{size:auto;margin:20mm}
  a[href]:after{content:""}
  *{-webkit-print-color-adjust:exact;print-color-adjust:exact}
}
</style>
</head>
<body>

<header class="header">
  <img src="logotipoadb.png" alt="Associação dos Detetives do Brasil - ADB" onerror="this.style.display='none'">
  <h1>Estatuto Social + Termo de ciencia para Assinatura </h1>
</header>

<main class="wrap">

  <!-- FORMULÁRIO -->
  <section id="formulario" class="card">
    <h2 class="section">Identificação do Profissional</h2>

    <label for="nome">Nome completo (como no GOV.BR)</label>
    <input type="text" id="nome" placeholder="Ex.: Venâncio Melo" autocomplete="name" required>

    <label for="matNum">Número da Matrícula / Registro</label>
    <div class="matricula-wrap">
      <div class="matricula-prefix">ADB-</div>
      <input type="text" id="matNum" class="matricula-input" placeholder="000123" inputmode="numeric" autocomplete="off" required>
    </div>
    <small class="notice">Digite apenas o número/código. O prefixo <b>ADB-</b> já está aplicado automaticamente.</small>

    <div class="controls">
      <button class="btn" onclick="gerar()">Gerar Estatuto para Assinar</button>
      <button class="btn secondary" onclick="limpar()">Limpar</button>
      <button class="btn secondary" onclick="window.print()">Imprimir / PDF</button>
    </div>
  </section>

  <!-- DOCUMENTO -->
  <section id="preview" class="panel" style="display:none">
    <h2 class="section">Estatuto Social da Associação dos Detetives do Brasil</h2>

    <div id="estatuto" class="texto">
ESTATUTO SOCIAL DA ASSOCIAÇÃO DOS DETETIVES DO BRASIL 
Com registro no órgão da receita federal sobre o número, CNPJ: 13.329.080/0001-75. 
Sede, Rua Isaac Bertoncine nº 278, Centro - Lauro Müller SC - CEP: 88880-000.

CAPÍTULO I
DA ASSOCIAÇÃO, DENOMINAÇÃO, SEDE, FORO,
TEMPO DE DURAÇÃO E FINALIDADES
Art. 1°. A Associação dos Detetives do Brasil, doravante designada apenas Associação, é pessoa jurídica de direito privado, constituída na forma de sociedade civil de fins não lucrativos, com autonomia administrativa e financeira, regendo-se pelo presente Estatuto e pela legislação que lhe for aplicável. 
Art. 2°. A Associação tem sede e foro jurídico na Rua Isaac Bertoncine nº 278, Centro - Lauro Müller/SC - CEP: 88880-000, e poderá ter filial representativa em todo território nacional, e como base principal no endereço eletrônico: http://www.associacaodosdetetives.com.br.
Art. 3°. O sistema de cadastro da Associação dos detetives do Brasil tem como seu principal objetivo unificar as informações dos profissionais que atuam na área das investigações particulares credenciados dentro da lei estabelecida para a profissão a Lei 13.432/2017, que dispõe sobre o exercício da profissão de detetive particular, e CBO (Classificação Brasileira de Ocupações) nº 3518–05 do Ministério do Trabalho, que estabelece como ocupação lícita em todo território nacional, para assim possibilitar uma base de dados confiáveis e segura para os cliente a procura de um profissional.
§1º. Ao aprovar a lei 13.432/2017, o governo federal corre o risco de legalizar e oficializar as atividades criminosas praticadas por pessoas que não fazem parte da categoria, mas que, por não existir uma regulamentação, controle e fiscalização por parte do Estado, usam esta brecha para praticar crimes contra o cidadão, que busca nos serviços do detetive particular, a resposta para os seus problemas pessoais ou empresariais. 
§2º. A classe dos verdadeiros detetives particulares do Brasil há muitos anos vem sofrendo a discriminação e repulsa do cidadão contratante, que se toma presa fácil nas mãos destes criminosos disfarçados de detetives particulares, e que não sabe identificar o profissional sério do golpista que se apresenta como profissional. 
§3º. O verdadeiro profissional que trabalha com seriedade observando as leis, sente no seu dia a dia os prejuízos causados por esses criminosos, mas que nada podem fazer. 
 §4º. A falta da fiscalização por parte do Estado, deixa a cargo de cada detetive a exercer a sua própria AUTORREGULAÇÃO da profissão. 
§5º. No sistema da Associação dos Detetives do Brasil o cidadão poderá consultar pelo número de registro do profissional cadastrado na Associação a identificação completa do detetive particular que esta prestes a contratar, seja pessoalmente ou pela internet, evitando assim que caiam em armadilhas elaboradas pelos estelionatários que se passam por detetives particulares, dando informações falsas para manterem-se no anonimato, trazendo assim a confiança do cliente para com o profissional, e também para facilitar a troca de informações solicitadas pelas autoridades civis e militares.

Art. 4°. Na consecução de tal objetivo a Associação dos Detetives do Brasil poderá efetivar trabalhos de suporte ao cidadão e ao associado, atividades de investigação particular para garantir a idoneidade moral de cada profissional detetive particular cadastrado no sistema, bem como a educação profissional de nível técnico relacionados com seus fins.
Art. 5°. A Associação dos Detetives do Brasil poderá firmar convênios ou contratos e articular-se, pela forma conveniente, com órgão ou entidades, públicas ou privadas. 
 Art. 6°. A Associação tem número ilimitado de associados, tempo de duração indeterminado.
Art. 7º. É vedado à Associação:
I - Distribuir qualquer parcela de seu patrimônio, receita, recursos ou excedentes financeiros, a título de lucro, vantagem, bonificação ou de participação, a qualquer dirigente, associado ou mantenedor, sob qualquer forma ou pretexto, nem mesmo em razão de desligamento, retirada ou falecimento;
II - Remunerar os membros da Diretoria.

CAPÍTULO II
DO QUADRO DE ASSOCIADOS: ADMISSÃO, DIREITOS, DEVERES,
DEMISSÃO E EXCLUSÃO

SEÇÃO I
ADMISSÃO
Art. 8º. Haverá as seguintes categorias de associados:
I - Fundadores: são os que estiveram presentes na Assembleia Geral de constituição da associação, devidamente consignados na Lista Nominativa de Associados Fundadores;
II - Efetivos: são os que se inscreverem no quadro social após a fundação da associação, tendo seus nomes aprovados pela Diretoria e que se disponham a cumprir o presente Estatuto.
§1º. Os associados estarão sujeitos ao pagamento de contribuições estipuladas pela Assembleia Geral, cujos valores definidos serão registrados em ata da Assembleia Geral, no regimento interno ou em resolução interna.
§2º. O não pagamento das contribuições referidas no artigo anterior, na data do vencimento, acarretará multa e juros de mora estabelecidos em lei, implicando também a suspensão dos direitos estatutários e eventual desligamento.
Art. 9º. Os associados da Associação dos Detetives do Brasil deverão se enquadrar às exigências da Lei Federal nº 13.432/2017, e devem trabalhar como detetive particular.
§1º. Considera-se detetive particular, nos termos da Lei Federal nº 13.432/2017, o profissional que, habitualmente, por conta própria ou na forma de sociedade civil ou empresarial, planeje e execute coleta de dados e informações de natureza não criminal, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse privado do contratante;
§ 2º. Consideram-se sinônimas, nos termos da Lei, as expressões “detetive particular”, “detetive profissional” e outras que tenham ou venham a ter o mesmo objeto.
Art. 10. Para se associar, o cidadão precisará apresentar:
I - Cópia digitalizada em PDF do CPF e Identidade no mesmo arquivo;
II - Exame ou declaração assinada, com firma reconhecida em Cartório, do seu tipo sanguíneo;
III - Cópia digitalizada em PDF do comprovante de residência (água, luz ou de telefone fixo) em nome do associado;
IV - Cópia digitalizada em arquivo PDF de Certidões negativas de antecedentes criminais das esferas estadual e federal;
V - 01 (uma) foto 3X4 atual, com fundo branco sem óculos de sol ou boné;
§1º Para se associar, o requerente terá que realizar obrigatoriamente o curso de reciclagem profissional totalmente gratuito, para receber seu número de registro como membro associado dentro do prazo estabelecido de 02 meses, devendo atingir, no mínimo, nota 07 para a aprovação;
§2º. Na hipótese do parágrafo anterior, caso o associado não atinja a nota mínima 07, terá que refazer a prova dentro de 15 dias após o resultado da avaliação, sendo vedada a sua admissão à Associação enquanto não alcançar a nota mínima na avaliação;
§3º Na hipótese do inc. V, caso o associado não tenha comprovante de endereço em seu nome, poderá enviar declaração de moradia assinada, com firma reconhecida em Cartório, pelo proprietário da residência juntamente com o comprovante do mês anterior,

SEÇÃO II
DOS DIREITOS DOS ASSOCIADOS
Art. 11. Aos associados efetivos e fundadores, em pleno gozo de seus direitos, asseguram-se os seguintes direitos:
I - comparecer às Assembleias Gerais e nelas votar;
II - votar e ser votado para qualquer cargo dentro dos limites deste Estatuto, obedecidas às condições das normas eleitorais;
III - participar de todas as atividades associativas e apresentar sugestões à Diretoria;
IV - convocar Assembleia Geral Extraordinária nas hipóteses previstas neste estatuto;
V - propor a admissão de novos associados;
VI - utilizar o acervo técnico, bem como as instalações e serviços;
VII - solicitar, a qualquer tempo, informações relativas às atividades associativas.

SEÇÃO III
DOS DEVERES DOS ASSOCIADOS
Art. 12. São deveres dos associados fundadores e efetivos:
I - cumprir e fazer cumprir o presente Estatuto, bem como as deliberações da Assembleia Geral e da Diretoria Executiva;
II - participar das reuniões técnicas e das Assembleias Gerais que exijam quórum qualificado, devendo justificar eventuais faltas;
III - exercer diligentemente os cargos para os quais tenham sido selecionados e/ou eleitos; 
IV - responder pelos projetos, atividades e ações pelos quais tenha sido indicado como responsável pela Diretoria;
V - comunicar à Diretoria quaisquer alterações de natureza cadastral, inclusive endereçamento postal e eletrônico;
VI - zelar pelo espírito cooperativo e a troca de informações entre os associados;
VII - zelar pela boa imagem e pelos objetivos da Associação, bem como pela conservação do seu patrimônio.

SEÇÃO IV
DA EXCLUSÃO E DA DEMISSÃO
Art. 13. A exclusão do associado, somente havendo justa causa,  é aplicada em virtude de infração legal ou estatutária, ou por fato especial previsto neste estatuto com os motivos que a determinaram, assegurados a ampla defesa, o contraditório e o direito de recurso à Assembleia Geral.
Parágrafo único. A Diretoria poderá excluir o associado que:
I - motivar qualquer atividade que conflite com os objetivos associativos;
II - deixar de cumprir as obrigações por ele contratadas com a Associação, inclusive deixando de observar os métodos e prazos da Associação;
III - depois de notificado, voltar a infringir disposições da lei, deste Estatuto e das resoluções e deliberações regularmente tomadas;
IV - denegrir a imagem e causar prejuízos de ordem moral, social e financeira à Associação e a seus dirigentes, associados e funcionários;
Art. 14. Poderá o associado solicitar sua demissão a qualquer tempo, desde que comunique sua saída com antecedência mínima de 15 dias, não sendo seu pedido passível de indeferimento.
Art. 15. Dar-se-á a exclusão do associado por:
I - morte da pessoa física ou extinção da pessoa jurídica;
II - incapacidade civil não suprida.
Art. 16. Os deveres dos membros da Diretoria e associados que detenham atribuições específicas perduram, para os desligados ou excluídos, até que sejam aprovadas, pela Assembleia Geral, as contas do exercício em que se deu o desligamento ou a exclusão.
Art. 17. Os atos de demissão ou exclusão acarretam o vencimento e a pronta exigibilidade das dívidas do associado com a Associação, sobre cuja liquidação caberá à Diretoria decidir.
Art. 18. Os associados, desde que tenham atuado probamente e de boa-fé, não respondem solidária, direta ou subsidiariamente, pelos compromissos da Associação.

CAPÍTULO V
DO PATRIMÔNIO, SUA CONSTITUIÇÃO E UTILIZAÇÃO
Art. 19. O patrimônio da Associação dos Detetives do Brasil será composto de:
I - Dotações ou subvenções eventuais, diretamente da União, dos Estados e Municípios ou através de órgãos Públicos da Administração direta e indireta;
II - Auxílios, contribuições e subvenções de entidades públicas e privadas, nacionais ou estrangeiras;
III - Usufruto que lhes forem conferidos;
IV - Contribuição voluntaria de seus associados.
Parágrafo único. A renda da Associação dos Detetives do Brasil somente poderá ser utilizada para a realização de seus objetivos.

CAPÍTULO VI
DA ASSEMBLEIA GERAL
Art. 20. A Associação dos Detetives do Brasil tem como órgãos deliberativos e administrativos a Assembleia Geral e a Diretoria executiva. 
Art. 21. A Assembleia Geral, órgão soberano da entidade, será constituída por todos os sócios em pleno gozo de seus direitos estatutários. 
Art. 22. São atribuições da Assembleia Geral: 
I - eleger os membros da Diretoria e do Conselho Fiscal; 
II - elaborar e aprovar o Regimento Interno da Associação dos Detetives do Brasil; 
III - deliberar sobre o orçamento anual e sobre o programa de trabalho elaborado pela Diretoria, ouvido previamente quanto àquele, o Conselho Fiscal; 
IV - examinar o relatório da Diretoria executiva e deliberar sobre o balanço e as contas; 
V - deliberar sobre a conveniência de aquisição, alienação ou oneração de bens pertencentes à Associação dos Detetives do Brasil; 
VI - decidir sobre a reforma do presente Estatuto; 
VII - deliberar sobre proposta de absorção ou incorporação de outras entidades à Associação; 
VIII - autorizar a celebração de convênios e acordos com entidades públicas ou privadas; 
IX - decidir sobre a extinção da Associação dos Detetives do Brasil e o destino do patrimônio;
X - destituir os membros da Diretoria e do Conselho Fiscal, assegurados o devido processo legal, ampla defesa e contraditório.
Art. 23. A Assembleia Geral se reunirá ordinariamente anualmente, quando convocada pela diretoria executiva ou ainda por no mínimo 1/3 de seus membros, para: 
I - tomar conhecimento da dotação orçamentária e planejamento de atividades para a Associação dos Detetives do Brasil;
II - prestação de contas;
III - deliberar sobre o relatório apresentado pela Diretoria sobre as atividades referentes ao exercício social encerrado.
Art. 24. A Assembleia Geral se reunirá extraordinariamente quando convocada: 
I - pela Diretoria executiva; 
II - pelo Conselho Fiscal; 
III - por 1/3 de seus membros.
Art. 25. A convocação das reuniões ordinárias ou extraordinárias será feita mediante edital, com pauta dos assuntos a serem tratados, a ser publicado online no sítio eletrônico da entidade, com antecedência mínima de oito (8) dias.
§ 1º. As reuniões ordinárias instalar-se-ão em primeira convocação, com a presença mínima de dois terços (2/3) dos integrantes da Assembleia Geral e, em segunda convocação, trinta (30) minutos depois, com qualquer número de presentes.
§ 2º. As reuniões extraordinárias instalar-se-ão, em primeira convocação, com 2/3 (dois terços) dos integrantes da Assembleia Geral e, em segunda convocação, trinta (30) minutos depois, com maioria absoluta dos integrantes do referido órgão.
Art. 26. O quórum de deliberação será de 2/3 (dois terços) da Assembleia Geral, em reunião extraordinária, para as seguintes hipóteses:
I - Alteração do Estatuto;
II - Alienação de bens imóveis e gravação de ônus reais sobre os mesmos;
III - Aprovação de tomada de empréstimos financeiros de valores superiores a cem (100) salários mínimos;
IV - Destituição dos membros da Diretoria e Conselho Fiscal;
V - Extinção da Associação.

CAPÍTULO VII
DA DIRETORIA E DO CONSELHO FISCAL
Art. 27. A Diretoria é composta de:
I. Diretor Presidente;
II. Secretário (a);
III. Tesoureiro (a).
Parágrafo único. O mandado dos integrantes da Diretoria executiva será de 05 (cinco) anos, permitida a reeleição. 
Art. 28. Ocorrendo vaga entre os integrantes da Diretoria, a Assembleia Geral se reunirá no prazo máximo de trinta dias após a vacância, para eleger o novo integrante.
Art. 29. Compete à Diretoria executiva: 
I - elaborar e executar o programa anual de atividades; 
II - elaborar e apresentar a Assembleia Geral o relatório anual e o respectivo demonstrativo de resultados do exercício findo;
III - elaborar o orçamento da receita e despesas para o exercício seguinte; 
IV - elaborar os regimentos internos da e de seus departamentos; 
V - entrosar-se com instituições públicas e privadas, tanto no País como no exterior, para mútua colaboração em atividades de interesse comum. 
Art. 30. Compete ao Diretor Presidente: 
I - representar a Associação dos Detetives do Brasil judicial e extrajudicialmente; 
II - cumprir e fazer cumprir este Estatuto e os demais regimentos internos; 
III - convocar e presidir as reuniões da Diretoria; 
IV - dirigir e supervisionar todas as atividades da Associação dos Detetives do Brasil; 
V - assinar quaisquer documentos relativos às operações ativas da Associação dos Detetives do Brasil. 
Art. 31. Compete ao Secretário (a): 
I - secretariar as reuniões das Assembleias Gerais e da Diretoria e redigir atas; 
II - cadastrar os profissionais que procurarem a Associação dos detetives do Brasil para fins de trabalho do caso e possível prestação de ajuda; 
III - manter organizada a secretaria, com os respectivos livros e correspondências. 
Art. 32. Compete ao Tesoureiro (a):
I - arrecadar e contabilizar as contribuições, rendas, auxílios e donativos efetuados à Associação dos Detetives do Brasil, mantendo em dia a escrituração; 
II - efetuar os pagamentos de todas as obrigações da Associação dos Detetives do Brasil; 
III - acompanhar e supervisionar os trabalhos de contabilidade da Associação dos Detetives do Brasil, contratados com profissionais habilitados, cuidando para que todas as obrigações fiscais e trabalhistas sejam devidamente cumpridas em tempo hábil;
IV - apresentar relatórios de receitas e despesas, sempre que forem solicitadas; 
V - apresentar o relatório financeiro para ser submetido à Assembleia Geral; 
VI - apresentar semestralmente o balancete de receitas e despesas; 
VII - publicar anualmente a demonstração das receitas e despesas realizadas no exercício;
VIII - elaborar, com base no orçamento realizado no exercício, a proposta orçamentária para o exercício seguinte a ser submetida à Diretoria, para posterior apreciação da Assembleia Geral;
IX - manter todo o numerário em estabelecido de crédito; 
X - conservar sob sua guarda e responsabilidade, todos os documentos relativos à tesouraria;
XI - assinar, em conjunto com o Presidente, todos os cheques emitidos pela Associação.
Art. 33. O Conselho Fiscal será constituído por (03) pessoas de reconhecida idoneidade eleitos pela Assembleia Geral, permitida apenas uma recondução.
Parágrafo único. O mandato do Conselho Fiscal será coincidente com o mandato da Diretoria.
Art. 34. Ocorrendo vaga entre os integrantes do Conselho Fiscal, a Assembleia Geral se reunirá no prazo máximo de trinta dias após a vacância, para eleger o novo integrante.
Art. 35. Compete ao Conselho Fiscal: 
I - examinar os documentos e livros de escrituração da entidade;
II - examinar o balancete semestral apresentado pelo Tesoureiro, opinando a respeito;
III - apreciar os balanços e inventários que acompanham o relatório anual da Diretoria;
IV - opinar sobre a aquisição, alienação e oneração de bens pertencentes à Associação. Parágrafo único. O Conselho Fiscal reunir-se-á a cada seis (6) meses e extraordinariamente sempre que necessário.

CAPÍTULO VIII
DAS DISPOSIÇÕES GERAIS E TRANSITÓRIAS
Art. 36. Os sócios e dirigentes da Associação dos Detetives do Brasil não respondem solidária nem subsidiariamente pelas obrigações da Entidade. 
Art. 37. A Associação dos Detetives do Brasil é composta por número ilimitado de sócios, distribuídos em categorias de fundadores e efetivos. 
Parágrafo único. A primeira Assembleia-Geral da Associação dos Detetives do Brasil composta por seus fundadores designará comissão para elaborar regimento que conste para se associar à mesma, bem como das categorias, deveres e obrigações dos sócios. 
Art. 38. Os cargos dos órgãos de administração da Associação dos Detetives do Brasil não são remunerados de nenhuma forma, ficando expressamente vedado por parte de seus integrantes o recebimento de qualquer lucro, gratificação, bonificação ou vantagem. 
Art. 39. Decidida a extinção da Associação, seu patrimônio, depois de satisfeitas as obrigações assumidas, serão incorporadas ao de outra Associação congênere, a critério da Assembleia-Geral.
Art. 40. O exercício financeiro da Associação coincidirá com o ano civil.
Art. 41. O orçamento da Associação dos Detetives do Brasil será uno, anual e compreenderá todas as receitas e despesas, compondo-se de estimativa de receita, discriminadas por dotações e discriminação analíticas das despesas de modo a evidenciar sua fixação. 
Art. 42. Os casos omissos serão resolvidos pela Diretoria e referendados pela Assembleia Geral, ficando eleito o foro da Comarca de Lauro Muller, para sanar possíveis dúvidas. 
    </div>

    <hr class="sep">

    <div class="signature-box" id="termo">
      <div class="signature-title">Termo de ciência e assinatura digital</div>
      <div class="sig-grid">
        <div class="sig-row"><div class="sig-label">Nome completo:</div> <div class="sig-value" id="outNome">—</div></div>
        <div class="sig-row"><div class="sig-label">Matrícula/Registro:</div> <div class="sig-value" id="outMatricula">—</div></div>
        <div class="sig-row"><div class="sig-label">Local e Data:</div> <div class="sig-value" id="outData">—</div></div>
      </div>
      <div class="sig-line"></div>
      <p class="notice">Declaro que li integralmente o Estatuto Social acima e estou ciente de suas disposições, firmando-o para todos os fins.</p>

      <div class="sig-assinatura"><br><br>
        <div class="linha"></div>
        <small>Assinatura do(a) Associado(a) via GOV</small>
      </div>

      <div class="controls tools">
        <button class="btn secondary" onclick="window.print()">Imprimir / Salvar PDF/ Assinar no GOV.BR</button>
        
      </div>
    </div>
  </section>
</main>

<script>
// normaliza código de matrícula (apenas letras/números, sem espaços) e força maiúsculas
function normCodigo(v){ return v.replace(/[^a-z0-9]/gi,'').toUpperCase(); }
function dataBR(d=new Date()){
  try{ return new Intl.DateTimeFormat('pt-BR',{dateStyle:'long'}).format(d); }
  catch(e){
    const dd=String(d.getDate()).padStart(2,'0');
    const mm=String(d.getMonth()+1).padStart(2,'0');
    const yyyy=d.getFullYear();
    return `${dd}/${mm}/${yyyy}`;
  }
}
function gerar(){
  const nome = document.getElementById('nome').value.trim();
  let cod  = normCodigo(document.getElementById('matNum').value.trim());
  if(!nome || !cod){ alert('Preencha Nome completo e o número da matrícula.'); return; }
  document.getElementById('matNum').value = cod; // reflete normalização no campo
  const matriculaFull = `ADB-${cod}`;
  document.getElementById('outNome').textContent = nome;
  document.getElementById('outMatricula').textContent = matriculaFull;
  document.getElementById('outData').textContent = `Lauro Müller/SC, ${dataBR()}`;
  document.getElementById('preview').style.display = 'block';
  document.getElementById('preview').scrollIntoView({behavior:'smooth',block:'start'});
}
function limpar(){
  document.getElementById('nome').value='';
  document.getElementById('matNum').value='';
  document.getElementById('preview').style.display='none';
}
// melhora UX: já deixa o campo aceitar só letras/números e em maiúsculas
document.getElementById('matNum').addEventListener('input', e=>{
  const sel = e.target.selectionStart;
  e.target.value = normCodigo(e.target.value);
  e.target.setSelectionRange(sel, sel);
});
</script>

</body>
</html>
