<?php
// Arquivo: cursodeformacao.php — layout unificado (navbar + sumário drawer) • ADB
header('Content-Type: text/html; charset=UTF-8');

// Fallback do brasão caso não venha via include
if (!isset($BRASAO) || !$BRASAO) { $BRASAO = 'logotipoadb.png'; }
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">

  <!-- Favicon / OG / Twitter -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">

  <!-- Seus arquivos (opcionais) -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>

  <style>
    :root{
      --verde:#009739;
      --amarelo:#ffcc29;
      --azul:#001a33;
      --azul-escuro:#000f24;
      --azul-clarinho:#e8f0fa;
      --texto:#1f2937;
      --cinza:#f8fafc;
      --linha:#e5e7eb;
      --shadow:0 8px 24px rgba(0,0,0,.06);
      --radius:14px;
      --max:1300px;
    }
    *{ box-sizing:border-box }
    html,body{ margin:0; padding:0; background:#fff; color:var(--texto); font-family:Arial, Helvetica, sans-serif; line-height:1.6; -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale; }

    /* ===== NAVBAR ===== */
    .adb-nav{ position:sticky; top:0; z-index:60; background:var(--azul); color:#fff; border-bottom:3px solid var(--amarelo); }
    .adb-wrap{ max-width:var(--max); margin:0 auto; padding:10px 16px; display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative; }
    .adb-brand{ display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0 }
    .adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
    .adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap }

    .adb-toggle{ display:none; background:transparent; border:0; color:#fff; cursor:pointer; width:40px; height:40px; border-radius:8px }
    .adb-toggle:focus-visible{ outline:2px solid #fff; outline-offset:2px }

    .adb-sumario-btn{
      display:none;
      margin-left:8px;
      background:transparent;
      border:1px solid rgba(255,255,255,.6);
      color:#fff;
      cursor:pointer;
      padding:8px 10px;
      border-radius:10px;
      font-weight:700;
      align-items:center;
      gap:8px;
    }
    .adb-sumario-btn:focus-visible{ outline:2px solid #fff; outline-offset:2px }
    .adb-sumario-text{ display:none }

    .adb-menu{ list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px }
    .adb-menu a{ display:inline-block; text-decoration:none; color:#fff; font-weight:700; padding:10px 14px; border-radius:10px }
    .adb-menu a:hover{ background:rgba(255,255,255,.12) }
    .adb-menu a.active{ background:var(--amarelo); color:#1f2937 }

    @media (max-width:1024px){
      .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
      .adb-sumario-btn{ display:inline-flex }
      .adb-sumario-text{ display:inline }
      .adb-menu{
        position:absolute; left:16px; right:16px; top:56px; background:var(--azul);
        flex-direction:column; align-items:stretch; gap:0; max-height:0; overflow:hidden;
        transition:max-height .25s ease; border-bottom:3px solid var(--amarelo);
        border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35);
      }
      .adb-menu.open{ max-height:420px }
      .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
      .adb-menu a{ padding:14px 18px }
    }

    /* ===== HERO ===== */
    header{ background:var(--azul); color:#fff; text-align:center; padding:28px 16px 46px; position:relative }
    header .topo{ max-width:1100px; margin:0 auto }
    header img.brasao{ width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px; background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15) }
    header h1{ margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35) }
    header .faixa{ position:absolute; left:0; right:0; bottom:-18px; height:36px; background:var(--amarelo); border-top:2px solid rgba(255,255,255,.5); border-bottom:1px solid rgba(0,0,0,.08) }

    /* ===== LAYOUT PRINCIPAL ===== */
    .layout{ max-width:var(--max); margin:48px auto 28px; padding:0 16px; display:grid; grid-template-columns:280px 1fr; gap:22px }
    @media (max-width:1024px){ .layout{ grid-template-columns:1fr } }

    /* Sidebar (Sumário) desktop */
    .toc{ position:sticky; top:86px; align-self:start; background:#fff; border:1px solid var(--linha); border-radius:var(--radius); box-shadow:var(--shadow); padding:16px; height:max-content }
    .toc h2{ margin:.2rem 0 8px; font-size:16px }
    .toc p{ margin:0 0 8px; color:#4b5563; font-size:13px }
    .toc ul{ list-style:none; margin:0; padding:0; display:grid; gap:6px }
    .toc a{ display:block; text-decoration:none; color:var(--texto); padding:8px 10px; border-radius:10px; font-weight:600 }
    .toc a:hover{ background:var(--azul-clarinho) }
    @media (max-width:1024px){ .toc{ display:none } }

    /* Drawer mobile do sumário */
    .drawer-backdrop{
      position:fixed; inset:0; background:rgba(0,0,0,.45); backdrop-filter:saturate(120%) blur(2px);
      opacity:0; pointer-events:none; transition:opacity .2s ease; z-index:70;
    }
    .drawer-backdrop.open{ opacity:1; pointer-events:auto }
    .drawer{
      position:fixed; top:0; left:0; height:100vh; width:min(86vw,340px); background:#fff;
      border-right:1px solid var(--linha); box-shadow:var(--shadow);
      transform:translateX(-100%); transition:transform .25s ease; z-index:80;
      display:flex; flex-direction:column;
    }
    .drawer.open{ transform:translateX(0) }
    .drawer__head{ display:flex; align-items:center; justify-content:space-between; gap:8px; padding:12px 14px; border-bottom:1px solid var(--linha) }
    .drawer__title{ font-weight:800 }
    .drawer__close{ background:transparent; border:0; cursor:pointer; width:40px; height:40px; border-radius:8px }
    .drawer__close:focus-visible{ outline:2px solid var(--azul); outline-offset:2px }
    .drawer__body{ padding:12px; overflow:auto }
    .drawer__body ul{ list-style:none; margin:0; padding:0; display:grid; gap:6px }
    .drawer__body a{ display:block; text-decoration:none; color:var(--texto); padding:10px 12px; border-radius:10px; font-weight:600 }
    .drawer__body a:hover{ background:var(--azul-clarinho) }

    /* Conteúdo / Cards */
    .lead{ background:var(--cinza); border:1px solid var(--linha); border-left:4px solid var(--azul); padding:12px 14px; border-radius:10px; margin:0 0 16px 0 }
    .grid{ display:grid; grid-template-columns:1fr 1fr; gap:16px }
    @media (max-width:800px){ .grid{ grid-template-columns:1fr } }
    .card{ background:#fff; border:1px solid var(--linha); border-radius:14px; padding:18px; box-shadow:var(--shadow) }
    .card h2,.card h3{ margin-top:0 }
    .muted{ color:#4b5563; font-size:14px }
    .hr{ height:1px; background:var(--linha); margin:16px 0 }

    /* Botões */
    .btn{ display:inline-block; padding:12px 18px; border-radius:10px; font-weight:700; text-decoration:none; text-align:center; color:#fff; box-shadow:0 6px 16px rgba(0,0,0,.12); transition:.2s transform ease,.2s opacity ease }
    .btn:hover{ transform:translateY(-1px); opacity:.95 }
    .btn:active{ transform:translateY(0) }
    .btn-azul{ background:var(--azul) }
    .btn-verde{ background-color:#cc0000; color:#fff }
    .btn-verde:hover{ background-color:#990000 }
    .btn-amarelo{ background:var(--amarelo); color:#1f2937 }
    .btn-claro{ background:#fff; color:var(--texto); border:1px solid var(--linha) }
    .cta{ margin:14px 0; display:flex; gap:10px; flex-wrap:wrap }

    /* FAB WhatsApp */
    .wa-fab{ position:fixed; right:18px; bottom:18px; z-index:90; width:64px; height:64px; border-radius:50%; background:#25D366; display:flex; align-items:center; justify-content:center; box-shadow:0 10px 24px rgba(0,0,0,.25) }
    .wa-fab img{ width:34px; height:34px; display:block }
    .wa-fab:focus-visible{ outline:3px solid #cfead8; outline-offset:3px }
    @media (max-width:768px){ .wa-fab{ width:60px; height:60px; right:14px; bottom:14px } .wa-fab img{ width:30px; height:30px } }

    /* Impressão */
    @media print{
      .adb-nav, header .faixa, .wa-fab, .toc, .drawer, .drawer-backdrop, #adb-translate{ display:none !important }
      header{ background:#fff; color:#000; padding:12px }
      header img.brasao{ background:transparent; box-shadow:none; padding:0 }
      .card{ box-shadow:none }
      body{ background:#fff }
    }
  </style>
</head>
<body>

<!-- ===== NAVBAR ===== -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="index.php" rel="noopener">
      <img src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="ADB">
      <span>Cadastro Nacional</span>
    </a>

    <!-- Botão do MENU (hambúrguer) -->
    <button class="adb-toggle" id="adbToggle"
            aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>

    <!-- Botão do SUMÁRIO (drawer) -->
    <button class="adb-sumario-btn" id="tocOpen"
            aria-label="Abrir sumário" aria-expanded="false" aria-controls="tocDrawer">
      📑 <span class="adb-sumario-text">Sumário</span>
    </button>

    <ul class="adb-menu" id="adbMenu">
      <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php">Com formação</a></li>
      <li><a href="cursodeformacao.php" class="active" aria-current="page">Sem formação</a></li>
      <li><a href="atualizacao.php">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<!-- ===== HERO ===== -->
<header id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da República Federativa do Brasil" onerror="this.style.display='none'">
    <h1>Curso de formação</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<div class="layout">
  <!-- ===== SUMÁRIO (desktop) ===== -->
  <aside class="toc" aria-label="Sumário">
    <h2>Sumário</h2>
    <p>Acesse rapidamente cada seção</p>
    <ul>
      <li><a href="#aviso">⚠️ Aviso / Inscrição</a></li>
      <li><a href="#sobre">📘 Sobre o curso</a></li>
      <li><a href="#legislacao">📑 Legislação</a></li>
      <li><a href="#conteudos">🧭 Conteúdos</a></li>
      <li><a href="#docs">🗂️ Documentos</a></li>
      <li><a href="#envio">📤 Envio & Assinatura</a></li>
    </ul>
  </aside>

  <!-- ===== CONTEÚDO ===== -->
  <main>
    <!-- Aviso / inscrição -->
    <section id="aviso" class="lead" role="note">
      Podem se cadastrar e permanecer em período de aprendizado por <strong>2 (dois) meses</strong>. Ao final, realizarão <strong>teste teórico</strong>, requisito obrigatório para a emissão do certificado.
      <div class="hr"></div>
      <div class="cta">
        <a class="btn btn-azul" href="restrito.php" target="_blank" rel="noopener">🔐 Portal do associado</a>
      </div>
    </section>

    <!-- Sobre -->
    <section id="sobre" class="card">
      <h2 style="margin-top:0">📘 Sobre o curso</h2>
      <ul>
        <li><strong>Início:</strong> imediato;</li>
        <li><strong>Duração:</strong> 02 meses;</li>
        <li><strong>Carga horária:</strong> 840 horas;</li>
        <li><strong>Modalidade:</strong> a distância.</li>
      </ul>

      <div class="lead" style="margin-top:10px">
        <strong>Taxa única de inscrição:</strong> R$ 150,00
      </div>

      <p style="margin-top:10px">
        <strong>Favorecido:</strong> Associação dos Detetives do Brasil<br>
        <strong>Chave PIX (CNPJ):</strong> 13.329.080/0001-75
      </p>
      <p>
        <strong>Transferência Bancária</strong><br>
        Banco: CORA • Agência: 0001 • Conta Corrente: 3023410-1
      </p>

      <p class="muted"><em>Após o pagamento, envie o comprovante para confirmação da matrícula e liberação de acesso.</em></p>
    </section>

    <!-- Legislação -->
    <section id="legislacao" class="card">
      <h2 style="margin-top:0">📑 Base legal</h2>
      <p>
        <a class="btn btn-amarelo" href="https://www.planalto.gov.br/ccivil_03/leis/l9394.htm" target="_blank" rel="noopener">Ver Lei nº 9.394/96 (LDB)</a>
      </p>
      <p class="muted">
        Lei de Diretrizes e Bases da Educação Nacional — estabelece as bases da educação no Brasil, incluindo a educação profissional e tecnológica; Decreto nº 5.154/2004.
      </p>
      <div class="cta">
        <a class="btn btn-azul" href="manual_gov_br.php" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:10px;text-decoration:none;">
          <img src="https://t2.tudocdn.net/697334?w=1200&h=1200" alt="GOV.BR" style="width:28px;height:28px;object-fit:contain;border-radius:4px;display:inline-block" loading="lazy" decoding="async" referrerpolicy="no-referrer">
          Assinatura GOV.br
        </a>
      </div>
    </section>

    <!-- Conteúdos -->
    <section id="conteudos" class="grid" aria-label="Conteúdos do curso">
      <article class="card">
        <h3>Conteúdo do curso — Parte 1</h3>
        <p class="box">
          <a href="login.php?info=DENIED">A Profissão de Detetive Particular</a><br>
          <a href="login.php?info=DENIED">Investigador Privado</a><br>
          <a href="login.php?info=DENIED">Investigador Criminal</a><br>
          <a href="login.php?info=DENIED">A Investigação Criminal</a><br>
          <a href="login.php?info=DENIED">Lofoscopia</a><br>
          <a href="login.php?info=DENIED">Vestígio</a><br>
          <a href="login.php?info=DENIED">Entrevista Investigativa</a><br>
          <a href="login.php?info=DENIED">Perícia Criminal</a><br>
          <a href="login.php?info=DENIED">Investigação Conjugal</a><br>
          <a href="login.php?info=DENIED">Investigação de Localização de Pessoas</a>
        </p>
      </article>

      <article class="card">
        <h3>Conteúdo do curso — Parte 2</h3>
        <p class="box">
          <a href="login.php?info=DENIED">Espionagem</a><br>
          <a href="login.php?info=DENIED">Localização de Devedores</a><br>
          <a href="login.php?info=DENIED">Psicologia da Mentira</a><br>
          <a href="login.php?info=DENIED">Conflito Aparente de Normas Penais</a><br>
          <a href="login.php?info=DENIED">Direito Penal do Crime</a><br>
          <a href="login.php?info=DENIED">Classificação de Crimes</a><br>
          <a href="login.php?info=DENIED">Morte Violenta</a><br>
          <a href="login.php?info=DENIED">Procedimentos para Campana Fixa</a><br>
          <a href="login.php?info=DENIED">Técnicas de Operações de Vigilância Dinâmica</a><br>
          <a href="login.php?info=DENIED">Outros Conhecimentos na Investigação</a>
        </p>
      </article>
    </section>

    <!-- Documentos -->
    <section id="docs" class="grid" aria-label="Documentação obrigatória">
      <article class="card">
        <h3>🧾 CPF</h3>
        <p>Cópia do CPF.</p>
        <div class="hr"></div>

        <h3>🪪 Identidade ou CNH</h3>
        <p>Cópia do RG ou da Carteira Nacional de Habilitação.</p>
        <div class="hr"></div>

        <h3>🏠 Comprovante de Residência</h3>
        <p>Conta de água, luz ou telefone fixo.</p>
        <ul>
          <li>Em nome do cônjuge/companheiro(a): anexar Certidão de Casamento/União Estável.</li>
          <li>Sem vínculo conjugal ou sem titularidade: anexar <strong>declaração com firma reconhecida</strong> do titular/proprietário.</li>
        </ul>
        <p><a class="btn btn-azul" href="imprimir_declaracao_de_residencia.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>
      </article>

      <article class="card">
        <h3>✍️ Declaração de Aceitação</h3>
        <p>Declaração de aceitação assinada.</p>
        <p><a class="btn btn-azul" href="imprimir_declaracao_de_aceitacao.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>
        <div class="hr"></div>

        <h3>🩸 Tipo Sanguíneo</h3>
        <p>Exame ou declaração do seu tipo sanguíneo.</p>
        <p><a class="btn btn-azul" href="imprimir_declaracao_de_tipo_sanguineo.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>
        <div class="hr"></div>

        <h3>🧾 Comprovação de Idoneidade</h3>
        <p>Apresentar certidões negativas de antecedentes criminais fornecidas pelos órgãos competentes.</p>
      </article>

      <article class="card">
        <h3>🖼️ Foto 3x4</h3>
        <ul>
          <li>Foto recente, traje social e aparência condizente com documentos oficiais;</li>
          <li>Imagem nítida, boa iluminação e foco correto; <strong>sem edição ou filtros</strong>;</li>
          <li>Formato do arquivo: apenas <strong>.JPG</strong>.</li>
        </ul>
        <p><a class="btn btn-amarelo" href="modelo_de_foto.png" target="_blank" rel="noopener">⬇️ Ver modelo de foto</a></p>
        <p class="muted"><strong>⚠️</strong> Não será aceita foto fora destas orientações.</p>
      </article>

      <article class="card">
        <h3>🪪 Identificação Profissional</h3>
        <p>A Identificação da Associação dos Detetives do Brasil é válida em todo o território nacional.</p>
        <p><a class="btn btn-amarelo" href="modelooficial.jpg" target="_blank" rel="noopener">⬇️ Ver modelo oficial</a></p>
      </article>
    </section>

    <!-- Envio e assinatura -->
    <section id="envio" class="card">
      <h2 style="margin-top:0">📤 Envio da documentação & Assinatura</h2>
      <ul>
        <li>Digitalize <strong>diretamente do original</strong>, legível e completo (evite xerox escaneada/fotos borradas).</li>
        <li>Os documentos digitalizados devem conter <strong>assinatura GOV.BR</strong>.</li>
       <li>
  <a class="btn-whatsapp"
     href="https://wa.me/5548999180960?text=Olá!%20Preciso%20de%20suporte."
     target="_blank" rel="noopener noreferrer"
     aria-label="Enviar para o suporte via WhatsApp">
    Enviar para o suporte via WhatsApp: (48) 99918-0960
  </a>
</li>

<style>
  .btn-whatsapp{
    display:inline-flex;align-items:center;gap:.6rem;
    padding:.6rem 1rem;border-radius:999px;text-decoration:none;
    font:600 14px/1.1 system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
    background:#25D366;color:#000;border:1px solid #1da653;
    box-shadow:0 2px 6px rgba(0,0,0,.15);
  }
  .btn-whatsapp:hover{filter:brightness(0.95)}
  .btn-whatsapp::before{
    content:"";width:18px;height:18px;display:inline-block;
    background:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path fill="%23000" d="M19.1 17.2c-.3-.2-1.7-.8-2-.9-.3-.1-.5-.2-.7.2-.2.3-.8.9-1 .9s-.5 0-1-.5-1-1.1-1.3-1.6c-.3-.5 0-.7.2-.9.2-.2.3-.5.5-.7.2-.2.2-.3 0-.6-.1-.3-.7-1.7-.9-2s-.5-.5-.7-.5h-.6c-.2 0-.6.1-.9.5s-1.2 1.2-1.2 2.9 1.2 3.3 1.4 3.6c.2.3 2.4 3.7 5.9 5 3.5 1.4 3.5.9 4.2.8.6-.1 2-.8 2.3-1.6.3-.8.3-1.5.2-1.6-.1-.1-.3-.2-.6-.4z"/><path fill="%23000" d="M16 3C9.9 3 5 7.9 5 14c0 2 .6 3.9 1.7 5.5L5 29l9-1.6c1.5.8 3.1 1.1 4.9 1.1 6.1 0 11-4.9 11-11S22.1 3 16 3zm0 20.2c-1.6 0-3.1-.4-4.4-1.1l-.3-.2-5.4.9.9-5.3-.2-.3c-.9-1.4-1.4-3-1.4-4.6 0-4.9 4-8.9 8.9-8.9s8.9 4 8.9 8.9-4 8.9-8.9 8.9z"/></svg>') no-repeat center/contain;
  }
</style>

      </ul>
      <div class="cta">
        <a class="btn btn-azul" href="manual_gov_br.php" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:10px;text-decoration:none;">
          <img src="https://t2.tudocdn.net/697334?w=1200&h=1200" alt="GOV.BR" style="width:28px;height:28px;object-fit:contain;border-radius:4px;display:inline-block" loading="lazy" decoding="async">
          Assinatura GOV.br
        </a>
      </div>
    </section>
  </main>
</div>

<!-- Drawer mobile (sumário) + backdrop -->
<div class="drawer-backdrop" id="drawerBackdrop" hidden></div>
<aside class="drawer" id="tocDrawer" role="dialog" aria-modal="true" aria-label="Sumário de seções" aria-hidden="true">
  <div class="drawer__head">
    <div class="drawer__title">Sumário</div>
    <button class="drawer__close" id="drawerClose" aria-label="Fechar sumário">✖</button>
  </div>
  <div class="drawer__body">
    <ul>
      <li><a href="#aviso">⚠️ Aviso / Inscrição</a></li>
      <li><a href="#sobre">📘 Sobre o curso</a></li>
      <li><a href="#legislacao">📑 Legislação</a></li>
      <li><a href="#conteudos">🧭 Conteúdos</a></li>
      <li><a href="#docs">🗂️ Documentos</a></li>
      <li><a href="#envio">📤 Envio & Assinatura</a></li>
    </ul>
  </div>
</aside>

<!-- FAB WhatsApp (corrigido) -->
<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<style>
.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-transform: scale(1.5);
    transform: scale(1.5);
}

.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-filter: drop-shadow(0px 0px 5px rgba(255,20,147));
    filter: drop-shadow(0px 0px 20px rgba(255,20,147));
}

</style>
</a>

<footer style="max-width:1000px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center;">
  Associação dos Detetives do Brasil
</footer>

<!-- ===== JS: menu topo + sumário independentes (apenas CLICK) ===== -->
<script>
(function(){
  // ===== Elementos =====
  const navBtn   = document.getElementById('adbToggle');   // botão do menu topo
  const navMenu  = document.getElementById('adbMenu');     // UL do menu topo
  const tocBtn   = document.getElementById('tocOpen');     // botão do Sumário
  const drawer   = document.getElementById('tocDrawer');   // drawer do Sumário
  const backdrop = document.getElementById('drawerBackdrop');
  const closeBtn = document.getElementById('drawerClose');

  if (!navMenu || !navBtn || !tocBtn || !drawer || !backdrop) return;

  let scrollTopBeforeLock = 0;
  function lockScroll(on){
    if(on){
      scrollTopBeforeLock = window.pageYOffset || document.documentElement.scrollTop;
      document.body.style.top = `-${scrollTopBeforeLock}px`;
      document.body.style.position = 'fixed';
      document.body.style.width = '100%';
    }else{
      document.body.style.position = '';
      document.body.style.top = '';
      document.body.style.width = '';
      window.scrollTo(0, scrollTopBeforeLock);
    }
  }

  // ===== MENU TOPO =====
  function openNav(){
    navMenu.classList.add('open');
    navBtn.setAttribute('aria-expanded','true');
    closeDrawer(); // evita conflito
    lockScroll(true);
  }
  function closeNav(){
    navMenu.classList.remove('open');
    navBtn.setAttribute('aria-expanded','false');
    lockScroll(false);
  }
  function toggleNav(e){
    e && e.stopPropagation();
    navMenu.classList.contains('open') ? closeNav() : openNav();
  }

  // ===== SUMÁRIO (DRAWER) =====
  function openDrawer(){
    drawer.classList.add('open');
    drawer.setAttribute('aria-hidden','false');
    backdrop.hidden = false;
    void backdrop.offsetWidth; // reflow
    backdrop.classList.add('open');
    tocBtn.setAttribute('aria-expanded','true');
    closeNav(); // evita conflito
    lockScroll(true);
    if (closeBtn) closeBtn.focus();
  }
  function closeDrawer(){
    drawer.classList.remove('open');
    drawer.setAttribute('aria-hidden','true');
    backdrop.classList.remove('open');
    tocBtn.setAttribute('aria-expanded','false');
    setTimeout(()=>{ backdrop.hidden = true; }, 200);
    lockScroll(false);
  }
  function toggleDrawer(e){
    e && e.stopPropagation();
    drawer.classList.contains('open') ? closeDrawer() : openDrawer();
  }

  // Bindings (click)
  navBtn.addEventListener('click', toggleNav);
  tocBtn.addEventListener('click', toggleDrawer);
  backdrop.addEventListener('click', closeDrawer);
  if (closeBtn) closeBtn.addEventListener('click', closeDrawer);

  // Fecha ao clicar fora da navbar quando o menu topo estiver aberto
  document.addEventListener('click', (e)=>{
    if (!navMenu.classList.contains('open')) return;
    if (!e.target.closest('.adb-nav')) closeNav();
  }, true);

  // Fecha o sumário ao clicar em qualquer link dentro do drawer (com scroll suave)
  drawer.addEventListener('click', (e)=>{
    const a = e.target.closest('a[href^="#"]');
    if (!a) return;
    closeDrawer();
    const id = a.getAttribute('href').slice(1);
    const target = document.getElementById(id);
    if (target){
      e.preventDefault();
      target.scrollIntoView({behavior:'smooth', block:'start'});
    }
  });

  // Tecla ESC fecha ambos
  document.addEventListener('keydown', (e)=>{
    if (e.key === 'Escape'){
      if (drawer.classList.contains('open')) closeDrawer();
      if (navMenu.classList.contains('open')) closeNav();
    }
  });

  // Ao ir para desktop, garante tudo fechado
  window.addEventListener('resize', ()=>{
    if (window.innerWidth > 1024){
      closeNav();
      closeDrawer();
    }
  });

  // Evita estado travado ao voltar no histórico
  window.addEventListener('pageshow', ()=>{
    closeNav();
    closeDrawer();
  });
})();
</script>

<!-- === ADB • BOTÃO FLUTUANTE DE TRADUÇÃO (BANDEIRAS + BUSCA) • VERSÃO ESTÁVEL === -->
<div id="adb-translate">
  <button id="adb-translate-toggle" type="button" aria-label="Traduzir página">
    🌐 <span>Tradução</span>
  </button>

  <div id="adb-translate-panel" role="dialog" aria-label="Selecione um idioma">
    <div class="adb-translate-header">
      <input id="adb-translate-search" type="text" placeholder="Buscar idioma..." aria-label="Buscar idioma" />
      <button id="adb-translate-close" type="button" aria-label="Fechar">✖</button>
    </div>
    <div id="adb-translate-grid" aria-live="polite"></div>
    <div class="adb-translate-foot">
      <small>ASSOCIAÇÃO DOS DETETIVES DO BRASIL • ADB</small>
    </div>
  </div>
</div>

<!-- Elemento oculto necessário ao Google Translate -->
<div id="google_translate_element" style="display:none;"></div>

<style>
  :root{ --adb-black:#000; --adb-gold:#c9a34b; --adb-gray:#111; }
  #adb-translate{ position:fixed; bottom:20px; left:20px; z-index:2147483000; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif; }
  #adb-translate-toggle{ display:flex; align-items:center; gap:8px; background:var(--adb-black); color:var(--adb-gold); border:1px solid var(--adb-gold); border-radius:12px; padding:8px 12px; cursor:pointer; box-shadow:0 6px 14px rgba(0,0,0,.45); font-weight:600; }
  #adb-translate-toggle:hover{ filter:brightness(1.1); }
  #adb-translate-panel{ display:none; margin-top:10px; width:min(92vw, 720px); max-height:min(70vh, 560px); background:var(--adb-black); color:var(--adb-gold); border:1px solid var(--adb-gold); border-radius:14px; box-shadow:0 14px 40px rgba(0,0,0,.6); overflow:hidden; }
  #adb-translate.open #adb-translate-panel{ display:block; }
  .adb-translate-header{ display:flex; align-items:center; gap:8px; padding:10px; background:var(--adb-gray); border-bottom:1px solid #2a2a2a; }
  #adb-translate-search{ flex:1; padding:10px 12px; border-radius:10px; border:1px solid #333; background:#000; color:#eee; outline:none; }
  #adb-translate-search::placeholder{ color:#999; }
  #adb-translate-close{ background:#000; color:var(--adb-gold); border:1px solid var(--adb-gold); border-radius:10px; padding:8px 10px; cursor:pointer; }
  #adb-translate-close:hover{ background:#111; }
  #adb-translate-grid{ padding:10px; display:grid; grid-template-columns: repeat(6, 1fr); gap:8px; overflow:auto; max-height: calc(min(70vh, 560px) - 98px); }
  @media (max-width:640px){ #adb-translate-grid{ grid-template-columns: repeat(3, 1fr); } }
  .adb-lang{ display:flex; align-items:center; gap:8px; background:#0a0a0a; color:#ddd; border:1px solid #222; border-radius:10px; padding:8px; cursor:pointer; min-height:44px; }
  .adb-lang:hover{ border-color:var(--adb-gold); transform:translateY(-1px); }
  .adb-flag{ width:1.6em; display:inline-flex; align-items:center; justify-content:center; }
  .adb-flag .fi{ width:1.5em; height:1em; border-radius:2px; box-shadow:0 0 0 1px rgba(0,0,0,.25); }
  .adb-name{ font-size:13px; line-height:1.2; }
  .adb-code{ font-size:11px; opacity:.7; }

  /* Anti-banner do Google Translate */
  #goog-gt-tt, .goog-te-balloon-frame, .goog-te-menu-frame, .goog-te-banner-frame { display:none !important; visibility:hidden !important; opacity:0 !important; height:0 !important; }
  iframe.goog-te-banner-frame { display:none !important; }
  html, body { top:0 !important; margin-top:0 !important; transform:none !important; }
  html.translated-ltr body, html.translated-rtl body { top:0 !important; position:static !important; }
  body > .skiptranslate { display:none !important; }
</style>

<script>
(function(){
  'use strict';
  const BASE_CODES = 'pt,af,sq,am,ar,hy,as,ay,az,bm,eu,be,bn,bho,bs,bg,ca,ceb,zh-CN,zh-TW,co,hr,cs,da,dv,doi,nl,en,eo,et,ee,fil,fi,fr,fy,gl,ka,de,el,gn,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,ilo,id,ga,it,ja,jv,kn,kk,km,rw,gom,ko,kri,ku,ky,lo,la,lv,ln,lt,lg,lb,mk,mai,mg,ms,ml,mt,mi,mr,lus,mn,my,ne,no,nso,ny,or,om,ps,fa,pl,pt-PT,pa,qu,ro,ru,sm,sa,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,tg,ta,tt,te,th,ti,ts,tr,tk,tw,uk,ur,ug,uz,vi,xh,yi,yo,zu'.split(',');
  const MAP = {'pt':['Português (Original)','🇧🇷'], 'en':['Inglês','🇺🇸'], 'es':['Espanhol','🇪🇸'], 'fr':['Francês','🇫🇷'], 'de':['Alemão','🇩🇪'], 'it':['Italiano','🇮🇹'], 'ru':['Russo','🇷🇺'], 'ja':['Japonês','🇯🇵'], 'ko':['Coreano','🇰🇷'], 'zh-CN':['Chinês (Simplificado)','🇨🇳'], 'zh-TW':['Chinês (Tradicional)','🇹🇼'], 'ar':['Árabe','🇸🇦']};
  const ADB_LANGUAGES = BASE_CODES.map(code => { const arr = MAP[code] || [code,'🌐']; return { code, name:arr[0], flag:arr[1] }; });
  const ALIAS = { 'pt-BR':'pt', 'zh':'zh-CN' };

  window.googleTranslateElementInit = function(){
    try{
      new google.translate.TranslateElement({ pageLanguage:'pt', includedLanguages: ADB_LANGUAGES.map(l => l.code).join(','), autoDisplay:false }, 'google_translate_element');
    }catch(e){}
  };
  function normalize(code){ return ALIAS[code] || code; }
  function setCookie(lang){
    try{
      const pair = '/pt/' + normalize(lang);
      const domain = location.hostname.replace(/^www\./,'');
      const base = 'googtrans=' + pair + '; path=/;';
      document.cookie = base; document.cookie = base + ' domain=.' + domain + ';';
    }catch(e){}
  }
  function apply(lang){
    try{
      if(!lang) return;
      setCookie(lang);
      const sel = document.querySelector('select.goog-te-combo');
      if (sel){ sel.value = normalize(lang); sel.dispatchEvent(new Event('change', {bubbles:true})); antiBanner.trigger(); }
      else { location.reload(); }
    }catch(e){}
  }

  const root=document.getElementById('adb-translate');
  const toggle=document.getElementById('adb-translate-toggle');
  const panel=document.getElementById('adb-translate-panel');
  const closeBtn=document.getElementById('adb-translate-close');
  const grid=document.getElementById('adb-translate-grid');
  const search=document.getElementById('adb-translate-search');

  function itemHTML(lang){
    return '<button class="adb-lang" type="button" data-code="'+lang.code+'" title="'+lang.name+'">'
         +   '<span class="adb-flag">'+lang.flag+'</span>'
         +   '<div class="adb-meta"><div class="adb-name">'+lang.name+'</div><div class="adb-code">'+lang.code+'</div></div>'
         + '</button>';
  }
  function renderList(filter){
    try{
      const f=(filter||'').trim().toLowerCase();
      const list = ADB_LANGUAGES.filter(l => !f || l.name.toLowerCase().includes(f) || l.code.toLowerCase().includes(f));
      grid.innerHTML = list.map(itemHTML).join('');
      applySVGFlagsSafe();
    }catch(e){}
  }
  renderList('');

  toggle.addEventListener('click', ()=>{ root.classList.toggle('open'); if(root.classList.contains('open')) search.focus(); });
  closeBtn.addEventListener('click', ()=> root.classList.remove('open'));
  document.addEventListener('click', (e)=>{ const btn = e.target.closest('button.adb-lang'); if(btn){ apply(btn.getAttribute('data-code')); }});
  search.addEventListener('input', ()=>renderList(search.value));

  // Anti-banner agressivo e seguro
  const antiBanner = (function(){
    function kill(){
      try{
        document.querySelectorAll('iframe.goog-te-banner-frame, .goog-te-menu-frame, #goog-gt-tt, .goog-te-balloon-frame').forEach(el => el.remove());
        document.documentElement.style.top='0px'; document.body.style.top='0px'; document.body.style.position='static'; document.body.style.marginTop='0px'; document.body.style.transform='none';
      }catch(e){}
    }
    function burst(){ kill(); setTimeout(kill,200); setTimeout(kill,600); setTimeout(kill,1200); setTimeout(kill,2500); setTimeout(kill,4000); }
    try{ const obs=new MutationObserver(burst); obs.observe(document.documentElement,{childList:true,subtree:true}); }catch(e){}
    window.addEventListener('load', burst);
    window.addEventListener('resize', burst);
    window.addEventListener('orientationchange', burst);
    document.addEventListener('DOMContentLoaded', burst);
    return { trigger: burst };
  })();

  // Bandeiras SVG opcionais
  let flagCSSLoaded = false;
  try{
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css';
    link.onload = function(){ flagCSSLoaded = true; applySVGFlagsSafe(); };
    document.head.appendChild(link);
  }catch(e){}
  const FLAG_MAP = { 'pt':'br','pt-PT':'pt','en':'us','es':'es','fr':'fr','de':'de','it':'it','ru':'ru','ja':'jp','ko':'kr','zh-CN':'cn','zh-TW':'tw','ar':'sa' };
  function applySVGFlagsSafe(){
    try{
      if(!flagCSSLoaded) return;
      const gridEl = document.getElementById('adb-translate-grid');
      if(!gridEl) return;
      gridEl.querySelectorAll('.adb-lang').forEach(btn=>{
        const code = btn.getAttribute('data-code');
        const cc = FLAG_MAP[code];
        const holder = btn.querySelector('.adb-flag');
        if(holder && cc){ holder.innerHTML = '<span class="fi fi-'+cc+'"></span>'; }
      });
    }catch(e){}
  }
})();
</script>
<script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<!-- === / ADB • BOTÃO FLUTUANTE DE TRADUÇÃO === -->

</body>
</html>
