<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Detetives Associados — Curso de Formação</title>
<meta name="description" content="Informações oficiais do curso de formação para iniciantes, requisitos, documentos com assinatura GOV.BR e orientações completas.">
<meta name="keywords" content="detetive particular, curso de formação, investigação privada, ADB">
<meta property="og:title" content="Detetives Associados — Curso de Formação">
<meta property="og:description" content="Requisitos, matrícula e documentos com assinatura GOV.BR.">
<meta property="og:type" content="website">
<meta name="twitter:card" content="summary">

<style>
  :root{
    --bg:#ffffff;
    --paper:#fafafa;
    --ink:#0f172a;
    --muted:#6b7280;
    --line:#e5e7eb;
    --accent:#2563eb;
    --accent-2:#1d4ed8;
    --danger:#dc2626;
    --danger-2:#b91c1c;
    --radius:14px;
    --shadow:0 8px 24px rgba(15,23,42,.06);
    --max:1200px;
  }
  *{box-sizing:border-box}
  html,body{margin:0;padding:0;background:var(--bg);color:var(--ink);font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,Helvetica,sans-serif;line-height:1.6}

  /* Topbar */
  .topbar{position:sticky;top:0;z-index:60;background:#fff;border-bottom:1px solid var(--line)}
  .topbar__wrap{max-width:var(--max);margin:0 auto;padding:10px 16px;display:flex;gap:12px;align-items:center;justify-content:space-between}
  .brand{font-weight:800;letter-spacing:.2px}
  .menu-btn{display:inline-flex;align-items:center;justify-content:center;background:transparent;border:0;cursor:pointer;width:40px;height:40px;border-radius:8px}
  .menu-btn:focus-visible{outline:2px solid var(--accent);outline-offset:2px}

  /* Layout */
  .layout{max-width:var(--max);margin:0 auto;padding:0 16px;display:grid;grid-template-columns:280px 1fr;gap:22px}
  @media (max-width:1024px){ .layout{grid-template-columns:1fr} }

  /* TOC desktop */
  .toc{
    position:sticky; top:76px; align-self:start; background:#fff; border:1px solid var(--line);
    border-radius:var(--radius); box-shadow:var(--shadow); padding:16px; height:max-content;
  }
  .toc h2{margin:.2rem 0 8px;font-size:16px}
  .toc p{margin:0 0 8px;color:var(--muted);font-size:13px}
  .toc ul{list-style:none;margin:0;padding:0;display:grid;gap:6px}
  .toc a{display:block;text-decoration:none;color:var(--ink);padding:8px 10px;border-radius:10px;font-weight:600}
  .toc a:hover{background:var(--paper)}
  .toc .muted{color:var(--muted);font-weight:500}

  /* TOC mobile: drawer lateral + backdrop */
  @media (max-width:1024px){
    .toc{display:none} /* escondido no fluxo normal; usamos #tocDrawer */
  }
  .drawer-backdrop{
    position:fixed; inset:0; background:rgba(15,23,42,.45);
    backdrop-filter:saturate(120%) blur(2px);
    opacity:0; pointer-events:none; transition:opacity .2s ease; z-index:70;
  }
  .drawer{
    position:fixed; top:0; left:0; height:100vh; width:min(86vw, 340px);
    background:#fff; border-right:1px solid var(--line); box-shadow:var(--shadow);
    transform:translateX(-100%); transition:transform .25s ease; z-index:80;
    display:flex; flex-direction:column;
  }
  .drawer.open{ transform:translateX(0) }
  .drawer-backdrop.open{ opacity:1; pointer-events:auto }
  .drawer__head{
    display:flex; align-items:center; justify-content:space-between; gap:8px;
    padding:12px 14px; border-bottom:1px solid var(--line);
  }
  .drawer__title{font-weight:800}
  .drawer__close{background:transparent;border:0;cursor:pointer;width:40px;height:40px;border-radius:8px}
  .drawer__close:focus-visible{outline:2px solid var(--accent);outline-offset:2px}
  .drawer__body{padding:12px; overflow:auto}
  .drawer__body ul{list-style:none;margin:0;padding:0;display:grid;gap:6px}
  .drawer__body a{display:block;text-decoration:none;color:var(--ink);padding:10px 12px;border-radius:10px;font-weight:600}
  .drawer__body a:hover{background:var(--paper)}

  /* Conteúdo */
  .header{padding:22px 0 6px; border-bottom:1px solid var(--line); margin-bottom:16px}
  .header h1{margin:0 0 6px;font-size:28px}
  .header p{margin:0;color:var(--muted)}
  .notice{background:#fff;border:1px solid var(--line);border-left:4px solid var(--accent);border-radius:12px;padding:12px 14px;box-shadow:var(--shadow);margin:16px 0}
  .grid{display:grid;grid-template-columns:1fr 1fr;gap:16px}
  @media (max-width:800px){ .grid{grid-template-columns:1fr} }
  .card{background:#fff;border:1px solid var(--line);border-radius:var(--radius);padding:18px;box-shadow:var(--shadow)}
  .card h2,.card h3{margin-top:0}
  .muted{color:var(--muted)}
  .hr{height:1px;background:var(--line);margin:16px 0}

  /* Botões */
  .btn{display:inline-block;padding:11px 16px;border-radius:10px;font-weight:700;text-decoration:none;text-align:center;transition:.2s transform ease,.2s opacity ease,.2s background ease}
  .btn:hover{transform:translateY(-1px);opacity:.98}
  .btn:active{transform:none}
  .btn-primary{background:var(--accent);color:#fff}
  .btn-primary:hover{background:var(--accent-2)}
  .btn-danger{background:var(--danger);color:#fff}
  .btn-danger:hover{background:var(--danger-2)}
  .btn-plain{background:#fff;border:1px solid var(--line);color:var(--ink)}
  .cta{margin:14px 0;display:flex;gap:10px;flex-wrap:wrap}

  /* Seções */
  section{scroll-margin-top:90px}
  .section-title{margin:0 0 8px;font-size:22px}

  /* Rodapé */
  footer{max-width:var(--max);margin:24px auto 36px;padding:0 16px;color:var(--muted);font-size:13px;text-align:center}

  /* FAB WhatsApp */
  .wa{position:fixed;right:18px;bottom:18px;z-index:40;width:64px;height:64px;border-radius:50%;display:flex;align-items:center;justify-content:center;background:#22c55e;box-shadow:var(--shadow)}
  .wa img{width:34px;height:34px}
  @media (max-width:768px){.wa{right:14px;bottom:14px;width:60px;height:60px}.wa img{width:32px;height:32px}}

  /* Impressão */
  @media print{
    .topbar, .drawer, .drawer-backdrop, .toc, .wa, #adb-translate { display:none !important }
    .layout{grid-template-columns:1fr}
    .card{box-shadow:none}
    body{background:#fff}
  }
</style>
</head>
<body>

<!-- Topbar -->
<div class="topbar" role="navigation" aria-label="Navegação principal">
  <div class="topbar__wrap">
    <div class="brand">Detetives Associados</div>
    <!-- Botão abre o drawer no mobile -->
    <button class="menu-btn" id="menuBtn" aria-label="Abrir sumário" aria-controls="tocDrawer" aria-expanded="false" title="Sumário">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>
  </div>
</div>

<div class="layout">
  <!-- Sidebar desktop (fixa) -->
  <aside class="toc" aria-label="Sumário">
    <h2>Sumário</h2>
    <p class="muted">Acesse rapidamente cada seção</p>
    <ul>
      <li><a href="#sobre">📘 Sobre o curso</a></li>
      <li><a href="#conteudo">📚 Conteúdo programático</a></li>
      <li><a href="#docs">🗂️ Documentação obrigatória</a></li>
      <li><a href="#foto">🖼️ Foto 3x4</a></li>
      <li><a href="#taxa">💳 Taxa de inscrição</a></li>
      <li><a href="#ident">🪪 Identificação profissional</a></li>
      <li><a href="#envio">📤 Envio da documentação</a></li>
      <li><a href="#assinatura">🔐 Assinatura digital (GOV.BR)</a></li>
      <li><a href="#duvidas" class="muted">❓ Dúvidas e contato</a></li>
    </ul>
  </aside>

  <!-- Conteúdo -->
  <main>
    <div class="header">
      <h1>Curso de Formação</h1>
      <p>Informações oficiais, requisitos e orientações para matrícula.</p>
    </div>

    <div class="notice" role="note">
      <strong>Atenção:</strong> Os documentos digitalizados devem conter <strong>assinatura GOV.BR</strong> e ser digitalizados diretamente do original, legíveis e completos.
    </div>

    <div class="cta">
      <a class="btn btn-plain" href="manual_gov_br.php" target="_blank" rel="noopener">Assinatura GOV.br — Manual</a>
      <a class="btn btn-danger" href="detetives_associados_cadastro_para_o_curso_de_formacao.php">✅ Cadastre-se agora</a>
      <a class="btn btn-primary" href="https://www.planalto.gov.br/ccivil_03/leis/l9394.htm" target="_blank" rel="noopener">Ver Lei nº 9.394/96</a>
    </div>

    <!-- SOBRE -->
    <section id="sobre" class="card">
      <h2 class="section-title">📘 Sobre o curso</h2>
      Início: Imediato,<br>
      Duração: 02 Meses,<br>
      Carga Horária: 840 horas,<br>
      Modalidade: A distância. <br>
      <div class="hr"></div>
      <p>
        Lei de Diretrizes e Bases da Educação Nacional (LDB) – Lei nº 9.394/96: estabelece as bases da educação no Brasil, incluindo a modalidade de educação profissional e tecnológica, na qual os cursos livres se inserem.<br>
        Decreto nº 5.154/2004.
      </p>
    </section>

    <!-- CONTEÚDO PROGRAMÁTICO -->
    <section id="conteudo" class="grid">
      <div class="card">
        <h2 class="section-title">📚 Conteúdo programático</h2>
        <p>
          A Profissão de Detetive Particular<br>
          Investigador Privado<br>
          Investigador Criminal<br>
          A Investigação Criminal<br>
          Lofoscopia<br>
          Vestígio<br>
          Entrevista Investigativa<br>
          Perícia Criminal<br>
          Investigação Conjugal<br>
          Investigação de Localização de Pessoas
        </p>
      </div>
      <div class="card">
        <h3 style="margin-top:0">Complementos</h3>
        <p>
          Espionagem<br>
          Localização de Devedores<br>
          Psicologia da Mentira<br>
          Conflito Aparente de Normas Penais<br>
          Direito Penal do Crime<br>
          Classificação de Crimes<br>
          Morte Violenta<br>
          Procedimentos para Campana Fixa<br>
          Técnicas de Operações de Vigilância Dinâmica<br>
          Outros Conhecimentos na Investigação
        </p>
      </div>
    </section>

    <!-- DOCUMENTAÇÃO -->
    <section id="docs" class="grid">
      <div class="card">
        <h2 class="section-title">🗂️ Documentação obrigatória</h2>

        <h3>🧾 CPF</h3>
        <p>Cópia do CPF.</p>

        <h3>🪪 Identidade ou CNH</h3>
        <p>Cópia do RG ou da Carteira Nacional de Habilitação.</p>

        <h3>🏠 Comprovante de residência</h3>
        <p>Conta de água, luz ou telefone fixo.</p>
        <ul>
          <li>Se em nome do cônjuge/companheiro(a): apresentar Certidão de Casamento ou de União Estável.</li>
          <li>Se não for cônjuge nem titular: declaração com firma reconhecida do titular da conta ou do proprietário do imóvel.</li>
        </ul>
        <p><a class="btn btn-primary" href="imprimir_declaracao_de_residencia.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>
      </div>

      <div class="card">
        <h3>✍️ Declaração de Aceitação</h3>
        <p>Declaração de aceitação assinada.</p>
        <p><a class="btn btn-primary" href="imprimir_declaracao_de_aceitacao.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>

        <div class="hr"></div>

        <h3>🩸 Tipo Sanguíneo</h3>
        <p>Cópia do exame ou declaração do seu tipo sanguíneo.</p>
        <p><a class="btn btn-primary" href="imprimir_declaracao_de_tipo_sanguineo.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a></p>

        <div class="hr"></div>

        <h3>🧾 Comprovação de Idoneidade</h3>
        <p>Apresentar certidões negativas de antecedentes criminais fornecidas pela delegacia da sua cidade.</p>
      </div>
    </section>

    <!-- FOTO -->
    <section id="foto" class="card">
      <h2 class="section-title">🖼️ Foto 3x4</h2>
      <ul>
        <li>Foto recente 3x4, traje social e aparência condizente com documentos oficiais;</li>
        <li>Imagem nítida, boa iluminação e foco correto;</li>
        <li>Digitalizada do original, sem edição ou filtros;</li>
        <li>Formato do arquivo: apenas .JPG.</li>
      </ul>
      <p><a class="btn btn-plain" href="modelo_de_foto.png" target="_blank" rel="noopener">⬇️ Ver modelo de foto</a></p>
      <p class="muted"><strong>⚠️</strong> Não será aceita foto fora destas orientações.</p>
    </section>

    <!-- TAXA -->
    <section id="taxa" class="card">
      <h2 class="section-title">💳 Taxa de Inscrição – Pagamento Único</h2>
      <p>Valor: <strong>R$ 490,00</strong></p>
      <p>
        <strong>Favorecido:</strong> Eliane de Fátima Cezaro<br>
        <strong>Chave PIX (Celular):</strong> 43 99963-8644
      </p>
      <p class="muted" style="font-style:italic;">
        💬 Após o pagamento, o aluno deverá enviar o comprovante para confirmação da matrícula e liberação do acesso ao conteúdo completo do curso.
      </p>
      <div class="cta">
        <a class="btn btn-danger" href="detetives_associados_cadastro_para_o_curso_de_formacao.php">✅ Cadastre-se agora</a>
      </div>
    </section>

    <!-- IDENTIFICAÇÃO -->
    <section id="ident" class="card">
      <h2 class="section-title">🪪 Identificação Profissional</h2>
      <p>A Identificação da Associação dos Detetives do Brasil é válida em todo o território nacional.</p>
      <p><a class="btn btn-plain" href="modelooficial.jpg" target="_blank" rel="noopener">⬇️ Ver modelo oficial</a></p>
    </section>

    <!-- ENVIO -->
    <section id="envio" class="card">
      <h2 class="section-title">📤 Envio da Documentação</h2>
      <p>
        Envie a digitalização diretamente do original, legível e completa. Não serão aceitas cópias de xerox escaneadas, fotos borradas ou documentos com dados incompletos.<br>
        <strong>Email:</strong> detetivetpmas308@gmail.com
      </p>
    </section>

    <!-- ASSINATURA DIGITAL -->
    <section id="assinatura" class="card">
      <h2 class="section-title">🔐 Importância da Assinatura Digital (GOV.BR)</h2>
      <ul>
        <li><strong>Autenticidade</strong> — confirma que o documento realmente foi emitido e assinado pelo titular;</li>
        <li><strong>Integridade</strong> — assegura que o conteúdo não foi alterado após a assinatura;</li>
        <li><strong>Segurança jurídica</strong> — validade legal em todo o território nacional;</li>
        <li><strong>Confiança</strong> — fortalece a credibilidade do sistema da ADB.</li>
      </ul>
      <div class="cta">
        <a class="btn btn-plain" href="manual_gov_br.php" target="_blank" rel="noopener">Assinatura GOV.br — Manual</a>
      </div>
    </section>

    <!-- DÚVIDAS -->
    <section id="duvidas" class="card">
      <h2 class="section-title">❓ Dúvidas e Contato</h2>
      <p class="muted">Use o botão do WhatsApp no canto inferior direito para falar com o suporte.</p>
    </section>
  </main>
</div>

<!-- Drawer mobile (sumário) + backdrop -->
<div class="drawer-backdrop" id="drawerBackdrop" hidden></div>
<aside class="drawer" id="tocDrawer" role="dialog" aria-modal="true" aria-label="Sumário de seções" aria-hidden="true">
  <div class="drawer__head">
    <div class="drawer__title">Sumário</div>
    <button class="drawer__close" id="drawerClose" aria-label="Fechar sumário">
      ✖
    </button>
  </div>
  <div class="drawer__body">
    <ul>
      <li><a href="#sobre">📘 Sobre o curso</a></li>
      <li><a href="#conteudo">📚 Conteúdo programático</a></li>
      <li><a href="#docs">🗂️ Documentação obrigatória</a></li>
      <li><a href="#foto">🖼️ Foto 3x4</a></li>
      <li><a href="#taxa">💳 Taxa de inscrição</a></li>
      <li><a href="#ident">🪪 Identificação profissional</a></li>
      <li><a href="#envio">📤 Envio da documentação</a></li>
      <li><a href="#assinatura">🔐 Assinatura digital (GOV.BR)</a></li>
      <li><a href="#duvidas" class="muted">❓ Dúvidas e contato</a></li>
    </ul>
  </div>
</aside>

<!-- FAB WhatsApp -->
<a href="https://api.whatsapp.com/send?phone=5543999638644" target="_blank" class="wa" aria-label="Abrir WhatsApp">
  <img src="WhatsAppPNG.png" alt="WhatsApp">
</a>

<footer>
  Associação dos Detetives do Brasil
</footer>

<!-- JS: Drawer responsivo do sumário -->
<script>
(function(){
  const btn = document.getElementById('menuBtn');
  const drawer = document.getElementById('tocDrawer');
  const closeBtn = document.getElementById('drawerClose');
  const backdrop = document.getElementById('drawerBackdrop');

  function openDrawer(){
    drawer.classList.add('open');
    drawer.setAttribute('aria-hidden','false');
    backdrop.hidden = false;
    requestAnimationFrame(()=> backdrop.classList.add('open'));
    btn.setAttribute('aria-expanded','true');
    document.body.style.overflow='hidden';
    // foco acessível
    closeBtn.focus();
  }
  function closeDrawer(){
    drawer.classList.remove('open');
    drawer.setAttribute('aria-hidden','true');
    backdrop.classList.remove('open');
    btn.setAttribute('aria-expanded','false');
    document.body.style.overflow='';
    setTimeout(()=>{ backdrop.hidden = true; }, 200);
    btn.focus();
  }

  // Abrir/fechar
  btn.addEventListener('click', openDrawer);
  closeBtn.addEventListener('click', closeDrawer);
  backdrop.addEventListener('click', closeDrawer);
  document.addEventListener('keydown', (e)=>{ if(e.key==='Escape' && drawer.classList.contains('open')) closeDrawer(); });

  // Fechar ao escolher seção (mobile UX)
  drawer.addEventListener('click', (e)=>{
    const link = e.target.closest('a[href^="#"]');
    if(!link) return;
    // pequeno atraso para permitir o scroll da âncora
    setTimeout(closeDrawer, 50);
  });

  // Se voltar para desktop, garante fechado
  window.addEventListener('resize', ()=>{
    if (window.innerWidth > 1024 && drawer.classList.contains('open')) closeDrawer();
  });
})();
</script>

<!-- ===== TRADUÇÃO (opcional; sem logos) ===== -->
<div id="adb-translate">
  <button id="adb-translate-toggle" type="button" aria-label="Traduzir página" style="position:fixed;bottom:20px;left:20px;z-index:2147483000;background:#000;color:#c9a34b;border:1px solid #c9a34b;border-radius:12px;padding:8px 12px;cursor:pointer;box-shadow:0 6px 14px rgba(0,0,0,.45);font-weight:600">🌐 <span>Tradução</span></button>
  <div id="adb-translate-panel" role="dialog" aria-label="Selecione um idioma" style="display:none;position:fixed;bottom:70px;left:20px;z-index:2147483000;width:min(92vw, 720px);max-height:min(70vh, 560px);background:#000;color:#c9a34b;border:1px solid #c9a34b;border-radius:14px;box-shadow:0 14px 40px rgba(0,0,0,.6);overflow:hidden">
    <div class="adb-translate-header" style="display:flex;align-items:center;gap:8px;padding:10px;background:#111;border-bottom:1px solid #2a2a2a">
      <input id="adb-translate-search" type="text" placeholder="Buscar idioma..." aria-label="Buscar idioma" style="flex:1;padding:10px 12px;border-radius:10px;border:1px solid #333;background:#000;color:#eee;outline:none" />
      <button id="adb-translate-close" type="button" aria-label="Fechar" style="background:#000;color:#c9a34b;border:1px solid #c9a34b;border-radius:10px;padding:8px 10px;cursor:pointer">✖</button>
    </div>
    <div id="adb-translate-grid" aria-live="polite" style="padding:10px;display:grid;grid-template-columns: repeat(6, 1fr);gap:8px;overflow:auto;max-height: calc(min(70vh, 560px) - 98px)"></div>
    <div class="adb-translate-foot" style="padding:8px 10px;border-top:1px solid #2a2a2a;text-align:center;background:#0b0b0b"><small style="color:#9a865b">ASSOCIAÇÃO DOS DETETIVES DO BRASIL • ADB</small></div>
  </div>
</div>
<div id="google_translate_element" style="display:none;"></div>

<script>
(function(){
  'use strict';
  const BASE_CODES = 'pt,en,es,fr,de,it,ru,ja,ko,zh-CN,zh-TW,ar'.split(',');
  const NAMES = {pt:'Português (Original)',en:'Inglês',es:'Espanhol',fr:'Francês',de:'Alemão',it:'Italiano',ru:'Russo',ja:'Japonês',ko:'Coreano','zh-CN':'Chinês (Simplificado)','zh-TW':'Chinês (Tradicional)',ar:'Árabe'};
  const ADB_LANGUAGES = BASE_CODES.map(code => ({ code, name:NAMES[code]||code, flag:'🌐'}));
  const ALIAS = { 'pt-BR':'pt', 'zh':'zh-CN' };
  window.googleTranslateElementInit = function(){ try{ new google.translate.TranslateElement({ pageLanguage:'pt', includedLanguages: ADB_LANGUAGES.map(l => l.code).join(','), autoDisplay:false }, 'google_translate_element'); }catch(e){} };
  function normalize(code){ return ALIAS[code] || code; }
  function setCookie(lang){ try{ const pair='/pt/'+normalize(lang); const domain=location.hostname.replace(/^www\./,''); const base='googtrans='+pair+'; path=/;'; document.cookie=base; document.cookie=base+' domain=.'+domain+';'; }catch(e){} }
  function apply(lang){
    try{ if(!lang) return; setCookie(lang);
      const sel=document.querySelector('select.goog-te-combo');
      if (sel){ sel.value = normalize(lang); sel.dispatchEvent(new Event('change',{bubbles:true})); antiBanner.trigger(); }
      else { location.reload(); }
    }catch(e){}
  }
  const toggle=document.getElementById('adb-translate-toggle');
  const panel=document.getElementById('adb-translate-panel');
  const closeB=document.getElementById('adb-translate-close');
  const grid=document.getElementById('adb-translate-grid');
  const search=document.getElementById('adb-translate-search');
  function itemHTML(lang){ return '<button class="adb-lang" type="button" data-code="'+lang.code+'" title="'+lang.name+'" style="display:flex;align-items:center;gap:8px;background:#0a0a0a;color:#ddd;border:1px solid #222;border-radius:10px;padding:8px;cursor:pointer;min-height:44px"><span>'+lang.flag+'</span><div><div style="font-size:13px">'+lang.name+'</div><div style="font-size:11px;opacity:.7">'+lang.code+'</div></div></button>'; }
  function renderList(f){
    const txt=(f||'').trim().toLowerCase();
    const list=ADB_LANGUAGES.filter(l=>!txt||l.name.toLowerCase().includes(txt)||l.code.toLowerCase().includes(txt));
    grid.innerHTML=list.map(itemHTML).join('');
  }
  renderList('');
  toggle.addEventListener('click', ()=>{ panel.style.display = panel.style.display==='block' ? 'none' : 'block'; if(panel.style.display==='block') search.focus(); });
  closeB.addEventListener('click', ()=> panel.style.display='none');
  document.addEventListener('click', (e)=>{ const btn = e.target.closest('.adb-lang'); if(btn){ apply(btn.getAttribute('data-code')); }});
  search.addEventListener('input', ()=>renderList(search.value));
  const antiBanner=(function(){ function kill(){ try{ document.querySelectorAll('iframe.goog-te-banner-frame,.goog-te-menu-frame,#goog-gt-tt,.goog-te-balloon-frame').forEach(el=>el.remove()); document.documentElement.style.top='0px'; document.body.style.top='0px'; document.body.style.position='static'; document.body.style.marginTop='0px'; document.body.style.transform='none'; }catch(e){} }
    function burst(){ kill(); setTimeout(kill,200); setTimeout(kill,600); setTimeout(kill,1200); setTimeout(kill,2500); setTimeout(kill,4000); }
    try{ const obs=new MutationObserver(burst); obs.observe(document.documentElement,{childList:true,subtree:true}); }catch(e){}
    window.addEventListener('load', burst); window.addEventListener('resize', burst); window.addEventListener('orientationchange', burst); document.addEventListener('DOMContentLoaded', burst);
    return { trigger: burst }; })();
})();
</script>
<script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

</body>
</html>
