<?php
// ======== INCLUDES ORIGINAIS ========
require_once('Connections/banco.php');
require_once('includes/common/KT_common.php');
require_once('includes/tng/tNG.inc.php');

// ======== DIAGNÓSTICO OPCIONAL ========
$DEBUG = isset($_GET['debug']) ? true : false;

// ======== GARANTIR SESSÃO ========
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

// ======== VERIFICA/ABRE CONEXÃO LEGADA (mysql_*) ========
// Esperado do Connections/banco.php: $banco (link), $database_banco, e possivelmente $hostname_banco, $username_banco, $password_banco.
if (!isset($banco) || !is_resource($banco)) {
  // tenta abrir com variáveis padrão do Dreamweaver (se existirem)
  if (isset($hostname_banco, $username_banco, $password_banco)) {
    $banco = @mysql_connect($hostname_banco, $username_banco, $password_banco);
  }
}
if (!$banco) {
  // última tentativa: aborta com erro claro
  header('Content-Type: text/html; charset=UTF-8');
  echo "<h3>Erro de conexão MySQL (mysql_connect)</h3>";
  echo "<pre>".htmlspecialchars(mysql_error(), ENT_QUOTES, 'UTF-8')."</pre>";
  if ($DEBUG) {
    echo "<p>Verifique se <code>Connections/banco.php</code> define \$hostname_banco, \$username_banco, \$password_banco e \$database_banco, 
    e se cria \$banco (mysql_connect/mysql_pconnect).</p>";
  }
  exit;
}

// Seleciona o DB
if (!@mysql_select_db($database_banco, $banco)) {
  header('Content-Type: text/html; charset=UTF-8');
  echo "<h3>Erro ao selecionar o banco <code>{$database_banco}</code></h3>";
  echo "<pre>".htmlspecialchars(mysql_error(), ENT_QUOTES, 'UTF-8')."</pre>";
  exit;
}

// ======== tNG dispatcher (mantido) ========
$tNGs = new tNG_dispatcher("");
$conn_banco = new KT_connection($banco, $database_banco);

// ======== GetSQLValueString (mantido) ========
if (!function_exists("GetSQLValueString")) {
  function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
    if (PHP_VERSION < 6) {
      $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
    }
    $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);
    switch ($theType) {
      case "text":   $theValue = ($theValue != "") ? "'".$theValue."'" : "NULL"; break;
      case "long":
      case "int":    $theValue = ($theValue != "") ? intval($theValue) : "NULL"; break;
      case "double": $theValue = ($theValue != "") ? doubleval($theValue) : "NULL"; break;
      case "date":   $theValue = ($theValue != "") ? "'".$theValue."'" : "NULL"; break;
      case "defined":$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue; break;
    }
    return $theValue;
  }
}

// ======== ENTRADA: RESTRITO (código ADB) ========
$colname_ConsultaDetetive = "-1";
if (isset($_POST['restrito'])) {
  $colname_ConsultaDetetive = $_POST['restrito'];
} elseif (isset($_GET['restrito'])) { // facilita testar via URL
  $colname_ConsultaDetetive = $_GET['restrito'];
}

// ======== CONSULTA DETETIVE (mantida, com JOIN explícito e erros visíveis em DEBUG) ========
$query_ConsultaDetetive = sprintf(
  "SELECT cd.*, 
          CAST((TO_DAYS(NOW()) - TO_DAYS(cd.data_nascimento)) / 365.25 AS SIGNED) AS idade,
          es.nm_estado AS estado_residencia
     FROM cadastro_detetive cd
     JOIN estado es ON cd.cd_estado = es.cd_estado
    WHERE cd.restrito = %s",
  GetSQLValueString($colname_ConsultaDetetive, "text")
);
$ConsultaDetetive = mysql_query($query_ConsultaDetetive, $banco);
if ($ConsultaDetetive === false) {
  header('Content-Type: text/html; charset=UTF-8');
  echo "<h3>Erro na consulta do detetive</h3>";
  echo "<pre>".htmlspecialchars(mysql_error(), ENT_QUOTES, 'UTF-8')."</pre>";
  if ($DEBUG) echo "<pre>SQL:\n{$query_ConsultaDetetive}</pre>";
  exit;
}
$row_ConsultaDetetive = mysql_fetch_assoc($ConsultaDetetive);
$totalRows_ConsultaDetetive = mysql_num_rows($ConsultaDetetive);

// ======== CONSULTA USUÁRIO LOGADO (mantida) ========
$colname_ConsultaUsuario = "-1";
if (isset($_SESSION['kt_login_id'])) {
  $colname_ConsultaUsuario = $_SESSION['kt_login_id'];
}
$query_ConsultaUsuario = sprintf("SELECT * FROM usuario WHERE cd_usuario = %s", GetSQLValueString($colname_ConsultaUsuario, "int"));
$ConsultaUsuario = mysql_query($query_ConsultaUsuario, $banco);
if ($ConsultaUsuario === false && $DEBUG) {
  // não é fatal para renderizar a declaração, mas mostra no debug
  $usuarioErro = mysql_error();
} else {
  $row_ConsultaUsuario = mysql_fetch_assoc($ConsultaUsuario);
  $totalRows_ConsultaUsuario = isset($ConsultaUsuario) ? mysql_num_rows($ConsultaUsuario) : 0;
}

// ======== LOGOUT TRANSACTION (mantida) ========
$logoutTransaction = new tNG_logoutTransaction($conn_banco);
$tNGs->addTransaction($logoutTransaction);
$logoutTransaction->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "GET", "KT_logout_now");
$logoutTransaction->registerTrigger("END", "Trigger_Default_Redirect", 99, "index.php");
$tNGs->executeTransactions();
$rscustom = $tNGs->getRecordset("custom");
if ($rscustom) {
  $row_rscustom = @mysql_fetch_assoc($rscustom);
  $totalRows_rscustom = @mysql_num_rows($rscustom);
}

// ======== HELPERS ========
function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function data_extenso_ptbr($ts = null){
  $ts = $ts ?: time();
  $meses = ['janeiro','fevereiro','março','abril','maio','junho','julho','agosto','setembro','outubro','novembro','dezembro'];
  return date('d',$ts).' de '.$meses[(int)date('m',$ts)-1].' de '.date('Y',$ts);
}

// ======== CAMPOS DO DETETIVE ========
$cnpj  = "13.329.080/0001-75";
$nome_detetive = $totalRows_ConsultaDetetive ? e($row_ConsultaDetetive['nome_detetive']) : '';
$cpf_cnpj      = $totalRows_ConsultaDetetive ? e($row_ConsultaDetetive['cpf_cnpj']) : '';
$codigo_adb    = $totalRows_ConsultaDetetive ? e($row_ConsultaDetetive['restrito']) : '';
$validade_doc  = $totalRows_ConsultaDetetive ? e($row_ConsultaDetetive['observacao']) : '';
$cidade        = $totalRows_ConsultaDetetive && !empty($row_ConsultaDetetive['cidade']) ? e($row_ConsultaDetetive['cidade']) : 'Lauro Müller';
$uf            = $totalRows_ConsultaDetetive && !empty($row_ConsultaDetetive['estado_residencia']) ? e($row_ConsultaDetetive['estado_residencia']) : 'SC';
$data_extenso  = data_extenso_ptbr();

// ======== ALERTA QUANDO NÃO ENCONTRAR O CÓDIGO ========
$avisoSemRegistro = (!$totalRows_ConsultaDetetive);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Declaração de Recomendação Profissional | ADB</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    /* Base e layout */
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB centralizado */
    .header{
      background:#000; color:#d4af37; padding:20px 12px;
      display:flex; flex-direction:column; align-items:center; text-align:center;
    }
    .header img{height:80px; display:block; margin:0 auto}
    .header h1{margin:6px 0; color:#fff; font-size:22px}
    .header .idline{margin:4px 0; color:#f0e6b2; font-size:13px; display:block; text-align:center}

    p{line-height:1.7; text-align:justify}
    .assinatura{margin-top:28px; text-align:center}
    .assin-gov-caixa{border:1px dashed #888;border-radius:8px;padding:18px;min-height:96px;display:flex;align-items:center;justify-content:center;text-align:center;color:#333;font-style:italic;margin-top:20px}
    .assin-linha{margin-top:14px;border-top:1px solid #000;padding-top:8px}

    .local-data{margin:16px 0; text-align:right}
    .btns{display:flex;gap:10px;justify-content:flex-end;margin:20px 0}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#000;color:#fff;font-weight:700;cursor:pointer}

    /* Painel de debug */
    .debug{padding:10px 14px;background:#fff7cc;border:1px solid #e6d484;color:#5a4d00;margin:16px 24px;border-radius:8px;font-size:14px}

    @media print{
      @page{size:A4;margin:14mm}
      .btns,.debug{display:none!important}
      .container{box-shadow:none}
      body{background:#fff}
      .header{ text-align:center; align-items:center }
    }
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="https://www.associacaodosdetetives.com.br/logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <?php if ($DEBUG): ?>
    <div class="debug">
      <strong>DEBUG</strong><br>
      Conexão: OK (mysql\_*)<br>
      Banco selecionado: <?php echo e($database_banco); ?><br>
      Parâmetro <code>restrito</code>: <strong><?php echo e($colname_ConsultaDetetive); ?></strong><br>
      Total de registros (detetive): <strong><?php echo (int)$totalRows_ConsultaDetetive; ?></strong><br>
      <?php if (isset($usuarioErro)): ?>
        Erro consulta usuário: <pre><?php echo e($usuarioErro); ?></pre>
      <?php endif; ?>
      <?php if ($avisoSemRegistro): ?>
        <div style="margin-top:8px;color:#a10000"><strong>Aviso:</strong> nenhum detetive encontrado para este código ADB.</div>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <div class="main">
    <h2>Declaração de Recomendação Profissional</h2>

    <?php if ($avisoSemRegistro): ?>
      <p style="color:#a10000"><strong>Não encontramos o cadastro para o código informado.</strong> 
      Recarregue esta página enviando um <em>POST</em> com <code>restrito=ADB-12345</code> (ou use <code>?restrito=ADB-12345</code> na URL para teste).</p>
    <?php endif; ?>

    <p>
      A <strong>Associação dos Detetives do Brasil (ADB)</strong>, no uso de suas atribuições legais,
      <strong>declara para os devidos fins</strong> que o(a) profissional abaixo identificado(a) integra
      regularmente o nosso quadro de associados, exercendo a atividade de
      <strong>Detetive Particular</strong>, conforme dispõe a
      <strong>Lei Federal nº 13.432, de 11 de abril de 2017</strong>, que regulamenta o exercício da profissão em território nacional.
    </p>

    <p>
      <strong>Dados do Profissional:</strong><br>
      Nome: <strong><?php echo $nome_detetive ?: '—'; ?></strong>,
      CPF/CNPJ: <strong><?php echo $cpf_cnpj ?: '—'; ?></strong>,
      Matricula na ADB: <strong><?php echo $codigo_adb ?: e($colname_ConsultaDetetive); ?></strong><br>
    </p>

    <p>
      Informamos que o(a) referido(a) profissional encontra-se
      <strong>devidamente identificado por esta entidade</strong>, com cadastro atualizado e regular,
      possuindo <strong>documentação comprobatória da sua habilitação técnica e legal</strong>,
      de acordo com os critérios estabelecidos pela legislação vigente.
    </p>

    <p>
      Ressaltamos que o(a) profissional demonstra <strong>conduta ética, responsabilidade, sigilo e comprometimento</strong>
      no exercício de suas atividades investigativas, sendo reconhecido(a) por sua
      <strong>qualificação, postura profissional e respeito às normas</strong> que regem a categoria.
    </p>

    <p>
      Diante do exposto, a Associação dos Detetives do Brasil
      <strong>recomenda formalmente os serviços prestados por este(a) detetive particular</strong>,
      considerando-o(a) apto(a) para atuar em demandas de natureza investigativa no âmbito privado.
    </p>

    <p class="local-data">
      <?php echo $cidade; ?> - <?php echo $uf; ?>, <?php echo e($data_extenso); ?>
    </p>

    <p>
      <strong>Data de validade deste documento:</strong>
      <span><?php echo $validade_doc !== '' ? $validade_doc : '—'; ?></span>
    </p>
    </div>

    <div class="btns">
      <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar como PDF</button>
    </div>
  </div>
</div>
</body>
</html>
<?php
// ======== LIBERA RECURSOS EXISTENTES ========
if (isset($ConsultaDetetive) && is_resource($ConsultaDetetive)) mysql_free_result($ConsultaDetetive);
if (isset($ConsultaUsuario)  && is_resource($ConsultaUsuario))  mysql_free_result($ConsultaUsuario);
?>
