<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – Comunicação Oficial</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    *{box-sizing:border-box}
    body{font-family:Arial,Helvetica,sans-serif;margin:0;background:#f5f5f5;color:#111;line-height:1.6}
    .container{max-width:900px;margin:28px auto;background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 3px 15px rgba(0,0,0,.1)}
    .main{padding:24px}
    h2{text-align:center;margin:6px 0 16px}

    /* Cabeçalho ADB centralizado */
    .header{
      background:#000; color:#d4af37; padding:20px 12px;
      display:flex; flex-direction:column; align-items:center; text-align:center;
    }
    .header img{height:80px; display:block; margin:0 auto}
    .header h1{margin:6px 0; color:#fff; font-size:22px}
    .header .idline{margin:4px 0; color:#f0e6b2; font-size:13px; display:block}

    .lead{background:#fff7cc;border:1px solid #ffe08a;color:#5a4d00;padding:12px 14px;border-radius:10px;margin:0 0 16px 0}
    p{text-align:justify}
    .no-print{display:block}
    .btn{padding:10px 16px;border:0;border-radius:8px;background:#004aad;color:#fff;font-weight:700;cursor:pointer}
    .btn:hover{opacity:.92}
    .btn-danger{background:#b91c1c}
    .muted{color:#4b5563}

    .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    .form-row{display:flex;gap:10px;flex-wrap:wrap}
    label{font-weight:700;display:block;margin-bottom:4px}
    input[type="text"]{
      width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;
    }

    /* Equipe (na tela o nome tem linha embaixo; na impressão vira texto puro) */
    .campo-nome{
      width: 420px; max-width: 100%;
      display: inline-block; vertical-align: middle;
      font-weight: 700; background: transparent;
      border: 0; border-bottom: 1px solid #000; padding: 2px 4px;
      white-space: normal !important; word-break: break-word; overflow-wrap: anywhere;
    }

    /* Bloco equipe no documento (evitar quebra feia) */
    .equipe-bloco{ break-inside: avoid; page-break-inside: avoid; margin-top:12px; }
    .equipe-titulo{ margin:0 0 8px 0; break-after: avoid; page-break-after: avoid; }
    .equipe-lista{ margin-left:16px; break-inside: avoid; page-break-inside: avoid; }
    .equipe-lista li{ break-inside: avoid; page-break-inside: avoid; }

    /* Assinaturas (profissional e autoridade) */
    .assinaturas-duplas{
      margin-top:28px;
      display:flex; gap:18px; align-items:flex-start; justify-content:space-between; flex-wrap:wrap;
      break-inside: avoid; page-break-inside: avoid;
    }
    .assin-card{
      flex:1 1 410px;
      border:1px solid #e5e7eb; border-radius:12px;
      padding:16px; background:#fff;
      break-inside: avoid; page-break-inside: avoid;
      min-width:380px;
    }
    .assin-titulo{ font-weight:700; text-align:center; margin-bottom:12px; }
    .assin-area{
      border:1px dashed #888; border-radius:8px; height:120px;
      background:#fafafa; margin:10px 0 12px;
    }
    .assin-linha{ margin-top:18px; border-top:1px solid #000; padding-top:6px; text-align:center; }
    .assin-meta{ font-size:13px; color:#4b5563; text-align:center; margin-top:4px; }

    /* Local e data */
    .local-data{
      text-align:center; margin-top:10px;
      break-inside: avoid; page-break-inside: avoid;
    }
    .campo-data{
      display:inline-block; min-width:115px; text-align:left;
      border:0; border-bottom:1px solid #000; background:transparent; padding:2px 4px;
      font: inherit; letter-spacing:.5px;
    }

    /* Lista equipe (formulário) */
    .team-row{display:flex;align-items:center;gap:8px;margin-bottom:8px}
    .team-row input{flex:1}

    @media (max-width: 768px){
      .form-grid{grid-template-columns:1fr}
      .assin-card{ min-width:auto; }
    }

    /* Impressão: esconder form e botões; inputs viram texto simples */
    @media print{
      .no-print{ display:none !important; }
      input, textarea, select{ border:0 !important; background:transparent !important; box-shadow:none !important; outline:0 !important; padding:0 !important; margin:0 !important; appearance:none; -webkit-appearance:none; }
      input[type="text"], textarea{ display:inline !important; width:auto !important; }
      input::placeholder, textarea::placeholder{ color:transparent !important; }
      .campo-nome{ border-bottom:0 !important; }
      .campo-data{ border-bottom:0 !important; }
      @page{ size:A4; margin:14mm; }
      .container{ box-shadow:none }
      body{ background:#fff }
      .header{ text-align:center; align-items:center }
      .local-data{ font-size:14px; }
    }

    /* Links utilitários sob título do print */
    .links-util{display:flex;gap:8px;justify-content:flex-end;margin-top:8px}
    .links-util a{font-size:12px;color:#004aad;text-decoration:none}
    .toggle-target{font-weight:700}
  </style>
</head>
<body>
<div class="container">
  <!-- Cabeçalho -->
  <div class="header">
    <img src="https://www.associacaodosdetetives.com.br/logotipoadb.png" alt="Logo ADB" onerror="this.style.display='none'">
    <h1>ASSOCIAÇÃO DOS DETETIVES DO BRASIL – ADB</h1>
    <span class="idline"><strong>CNPJ:</strong> 13.329.080/0001-75</span>
    <span class="idline"><strong>Sede:</strong> Rua Isaac Bertoncine, nº 278, Centro – Lauro Müller/SC – CEP: 88880-000</span>
  </div>

  <div class="main">
    <!-- ========== FORMULÁRIO (sem banco) ========== -->
    <div id="formArea" class="no-print">
      <h2>Preencher dados para gerar o documento</h2>

      <div class="lead">
        Selecione a corporação destinatária:
        <div class="form-row" style="margin-top:8px">
          <label style="font-weight:400"><input type="radio" name="corp" value="PC" checked> Polícia Civil</label>
          <label style="font-weight:400"><input type="radio" name="corp" value="PM"> Polícia Militar</label>
        </div>
      </div>

      <div class="lead">Preencha os campos abaixo e clique em <strong>Gerar documento</strong>. Você poderá revisar e <strong>imprimir em PDF</strong>.</div>

      <div class="form-grid">
        <div>
          <label>Nome do profissional</label>
          <input type="text" id="f_nome" placeholder="Nome completo" required>
        </div>
        <div>
          <label>RG / Identidade</label>
          <input type="text" id="f_rg" placeholder="Número da identidade" required>
        </div>
        <div>
          <label>CPF</label>
          <input type="text" id="f_cpf" placeholder="000.000.000-00" maxlength="14" inputmode="numeric" required>
        </div>
        <div>
          <label>Matrícula ADB</label>
          <input type="text" id="f_matricula" placeholder="ADB-12345" required>
        </div>
        <div>
          <label id="lbl_dest">Delegacia (destinatário)</label>
          <input type="text" id="f_dest" placeholder="Ex.: 1ª DP de (Cidade/UF)" required>
        </div>
        <div>
          <label>Período da investigação – Início</label>
          <input type="text" id="f_data_ini" placeholder="dd/mm/aaaa" maxlength="10" inputmode="numeric" required>
        </div>
        <div>
          <label>Período da investigação – Fim</label>
          <input type="text" id="f_data_fim" placeholder="dd/mm/aaaa" maxlength="10" inputmode="numeric" required>
        </div>
        <div>
          <label>Local (cidade)</label>
          <input type="text" id="f_local" placeholder="Cidade (ex.: Lauro Müller)" required>
        </div>
        <div>
          <label>Data do documento</label>
          <input type="text" id="f_data_doc" placeholder="dd/mm/aaaa" maxlength="10" inputmode="numeric" required>
        </div>
        <div>
          <label>Veículos utilizados (placas)</label>
          <input type="text" id="f_veiculos" placeholder="Ex.: ABC1D23; XYZ4E56">
        </div>
      </div>

      <h3 style="margin-top:18px">Equipe profissional</h3>
      <div id="teamList"></div>
      <button class="btn" type="button" id="btnAddMember">+ Adicionar Membro</button>

      <div style="text-align:right;margin-top:18px">
        <button class="btn" id="btnGerar">Gerar documento</button>
      </div>
    </div>

    <!-- ========== DOCUMENTO GERADO ========== -->
    <div id="printArea" style="display:none">
      <h2>COMUNICAÇÃO OFICIAL</h2>

      <div class="links-util no-print">
        <a href="#" id="editAgain">← Voltar e editar</a>
        <a href="#" onclick="window.print()">🖨️ Imprimir / Salvar PDF</a>
      </div>

      <p id="linhaDest">
        AO ILMO. SR. DR. DELEGADO DE POLÍCIA CIVIL – <strong><span id="out_dest"></span></strong>
      </p><br>

      <p id="textoBasePC" style="display:block">
        Eu, <strong><span id="out_nome"></span></strong>, portador(a) da cédula de identidade nº
        <strong><span id="out_rg"></span></strong>, inscrito(a) no CPF nº
        <strong><span id="out_cpf"></span></strong>,
        <b>Matrícula ADB:</b> <strong><span id="out_matricula"></span></strong>,
        venho respeitosamente, por meio desta, informar a Vossa Senhoria que, no período de
        <strong><span id="out_data_ini"></span> a <span id="out_data_fim"></span></strong>, estaremos realizando
        investigação particular na circunscrição desta delegacia.
      </p>

      <p id="textoBasePM" style="display:none">
        Eu, <strong><span id="out_nome_pm"></span></strong>, portador(a) da cédula de identidade nº
        <strong><span id="out_rg_pm"></span></strong>, inscrito(a) no CPF nº
        <strong><span id="out_cpf_pm"></span></strong>,
        <b>Matrícula ADB:</b> <strong><span id="out_matricula_pm"></span></strong>,
        venho respeitosamente, por meio desta, informar a Vossa Senhoria que, no período de
        <strong><span id="out_data_ini_pm"></span> a <span id="out_data_fim_pm"></span></strong>, estaremos realizando
        investigação particular na circunscrição desta unidade.
      </p><br>

      <p>
        Esclarecemos que a atividade será conduzida com base na <strong>Lei Federal nº 13.432/2017</strong>,
        utilizando técnicas legais e recursos tecnológicos permitidos, com o objetivo de apurar informações
        de natureza <strong>não criminal</strong>, de interesse exclusivamente particular do contratante.
      </p><br>

      <div id="equipeSection" class="equipe-bloco" style="display:none">
        <p class="equipe-titulo"><strong>A investigação será realizada por equipe profissional qualificada, conforme segue:</strong></p>
        <ul id="out_equipe" class="equipe-lista"></ul>
      </div><br>

      <p><strong>Veículos utilizados:</strong> <span id="out_veiculos"></span></p>

      <p class="local-data">
        <strong>Local e data:</strong> <span id="out_local"></span>, <span id="out_data_doc"></span>
      </p>

      <!-- Assinaturas -->
      <div class="assinaturas-duplas">
        <div class="assin-card">
          <div class="assin-titulo">Assinatura do Profissional</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha">
            <strong><span id="out_nome_ass"></span></strong><br>
            CPF: <span id="out_cpf_ass"></span> • Matrícula ADB: <span id="out_matricula_ass"></span>
          </div>
          <div class="assin-meta">Assinatura eletrônica via GOV.BR (quando aplicável)</div>
        </div>

        <div class="assin-card">
          <div class="assin-titulo">Assinatura da Autoridade</div>
          <div class="assin-area" aria-label="Área para assinatura manuscrita"></div>
          <div class="assin-linha" id="linhaAutoridade">
            <strong>Autoridade / Carimbo</strong><br>
            <span id="rotuloUnidade">Delegacia / Unidade</span>: ______________________
          </div>
          <div class="assin-meta">(Assinatura e carimbo da autoridade)</div>
        </div>
      </div>

      <div class="no-print" style="text-align:right; margin-top:16px">
        <button class="btn" onclick="window.print()">🖨️ Imprimir / Salvar PDF</button>
      </div><br>

      <p class="muted">Esta atividade encontra-se regulamentada pela <strong>Lei Federal nº 13.432, de 11 de abril de 2017</strong>.</p>
    </div>
  </div>
</div>

<!-- Botão flutuante WhatsApp (opcional) -->
<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank"
   style="right:60px; position:fixed; bottom:100px; z-index:100;" class="no-print">
  <img src="WhatsAppPNG.png" alt="WhatsApp" width="90"
       style="transition:.3s; cursor:pointer;"
       onmouseover="this.style.transform='scale(1.15)'; this.style.filter='drop-shadow(0 0 10px rgba(0,0,0,.25))';"
       onmouseout="this.style.transform='scale(1)'; this.style.filter='none';">
</a>

<script>
  // ---------- Utilidades ----------
  const el = (id)=>document.getElementById(id);
  const q = (sel)=>document.querySelector(sel);
  function onlyDigits(v){ return (v||'').replace(/\D/g,''); }

  // Troca de corporação (PC / PM)
  const corpRadios = document.getElementsByName('corp');
  function applyCorpUI(){
    const corp = [...corpRadios].find(r=>r.checked)?.value || 'PC';
    const isPC = corp === 'PC';

    // Rótulos e placeholders
    el('lbl_dest').innerText = isPC ? 'Delegacia (destinatário)' : 'Batalhão/Unidade (destinatário)';
    el('f_dest').placeholder = isPC ? 'Ex.: 1ª DP de (Cidade/UF)' : 'Ex.: 8º BPM (Cidade/UF)';

    // Linha de abertura e textos base
    el('linhaDest').innerHTML = isPC
      ? 'AO ILMO. SR. DR. DELEGADO DE POLÍCIA CIVIL – <strong><span id="out_dest"></span></strong>'
      : 'AO SENHOR COMANDANTE DO BATALHÃO DE POLÍCIA MILITAR – <strong><span id="out_dest"></span></strong>';

    // Texto da circunscrição (delegacia vs unidade)
    el('textoBasePC').style.display = isPC ? 'block' : 'none';
    el('textoBasePM').style.display = isPC ? 'none' : 'block';

    // Rótulo na assinatura da autoridade
    el('rotuloUnidade').innerText = isPC ? 'Delegacia' : 'Batalhão / Unidade';
  }
  corpRadios.forEach(r=>r.addEventListener('change', applyCorpUI));
  applyCorpUI();

  // Máscara CPF (000.000.000-00)
  el('f_cpf').addEventListener('input', ()=>{
    let v = onlyDigits(el('f_cpf').value).slice(0,11);
    if(v.length > 9) v = v.replace(/(\d{3})(\d{3})(\d{3})(\d{0,2})/, '$1.$2.$3-$4');
    else if(v.length > 6) v = v.replace(/(\d{3})(\d{3})(\d{0,3})/, '$1.$2.$3');
    else if(v.length > 3) v = v.replace(/(\d{3})(\d{0,3})/, '$1.$2');
    el('f_cpf').value = v;
  });

  // Normalização do Código ADB (ADB-####...)
  el('f_matricula').addEventListener('blur', ()=>{
    let val = el('f_matricula').value.trim().toUpperCase();
    if(!val) return;
    if(!val.startsWith('ADB-')){
      val = 'ADB-' + val.replace(/[^0-9]/g,'');
    } else {
      const sufix = val.slice(4).replace(/[^0-9]/g,'');
      val = 'ADB-' + sufix;
    }
    el('f_matricula').value = val;
  });

  // Máscara data dd/mm/aaaa (genérica)
  function maskDateInput(input){
    let v = onlyDigits(input.value).slice(0,8);
    if(v.length >= 5) v = v.replace(/^(\d{2})(\d{2})(\d{0,4}).*$/, '$1/$2/$3');
    else if(v.length >= 3) v = v.replace(/^(\d{2})(\d{0,2}).*$/, '$1/$2');
    input.value = v;
  }
  ;['f_data_ini','f_data_fim','f_data_doc'].forEach(id=>{
    const i = el(id);
    i.addEventListener('input', ()=>maskDateInput(i));
  });

  // ---------- Equipe (form) ----------
  const teamList = el('teamList');
  function addMemberRow(nome='', iddoc=''){
    const row = document.createElement('div');
    row.className = 'team-row';
    row.innerHTML = `
      <input type="text" class="team-nome" placeholder="Nome do membro" value="${nome}">
      <input type="text" class="team-id" placeholder="Identidade (RG/CPF)" value="${iddoc}">
      <button type="button" class="btn btn-danger" title="Remover">Remover</button>
    `;
    row.querySelector('button').addEventListener('click', ()=> row.remove());
    teamList.appendChild(row);
  }
  // Começa com 1 membro vazio
  addMemberRow();
  el('btnAddMember').addEventListener('click', ()=> addMemberRow());

  // ---------- Geração do documento ----------
  el('btnGerar').addEventListener('click', ()=>{
    const corp = [...corpRadios].find(r=>r.checked)?.value || 'PC';
    const isPC = corp === 'PC';

    // Coleta e valida mínimos
    const nome = el('f_nome').value.trim();
    const rg = el('f_rg').value.trim();
    const cpf = el('f_cpf').value.trim();
    const matricula = el('f_matricula').value.trim().toUpperCase();
    const dest = el('f_dest').value.trim();
    const dataIni = el('f_data_ini').value.trim();
    const dataFim = el('f_data_fim').value.trim();
    const local = el('f_local').value.trim();
    const dataDoc = el('f_data_doc').value.trim();
    const veiculos = el('f_veiculos').value.trim();

    if(!nome){ alert('Informe o nome do profissional.'); return; }
    if(!rg){ alert('Informe o RG/Identidade.'); return; }
    if(!cpf || !/^\d{3}\.\d{3}\.\d{3}-\d{2}$/.test(cpf)){ alert('Informe o CPF no formato 000.000.000-00.'); return; }
    if(!/^ADB-\d+$/.test(matricula)){ alert('Informe a Matrícula ADB no formato ADB-12345.'); return; }
    if(!dest){ alert(isPC ? 'Informe a Delegacia (destinatário).' : 'Informe o Batalhão/Unidade (destinatário).'); return; }
    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(dataIni)){ alert('Informe a data inicial no formato dd/mm/aaaa.'); return; }
    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(dataFim)){ alert('Informe a data final no formato dd/mm/aaaa.'); return; }
    if(!local){ alert('Informe o Local (cidade).'); return; }
    if(!/^\d{2}\/\d{2}\/\d{4}$/.test(dataDoc)){ alert('Informe a data do documento no formato dd/mm/aaaa.'); return; }

    // Equipe (pega linhas preenchidas)
    const membros = [];
    teamList.querySelectorAll('.team-row').forEach(row=>{
      const n = row.querySelector('.team-nome').value.trim();
      const idd = row.querySelector('.team-id').value.trim();
      if(n || idd){ membros.push({nome:n, id:idd}); }
    });

    // Preenche saída comum
    el('out_dest').innerText = dest;
    el('out_nome').innerText = nome;
    el('out_rg').innerText = rg;
    el('out_cpf').innerText = cpf;
    el('out_matricula').innerText = matricula;
    el('out_data_ini').innerText = dataIni;
    el('out_data_fim').innerText = dataFim;

    // Versão PM espelha campos
    el('out_nome_pm').innerText = nome;
    el('out_rg_pm').innerText = rg;
    el('out_cpf_pm').innerText = cpf;
    el('out_matricula_pm').innerText = matricula;
    el('out_data_ini_pm').innerText = dataIni;
    el('out_data_fim_pm').innerText = dataFim;

    el('out_local').innerText = local;
    el('out_data_doc').innerText = dataDoc;
    el('out_veiculos').innerText = veiculos || '—';

    // Assinatura (profissional)
    el('out_nome_ass').innerText = nome;
    el('out_cpf_ass').innerText = cpf;
    el('out_matricula_ass').innerText = matricula;

    // Monta equipe no documento
    const lista = el('out_equipe');
    lista.innerHTML = '';
    if(membros.length){
      el('equipeSection').style.display = 'block';
      membros.forEach(m=>{
        const li = document.createElement('li');
        const nomeSpan = document.createElement('span');
        nomeSpan.style.fontWeight = '700';
        nomeSpan.style.whiteSpace = 'normal';
        nomeSpan.style.wordBreak = 'break-word';
        nomeSpan.style.overflowWrap = 'anywhere';
        nomeSpan.textContent = m.nome || '—';

        const idSpan = document.createElement('span');
        idSpan.textContent = m.id || '—';

        li.appendChild(document.createTextNode('Nome: '));
        li.appendChild(nomeSpan);
        li.appendChild(document.createTextNode(' — Identidade: '));
        li.appendChild(idSpan);
        lista.appendChild(li);
      });
    } else {
      el('equipeSection').style.display = 'none';
    }

    // Alterna telas
    el('formArea').style.display = 'none';
    el('printArea').style.display = 'block';
    window.scrollTo(0,0);
  });

  // Voltar e editar
  document.getElementById('editAgain').addEventListener('click', (e)=>{
    e.preventDefault();
    document.getElementById('printArea').style.display = 'none';
    document.getElementById('formArea').style.display = 'block';
    window.scrollTo(0,0);
  });
</script>
</body>
</html>
