<?php require_once('Connections/banco.php'); ?>
<?php
//MX Widgets3 include
require_once('includes/wdg/WDG.php');

// Load the common classes
require_once('includes/common/KT_common.php');

// Load the tNG classes
require_once('includes/tng/tNG.inc.php');

// Make a transaction dispatcher instance
$tNGs = new tNG_dispatcher("");

// Make unified connection variable
$conn_banco = new KT_connection($banco, $database_banco);

//start Trigger_CheckPasswords trigger
//remove this line if you want to edit the code by hand
function Trigger_CheckPasswords(&$tNG) {
  $myThrowError = new tNG_ThrowError($tNG);
  $myThrowError->setErrorMsg("Passwords do not match.");
  $myThrowError->setField("senha");
  $myThrowError->setFieldErrorMsg("The two passwords do not match.");
  return $myThrowError->Execute();
}
//end Trigger_CheckPasswords trigger

//start Trigger_WelcomeEmail trigger
//remove this line if you want to edit the code by hand
function Trigger_WelcomeEmail(&$tNG) {
  $emailObj = new tNG_Email($tNG);
  $emailObj->setFrom("{KT_defaultSender}");
  $emailObj->setTo("{email}");
  $emailObj->setCC("recebetudo.tudo@gmail.com");
  $emailObj->setBCC("");
  $emailObj->setSubject("Cadastro realizado");
  //FromFile method
  $emailObj->setContentFile("includes/mailtemplates/welcome.html");
  $emailObj->setEncoding("ISO-8859-1");
  $emailObj->setFormat("HTML/Text");
  $emailObj->setImportance("Normal");
  return $emailObj->Execute();
}
//end Trigger_WelcomeEmail trigger

//start Trigger_ImageUpload trigger
//remove this line if you want to edit the code by hand
function Trigger_ImageUpload(&$tNG) {
  $uploadObj = new tNG_ImageUpload($tNG);
  $uploadObj->setFormFieldName("logotipo");
  $uploadObj->setDbFieldName("logotipo");
  $uploadObj->setFolder("logotipo/");
  $uploadObj->setResize("true", 480, 640);
  $uploadObj->setMaxSize(10000);
  $uploadObj->setAllowedExtensions("jpeg, jpg, gif, png, JPEG");
  $uploadObj->setRename("custom");
  $uploadObj->setRenameRule("detetive_{cd_cadastro_detetive}.jpg");
  return $uploadObj->Execute();
}

//end Trigger_ImageUpload trigger

// Start trigger
$formValidation = new tNG_FormValidation();
$formValidation->addField("condicoes", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("nome_detetive", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("entidade_de_registro", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("cpf_cnpj", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("rg", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("naturalidade", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("tipo_sanguineo", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("data_nascimento", true, "date", "", "", "", "Campo Obrigatório!");
$formValidation->addField("data_da_conclusao", true, "date", "", "", "", "Campo Obrigatório!");
$formValidation->addField("curso_de_formacao", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("logotipo_estado", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("bairro", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("nome_pai", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("nome_mae", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("tempo_de_profissao", true, "numeric", "", "", "", "Campo Obrigatório!");
$formValidation->addField("endereco", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("numero", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("cidade", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("cep", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("cd_estado", true, "numeric", "", "", "", "Campo Obrigatório!");
$formValidation->addField("email", true, "text", "email", "", "", "Digite um e-mail válido!");
$formValidation->addField("area_de_atuacao", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("restrito", true, "text", "", "", "", "Campo Obrigatório!");
$formValidation->addField("senha", true, "text", "", "", "", "Campo Obrigatório!");
$tNGs->prepareValidation($formValidation);
// End trigger

if (!function_exists("GetSQLValueString")) {
function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
{
  if (PHP_VERSION < 6) {
    $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
  }

  $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

  switch ($theType) {
    case "text":
      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
      break;
    case "long":
    case "int":
      $theValue = ($theValue != "") ? intval($theValue) : "NULL";
      break;
    case "double":
      $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
      break;
    case "date":
      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
      break;
    case "defined":
      $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
      break;
  }
  return $theValue;
}
}

mysql_select_db($database_banco, $banco);
$query_ConsultaEstado = "SELECT * FROM estado ORDER BY nm_estado ASC";
$ConsultaEstado = mysql_query($query_ConsultaEstado, $banco) or die(mysql_error());
$row_ConsultaEstado = mysql_fetch_assoc($ConsultaEstado);
$totalRows_ConsultaEstado = mysql_num_rows($ConsultaEstado);

// Make an insert transaction instance
$userRegistration = new tNG_insert($conn_banco);
$tNGs->addTransaction($userRegistration);
// Register triggers
$userRegistration->registerTrigger("STARTER", "Trigger_Default_Starter", 1, "POST", "KT_Insert1");
$userRegistration->registerTrigger("BEFORE", "Trigger_Default_FormValidation", 10, $formValidation);
$userRegistration->registerTrigger("END", "Trigger_Default_Redirect", 99, "{kt_login_redirect}");
$userRegistration->registerConditionalTrigger("{POST.senha} != {POST.re_senha}", "BEFORE", "Trigger_CheckPasswords", 50);
$userRegistration->registerTrigger("AFTER", "Trigger_WelcomeEmail", 40);
$userRegistration->registerTrigger("AFTER", "Trigger_ImageUpload", 97);
// Add columns
$userRegistration->setTable("cadastro_detetive");
$userRegistration->addColumn("nome_detetive", "STRING_TYPE", "POST", "nome_detetive");
$userRegistration->addColumn("entidade_de_registro", "STRING_TYPE", "POST", "entidade_de_registro");
$userRegistration->addColumn("cpf_cnpj", "STRING_TYPE", "POST", "cpf_cnpj");
$userRegistration->addColumn("rg", "STRING_TYPE", "POST", "rg");
$userRegistration->addColumn("naturalidade", "STRING_TYPE", "POST", "naturalidade");
$userRegistration->addColumn("tipo_sanguineo", "STRING_TYPE", "POST", "tipo_sanguineo");
$userRegistration->addColumn("bairro", "STRING_TYPE", "POST", "bairro");
$userRegistration->addColumn("data_nascimento", "DATE_TYPE", "POST", "data_nascimento");
$userRegistration->addColumn("data_da_conclusao", "DATE_TYPE", "POST", "data_da_conclusao");
$userRegistration->addColumn("curso_de_formacao", "STRING_TYPE", "POST", "curso_de_formacao");
$userRegistration->addColumn("logotipo_estado", "STRING_TYPE", "POST", "logotipo_estado");
$userRegistration->addColumn("nome_pai", "STRING_TYPE", "POST", "nome_pai");
$userRegistration->addColumn("nome_mae", "STRING_TYPE", "POST", "nome_mae");
$userRegistration->addColumn("tempo_de_profissao", "NUMERIC_TYPE", "POST", "tempo_de_profissao");
$userRegistration->addColumn("endereco", "STRING_TYPE", "POST", "endereco");
$userRegistration->addColumn("numero", "STRING_TYPE", "POST", "numero");
$userRegistration->addColumn("cidade", "STRING_TYPE", "POST", "cidade");
$userRegistration->addColumn("cep", "STRING_TYPE", "POST", "cep");
$userRegistration->addColumn("cd_estado", "NUMERIC_TYPE", "POST", "cd_estado");
$userRegistration->addColumn("email", "STRING_TYPE", "POST", "email");
$userRegistration->addColumn("site", "STRING_TYPE", "POST", "site");
$userRegistration->addColumn("fone_fixo", "STRING_TYPE", "POST", "fone_fixo");
$userRegistration->addColumn("fone_celular", "STRING_TYPE", "POST", "fone_celular");
$userRegistration->addColumn("whatsapp", "STRING_TYPE", "POST", "whatsapp");
$userRegistration->addColumn("area_de_atuacao", "STRING_TYPE", "POST", "area_de_atuacao");
$userRegistration->addColumn("logotipo", "FILE_TYPE", "FILES", "logotipo");
$userRegistration->addColumn("restrito", "STRING_TYPE", "POST", "restrito");
$userRegistration->addColumn("senha", "STRING_TYPE", "POST", "senha");
$userRegistration->addColumn("observacao", "STRING_TYPE", "POST", "observacao");
$userRegistration->addColumn("ativo", "NUMERIC_TYPE", "VALUE", "0");
$userRegistration->addColumn("nivel", "NUMERIC_TYPE", "POST", "nivel");
$userRegistration->addColumn("randomkey", "STRING_TYPE", "POST", "randomkey");
$userRegistration->setPrimaryKey("cd_cadastro_detetive", "NUMERIC_TYPE");

// Execute all the registered transactions
$tNGs->executeTransactions();

// Get the transaction recordset
$rscadastro_detetive = $tNGs->getRecordset("cadastro_detetive");
$row_rscadastro_detetive = mysql_fetch_assoc($rscadastro_detetive);
$totalRows_rscadastro_detetive = mysql_num_rows($rscadastro_detetive);
?>
<!DOCTYPE html>
<html lang="pt-br">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>CADASTRO</title>
     <style>
  body {
    font-family: Consolas, monospace;
    font-size: 16px;
    margin: 0;
    padding: 0;
  }

  form {
    width: 100%;
    max-width: 960px;
    margin: 0 auto;
    padding: 20px;
  }

  label, input, select, textarea {
    display: block;
    width: 100%;
    max-width: 100%;
    box-sizing: border-box;
    margin-bottom: 15px;
  }

  input[type="checkbox"] {
    display: inline-block;
    width: auto;
  }

  .form-section {
    background: #f4f4f4;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 30px;
  }

  .form-section h2 {
    font-size: 1.2em;
    color: #000;
    margin-bottom: 15px;
  }

  input[type="submit"] {
    background-color: #444;
    color: white;
    padding: 10px 20px;
    border: none;
    font-weight: bold;
    cursor: pointer;
  }

  @media (max-width: 600px) {
    body {
      font-size: 14px;
    }

    input, select {
      font-size: 14px;
    }
  }
</style>
   <META NAME="DESCRIPTION" CONTENT="Os detetives profissionais são profissionais que atuam na área privada e que prestam serviços específicos, de acordo com as necessidades de cada cliente na coleta de dados e informações, com conhecimento técnico e utilizando recursos e meios tecnológicos permitidos, visando ao esclarecimento de assuntos de interesse privado do contratante."/>
    <link href="https://www.associacaodosdetetives.com.br/logotipoadb.png" rel="shortcut icon" type="image/x-icon"/>
    <META NAME="Keywords" Content="Detetive Particular,Detetive particular, investigador particular, investigador profissional em santa Catarina, detetive profissional, investigação criminal, detetive em florianopolis, detetive em tubarão, investigação conjugal, detetive,"/>
    <link href="css/css.css" rel="stylesheet" type="text/css" />
<link href="includes/skins/mxkollection3.css" rel="stylesheet" type="text/css" media="all" />
<script src="includes/common/js/base.js" type="text/javascript"></script>
<script src="includes/common/js/utility.js" type="text/javascript"></script>
<script src="includes/skins/style.js" type="text/javascript"></script>
<?php echo $tNGs->displayValidationRules();?>
<script type="text/javascript" src="includes/wdg/classes/MXWidgets.js"></script>
<script type="text/javascript" src="includes/wdg/classes/MXWidgets.js.php"></script>
<script type="text/javascript" src="includes/wdg/classes/MaskedInput.js"></script>
<script type="text/javascript" src="includes/wdg/classes/Calendar.js"></script>
<script type="text/javascript" src="includes/wdg/classes/SmartDate.js"></script>
<script type="text/javascript" src="includes/wdg/calendar/calendar_stripped.js"></script>
<script type="text/javascript" src="includes/wdg/calendar/calendar-setup_stripped.js"></script>
<script src="includes/resources/calendar.js"></script>
<link rel="stylesheet" href="style.css" />
<script defer src="app.js"></script>

</head>
   <body >
   <?php
echo '<div style="background-color: #fff3cd; color: #856404; padding: 15px; border: 1px solid #ffeeba; border-radius: 5px; margin-bottom: 20px;">
  <strong>Atenção:</strong> O cadastro deverá ser regularizado no prazo máximo de <strong>7 dias</strong> a contar da data do cadastro. O não cumprimento deste prazo acarretará na <strong>exclusão automática</strong> do cadastro.
</div>';
?>    
 <div class="form-section">
  
     
 <?php
	echo $tNGs->getErrorMsg();
?>
<form method="post" id="form1" action="<?php echo KT_escapeAttribute(KT_getFullUri()); ?>" enctype="multipart/form-data">        
 <h1><p align="center">CADASTRO</p></h1><BR><BR>        
         
  <h2>DADOS PESSOAIS</h2>

  <form><label for="logotipo">Foto (jpg 3x4) recente (atualizada) estilo social, com vestimenta adequada e aparência compatível para documento oficial</label>
  <input name="logotipo" type="file" id="logotipo" />
  <?php echo $tNGs->displayFieldError("cadastro_detetive", "logotipo"); ?>

  
 Nome completo:<br>
<input 
  type="text" 
  name="nome_detetive" 
  id="nome_detetive" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['nome_detetive']); ?>" 
  style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="Informe seu nome completo" 
  autocomplete="off" 
/>
<?php echo $tNGs->displayFieldHint("nome_detetive"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "nome_detetive"); ?>

<script>
  const inputNaturalidade = document.getElementById('nome_detetive');

  // Formata em tempo real: primeira letra de cada palavra em maiúscula
  inputNaturalidade.addEventListener('input', () => {
    const pos = inputNaturalidade.selectionStart;

    inputNaturalidade.value = inputNaturalidade.value
      .toLowerCase()
      .split(' ')
      .map(palavra => {
        if (palavra.length === 0) return '';
        return palavra[0].toUpperCase() + palavra.slice(1);
      })
      .join(' ');

    inputNaturalidade.setSelectionRange(pos, pos);
  });
</script> 
 
 <label for="cpf_cnpj">CPF: <input 
    name="cpf_cnpj" 
    id="cpf_cnpj" 
    value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['cpf_cnpj']); ?>" 
    style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
     placeholder="Informe seu cpf" 
  autocomplete="off" 
    wdg:subtype="MaskedInput" 
    wdg:mask="999.999.999-99" 
    wdg:restricttomask="no" 
    wdg:type="widget"
  />
  <?php echo $tNGs->displayFieldHint("cpf_cnpj"); ?>
  <?php echo $tNGs->displayFieldError("cadastro_detetive", "cpf_cnpj"); ?>
  

RG:<br>
  <input 
    type="text" 
    name="rg" 
    id="rg" 
    value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['rg']); ?>" 
    style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
     placeholder="Informe sua RG" 
  autocomplete="off" 
  />
  <?php echo $tNGs->displayFieldHint("rg"); ?> 
  <?php echo $tNGs->displayFieldError("cadastro_detetive", "rg"); ?>


Dat.Nasc:<br>
<input 
  type="text" 
  name="data_nascimento" 
  id="data_nascimento" 
  maxlength="10"
  value="<?php echo KT_formatDate($row_rscadastro_detetive['data_nascimento']); ?>" 
  style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="dd/mm/aaaa"
/>
<?php echo $tNGs->displayFieldHint("data_nascimento"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "data_nascimento"); ?>

<script>
  const dataInput = document.getElementById('data_nascimento');

  dataInput.addEventListener('input', function(e) {
    let v = this.value;

    // Remove tudo que não for número
    v = v.replace(/\D/g, '');

    // Coloca a barra após o 2º e 4º dígito
    if (v.length > 2 && v.length <= 4) {
      v = v.slice(0,2) + '/' + v.slice(2);
    } else if (v.length > 4) {
      v = v.slice(0,2) + '/' + v.slice(2,4) + '/' + v.slice(4,8);
    }

    this.value = v;
  });
</script>


Naturalidade:<br>
<input 
  type="text" 
  name="naturalidade" 
  id="naturalidade" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['naturalidade']); ?>" 
  style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="Informe sua naturalidade onde nasceu" 
  autocomplete="off" 
/>
<?php echo $tNGs->displayFieldHint("naturalidade"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "naturalidade"); ?>

<script>
  const inputNaturalidade = document.getElementById('naturalidade');

  // Formata em tempo real: primeira letra de cada palavra em maiúscula
  inputNaturalidade.addEventListener('input', () => {
    const pos = inputNaturalidade.selectionStart;

    inputNaturalidade.value = inputNaturalidade.value
      .toLowerCase()
      .split(' ')
      .map(palavra => {
        if (palavra.length === 0) return '';
        return palavra[0].toUpperCase() + palavra.slice(1);
      })
      .join(' ');

    inputNaturalidade.setSelectionRange(pos, pos);
  });
</script>
Pai:<br>
<input 
  type="text" 
  name="nome_pai" 
  id="nome_pai" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['nome_pai']); ?>" 
  style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="Nome do pai" 
  autocomplete="off" 
/>
<?php echo $tNGs->displayFieldHint("nome_pai"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "nome_pai"); ?>

<script>
  const inputNomePai = document.getElementById('nome_pai');

  inputNomePai.addEventListener('input', () => {
    const pos = inputNomePai.selectionStart;

    inputNomePai.value = inputNomePai.value
      .toLowerCase()
      .split(' ')
      .map(palavra => {
        if (palavra.length === 0) return '';
        return palavra[0].toUpperCase() + palavra.slice(1);
      })
      .join(' ');

    inputNomePai.setSelectionRange(pos, pos);
  });
</script>
Mãe:<br>
<input 
  type="text" 
  name="nome_mae" 
  id="nome_mae" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['nome_mae']); ?>" 
  style="width: 100%; max-width: 400px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="Nome da mãe" 
  autocomplete="off" 
/>
<?php echo $tNGs->displayFieldHint("nome_mae"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "nome_mae"); ?>

<script>
  const inputNomeMae = document.getElementById('nome_mae');

  inputNomeMae.addEventListener('input', () => {
    const pos = inputNomeMae.selectionStart;

    inputNomeMae.value = inputNomeMae.value
      .toLowerCase()
      .split(' ')
      .map(palavra => {
        if (palavra.length === 0) return '';
        return palavra[0].toUpperCase() + palavra.slice(1);
      })
      .join(' ');

    inputNomeMae.setSelectionRange(pos, pos);
  });
</script>

Tipo sanguíneo:<br>
  <select 
    name="tipo_sanguineo" 
    id="tipo_sanguineo" 
    style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;"
  >
    <option value="">Selecione seu tipo sanguíneo</option>
    <option value="a-.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'a-.jpg') echo 'selected'; ?>>A Negativo</option>
    <option value="a+.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'a+.jpg') echo 'selected'; ?>>A Positivo</option>
    <option value="ab-.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'ab-.jpg') echo 'selected'; ?>>AB Negativo</option>
    <option value="ab+.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'ab+.jpg') echo 'selected'; ?>>AB Positivo</option>
    <option value="b-.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'b-.jpg') echo 'selected'; ?>>B Negativo</option>
    <option value="b+.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'b+.jpg') echo 'selected'; ?>>B Positivo</option>
    <option value="o-.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'o-.jpg') echo 'selected'; ?>>O Negativo</option>
    <option value="o+.jpg" <?php if($row_rscadastro_detetive['tipo_sanguineo'] == 'o+.jpg') echo 'selected'; ?>>O Positivo</option>
  </select>
  <?php echo $tNGs->displayFieldHint("tipo_sanguineo"); ?> 
  <?php echo $tNGs->displayFieldError("cadastro_detetive", "tipo_sanguineo"); ?>

 <h2>- DADOS PROFISSIONAIS - </h2>
Nome completo da instituição onde concluiu o curso de Detetive Particular:<br>
<input 
  type="text" 
  name="entidade_de_registro" 
  id="entidade_de_registro" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['entidade_de_registro']); ?>" 
 style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: Instituto Nacional de Investigação Privada" 
  autocomplete="off"
/>
<?php echo $tNGs->displayFieldHint("entidade_de_registro"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "entidade_de_registro"); ?>

<script>
  const entidadeInput = document.getElementById('entidade_de_registro');

  entidadeInput.addEventListener('input', () => {
    const pos = entidadeInput.selectionStart;

    entidadeInput.value = entidadeInput.value
      .toLowerCase()
      .split(' ')
      .map(palavra => {
        if (palavra.length === 0) return '';
        return palavra[0].toUpperCase() + palavra.slice(1);
      })
      .join(' ');

    entidadeInput.setSelectionRange(pos, pos);
  });
</script>
Data da conclusão do curso:<br>
<input 
  type="text" 
  name="data_da_conclusao" 
  id="data_da_conclusao" 
  value="<?php echo KT_formatDate($row_rscadastro_detetive['data_da_conclusao']); ?>" 
  maxlength="10"
  style="width: 100%; max-width: 200px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="dd/mm/aaaa" 
  autocomplete="off" 
/>
<?php echo $tNGs->displayFieldHint("data_da_conclusao"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "data_da_conclusao"); ?>

<script>
  const dataConclusao = document.getElementById('data_da_conclusao');

  dataConclusao.addEventListener('input', function () {
    let v = this.value.replace(/\D/g, '');

    if (v.length > 2 && v.length <= 4) {
      v = v.slice(0, 2) + '/' + v.slice(2);
    } else if (v.length > 4) {
      v = v.slice(0, 2) + '/' + v.slice(2, 4) + '/' + v.slice(4, 8);
    }

    this.value = v;
  });
</script>
Curso de formação:<br>
<select 
  name="curso_de_formacao" 
  id="curso_de_formacao" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;"
>
  <option value="">Selecione sua opção</option>
  <option value="Detetive particular" <?php if ($row_rscadastro_detetive['curso_de_formacao'] == 'Detetive particular') echo 'selected'; ?>>Detetive Particular</option>
  <option value="Detetive profissional" <?php if ($row_rscadastro_detetive['curso_de_formacao'] == 'Detetive profissional') echo 'selected'; ?>>Detetive Profissional</option>
  <option value="Detetive criminal" <?php if ($row_rscadastro_detetive['curso_de_formacao'] == 'Detetive criminal') echo 'selected'; ?>>Detetive Criminal</option>
</select>
<?php echo $tNGs->displayFieldHint("curso_de_formacao"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "curso_de_formacao"); ?>
Especialidade:<br>
<select 
  name="area_de_atuacao" 
  id="area_de_atuacao" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;"
>
  <option value="">Selecione a sua especialidade</option>
  
  <option value="Investigação civil e criminal." 
    <?php if ($row_rscadastro_detetive['area_de_atuacao'] == 'Investigação civil e criminal.') echo 'selected'; ?>>
    Investigação Civil e Criminal
  </option>

  <option value="Investigação civil." 
    <?php if ($row_rscadastro_detetive['area_de_atuacao'] == 'Investigação civil.') echo 'selected'; ?>>
    Investigação Civil
  </option>

  <option value="Investigação criminal." 
    <?php if ($row_rscadastro_detetive['area_de_atuacao'] == 'Investigação criminal.') echo 'selected'; ?>>
    Investigação Criminal
  </option>

  <option value="Perícia civil e criminal." 
    <?php if ($row_rscadastro_detetive['area_de_atuacao'] == 'Perícia civil e criminal.') echo 'selected'; ?>>
    Perícia Civil e Criminal
  </option>
</select>

<?php echo $tNGs->displayFieldHint("area_de_atuacao"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "area_de_atuacao"); ?>


Tempo de experiência:<br>
<input 
  type="text" 
  name="tempo_de_profissao" 
  id="tempo_de_profissao" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['tempo_de_profissao']); ?>" 
  style="width: 100%; max-width: 150px; height: 30px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: 5 anos" 
  autocomplete="off"
/>
<?php echo $tNGs->displayFieldHint("tempo_de_profissao"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "tempo_de_profissao"); ?>

<script>
  const tempoInput = document.getElementById('tempo_de_profissao');

  // Permitir apenas números e sufixo "anos"
  tempoInput.addEventListener('input', function () {
    let valor = this.value;

    // Remove tudo que não for número
    valor = valor.replace(/\D/g, '');

    // Adiciona " anos" se tiver valor
    if (valor) {
      this.value = valor + ' anos';
    } else {
      this.value = '';
    }
  });

  // Impede apagar parcialmente o sufixo "anos"
  tempoInput.addEventListener('keydown', function(e) {
    if (this.value.endsWith(' anos') && e.key === 'Backspace') {
      e.preventDefault();
      this.value = '';
    }
  });
</script>
Estado de atuação:<br>
<select 
  name="logotipo_estado" 
  id="logotipo_estado" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;"
>
  <option value="">Selecione seu Estado</option>
  <option value="acre.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'acre.jpg') echo 'selected'; ?>>Acre</option>
  <option value="alagoas.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'alagoas.jpg') echo 'selected'; ?>>Alagoas</option>
  <option value="amapa.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'amapa.jpg') echo 'selected'; ?>>Amapá</option>
  <option value="amazonas.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'amazonas.jpg') echo 'selected'; ?>>Amazonas</option>
  <option value="bahia.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'bahia.jpg') echo 'selected'; ?>>Bahia</option>
  <option value="ceara.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'ceara.jpg') echo 'selected'; ?>>Ceará</option>
  <option value="distrito_federal.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'distrito_federal.jpg') echo 'selected'; ?>>Distrito Federal</option>
  <option value="espirito_santo.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'espirito_santo.jpg') echo 'selected'; ?>>Espírito Santo</option>
  <option value="goias.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'goias.jpg') echo 'selected'; ?>>Goiás</option>
  <option value="maranhao.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'maranhao.jpg') echo 'selected'; ?>>Maranhão</option>
  <option value="mato_grosso.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'mato_grosso.jpg') echo 'selected'; ?>>Mato Grosso</option>
  <option value="mato_grosso_do_sul.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'mato_grosso_do_sul.jpg') echo 'selected'; ?>>Mato Grosso do Sul</option>
  <option value="minas_gerais.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'minas_gerais.jpg') echo 'selected'; ?>>Minas Gerais</option>
  <option value="para.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'para.jpg') echo 'selected'; ?>>Pará</option>
  <option value="paraiba.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'paraiba.jpg') echo 'selected'; ?>>Paraíba</option>
  <option value="parana.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'parana.jpg') echo 'selected'; ?>>Paraná</option>
  <option value="pernambuco.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'pernambuco.jpg') echo 'selected'; ?>>Pernambuco</option>
  <option value="piaui.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'piaui.jpg') echo 'selected'; ?>>Piauí</option>
  <option value="rio_de_janeiro.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'rio_de_janeiro.jpg') echo 'selected'; ?>>Rio de Janeiro</option>
  <option value="rio_grande_do_norte.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'rio_grande_do_norte.jpg') echo 'selected'; ?>>Rio Grande do Norte</option>
  <option value="rio_grande_do_sul.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'rio_grande_do_sul.jpg') echo 'selected'; ?>>Rio Grande do Sul</option>
  <option value="rondonia.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'rondonia.jpg') echo 'selected'; ?>>Rondônia</option>
  <option value="roraima.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'roraima.jpg') echo 'selected'; ?>>Roraima</option>
  <option value="santa_catarina.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'santa_catarina.jpg') echo 'selected'; ?>>Santa Catarina</option>
  <option value="sao_paulo.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'sao_paulo.jpg') echo 'selected'; ?>>São Paulo</option>
  <option value="sergipe.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'sergipe.jpg') echo 'selected'; ?>>Sergipe</option>
  <option value="tocantins.jpg" <?php if ($row_rscadastro_detetive['logotipo_estado'] == 'tocantins.jpg') echo 'selected'; ?>>Tocantins</option>
</select>
<?php echo $tNGs->displayFieldHint("logotipo_estado"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "logotipo_estado"); ?><br>

 <h2>- DADOS DE RESIDÊNCIA - </h2>
 
Rua/AV:<br>
<input 
  type="text" 
  name="endereco" 
  id="endereco" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['endereco']); ?>" 
  size="35" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: Avenida Paulista" 
/>
<?php echo $tNGs->displayFieldHint("endereco"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "endereco"); ?>

<script>
  function capitalizeWords(str) {
    return str.toLowerCase().replace(/\b\w/g, function(match) {
      return match.toUpperCase();
    });
  }

  const inputEndereco = document.getElementById('endereco');

  inputEndereco.addEventListener('input', () => {
    const cursorPos = inputEndereco.selectionStart;
    inputEndereco.value = capitalizeWords(inputEndereco.value);
    inputEndereco.setSelectionRange(cursorPos, cursorPos);
  });
</script>

Número:<br>
<input 
  type="text" 
  name="numero" 
  id="numero" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['numero']); ?>" 
  size="35" 
  style="width: 100%; max-width: 150px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: 123" 
/>
<?php echo $tNGs->displayFieldHint("numero"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "numero"); ?>


Bairro:<br>
<input 
  type="text" 
  name="bairro" 
  id="bairro" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['bairro']); ?>" 
  size="35" 
  style="width: 100%; max-width: 300px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: Jardim Paulista" 
/>
<?php echo $tNGs->displayFieldHint("bairro"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "bairro"); ?>

<script>
  function capitalizeWords(str) {
    return str.toLowerCase().replace(/\b\w/g, function(match) {
      return match.toUpperCase();
    });
  }

  const inputBairro = document.getElementById('bairro');

  inputBairro.addEventListener('input', () => {
    const cursorPos = inputBairro.selectionStart;
    inputBairro.value = capitalizeWords(inputBairro.value);
    inputBairro.setSelectionRange(cursorPos, cursorPos);
  });
</script>


Cidade:<br>
<input 
  type="text" 
  name="cidade" 
  id="cidade" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['cidade']); ?>" 
  size="35" 
  style="width: 100%; max-width: 300px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: São Paulo" 
/>
<?php echo $tNGs->displayFieldHint("cidade"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "cidade"); ?>

<script>
  function capitalizeWords(str) {
    return str.toLowerCase().replace(/\b\w/g, function(match) {
      return match.toUpperCase();
    });
  }

  const inputCidade = document.getElementById('cidade');

  inputCidade.addEventListener('input', () => {
    const cursorPos = inputCidade.selectionStart;
    inputCidade.value = capitalizeWords(inputCidade.value);
    inputCidade.setSelectionRange(cursorPos, cursorPos);
  });
</script>


CEP:<br>
<input 
  name="cep" 
  id="cep" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['cep']); ?>" 
  size="35" 
  style="width: 100%; max-width: 150px; height: 35px; font-size: 16px; padding: 5px;" 
  wdg:subtype="MaskedInput" 
  wdg:mask="99999-999" 
  wdg:restricttomask="no" 
  wdg:type="widget" 
  placeholder="00000-000"
/>
<?php echo $tNGs->displayFieldHint("cep"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "cep"); ?>

Estado:<br>
<select 
  name="cd_estado" 
  id="cd_estado" 
  style="width: 100%; max-width: 200px; height: 35px; font-size: 16px; padding: 5px;"
>
  <?php
  do {
  ?>
    <option value="<?php echo $row_ConsultaEstado['cd_estado']; ?>" 
      <?php if (!(strcmp($row_ConsultaEstado['cd_estado'], $row_rscadastro_detetive['cd_estado']))) echo 'selected'; ?>>
      <?php echo $row_ConsultaEstado['nm_estado']; ?>
    </option>
  <?php
  } while ($row_ConsultaEstado = mysql_fetch_assoc($ConsultaEstado));
  // Reset pointer if needed
  $rows = mysql_num_rows($ConsultaEstado);
  if ($rows > 0) {
    mysql_data_seek($ConsultaEstado, 0);
    $row_ConsultaEstado = mysql_fetch_assoc($ConsultaEstado);
  }
  ?>
</select>
<?php echo $tNGs->displayFieldError("cadastro_detetive", "cd_estado"); ?><br>

 <h2>- DADOS PROFISSIONAIS - </h2>

E-mail:<br>
<input 
  type="email" 
  name="email" 
  id="email" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['email']); ?>" 
  size="35" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px; text-transform: lowercase;" 
  placeholder="Ex: nome@email.com"
/>
<?php echo $tNGs->displayFieldHint("email"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "email"); ?>

<script>
  const inputEmail = document.getElementById('email');
  inputEmail.addEventListener('input', () => {
    const cursorPos = inputEmail.selectionStart;
    inputEmail.value = inputEmail.value.toLowerCase();
    inputEmail.setSelectionRange(cursorPos, cursorPos);
  });
</script>


Site:<br>
<input 
  type="text" 
  name="site" 
  id="site" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['site']); ?>" 
  size="35" 
  style="width: 100%; max-width: 400px; height: 35px; font-size: 16px; padding: 5px; text-transform: lowercase;" 
  placeholder="Ex: www.seusite.com.br"
/>
<?php echo $tNGs->displayFieldHint("site"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "site"); ?>

<script>
  const inputSite = document.getElementById('site');
  inputSite.addEventListener('input', () => {
    const cursorPos = inputSite.selectionStart;
    inputSite.value = inputSite.value.toLowerCase();
    inputSite.setSelectionRange(cursorPos, cursorPos);
  });
</script>


Telefone fixo:<br>
<input 
  name="fone_fixo" 
  id="fone_fixo" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['fone_fixo']); ?>" 
  size="35" 
  style="width: 100%; max-width: 200px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: (11) 1234-5678"
  wdg:subtype="MaskedInput" 
  wdg:mask="(99)9999-99999" 
  wdg:restricttomask="no" 
  wdg:type="widget"
/>
<?php echo $tNGs->displayFieldHint("fone_fixo"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "fone_fixo"); ?>

Telefone celular:<br>
<input 
  name="fone_celular" 
  id="fone_celular" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['fone_celular']); ?>" 
  size="35" 
  style="width: 100%; max-width: 200px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: (11) 91234-5678"
  wdg:subtype="MaskedInput" 
  wdg:mask="(99)9999-99999" 
  wdg:restricttomask="no" 
  wdg:type="widget"
/>
<?php echo $tNGs->displayFieldHint("fone_celular"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "fone_celular"); ?>

Whatsapp:<br>
<input 
  name="whatsapp" 
  id="whatsapp" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['whatsapp']); ?>" 
  size="35" 
  style="width: 100%; max-width: 200px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Ex: 11912345678"
  wdg:subtype="MaskedInput" 
  wdg:mask="99999999999" 
  wdg:restricttomask="no" 
  wdg:type="widget"
/>
<?php echo $tNGs->displayFieldHint("whatsapp"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "whatsapp"); ?><BR>

 <h2>- DADOS DE ACESSO AO CADASTRO - </h2>
<label for="restrito">Matrícula:</label>
Digite os 5 últimos números do seu CPF.<br>
<em>Exemplo: ADB-12345</em><br>

<input 
  type="text" 
  name="restrito" 
  id="restrito" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['restrito']); ?>" 
  style="width: 100%; max-width: 300px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="ADB-12345"
  required
/>

<?php echo $tNGs->displayFieldHint("restrito"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "restrito"); ?>

<script>
  const inputMatricula = document.getElementById('restrito');

  // Adiciona prefixo automaticamente se não existir
  inputMatricula.addEventListener('focus', () => {
    if (!inputMatricula.value.startsWith('ADB-')) {
      inputMatricula.value = 'ADB-';
    }
  });

  // Impede remoção do prefixo ADB-
  inputMatricula.addEventListener('keydown', (event) => {
    if (inputMatricula.selectionStart < 4 && 
        !['ArrowRight', 'ArrowLeft', 'Tab'].includes(event.key)) {
      event.preventDefault();
    }
  });

  // Força letras maiúsculas e mantém só números após ADB-
  inputMatricula.addEventListener('input', () => {
    let numbers = inputMatricula.value.slice(4).replace(/\D/g, '');
    inputMatricula.value = 'ADB-' + numbers.toUpperCase();
  });
</script>


Crie uma Senha:<br>
<input 
  type="password" 
  name="senha" 
  id="senha" 
  value="" 
  size="35" 
  style="width: 100%; max-width: 300px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Mínimo 6 caracteres"
/>
<button 
  type="button" 
  onclick="toggleSenha()" 
  style="margin-left: 10px; padding: 5px 10px; font-size: 14px;"
>
  Mostrar senha 
</button>

<?php echo $tNGs->displayFieldHint("senha"); ?> 
<?php echo $tNGs->displayFieldError("cadastro_detetive", "senha"); ?>

<script>
  function toggleSenha() {
    const senhaInput = document.getElementById('senha');
    const btn = event.target;
    if (senhaInput.type === 'password') {
      senhaInput.type = 'text';
      btn.textContent = 'Ocultar';
    } else {
      senhaInput.type = 'password';
      btn.textContent = 'Mostrar senha';
    }
  }
</script><br><br>


Repita a Senha:<br>
<input 
  type="password" 
  name="re_senha" 
  id="re_senha" 
  value="" 
  size="35" 
  style="width: 100%; max-width: 300px; height: 35px; font-size: 16px; padding: 5px;" 
  placeholder="Repita a senha"
/>
<button 
  type="button" 
  onclick="toggleReSenha()" 
  style="margin-left: 10px; padding: 5px 10px; font-size: 14px;"
>
  Mostrar senha
</button>

<script>
  function toggleReSenha() {
    const reSenhaInput = document.getElementById('re_senha');
    const btn = event.target;
    if (reSenhaInput.type === 'password') {
      reSenhaInput.type = 'text';
      btn.textContent = 'Ocultar';
    } else {
      reSenhaInput.type = 'password';
      btn.textContent = 'Mostrar senha';
    }
  }
</script> <br><br>
 <input type="checkbox" name="condicoes" />
  Eu li e concordo com as 
  <a href="obrigaçoes_e_deveres.php" style="color: #0000FF; font-weight: bold;" target="_blank" rel="noopener noreferrer">
    Obrigações e Deveres dos Profissionais Cadastrados na ADB
  </a>.
</label>
<br>
<span style="font-family: Verdana, Helvetica, Arial; font-size: 12px; color: #000000;">
  Ao marcar esta opção, você declara estar de acordo com os termos de aceitação.
</span><br><br>

<input 
  type="submit" 
  name="KT_Insert1" 
  id="KT_Insert1" 
  value="ENVIAR CADASTRO E AGUARDE" 
  style="width: 100%; max-width: 300px; height: 45px; font-size: 16px; font-weight: bold; background-color: #2e8b57; color: white; border: none; border-radius: 6px; cursor: pointer; margin-top: 20px;"
  onmouseover="this.style.backgroundColor='#246b45'" 
  onmouseout="this.style.backgroundColor='#2e8b57'"
/>

<!-- Campos ocultos do cadastro -->
<input 
  type="hidden" 
  name="ativo" 
  id="ativo" 
  value="<?php echo KT_formatDate($row_rscadastro_detetive['ativo']); ?>" 
/>

<input 
  type="hidden" 
  name="data_cadastro" 
  id="data_cadastro" 
  value="<?php echo KT_formatDate($row_rscadastro_detetive['data_cadastro']); ?>" 
/>

<input 
  type="hidden" 
  name="nivel" 
  id="nivel" 
  value="0" 
/>

<input 
  type="hidden" 
  name="randomkey" 
  id="randomkey" 
  value="<?php echo KT_escapeAttribute($row_rscadastro_detetive['randomkey']); ?>" 
/>
<br><br>
</div>
  </body>
</html>
<?php
mysql_free_result($ConsultaEstado);
?>
