<?php
// arquivo: aviso_grupo_oficial.php
header('Content-Type: text/html; charset=UTF-8');

// URL do grupo oficial (link informado)
$GRUPO_OFICIAL_URL = 'https://chat.whatsapp.com/GtpD2jLwN8523vDmhDz9Aa';

// Mensagem institucional
$mensagem = <<<HTML
<p><strong>Comunicado aos Associados</strong></p>
<p>O associado deverá entrar no <strong>grupo oficial</strong> para acompanhar os atos administrativos e comunicados.</p>
<hr>
<p>
Aos <strong>30</strong> dias do mês de <strong>dezembro de 2025</strong>, às <strong>08h00</strong>, em primeira convocação, e, não atingindo o quórum suficiente, 
reuniram-se em <strong>2ª convocação</strong>, às <strong>08h30</strong> (trinta minutos depois).
</p>
HTML;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Comunicado – Grupo Oficial dos Associados</title>
  <meta name="color-scheme" content="light dark">
  <style>
    :root{--bg:#0f1115;--card:#161a22;--text:#e9edf1;--muted:#a7afbc;--gold:#d4af37;--gold-2:#f0c94d;--line:#262b36;--accent:#2b7dfc;--ok:#28a745}
    *{box-sizing:border-box} html,body{height:100%}
    body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:var(--bg);color:var(--text);display:flex;align-items:center;justify-content:center;padding:24px}
    .card{background:linear-gradient(180deg,rgba(255,255,255,.03),transparent),var(--card);border:1px solid var(--line);border-radius:18px;box-shadow:0 10px 30px rgba(0,0,0,.25);max-width:920px;width:100%;overflow:hidden}
    .card header{display:flex;align-items:center;gap:12px;padding:18px 20px;border-bottom:1px solid var(--line);background:linear-gradient(90deg,rgba(212,175,55,.18),rgba(240,201,77,.05))}
    .badge{background:rgba(212,175,55,.18);color:var(--gold-2);border:1px solid rgba(212,175,55,.35);padding:4px 10px;border-radius:999px;font-weight:600;font-size:.85rem}
    .title{font-size:1.15rem;font-weight:700}
    .content{padding:20px;line-height:1.6}.content p{margin:.4rem 0}
    .actions{display:flex;flex-wrap:wrap;gap:10px;padding:16px 20px;border-top:1px solid var(--line);background:rgba(255,255,255,.02)}
    .btn{appearance:none;border:none;border-radius:12px;padding:12px 16px;font-weight:700;cursor:pointer;transition:transform .06s ease,box-shadow .2s ease,opacity .2s ease;box-shadow:0 6px 18px rgba(0,0,0,.25)}
    .btn:active{transform:translateY(1px)} .btn-primary{background:var(--accent);color:#fff}
    .btn-outline{background:transparent;color:var(--text);border:1px solid var(--line)}
    .hint{color:var(--muted);font-size:.9rem}.ok{color:var(--ok);font-weight:700}
    .modal-backdrop{position:fixed;inset:0;background:rgba(0,0,0,.55);display:flex;align-items:center;justify-content:center;padding:20px;z-index:20}
    .modal{background:var(--card);border:1px solid var(--line);border-radius:16px;max-width:720px;width:100%;overflow:hidden}
    .modal header{padding:16px 18px;border-bottom:1px solid var(--line);display:flex;align-items:center;justify-content:space-between}
    .modal h2{margin:0;font-size:1.05rem}.modal .modal-body{padding:18px}
    .modal .modal-actions{padding:16px 18px;border-top:1px solid var(--line);display:flex;gap:10px;flex-wrap:wrap}
    .close-x{background:transparent;border:1px solid var(--line);color:var(--text);border-radius:10px;padding:8px 12px;cursor:pointer}
    .checkbox{display:flex;align-items:flex-start;gap:10px;margin-top:10px}
    a.link{color:var(--gold-2);text-decoration:none;border-bottom:1px dotted var(--gold-2)} a.link:hover{opacity:.9}
    @media (max-width:520px){.title{font-size:1rem}.content{font-size:.95rem}}
  </style>
</head>
<body>
  <main class="card" role="region" aria-label="Comunicado">
    <header>
      <span class="badge">AVISO OFICIAL</span>
      <div class="title">Grupo Oficial dos Associados – Acesso Obrigatório</div>
    </header>

    <div class="content">
      <?php echo $mensagem; ?>
      <p class="hint">A participação no grupo assegura que você receba as convocações, atas e demais instruções institucionais.</p>
    </div>

    <div class="actions">
      <button class="btn btn-primary" id="btn-entrar" onclick="window.open('<?php echo htmlspecialchars($GRUPO_OFICIAL_URL, ENT_QUOTES, 'UTF-8'); ?>','_blank','noopener')">
        Entrar no Grupo Oficial (WhatsApp)
      </button>
      <button class="btn btn-outline" id="btn-abrir-aviso">Rever Aviso</button>
      <span class="hint" id="status"></span>
    </div>
  </main>

  <!-- Modal (abre automaticamente) -->
  <div class="modal-backdrop" id="backdrop" aria-modal="true" role="dialog" aria-labelledby="modal-titulo" style="display:none">
    <div class="modal">
      <header>
        <h2 id="modal-titulo">Leitura obrigatória</h2>
        <button class="close-x" id="fechar-x" aria-label="Fechar">Fechar</button>
      </header>
      <div class="modal-body">
        <?php echo $mensagem; ?>
        <label class="checkbox">
          <input type="checkbox" id="chk-li" />
          <span>Declaro que <strong>li e compreendi</strong> o comunicado e que irei ingressar no <strong>grupo oficial</strong>.</span>
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn btn-primary" id="confirmar">Confirmar e Entrar no Grupo</button>
        <button class="btn btn-outline" id="fechar">Fechar</button>
      </div>
    </div>
  </div>

  <script>
    (function(){
      const backdrop = document.getElementById('backdrop');
      const abrir = document.getElementById('btn-abrir-aviso');
      const fechar = document.getElementById('fechar');
      const fecharX = document.getElementById('fechar-x');
      const confirmar = document.getElementById('confirmar');
      const status = document.getElementById('status');
      const chk = document.getElementById('chk-li');
      const btnEntrar = document.getElementById('btn-entrar');
      const grupoURL = <?php echo json_encode($GRUPO_OFICIAL_URL, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>;

      window.addEventListener('load', () => { backdrop.style.display = 'flex'; });

      function fecharModal(){ backdrop.style.display = 'none'; }

      abrir.addEventListener('click', () => backdrop.style.display = 'flex');
      fechar.addEventListener('click', fecharModal);
      fecharX.addEventListener('click', fecharModal);

      confirmar.addEventListener('click', () => {
        if(!chk.checked){
          status.textContent = 'Marque a confirmação para prosseguir.';
          status.style.color = '#f0c94d';
          return;
        }
        status.innerHTML = '<span class="ok">Confirmação registrada.</span> Abrindo o grupo...';
        window.open(grupoURL, '_blank', 'noopener');
        fecharModal();
      });

      btnEntrar.addEventListener('click', () => {
        status.innerHTML = 'Abrindo o grupo oficial...';
        setTimeout(()=> status.textContent = 'Se não abriu, verifique bloqueadores de pop-up.', 1800);
      });

      document.addEventListener('keydown', (e)=>{ if(e.key === 'Escape' && backdrop.style.display !== 'none') fecharModal(); });
    })();
  </script>
</body>
</html>
