<?php
// Arquivo: documentacao.php (layout modernizado; mesma funcionalidade)
header('Content-Type: text/html; charset=UTF-8');

// Fallback do brasão caso não venha via include
if (!isset($BRASAO) || !$BRASAO) {
  $BRASAO = 'logotipoadb.png';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Título (até 60 caracteres, com palavra-chave principal) -->
  <title>Cadastro Nacional de Detetive Particular no Brasil - Associação dos Detetives</title>
  
  <!-- Meta Description (até 160 caracteres, chamando clique) -->
  <meta name="description" content="A Associação dos Detetives do Brasil reúne profissionais especializados em investigação particular, conjugal, criminal e empresarial.">
  
  <!-- Palavras-chave (não tem peso alto hoje, mas ajuda um pouco) -->
  <meta name="keywords" content="detetive particular, investigação privada, investigação conjugal, detetive Brasil, detetive profissional, investigação criminal, Associação dos Detetives do Brasil">
  
  <!-- Favicon -->
  <link rel="icon" href="https://www.detetivesprofissionais.com.br/logotipoadb.png" type="image/png">
  
  <!-- Open Graph (para redes sociais como Facebook, WhatsApp, LinkedIn) -->
  <meta property="og:title" content="Associação dos Detetives do Brasil">
  <meta property="og:description" content="Referência nacional em investigação privada. Conheça nossos profissionais credenciados.">
  <meta property="og:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  <meta property="og:url" content="https://www.detetivesprofissionais.com.br/">
  <meta property="og:type" content="website">
  
  <!-- Twitter Card (para compartilhamento no Twitter/X) -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Associação dos Detetives do Brasil">
  <meta name="twitter:description" content="Investigação particular profissional em todo o Brasil.">
  <meta name="twitter:image" content="https://www.detetivesprofissionais.com.br/logotipoadb.png">
  
  <!-- CSS e JS -->
  <link rel="stylesheet" href="style.css" />
  <script defer src="app.js"></script>
</head>

<style>
  :root{
  --verde:#009739;
  --amarelo:#ffcc29;
  --azul:#001a33;        /* azul bem mais forte (navy profundo) */
  --azul-escuro:#000f24; /* ainda mais fechado p/ sombras/bordas */
  --azul-clarinho:#e8f0fa;
  --texto:#1f2937;
  --cinza:#f8fafc;
}


  *{ box-sizing:border-box }
  body{
    margin:0;
    font-family: Arial, Helvetica, sans-serif;
    color:var(--texto);
    background:#fff;
    line-height:1.6;
    -webkit-font-smoothing:antialiased;
    -moz-osx-font-smoothing:grayscale;
  }

  /* ===== NAVBAR RESPONSIVA ===== */
  .adb-nav{
    position:sticky; top:0; z-index:999;
    background: var(--azul);
    color:#fff;
    border-bottom:3px solid var(--amarelo);
  }
  .adb-wrap{
    max-width:1300px; margin:0 auto; padding:10px 16px;
    display:flex; align-items:center; justify-content:space-between; gap:12px; position:relative;
  }
  .adb-brand{ display:flex; align-items:center; gap:10px; text-decoration:none; color:#fff; min-width:0 }
  .adb-brand img{ width:40px; height:40px; border-radius:6px; background:#fff; padding:4px }
  .adb-brand span{ font-weight:800; font-size:16px; line-height:1.1; white-space:nowrap }

  .adb-toggle{
    display:none; background:transparent; border:0; color:#fff; cursor:pointer;
    width:40px; height:40px; border-radius:8px;
  }
  .adb-toggle:focus-visible{ outline:2px solid #fff; outline-offset:2px }

  .adb-menu{ list-style:none; margin:0; padding:0; display:flex; align-items:center; gap:8px }
  .adb-menu a{
    display:inline-block; text-decoration:none; color:#fff; font-weight:700;
    padding:10px 14px; border-radius:10px;
  }
  .adb-menu a:hover{ background:rgba(255,255,255,.12) }

  @media (max-width:768px){
    .adb-toggle{ display:inline-flex; align-items:center; justify-content:center }
    .adb-menu{
      position:absolute; left:16px; right:16px; top:56px;
      background:var(--azul);
      flex-direction:column; align-items:stretch; gap:0;
      max-height:0; overflow:hidden; transition:max-height .25s ease;
      border-bottom:3px solid var(--amarelo);
      border-radius:12px; box-shadow:0 20px 40px rgba(0,0,0,.35);
    }
    .adb-menu.open{ max-height:420px }
    .adb-menu li{ border-top:1px solid rgba(255,255,255,.12) }
    .adb-menu a{ padding:14px 18px }
  }

  /* ===== HERO ===== */
  header{
    background: var(--azul);
    color:#fff;
    text-align:center;
    padding:28px 16px 46px;
    position:relative;
  }
  header .topo{ max-width:1100px; margin:0 auto }
  header img.brasao{
    width:110px; max-width:28vw; height:auto; display:block; margin:0 auto 12px;
    background:#fff; border-radius:10px; padding:8px; box-shadow:0 6px 20px rgba(0,0,0,.15);
  }
  header h1{ margin:0; font-size:26px; font-weight:800; text-shadow:0 1px 3px rgba(0,0,0,.35) }
  header .faixa{
    position:absolute; left:0; right:0; bottom:-18px; height:36px;
    background: var(--amarelo);
    border-top:2px solid rgba(255,255,255,.5);
    border-bottom:1px solid rgba(0,0,0,.08);
  }

  /* ===== MAIN / CARDS ===== */
  main{ max-width:1300px; margin:48px auto 28px; padding:0 16px }
  .lead{
    background:var(--cinza);
    border:1px solid var(--borda);
    border-left:4px solid var(--azul);
    padding:12px 14px;
    border-radius:10px;
    margin:0 0 16px 0;
  }
  .grid{ display:grid; grid-template-columns:1fr 1fr; gap:16px }
  .card{
    background:#fff; border:1px solid var(--borda);
    border-radius:14px; padding:18px;
    box-shadow:0 6px 18px rgba(0,0,0,.04);
  }
  .card h2,.card h3{ margin-top:0 }

  .muted{ color:#4b5563; font-size:14px }

  /* Botões */
  .btn{
    display:inline-block; padding:12px 18px; border-radius:10px; font-weight:700;
    text-decoration:none; text-align:center; color:#fff;
    box-shadow:0 6px 16px rgba(0,0,0,.12); transition:.2s transform ease,.2s opacity ease;
  }
  .btn:hover{ transform:translateY(-1px); opacity:.95 }
  .btn:active{ transform:translateY(0) }
  .btn-azul{ background:var(--azul) }
  .btn-verde{ background:var(--verde) }
  .btn-amarelo{ background:var(--amarelo); color:#1f2937 }

  .cta{ margin:14px 0 0; display:flex; gap:10px; flex-wrap:wrap }

  /* FAB WhatsApp */
  .wa-fab{
    position:fixed; right:18px; bottom:18px; z-index:1000;
    width:72px; height:72px; border-radius:50%;
    background:#25D366; display:flex; align-items:center; justify-content:center;
    box-shadow:0 10px 24px rgba(0,0,0,.25);
  }
  .wa-fab img{ width:38px; height:38px }

  /* ===== Responsividade ===== */
  @media (max-width:768px){
    header{ padding:22px 12px 40px }
    header h1{ font-size:20px }
    header img.brasao{ width:90px; padding:6px; border-radius:8px }
    .grid{ grid-template-columns:1fr }
    .btn{ width:100% }
    .wa-fab{ width:64px; height:64px; right:14px; bottom:14px }
    .wa-fab img{ width:34px; height:34px }
  }

  /* ===== Impressão ===== */
  @media print{
    .adb-nav, header .faixa, .wa-fab{ display:none !important }
    header{ background:#fff; color:#000; padding:12px }
    header img.brasao{ background:transparent; box-shadow:none; padding:0 }
    .card{ box-shadow:none }
    body{ background:#fff }
  }
  .adb-menu a.active {
  background: var(--amarelo);
  color: var(--texto); /* deixa o texto escuro para contraste */
}
.btn-verde {
  background-color: #cc0000; /* vermelho forte */
  color: #fff;              /* texto branco */
  padding: 10px 20px;
  text-decoration: none;
  border-radius: 6px;
  display: inline-block;
  font-weight: bold;
  transition: background 0.3s;
}

.btn-verde:hover {
  background-color: #990000; /* tom mais escuro no hover */
}

</style>
</head>
<body>

<!-- ===== NAVBAR ===== -->
<nav class="adb-nav" role="navigation" aria-label="Menu principal">
  <div class="adb-wrap">
    <a class="adb-brand" href="index.php" rel="noopener">
      <img src="logotipoadb.png" alt="ADB">
      <span>Cadastro Nacional</span>
    </a>
    <button class="adb-toggle" id="adbToggle" aria-label="Abrir menu" aria-expanded="false" aria-controls="adbMenu">
      <svg width="26" height="26" viewBox="0 0 24 24" fill="none" aria-hidden="true">
        <path d="M3 6h18M3 12h18M3 18h18" stroke="white" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </button>
    <ul class="adb-menu" id="adbMenu">
    <li><a href="finalidade_institucional.php">Finalidade Institucional</a></li>
      <li><a href="index.php">Opção de Busca</a></li>
      <li><a href="beneficios.php">Benefícios</a></li>
      <li><a href="documentacao.php" class="active">Com formação</a></li>
      <li><a href="cursodeformacao.php"class="active">Sem formação</a></li>
      <li><a href="atualizacao.php"class="active">Recadastramento</a></li>
      <li><a href="restrito.php">Login</a></li>
    </ul>
  </div>
</nav>

<!-- ===== HERO ===== -->
<header id="topo">
  <div class="topo">
    <img class="brasao" src="<?php echo htmlspecialchars($BRASAO, ENT_QUOTES, 'UTF-8'); ?>" alt="Brasão da República Federativa do Brasil" onerror="this.style.display='none'">
    <h1>Documentações obrigatórias</h1>
  </div>
  <div class="faixa" aria-hidden="true"></div>
</header>

<!-- ===== CONTEÚDO ===== -->
<main>
<p class="lead">
  <strong>Remoção automática do cadastro</strong> poderá ocorrer em caso de inatividade prolongada,
  decorrente da ausência de <strong>regularização anual obrigatória</strong>, observando-se a respectiva
  <strong>data de validade do registro profissional</strong>.<br><br>

  O <strong>recadastramento</strong> é um procedimento obrigatório após a remoção, devendo ser realizado
  por todos os profissionais que desejarem restabelecer sua situação ativa junto à
  <strong>Associação dos Detetives do Brasil (ADB)</strong>.<br><br>

  <h4 style="margin-top:10px;color:#b71c1c;">⚖️ Falsidade de Documento</h4>
  <p style="margin:0 0 12px;">
    <strong>O que é:</strong> Falsificar um documento em sua forma física ou alterá-lo.
    Essa conduta é tipificada no <strong>Art. 297 do Código Penal</strong> (falsificação de documento público)
    e no <strong>Art. 298 do Código Penal</strong> (falsificação de documento particular).<br>
    A prática constitui crime, sujeito a <strong>penas de reclusão e multa</strong>.
  </p>

  <h4 style="margin-top:16px;">🖋️ Procedimento de Envio</h4>
  Siga a ordem abaixo. Digitalize <strong>diretamente do original</strong>, com boa qualidade e
  <strong>assine eletronicamente via GOV.BR</strong> antes do envio.
</p>

<h4 style="margin-top:14px">🔐 Por que assinar digitalmente?</h4>
<ul>
  <li><strong>Autenticidade</strong> — confirma a autoria do documento;</li>
  <li><strong>Integridade</strong> — garante que o conteúdo não foi alterado após a assinatura;</li>
  <li><strong>Segurança jurídica</strong> — possui validade legal em todo o território nacional.</li>
</ul>


  <div class="cta">
    <a class="btn btn-azul" href="manual_gov_br.php" target="_blank" rel="noopener" style="display:inline-flex;align-items:center;gap:10px;text-decoration:none;">
      <img src="https://t2.tudocdn.net/697334?w=1200&h=1200" alt="GOV.BR"
           style="width:28px;height:28px;object-fit:contain;border-radius:4px;display:inline-block;" loading="lazy">
      Assinatura GOV.br
    </a>
    <a class="btn btn-verde" href="cadastro.php">✅ Recadastramento </a>
  </div>

  <section class="grid" aria-label="Documentação obrigatória em sequência">

    <!-- 1 -->
    <article class="card" aria-labelledby="p1">
      <h3 id="p1">1) Documento de Identidade e CPF</h3>
      <p>Envie <strong>RG</strong> ou <strong>CNH</strong> (válidos e legíveis) e o <strong>CPF</strong>.</p>
      <ul>
        <li>Frente e verso (quando aplicável).</li>
        <li>Sem reflexos, cortes ou desfoque.</li>
      </ul><br>
    <!-- 4 -->
    <article class="card" aria-labelledby="p4">
      <h3 id="p4">2) Comprovante de Residência</h3>
      <p>Conta de <strong>água</strong>, <strong>luz</strong> ou <strong>telefone fixo</strong>.</p>
      <ul>
        <li>Em nome do cônjuge/companheiro(a): anexar Certidão de Casamento/União Estável.</li>
        <li>Sem vínculo conjugal ou sem titularidade: anexar <strong>declaração com firma reconhecida</strong> do titular/proprietário.</li>
      </ul>
      <a class="btn btn-azul" href="imprimir_declaracao_de_residencia.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a>
    </article>  
     <!-- 6 -->
    <article class="card" aria-labelledby="p6">
      <h3 id="p6">3) Foto 3x4</h3>
      <ul>
        <li>Recente, <strong>traje social</strong> e aparência condizente com documentos oficiais.</li>
        <li>Imagem nítida, boa iluminação e <strong>sem filtros</strong>.</li>
        <li>Formato aceito: <strong>.JPG</strong>.</li>
      </ul>
      <a class="btn btn-amarelo" href="modelo_de_foto.png" target="_blank" rel="noopener">⬇️ Ver modelo de foto</a>
      <p class="muted"><strong>⚠️</strong> Fotos fora dessas orientações serão recusadas.</p>
    </article>  
       <!-- 8 -->
    <h3 id="p2">4) Diploma/Certificado Profissional (Com formação)</h3>
      <p>Cópia do <strong>Diploma</strong> ou <strong>Certificado</strong> do curso de formação (área de investigação ou correlata).</p>
      <ul>
        <li>Informar <strong>instituição</strong>, <strong>carga horária</strong> e <strong>data</strong> de conclusão.</li>
        <li>Preferencialmente com assinatura eletrônica da instituição.</li>
      </ul>
      <p><a class="btn btn-amarelo" href="https://www.planalto.gov.br/ccivil_03/_ato2015-2018/2017/lei/L13432.htm" target="_blank" rel="noopener">Ver Lei nº 13.432/2017</a></p>
      <article class="card" aria-labelledby="p3">
      <h3 id="p3">5) Comprovação de Idoneidade</h3>
      <p>Apresente <strong>certidões negativas de antecedentes criminais</strong> emitidas pelos órgãos competentes da sua localidade.</p>
      <ul>
        <li>Certidões <strong>válidas</strong> e <strong>legíveis</strong> (assinar eletronicamente quando disponível).</li>
      </ul>
    </article>
    
    </article>
    <!-- 2 -->
    <article class="card" aria-labelledby="p2">
     <!-- 5 -->
    <article class="card" aria-labelledby="p5">
      <h3 id="p5">6) Tipo Sanguíneo</h3>
      <p>Envie exame ou declaração com seu <strong>tipo sanguíneo</strong>.</p>
      <a class="btn btn-azul" href="imprimir_declaracao_de_tipo_sanguineo.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a>
    </article>
     <!-- 7 -->
    <article class="card" aria-labelledby="p7">
      <h3 id="p7">7) Declaração de Aceitação</h3>
      <p>Preencha e <strong>assine</strong> a declaração.</p>
      <a class="btn btn-azul" href="imprimir_declaracao_de_aceitacao.php" target="_blank" rel="noopener">⬇️ Imprimir Declaração</a>
    </article><br>
    
    
 <!-- 10 -->
    <article class="card" aria-labelledby="p10">
      <h3 id="p10">8) Contribuição </h3>
    <p>Para contribuir com a manutenção do sistema.</p>

      <div class="lead" style="margin-top:8px">
        <strong>Valor:</strong> R$ 100,00
      </div>

      <p style="margin-top:12px">
        <strong>Favorecido:</strong> Associação dos Detetives do Brasil<br>
        <strong>Chave PIX (CNPJ):</strong> 13.329.080/0001-75
      </p>

      <p>
        <strong>Transferência Bancária</strong><br>
        Banco: CORA • Agência: 0001 • Conta Corrente: 3023410-1
      </p>

      <p class="muted"><em>Sua contribuição ajuda a manter o sistema ativo para todos os detetives do Brasil.</em></p><br>
       <article class="card" aria-labelledby="p8">
      <h3 id="p8">9) Envio da Documentação</h3>
      <p>Todos os arquivos devem estar <strong>completos</strong>, <strong>legíveis</strong> e <strong>assinados via GOV.BR</strong>.</p>
      <ul>
        <li>Não aceitamos: xerox escaneada, fotos borradas ou documentos incompletos.</li>
        <li>Digitalize em alta qualidade antes da assinatura eletrônica.</li>
       <li>
  <a class="btn-whatsapp"
     href="https://wa.me/5548999180960?text=Olá!%20Preciso%20de%20suporte."
     target="_blank" rel="noopener noreferrer"
     aria-label="Enviar para o suporte via WhatsApp">
    Enviar para o suporte via WhatsApp: (48) 99918-0960
  </a>
</li>

<style>
  .btn-whatsapp{
    display:inline-flex;align-items:center;gap:.6rem;
    padding:.6rem 1rem;border-radius:999px;text-decoration:none;
    font:600 14px/1.1 system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
    background:#25D366;color:#000;border:1px solid #1da653;
    box-shadow:0 2px 6px rgba(0,0,0,.15);
  }
  .btn-whatsapp:hover{filter:brightness(0.95)}
  .btn-whatsapp::before{
    content:"";width:18px;height:18px;display:inline-block;
    background:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path fill="%23000" d="M19.1 17.2c-.3-.2-1.7-.8-2-.9-.3-.1-.5-.2-.7.2-.2.3-.8.9-1 .9s-.5 0-1-.5-1-1.1-1.3-1.6c-.3-.5 0-.7.2-.9.2-.2.3-.5.5-.7.2-.2.2-.3 0-.6-.1-.3-.7-1.7-.9-2s-.5-.5-.7-.5h-.6c-.2 0-.6.1-.9.5s-1.2 1.2-1.2 2.9 1.2 3.3 1.4 3.6c.2.3 2.4 3.7 5.9 5 3.5 1.4 3.5.9 4.2.8.6-.1 2-.8 2.3-1.6.3-.8.3-1.5.2-1.6-.1-.1-.3-.2-.6-.4z"/><path fill="%23000" d="M16 3C9.9 3 5 7.9 5 14c0 2 .6 3.9 1.7 5.5L5 29l9-1.6c1.5.8 3.1 1.1 4.9 1.1 6.1 0 11-4.9 11-11S22.1 3 16 3zm0 20.2c-1.6 0-3.1-.4-4.4-1.1l-.3-.2-5.4.9.9-5.3-.2-.3c-.9-1.4-1.4-3-1.4-4.6 0-4.9 4-8.9 8.9-8.9s8.9 4 8.9 8.9-4 8.9-8.9 8.9z"/></svg>') no-repeat center/contain;
  }
</style>

      </ul>
    </article><br>
       
    </article>
    </article>


  </section>
</main>


<a href="https://api.whatsapp.com/send?phone=5548991809609" target="_blank" style="right:60px; position:fixed;width:40px;height:5px;bottom:100px;z-index:100;">

<img class="imagem3" src=" WhatsAppPNG.png  " alt="" width="90px">

<style>
.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-transform: scale(1.5);
    transform: scale(1.5);
}

.imagem3{
    transition: all 0.5s;
    cursor: pointer;
}

.imagem3:hover{
    -webkit-filter: drop-shadow(0px 0px 5px rgba(255,20,147));
    filter: drop-shadow(0px 0px 20px rgba(255,20,147));
}

</style>
</a>

<footer style="max-width:1000px; margin:8px auto 36px; padding:0 16px; color:#6b7280; font-size:13px; text-align:center;">
  Associação dos Detetives do Brasil
</footer>

<!-- ===== JS do menu ===== -->
<script>
  (function(){
    const btn = document.getElementById('adbToggle');
    const menu = document.getElementById('adbMenu');
    if(!btn || !menu || btn.dataset.bound) return;

    const closeMenu = () => { menu.classList.remove('open'); btn.setAttribute('aria-expanded','false'); document.body.style.overflow=''; };
    const openMenu  = () => { menu.classList.add('open');  btn.setAttribute('aria-expanded','true');  document.body.style.overflow='hidden'; };
    const toggle    = (e) => { e && e.stopPropagation(); menu.classList.contains('open') ? closeMenu() : openMenu(); };

    ['click','touchstart','pointerup'].forEach(evt => btn.addEventListener(evt, toggle, {passive:true}));
    document.addEventListener('click', (e)=>{ if (!menu.classList.contains('open')) return; if (!e.target.closest('.adb-nav')) closeMenu(); }, true);
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape' && menu.classList.contains('open')) closeMenu(); });
    window.addEventListener('resize', ()=>{ if (window.innerWidth>768) closeMenu(); });
    window.addEventListener('pageshow', ()=>{ closeMenu(); });

    btn.dataset.bound = '1';
  })();
</script>
<!-- === ADB • BOTÃO FLUTUANTE DE TRADUÇÃO (BANDEIRAS + BUSCA) • VERSÃO ESTÁVEL === -->
<div id="adb-translate">
  <button id="adb-translate-toggle" type="button" aria-label="Traduzir página">
    🌐 <span>Tradução</span>
  </button>

  <div id="adb-translate-panel" role="dialog" aria-label="Selecione um idioma">
    <div class="adb-translate-header">
      <input id="adb-translate-search" type="text" placeholder="Buscar idioma..." aria-label="Buscar idioma" />
      <button id="adb-translate-close" type="button" aria-label="Fechar">✖</button>
    </div>
    <div id="adb-translate-grid" aria-live="polite"></div>
    <div class="adb-translate-foot">
      <small>ASSOCIAÇÃO DOS DETETIVES DO BRASIL • ADB</small>
    </div>
  </div>
</div>

<!-- Elemento oculto necessário ao Google Translate -->
<div id="google_translate_element" style="display:none;"></div>

<style>
  :root{ --adb-black:#000; --adb-gold:#c9a34b; --adb-gray:#111; }
  #adb-translate{
    position:fixed; bottom:20px; left:20px; z-index:2147483000; /* bem alto */
    font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
  }
  #adb-translate-toggle{
    display:flex; align-items:center; gap:8px;
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:12px;
    padding:8px 12px; cursor:pointer; box-shadow:0 6px 14px rgba(0,0,0,.45);
    font-weight:600;
  }
  #adb-translate-toggle:hover{ filter:brightness(1.1); }

  #adb-translate-panel{
    display:none; margin-top:10px; width:min(92vw, 720px); max-height:min(70vh, 560px);
    background:var(--adb-black); color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:14px;
    box-shadow:0 14px 40px rgba(0,0,0,.6); overflow:hidden;
  }
  #adb-translate.open #adb-translate-panel{ display:block; }

  .adb-translate-header{
    display:flex; align-items:center; gap:8px;
    padding:10px; background:var(--adb-gray); border-bottom:1px solid #2a2a2a;
  }
  #adb-translate-search{
    flex:1; padding:10px 12px; border-radius:10px; border:1px solid #333;
    background:#000; color:#eee; outline:none;
  }
  #adb-translate-search::placeholder{ color:#999; }
  #adb-translate-close{
    background:#000; color:var(--adb-gold);
    border:1px solid var(--adb-gold); border-radius:10px; padding:8px 10px; cursor:pointer;
  }
  #adb-translate-close:hover{ background:#111; }

  #adb-translate-grid{
    padding:10px; display:grid; grid-template-columns: repeat(6, 1fr);
    gap:8px; overflow:auto; max-height: calc(min(70vh, 560px) - 98px);
  }
  @media (max-width:640px){ #adb-translate-grid{ grid-template-columns: repeat(3, 1fr); } }
  .adb-lang{
    display:flex; align-items:center; gap:8px;
    background:#0a0a0a; color:#ddd; border:1px solid #222; border-radius:10px;
    padding:8px; cursor:pointer; min-height:44px;
  }
  .adb-lang:hover{ border-color:var(--adb-gold); transform:translateY(-1px); }
  .adb-flag{ width:1.6em; display:inline-flex; align-items:center; justify-content:center; }
  .adb-flag .fi{ width:1.5em; height:1em; border-radius:2px; box-shadow:0 0 0 1px rgba(0,0,0,.25); }
  .adb-name{ font-size:13px; line-height:1.2; }
  .adb-code{ font-size:11px; opacity:.7; }

  .adb-translate-foot{ padding:8px 10px; border-top:1px solid #2a2a2a; text-align:center; background:#0b0b0b; }
  .adb-translate-foot small{ color:#9a865b; }

  /* Anti-banner do Google Translate (desktop + mobile) */
  #goog-gt-tt, .goog-te-balloon-frame, .goog-te-menu-frame, .goog-te-banner-frame { display:none !important; visibility:hidden !important; opacity:0 !important; height:0 !important; }
  iframe.goog-te-banner-frame { display:none !important; }
  html, body { top:0 !important; margin-top:0 !important; transform:none !important; }
  html.translated-ltr body, html.translated-rtl body { top:0 !important; position:static !important; }
  body > .skiptranslate { display:none !important; }
</style>

<script>
(function(){
  'use strict';

  /* ===== Lista de códigos (~130) ===== */
  const BASE_CODES = 'pt,af,sq,am,ar,hy,as,ay,az,bm,eu,be,bn,bho,bs,bg,ca,ceb,zh-CN,zh-TW,co,hr,cs,da,dv,doi,nl,en,eo,et,ee,fil,fi,fr,fy,gl,ka,de,el,gn,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,ilo,id,ga,it,ja,jv,kn,kk,km,rw,gom,ko,kri,ku,ky,lo,la,lv,ln,lt,lg,lb,mk,mai,mg,ms,ml,mt,mi,mr,lus,mn,my,ne,no,nso,ny,or,om,ps,fa,pl,pt-PT,pa,qu,ro,ru,sm,sa,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,tg,ta,tt,te,th,ti,ts,tr,tk,tw,uk,ur,ug,uz,vi,xh,yi,yo,zu'.split(',');

  /* Nomes e bandeiras por emoji — sempre funciona (mobile/desktop que suporte emoji) */
  const MAP = {
    'pt':['Português (Original)','🇧🇷'], 'en':['Inglês','🇺🇸'], 'es':['Espanhol','🇪🇸'], 'fr':['Francês','🇫🇷'], 'de':['Alemão','🇩🇪'],
    'it':['Italiano','🇮🇹'], 'ru':['Russo','🇷🇺'], 'ja':['Japonês','🇯🇵'], 'ko':['Coreano','🇰🇷'],
    'zh-CN':['Chinês (Simplificado)','🇨🇳'], 'zh-TW':['Chinês (Tradicional)','🇹🇼'], 'ar':['Árabe','🇸🇦'],
    'hi':['Hindi','🇮🇳'], 'bn':['Bengali','🇧🇩'], 'id':['Indonésio','🇮🇩'], 'tr':['Turco','🇹🇷'],
    'uk':['Ucraniano','🇺🇦'], 'pl':['Polonês','🇵🇱'], 'pt-PT':['Português (Portugal)','🇵🇹'],
    'fa':['Persa (Farsi)','🇮🇷'], 'he':['Hebraico','🇮🇱'], 'el':['Grego','🇬🇷'], 'sv':['Sueco','🇸🇪'],
    'no':['Norueguês','🇳🇴'], 'da':['Dinamarquês','🇩🇰'], 'fi':['Finlandês','🇫🇮'], 'cs':['Tcheco','🇨🇿'],
    'sk':['Eslovaco','🇸🇰'], 'sl':['Esloveno','🇸🇮'], 'ro':['Romeno','🇷🇴'], 'hu':['Húngaro','🇭🇺'],
    'bg':['Búlgaro','🇧🇬'], 'sr':['Sérvio','🇷🇸'], 'hr':['Croata','🇭🇷'], 'nl':['Holandês','🇳🇱'],
    'et':['Estoniano','🇪🇪'], 'lv':['Letão','🇱🇻'], 'lt':['Lituano','🇱🇹'], 'ga':['Irlandês','🇮🇪'],
    'gd':['Gaélico Escocês','🏴'], 'gl':['Galego','🇪🇸'], 'ca':['Catalão','🇪🇸'], 'eu':['Basco','🇪🇸'],
    'mi':['Maori','🇳🇿'], 'ms':['Malaio','🇲🇾'], 'sw':['Suaíli','🇰🇪'], 'vi':['Vietnamita','🇻🇳'],
    'th':['Tailandês','🇹🇭'], 'ur':['Urdu','🇵🇰'], 'ta':['Tâmil','🇮🇳'], 'te':['Telugo','🇮🇳'],
    'ml':['Malaiala','🇮🇳'], 'mr':['Marati','🇮🇳'], 'kn':['Kannada','🇮🇳'], 'gu':['Gujarati','🇮🇳'],
    'ne':['Nepalês','🇳🇵'], 'si':['Cingalês (Sinhala)','🇱🇰'], 'my':['Birmanês','🇲🇲'], 'km':['Khmer','🇰🇭'],
    'lo':['Lao','🇱🇦'], 'mn':['Mongol','🇲🇳'], 'kk':['Cazaque','🇰🇿'], 'uz':['Uzbeque','🇺🇿'],
    'az':['Azeri','🇦🇿'], 'ka':['Georgiano','🇬🇪'], 'hy':['Armênio','🇦🇲'], 'ps':['Pastó (Pashto)','🇦🇫'],
    'tk':['Turcomano','🇹🇲'], 'tg':['Tajique','🇹🇯'], 'ky':['Quirguiz','🇰🇬'], 'ku':['Curdo','🇮🇶'],
    'pa':['Panjabi (Punjabi)','🇮🇳'], 'af':['Africâner','🇿🇦'], 'sq':['Albanês','🇦🇱'], 'bs':['Bósnio','🇧🇦'],
    'mk':['Macedônio','🇲🇰'], 'is':['Islandês','🇮🇸'], 'xh':['Xhosa','🇿🇦'], 'zu':['Zulu','🇿🇦'],
    'st':['Sesoto (Sotho do Sul)','🇿🇦'], 'nso':['Sepedi (Sotho do Norte)','🇿🇦'], 'yo':['Iorubá','🇳🇬'],
    'ig':['Igbo','🇳🇬'], 'ha':['Hauçá','🇳🇬'], 'rw':['Quiniaruanda','🇷🇼'], 'so':['Somali','🇸🇴'],
    'am':['Amárico','🇪🇹'], 'ti':['Tigrínia','🇪🇷'], 'om':['Oromo','🇪🇹'], 'ee':['Ewe','🇬🇭'],
    'tw':['Twi (Akan)','🇬🇭'], 'kri':['Krio','🇸🇱'], 'sm':['Samoano','🇼🇸'], 'ht':['Haitiano Crioulo','🇭🇹'],
    'fil':['Filipino','🇵🇭'], 'tl':['Tagalo','🇵🇭'], 'jv':['Javanês','🇮🇩'], 'su':['Sundanês','🇮🇩'],
    'bho':['Bojpuri','🇮🇳'], 'mai':['Maithili','🇮🇳'], 'or':['Odia (Oriá)','🇮🇳'], 'as':['Assamês','🇮🇳'],
    'gom':['Concani (Konkani)','🇮🇳'], 'la':['Latim','🌐'], 'sa':['Sânscrito','🌐'], 'tt':['Tártaro','🌐'],
    'yi':['Iídiche','🌐'], 'hmn':['Hmong','🌐'], 'co':['Córsico','🇫🇷'], 'haw':['Havaiano','🇺🇸']
  };

  const ADB_LANGUAGES = BASE_CODES.map(code => {
    const [name, flag] = MAP[code] || [code,'🌐'];
    return { code, name, flag };
  });

  const ADB_CODE_ALIASES = { 'pt-BR':'pt', 'zh':'zh-CN' };

  /* Google Translate init */
  window.googleTranslateElementInit = function(){
    try{
      new google.translate.TranslateElement({
        pageLanguage:'pt',
        includedLanguages: ADB_LANGUAGES.map(l => l.code).join(','),
        autoDisplay:false
      }, 'google_translate_element');
    }catch(e){}
  };

  function normalizeCode(code){ return ADB_CODE_ALIASES[code] || code; }
  function setTranslateCookie(langTo){
    try{
      const pair = '/pt/' + normalizeCode(langTo);
      const domain = location.hostname.replace(/^www\./,'');
      const base = 'googtrans=' + pair + '; path=/;';
      document.cookie = base;
      document.cookie = base + ' domain=.' + domain + ';';
    }catch(e){}
  }
  function applyTranslation(lang){
    try{
      if(!lang) return;
      setTranslateCookie(lang);
      const sel = document.querySelector('select.goog-te-combo');
      if (sel){
        sel.value = normalizeCode(lang);
        sel.dispatchEvent(new Event('change', {bubbles:true}));
        antiBanner.trigger();
      } else {
        location.reload();
      }
    }catch(e){}
  }

  /* Render e interação */
  (function(){
    const root=document.getElementById('adb-translate');
    const toggle=document.getElementById('adb-translate-toggle');
    const panel=document.getElementById('adb-translate-panel');
    const closeBtn=document.getElementById('adb-translate-close');
    const grid=document.getElementById('adb-translate-grid');
    const search=document.getElementById('adb-translate-search');

    function itemHTML(lang){
      return '<button class="adb-lang" type="button" data-code="'+lang.code+'" title="'+lang.name+'">'
           +   '<span class="adb-flag">'+lang.flag+'</span>'
           +   '<div class="adb-meta">'
           +     '<div class="adb-name">'+lang.name+'</div>'
           +     '<div class="adb-code">'+lang.code+'</div>'
           +   '</div>'
           + '</button>';
    }
    function renderList(filter){
      try{
        const f=(filter||'').trim().toLowerCase();
        const list = ADB_LANGUAGES.filter(l => !f || l.name.toLowerCase().includes(f) || l.code.toLowerCase().includes(f));
        grid.innerHTML = list.map(itemHTML).join('');
        // após render, tenta aplicar SVGs (se folha carregar)
        applySVGFlagsSafe();
      }catch(e){}
    }
    renderList('');

    toggle.addEventListener('click', ()=>{ root.classList.toggle('open'); if(root.classList.contains('open')) search.focus(); });
    closeBtn.addEventListener('click', ()=> root.classList.remove('open'));
    document.addEventListener('click', (e)=>{
      const btn = e.target.closest('.adb-lang');
      if(btn){ applyTranslation(btn.getAttribute('data-code')); }
    });
    search.addEventListener('input', ()=>renderList(search.value));
  })();

  /* Anti-banner (agressivo e seguro) */
  const antiBanner = (function(){
    function kill(){
      try{
        document.querySelectorAll('iframe.goog-te-banner-frame, .goog-te-menu-frame, #goog-gt-tt, .goog-te-balloon-frame').forEach(el => el.remove());
        document.documentElement.style.top='0px';
        document.body.style.top='0px';
        document.body.style.position='static';
        document.body.style.marginTop='0px';
        document.body.style.transform='none';
      }catch(e){}
    }
    function burst(){
      kill(); setTimeout(kill,200); setTimeout(kill,600); setTimeout(kill,1200); setTimeout(kill,2500); setTimeout(kill,4000);
    }
    try{
      const obs=new MutationObserver(burst);
      obs.observe(document.documentElement,{childList:true,subtree:true});
    }catch(e){}
    window.addEventListener('load', burst);
    window.addEventListener('resize', burst);
    window.addEventListener('orientationchange', burst);
    document.addEventListener('DOMContentLoaded', burst);
    return { trigger: burst };
  })();

  /* ===== Bandeiras SVG no desktop (opcional, sem travar nada) ===== */
  // Carrega CSS de bandeiras; se não carregar, continua com emoji.
  let flagCSSLoaded = false;
  try{
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css';
    link.onload = function(){ flagCSSLoaded = true; applySVGFlagsSafe(); };
    document.head.appendChild(link);
  }catch(e){}

  // Mapeamento mínimo idioma->país para SVG; não listado => mantém emoji.
  const FLAG_MAP = {
    'pt':'br','pt-PT':'pt','en':'us','es':'es','fr':'fr','de':'de','it':'it','ru':'ru',
    'ja':'jp','ko':'kr','zh-CN':'cn','zh-TW':'tw','ar':'sa','he':'il','fa':'ir',
    'hi':'in','bn':'bd','id':'id','tr':'tr','uk':'ua','pl':'pl','nl':'nl','sv':'se',
    'no':'no','da':'dk','fi':'fi','cs':'cz','sk':'sk','sl':'si','ro':'ro','hu':'hu',
    'bg':'bg','sr':'rs','hr':'hr','et':'ee','lv':'lv','lt':'lt','ga':'ie','gd':'gb', /* gb (uk) genérico */
    'gl':'es','ca':'es','eu':'es','mi':'nz','ms':'my','sw':'ke','vi':'vn','th':'th',
    'ur':'pk','ta':'in','te':'in','ml':'in','mr':'in','kn':'in','gu':'in','ne':'np',
    'si':'lk','my':'mm','km':'kh','lo':'la','mn':'mn','kk':'kz','uz':'uz','az':'az',
    'ka':'ge','hy':'am','ps':'af','tk':'tm','tg':'tj','ky':'kg','ku':'iq','pa':'in',
    'af':'za','sq':'al','bs':'ba','mk':'mk','is':'is','xh':'za','zu':'za','st':'za',
    'nso':'za','yo':'ng','ig':'ng','ha':'ng','rw':'rw','so':'so','am':'et','ti':'er',
    'om':'et','ee':'gh','tw':'gh','kri':'sl','sm':'ws','ht':'ht','fil':'ph','tl':'ph',
    'jv':'id','su':'id','bho':'in','mai':'in','or':'in','as':'in','gom':'in','co':'fr','haw':'us'
  };

  function applySVGFlagsSafe(){
    try{
      if(!flagCSSLoaded) return; // só tenta se o CSS carregou
      const grid = document.getElementById('adb-translate-grid');
      if(!grid) return;
      grid.querySelectorAll('.adb-lang').forEach(btn=>{
        const code = btn.getAttribute('data-code');
        const cc = FLAG_MAP[code];
        const holder = btn.querySelector('.adb-flag');
        if(holder && cc){
          holder.innerHTML = '<span class="fi fi-'+cc+'"></span>';
        }
      });
    }catch(e){}
  }

})();
</script>

<!-- Script oficial do Google Translate -->
<script src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<!-- === / ADB • BOTÃO FLUTUANTE DE TRADUÇÃO • VERSÃO ESTÁVEL === -->

</body>
</html>
